/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SpringLayout;
import vlcskineditor.Helper;
import vlcskineditor.Language;

public class Config {
    private static Hashtable<String, String> strings = new Hashtable();
    private static File configFile;

    public static void load() {
        try {
            FileReader fileReader = new FileReader(configFile);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string = "";
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray;
                if (string.startsWith("#") || (stringArray = string.split("\\|")).length != 2) continue;
                strings.put(stringArray[0], stringArray[1].replaceAll("\\\\n", "\n"));
            }
            bufferedReader.close();
            fileReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Configuration does not yet exist. Creating it...");
            Config.save();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static String get(String string) {
        return strings.get(string);
    }

    public static int getInt(String string) {
        String string2 = strings.get(string);
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public static void set(String string, Object object) {
        strings.put(string, String.valueOf(object));
    }

    public static void save() {
        try {
            FileWriter fileWriter = new FileWriter(configFile);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            Enumeration<String> enumeration = strings.keys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                String string2 = strings.get(string);
                bufferedWriter.write(string + "|" + string2);
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void showOptions() {
        final JFrame jFrame = new JFrame(Language.get("WIN_PREFS_TITLE"));
        JLabel jLabel = new JLabel(Language.get("WIN_PREFS_UPDATE_L"));
        final JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setSelected(Boolean.parseBoolean(Config.get("autoupdate")));
        JLabel jLabel2 = new JLabel(Language.get("WIN_PREFS_LANG_L"));
        Object[] objectArray = Language.getAvailableLanguages().toArray();
        final JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            if (!((Language)objectArray[i]).getCode().equals(Config.get("language"))) continue;
            jComboBox.setSelectedIndex(i);
        }
        JLabel jLabel3 = new JLabel(Language.get("WIN_PREFS_LAF_L"));
        String[] stringArray = new String[]{"System", "Metal: Steel", "Metal: Ocean"};
        final JComboBox<String> jComboBox2 = new JComboBox<String>(stringArray);
        jComboBox2.setSelectedItem(Config.get("swing.laf"));
        JLabel jLabel4 = new JLabel(Language.get("WIN_PREFS_RESTART_L"));
        JButton jButton = new JButton(Language.get("BUTTON_OK"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                strings.put("autoupdate", String.valueOf(jCheckBox.isSelected()));
                strings.put("language", ((Language)jComboBox.getSelectedItem()).getCode());
                strings.put("swing.laf", (String)jComboBox2.getSelectedItem());
                jFrame.setVisible(false);
                jFrame.dispose();
            }
        });
        JButton jButton2 = new JButton(Language.get("BUTTON_CANCEL"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jFrame.setVisible(false);
                jFrame.dispose();
            }
        });
        jFrame.add(jLabel2);
        jFrame.add(jComboBox);
        jFrame.add(jLabel);
        jFrame.add(jCheckBox);
        jFrame.add(jLabel3);
        jFrame.add(jComboBox2);
        jFrame.add(jLabel4);
        jFrame.add(jButton);
        jFrame.add(jButton2);
        Component[] componentArray = new Component[]{jLabel2, jLabel, jLabel3};
        int n = Helper.maxWidth(componentArray) + 10;
        int n2 = jLabel4.getPreferredSize().width + 5 - n;
        if (n2 < jComboBox.getPreferredSize().width) {
            n2 = jComboBox.getPreferredSize().width;
        }
        jComboBox.setPreferredSize(new Dimension(n2, jComboBox.getPreferredSize().height));
        SpringLayout springLayout = new SpringLayout();
        springLayout.putConstraint("North", (Component)jLabel2, 5, "North", (Component)jFrame.getContentPane());
        springLayout.putConstraint("West", (Component)jLabel2, 5, "West", (Component)jFrame.getContentPane());
        springLayout.putConstraint("VerticalCenter", jComboBox, 0, "VerticalCenter", (Component)jLabel2);
        springLayout.putConstraint("West", jComboBox, n, "West", (Component)jFrame.getContentPane());
        springLayout.putConstraint("North", (Component)jLabel, 10, "South", (Component)jLabel2);
        springLayout.putConstraint("West", (Component)jLabel, 5, "West", (Component)jFrame.getContentPane());
        springLayout.putConstraint("VerticalCenter", (Component)jCheckBox, 0, "VerticalCenter", (Component)jLabel);
        springLayout.putConstraint("West", (Component)jCheckBox, n, "West", (Component)jFrame.getContentPane());
        springLayout.putConstraint("East", (Component)jCheckBox, 0, "East", jComboBox);
        springLayout.putConstraint("North", (Component)jLabel3, 10, "South", (Component)jLabel);
        springLayout.putConstraint("West", (Component)jLabel3, 5, "West", (Component)jFrame.getContentPane());
        springLayout.putConstraint("VerticalCenter", jComboBox2, 0, "VerticalCenter", (Component)jLabel3);
        springLayout.putConstraint("West", jComboBox2, n, "West", (Component)jFrame.getContentPane());
        springLayout.putConstraint("East", jComboBox2, 0, "East", jComboBox);
        springLayout.putConstraint("North", (Component)jLabel4, 10, "South", (Component)jLabel3);
        springLayout.putConstraint("West", (Component)jLabel4, 5, "West", (Component)jFrame.getContentPane());
        springLayout.putConstraint("North", (Component)jButton, 10, "South", (Component)jLabel4);
        springLayout.putConstraint("West", (Component)jButton, 5, "West", (Component)jFrame.getContentPane());
        springLayout.putConstraint("West", (Component)jButton2, 5, "East", (Component)jButton);
        springLayout.putConstraint("North", (Component)jButton2, 0, "North", (Component)jButton);
        springLayout.putConstraint("South", (Component)jFrame.getContentPane(), 10, "South", (Component)jButton);
        springLayout.putConstraint("East", (Component)jFrame.getContentPane(), 5, "East", jComboBox);
        jFrame.setLayout(springLayout);
        jFrame.pack();
        jFrame.setResizable(false);
        jFrame.setVisible(true);
    }

    static {
        strings.put("autoupdate", "true");
        strings.put("language", "en");
        if (Language.isLanguageAvailable(System.getProperty("user.language"))) {
            strings.put("language", System.getProperty("user.language"));
        }
        strings.put("win.main.width", "800");
        strings.put("win.main.height", "600");
        strings.put("win.main.maximized", "false");
        strings.put("win.res.x", "0");
        strings.put("win.res.y", "0");
        strings.put("win.res.width", "190");
        strings.put("win.res.height", "200");
        strings.put("win.win.x", "0");
        strings.put("win.win.y", "200");
        strings.put("win.win.width", "190");
        strings.put("win.win.height", "150");
        strings.put("win.items.x", "0");
        strings.put("win.items.y", "350");
        strings.put("win.items.width", "190");
        strings.put("win.items.height", "200");
        strings.put("swing.laf", "System");
        if (System.getProperty("os.name").indexOf("Windows") != -1) {
            File file = new File(System.getenv("APPDATA"), "vlc");
            if (!file.exists()) {
                file.mkdirs();
            }
            configFile = new File(file, "VLCSkinEditor.cfg");
        } else {
            File file = new File("~/.vlc");
            if (!file.exists()) {
                file.mkdirs();
            }
            configFile = new File(file, "VLCSkinEditor.cfg");
        }
    }
}

