/*
 * Decompiled with CFR 0.152.
 */
package vncviewer;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import rdr.EndOfStream;
import rfb.AliasParameter;
import rfb.BoolParameter;
import rfb.Configuration;
import rfb.IntParameter;
import rfb.LogWriter;
import rfb.StringParameter;
import vncviewer.CConn;
import vncviewer.MessageBox;

public class VNCViewer
extends Applet
implements Runnable {
    public static final String version = "4.1";
    public static final String about1 = "VNC Viewer Free Edition 4.1";
    public static final String about2 = "Copyright (C) 2002-2004 RealVNC Ltd.";
    public static final String about3 = "See http://www.realvnc.com for information on VNC.";
    public static final String aboutText = "VNC Viewer Free Edition 4.1\nCopyright (C) 2002-2004 RealVNC Ltd.\nSee http://www.realvnc.com for information on VNC.";
    BoolParameter fastCopyRect = new BoolParameter("FastCopyRect", "Use fast CopyRect - turn this off if you get screen corruption when copying from off-screen", true);
    BoolParameter useLocalCursor = new BoolParameter("UseLocalCursor", "Render the mouse cursor locally", true);
    BoolParameter autoSelect = new BoolParameter("AutoSelect", "Auto select pixel format and encoding", true);
    BoolParameter fullColour = new BoolParameter("FullColour", "Use full colour - otherwise 6-bit colour is used until AutoSelect decides the link is fast enough", false);
    AliasParameter fullColor = new AliasParameter("FullColor", "Alias for FullColour", this.fullColour);
    StringParameter preferredEncoding = new StringParameter("PreferredEncoding", "Preferred encoding to use (ZRLE, hextile or raw) - implies AutoSelect=0", null);
    BoolParameter viewOnly = new BoolParameter("ViewOnly", "Don't send any mouse or keyboard events to the server", false);
    BoolParameter shared = new BoolParameter("Shared", "Don't disconnect other viewers upon connection - share the desktop instead", false);
    BoolParameter acceptClipboard = new BoolParameter("AcceptClipboard", "Accept clipboard changes from the server", true);
    BoolParameter sendClipboard = new BoolParameter("SendClipboard", "Send clipboard changes to the server", true);
    BoolParameter alwaysShowServerDialog = new BoolParameter("AlwaysShowServerDialog", "Always show the server dialog even if a server has been specified in an applet parameter or on the command line", false);
    StringParameter vncServerName = new StringParameter("Server", "The VNC server <host>[:<dpyNum>] or <host>::<port>", null);
    IntParameter vncServerPort = new IntParameter("Port", "The VNC server's port number, assuming it is on the host from which the applet was downloaded", 0);
    Thread thread;
    boolean applet;
    boolean firstApplet;
    Image logo;
    Label versionLabel;
    static int nViewers;
    static LogWriter vlog;

    static {
        vlog = new LogWriter("main");
    }

    public static void main(String[] argv) {
        VNCViewer viewer = new VNCViewer(argv);
        viewer.start();
    }

    /*
     * Unable to fully structure code
     */
    public VNCViewer(String[] argv) {
        super();
        this.applet = false;
        i = 0;
        while (i < argv.length) {
            block6: {
                block5: {
                    if (!argv[i].equalsIgnoreCase("-log")) break block5;
                    if (++i >= argv.length) {
                        VNCViewer.usage();
                    }
                    System.err.println("Log setting: " + argv[i]);
                    LogWriter.setLogParams(argv[i]);
                    break block6;
                }
                if (Configuration.setParam(argv[i])) break block6;
                if (argv[i].charAt(0) != '-') ** GOTO lbl32
                if (i + 1 < argv.length && Configuration.setParam(argv[i].substring(1), argv[i + 1])) {
                    ++i;
                } else {
                    VNCViewer.usage();
lbl32:
                    // 2 sources

                    if (this.vncServerName.getValue() != null) {
                        VNCViewer.usage();
                    }
                    this.vncServerName.setParam(argv[i]);
                }
            }
            ++i;
        }
    }

    public static void usage() {
        String usage = "\nusage: vncviewer [options/parameters] [host:displayNum] [options/parameters]\n\nOptions:\n  -log <level>    configure logging level\n\nParameters can be turned on with -<param> or off with -<param>=0\nParameters which take a value can be specified as -<param> <value>\nOther valid forms are <param>=<value> -<param>=<value> --<param>=<value>\nParameter names are case-insensitive.  The parameters are:\n\n" + Configuration.listParams();
        System.err.print(usage);
        System.exit(1);
    }

    public VNCViewer() {
        this.applet = true;
        this.firstApplet = true;
    }

    public static void newViewer(VNCViewer oldViewer) {
        VNCViewer viewer = new VNCViewer();
        viewer.applet = oldViewer.applet;
        viewer.firstApplet = false;
        viewer.start();
    }

    public void init() {
        vlog.debug("init called");
        this.setBackground(Color.white);
        this.logo = this.getImage(this.getDocumentBase(), "logo150x150.gif");
    }

    public void start() {
        vlog.debug("start called");
        ++nViewers;
        if (this.firstApplet) {
            this.alwaysShowServerDialog.setParam(true);
            Configuration.readAppletParams(this);
            String host = this.getCodeBase().getHost();
            if (this.vncServerName.getValue() == null && this.vncServerPort.getValue() != 0) {
                int port = this.vncServerPort.getValue();
                this.vncServerName.setParam(String.valueOf(host) + (port >= 5900 && port <= 5999 ? ":" + (port - 5900) : "::" + port));
            }
        }
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void paint(Graphics g) {
        g.drawImage(this.logo, 0, 0, this);
        int h = this.logo.getHeight(this) + 20;
        g.drawString(about1, 0, h);
        g.drawString(about2, 0, h += g.getFontMetrics().getHeight());
        g.drawString(about3, 0, h += g.getFontMetrics().getHeight());
    }

    public void run() {
        CConn cc;
        block8: {
            cc = null;
            try {
                cc = new CConn(this);
                if (cc.init(null, this.vncServerName.getValue(), this.alwaysShowServerDialog.getValue())) {
                    while (true) {
                        cc.processMsg();
                    }
                }
            }
            catch (EndOfStream e) {
                vlog.info(e.toString());
            }
            catch (Exception e) {
                if (cc != null) {
                    cc.removeWindow();
                }
                if (cc != null && cc.shuttingDown) break block8;
                e.printStackTrace();
                new MessageBox(e.toString());
            }
        }
        if (cc != null) {
            cc.removeWindow();
        }
        if (!this.applet && --nViewers == 0) {
            System.exit(0);
        }
    }
}

