/* ------------------------------------------------------------------------ */
/*                                                                          */
/* [sink.h]                       Type: Sink                                */
/*                                                                          */
/* Copyright (c) 1993 by Doelle, Manns                                      */
/* ------------------------------------------------------------------------ */

/* File generated by 'ctoh'. Don't change manually. */

#ifndef sink_INCL
#define sink_INCL


#include "standard.h"


#ifdef __cplusplus
extern "C" {
#endif


/*  
  This module [sink] implements a dynamic sink i.e. string stream.
  It uses the printf-konform formatting facility.

  Note: Float and double values aren't supported yet.
*/

/* ---------------------------- The Type ---------------------------------- */

AbstractType( Sink ); /* Abstract sink / string stream type */

/* ---------------------------- Basics ------------------------------------ */

Sink   Sink_open(void);                 /* creates a new sink               */
void   Sink_putc(Sink s, char c);       /* adds character 'c' to sink 's'   */
void   Sink_puts(Sink s, c_string str); /* adds string 'str' to sink 's'    */

void Sink_puts_raw(Sink s, c_string str)
/* adds string 'str' in a printable format to sink 's' */
;

c_string Sink_close(Sink s)
/* closes and converts sink 's' into a string;
   allocs memory
*/
;

c_bool Sink_empty(Sink s);              /* whether sink 's' is empty        */

/* ---------------------------- Printing ---------------------------------- */

void xultoa_aux(Sink dst, unsigned long value, int radix)
/* converts and adds long 'value' to sink 'dst' */
;

c_string xultoa(unsigned long value, int radix)
/* converts long 'value' into a string; allocs memory */
;

void Sink_vprintf(Sink sink, c_string format, va_list args)
/* like 'vfprintf'
   The text resulting from 'format' and arguments 'args'
   will be added to 'sink'.
*/
;

void Sink_printf(Sink sink, c_string format, ...)
/* like 'fprintf'
   The text resulting from 'format' and arguments '...'
   will be added to 'sink'.
*/
;

c_string Str_printf(c_string format, ...)
/* like 'sprintf'
   with resulting string from 'format' and arguments '...';
   allocs memory
*/
;



#ifdef __cplusplus
}
#endif

#endif
