# stress-ng Citations

* [Linux kernel performance test tool](https://github.com/intel/lkp-tests/commit/df80a984c3aab82972733114bac3ae19963cff1e)

2015:
* [An Investigation of CPU utilization relationship between host and guests in a Cloud infrastructure](http://www.diva-portal.org/smash/get/diva2:861239/FULLTEXT02)
* [CoMA: Resource Monitoring of Docker Containers](http://www.scitepress.org/Papers/2015/54480/54480.pdf)
* [Enhancing Cloud energy models for optimizing datacenters efficiency](https://cs.gmu.edu/~menasce/cs788/papers/ICCAC2015-Outin.pdf)
* [Tejo: A Supervised Anomaly Detection Scheme for NewSQL Databases](https://hal.archives-ouvertes.fr/hal-01211772/document)

2016:
* [A Virtual Network Function Workload Simulator](https://uu.diva-portal.org/smash/get/diva2:1043751/FULLTEXT01.pdf)
* [Characterizing and Reducing Cross-Platform Performance Variability Using OS-level Virtualization](http://www.lofstead.org/papers/2016-varsys.pdf)
* [CPU and memory performance analysis on dynamic and dedicated resource allocation using XenServer in Data Center environment](http://ieeexplore.ieee.org/document/7877341/)
* [DevOps for IoT Applications using Cellular Networks and Cloud](https://www.ericsson.com/assets/local/publications/conference-papers/devops.pdf)
* [How much power does your server consume? Estimating wall socket power using RAPL measurements](https://www.researchgate.net/publication/306004997_How_much_power_does_your_server_consume_Estimating_wall_socket_power_using_RAPL_measurements)
* [Increasing Platform Determinism PQOS DPDK](https://www.intel.com/content/dam/www/public/us/en/documents/white-papers/increasing-platform-determinism-pqos-dpdk-paper.pdf)
* [Towards Energy Efficient Data Management in HPC: The Open Ethernet Drive Approach](http://www.pdsw.org/pdsw-discs16/papers/p43-kougkas.pdf)
* [UIE: User-centric Interference Estimation for Cloud Applications](https://www3.cs.stonybrook.edu/~anshul/ic2e16_uie.pdf)

2017:
* [Advanced concepts and tools for renewable energy supply of Data Centres](https://www.riverpublishers.com/pdf/ebook/RP_9788793519411.pdf)
* [Algorithms and Architectures for Parallel Processing](https://books.google.co.uk/books?id=S4wwDwAAQBAJ&pg=PA7&lpg=PA7&dq=http://kernel.ubuntu.com/~cking/stress-ng/&source=bl&ots=bVZccBq2Io&sig=rIqKWyEhGmVPosAJiemKjGgEv0M&hl=en&sa=X&ved=0ahUKEwiFo6LO2fbXAhWBtxQKHRcnDY04HhDoAQguMAE#v=onepage&q=http%3A%2F%2Fkernel.ubuntu.com%2F~cking%2Fstress-ng%2F&f=false)
* [Auto-scaling of Containers: the impact of Relative and Absolute Metrics](https://www.researchgate.net/publication/319905237_Auto-Scaling_of_Containers_The_Impact_of_Relative_and_Absolute_Metrics)
* [Cloud Orchestration at the Level of Application](https://ec.europa.eu/research/participants/documents/downloadPublic/RFpPOGljenYrclUyK3N5eFN4NnVVZEJpVEl3TTAxcFhXRzRGaXdzN2dmSjBycjNIbXB6dlJ3PT0=/attachment/VFEyQTQ4M3ptUWQ4VDN5UWNDYVZ0UEVSWSt2REhrV1Q=)
* [Effectively Measure and Reduce Kernel Latencies for Real time Constraints](https://elinux.org/images/a/a9/ELC2017-_Effectively_Measure_and_Reduce_Kernel_Latencies_for_Real-time_Constraints_%281%29.pdf)
* [Elastic-PPQ: A two-level autonomic system for spatial preference query processing over dynamic data stream](https://www.researchgate.net/publication/319613604_Elastic-PPQ_A_two-level_autonomic_system_for_spatial_preference_query_processing_over_dynamic_data_streams)
* [Experience Report: Log Mining using Natural Language Processing and Application to Anomaly Detection](https://hal.laas.fr/hal-01576291/document)
* [Experimental and numerical analysis for potential heat reuse in liquid cooled data centres](http://personals.ac.upc.edu/jguitart/HomepageFiles/ECM16.pdf)
* [Measuring the impacts of the Preempt-RT patch](http://events17.linuxfoundation.org/sites/events/files/slides/rtpatch.pdf)
* [Mixed time-criticality process interferences characterization on a multicore Linux system](https://re.public.polimi.it/retrieve/handle/11311/1033069/292404/paper-accepted-version.pdf)
* [Modeling and Analysis of Performance under Interference in the Cloud](https://www3.cs.stonybrook.edu/~anshul/mascots17.pdf)
* [Monitoring and Analysis of CPU load relationships between Host and Guests in a Cloud Networking Infrastructure](http://www.diva-portal.org/smash/get/diva2:861235/FULLTEXT02)
* [Monitoring and Modelling Open Compute Servers](http://staff.www.ltu.se/~damvar/Publications/Eriksson%20et%20al.%20-%202017%20-%20Monitoring%20and%20Modelling%20Open%20Compute%20Servers.pdf)
* [OpenEPC integration within 5GTN as an NFV proof of concept](http://jultika.oulu.fi/files/nbnfioulu-201706082638.pdf)
* [Practical analysis of the Precision Time Protocol under different types of system load](http://www.diva-portal.org/smash/get/diva2:1106630/FULLTEXT01.pdf)
* [Reliable Library Identification Using VMI Techniques](https://rp.os3.nl/2016-2017/p64/report.pdf)
* [Testing the Windows Subsystem for Linux](https://blogs.msdn.microsoft.com/wsl/2017/04/11/testing-the-windows-subsystem-for-linux/)
* [Time-Aware Dynamic Binary Instrumentation](https://uwspace.uwaterloo.ca/bitstream/handle/10012/12182/Arafa_Pansy.pdf?sequence=3)
* [Towards Virtual Machine Energy-Aware Cost Prediction in Clouds](http://eprints.whiterose.ac.uk/124309/1/paper_final.pdf)

2018:
* [FECBench: An Extensible Framework for Pinpointing Sources of Performance Interference in the Cloud-Edge Resource Spectrum](https://www.academia.edu/68455840/FECBench_An_Extensible_Framework_for_Pinpointing_Sources_of_Performance_Interference_in_the_Cloud_Edge_Resource_Spectrum)
* [quiho: Automated Performance Regression Testing Using Inferred Resource Utilization Profiles](https://dl.acm.org/citation.cfm?id=3184422&dl=ACM&coll=DL&preflayout=flat)
* [Hypervisor and Virtual Machine Memory Optimization Analysis](http://dspace.ut.ee/bitstream/handle/10062/60705/Viitkar_BSc2018.pdf)
* [Multicore Emulation on Virtualised Environment](https://indico.esa.int/event/165/contributions/1230/attachments/1195/1412/04b_-_Multicore_-_Presentation.pdf)
* [Quantifying the Interaction Between Structural Properties of Software and Hardware in the ARM Big.LITTLE Architecture](https://research.abo.fi/ws/files/26568716/QuantifyingInteraction.pdf)
* [RAPL in Action: Experiences in Using RAPL for Power Measurements](https://dl.acm.org/doi/10.1145/3177754)
* [Real-Time testing with Fuego](https://elinux.org/images/4/43/ELC2018_Real-time_testing_with_Fuego-181024m.pdf)
* [Stress-SGX : Load and Stress your Enclaves for Fun and Profit](https://seb.vaucher.org/papers/stress-sgx.pdf)

2019:
* [A study on performance measures for auto-scaling CPU-intensive containerized applications](https://link.springer.com/article/10.1007/s10586-018-02890-1)
* [Analysis and Detection of Cache-Based Exploits](https://ssg.lancs.ac.uk/wp-content/uploads/2020/07/analysis_and_detection_vateva.pdf)
* [Anomaly Detection in NFV Using Tree-Based Unsupervised Learning Method](https://osf.io/preprints/indiarxiv/fxubm)
* [Estimating Cloud Application Performance Based on Micro-Benchmark Profiling](https://core.ac.uk/download/pdf/198051426.pdf)
* [kMVX: Detecting Kernel Information Leaks with Multi-variant Execution](https://research.vu.nl/ws/files/122357910/KMVX.pdf)
* [Performance Isolation of Co-located Workload in a Container-based Vehicle Software Architecture](https://www.thinkmind.org/articles/ambient_2019_2_20_40020.pdf)
* [Scalability of Kubernetes Running Over AWS](https://www.diva-portal.org/smash/get/diva2:1367111/FULLTEXT02)
* [Scavenger: A Black-Box Batch Workload Resource Manager for Improving Utilization in Cloud Environments](https://www3.cs.stonybrook.edu/~sjavadi/files/javadi_socc2019.pdf)

2020:
* [A Performance Analysis of Hardware-assisted Security Technologies](https://openscholarship.wustl.edu/cgi/viewcontent.cgi?article=1556&context=eng_etds)
* [C-Balancer: A System for Container Profiling and Scheduling](https://arxiv.org/pdf/2009.08912.pdf)
* [Demystifying the Real-Time Linux Scheduling Latency](https://bristot.me/files/research/papers/ecrts2020/deOliveira2020Demystifying.pdf)
* [Green Cloud Software Engineering for Big Data Processing](https://eprints.leedsbeckett.ac.uk/id/eprint/7294/1/GreenCloudSoftwareEngineeringForBigDataProcessingPV-KOR.pdf)
* [Latency-aware Resource Management in Data Centres](https://ntnuopen.ntnu.no/ntnu-xmlui/bitstream/handle/11250/2777859/no.ntnu%3Ainspera%3A57320302%3A34511143.pdf)
* [Low Energy Consumption on Post-Moore Platforms for HPC Research](https://revistas.usfq.edu.ec/index.php/avances/article/download/2108/2919/18081)
* [Managing Latency in Edge-Cloud Environment](https://s2group.cs.vu.nl/files/pubs/2020-JSS-IG-Edge_Cloud.pdf)
* [Modelling VM Latent Characteristics and Predicting Application Performance using Semi-supervised Non-negative Matrix Factorization](https://ieeexplore.ieee.org/document/9284328)
* [Performance and Energy Trade-Offs for Parallel Applications on Heterogeneous Multi-Processing Systems](https://www.mdpi.com/1996-1073/13/9/2409/htm)
* [Real-Time Detection for Cache Side Channel Attack using Performance Counter Monitor](https://www.proquest.com/docview/2533920884)
* [Real-time performance assessment using fast interrupt request on a standard Linux kernel](https://onlinelibrary.wiley.com/doi/full/10.1002/eng2.12114)
* [Semi-dynamic load balancing: efficient distributed learning in non-dedicated environments](https://dl.acm.org/doi/10.1145/3419111.3421299)
* [Subverting Linux’ Integrity Measurement Architecture](https://svs.informatik.uni-hamburg.de/publications/2020/2020-08-27-Bohling-IMA.pdf)

2021:
* [A Generalized Approach For Practical Task Allocation Using A MAPE-K Control Loop](https://www.marquez-barja.com/images/papers/A_Generalized_Approach_For_Software_Placement_In_The_Fog_Using_A_MAPE_K_Control_Loop-AuthorVersion.pdf)]
* [An Empirical Study of Thermal Attacks on Edge Platforms](https://digitalcommons.kennesaw.edu/cgi/viewcontent.cgi?article=1590&context=undergradsymposiumksu)
* [Evaluating Latency in Multiprocessing Embedded Systems for the Smart Grid](https://www.mdpi.com/1996-1073/14/11/3322)
* [Experimental Analysis in Hadoop MapReduce: A Closer Look at Fault Detection and Recovery Techniques](https://www.mdpi.com/1131714)
* [FIRESTARTER 2: Dynamic Code Generation for Processor Stress Tests](https://tu-dresden.de/zih/forschung/ressourcen/dateien/projekte/firestarter/FIRESTARTER-2-Dynamic-Code-Generation-for-Processor-Stress-Tests.pdf?lang=en)
* [Performance Characteristics of the BlueField-2 SmartNIC](https://arxiv.org/pdf/2105.06619.pdf)
* [Performance comparison between a Kubernetes cluster and an embedded system](http://www.diva-portal.se/smash/get/diva2:1569829/FULLTEXT01.pdf)
* [Performance Exploration of Virtualization Systems](https://www.researchgate.net/publication/350061536_Performance_Exploration_of_Virtualization_Systems)
* [PTEMagnet: Fine-Grained Physical Memory Reservation for Faster Page Walks in Public Clouds](https://www.pure.ed.ac.uk/ws/portalfiles/portal/196157550/PTEMagnet_MARGARITOV_DOA19112020_AFV.pdf)
* [Sage: Practical & Scalable ML-Driven Performance Debugging in Microservices](https://people.csail.mit.edu/delimitrou/papers/2021.asplos.sage.pdf)
* [Sequential Deep Learning Architectures for Anomaly Detection in Virtual Network Function Chains](https://arxiv.org/pdf/2109.14276.pdf)
* [Streamline: A Fast, Flushless Cache Covert-Channel Attack by Enabling Asynchronous Collusion](https://dl.acm.org/doi/pdf/10.1145/3445814.3446742)
* [The Price of Meltdown and Spectre: Energy Overhead of Mitigations at Operating System Level](https://www4.cs.fau.de/Publications/2021/herzog_2021_eurosec.pdf)
* [Towards Independent Run-time Cloud Monitoring](https://research.spec.org/icpe_proceedings/2021/companion/p21.pdf)
* [Tricking Hardware into Efficiently Securing Software](https://research.vu.nl/ws/portalfiles/portal/120740500/983666.pdf)
* [WattEdge: A Holistic Approach for Empirical Energy Measurements in Edge Computing](https://www.researchgate.net/publication/356342806_WattEdge_A_Holistic_Approach_for_Empirical_Energy_Measurements_in_Edge_Computing)
* [Work-in-Progress: Timing Diversity as a Protective Mechanism](https://dl.acm.org/doi/pdf/10.1145/3477244.3477614)

2022:
* [A general method for evaluating the overhead when consolidating servers: performance degradation in virtual machines and containers](https://link.springer.com/article/10.1007/s11227-022-04318-5)
* [Achieving Isolation in Mixed-Criticality Industrial Edge Systems with Real-Time Containers](https://drops.dagstuhl.de/opus/volltexte/2022/16332/pdf/LIPIcs-ECRTS-2022-15.pdf)
* [Design and Implementation of Machine Learning-Based Fault Prediction System in Cloud Infrastructure](https://www.mdpi.com/2079-9292/11/22/3765)
* [Don’t Mesh Around: Side-Channel Attacks and Mitigations on Mesh Interconnects](https://www.cs.cmu.edu/~rpaccagn/papers/dont-mesh-around-usenix2022.pdf)
* [Evaluation of Real-Time Linux on RISC-V processor architecture](https://trepo.tuni.fi/bitstream/handle/10024/138547/J%C3%A4mb%C3%A4ckMarkus.pdf)
* [Evaluating Secure Enclave Firmware Development for Contemporary RISC-V WorkstationsContemporary RISC-V Workstation](https://scholar.afit.edu/cgi/viewcontent.cgi?article=6319&context=etd)
* [FedComm: Understanding Communication Protocols for Edge-based Federated Learning](https://arxiv.org/pdf/2208.08764.pdf)
* [Hertzbleed: Turning Power Side-Channel Attacks Into Remote Timing Attacks on x86](https://www.hertzbleed.com/hertzbleed.pdf)
* [Machine Learning based Interference Modelling in Cloud-Native Applications](https://research.spec.org/icpe_proceedings/2022/proceedings/p125.pdf)
* [Performance Implications for Multi-Core RISC-V Systems with Dedicated Security Hardware](https://papers.academic-conferences.org/index.php/iccws/article/download/56/55/96)
* [The TSN Building Blocks in Linux](https://arxiv.org/pdf/2211.14138.pdf)
* [uKharon: A Membership Service for Microsecond Applications](https://www.usenix.org/system/files/atc22-guerraoui.pdf)

2023:
* [A 2-Phase Strategy for Intelligent Cloud Operations](https://ieeexplore.ieee.org/stamp/stamp.jsp?arnumber=10239346)
* [A Comprehensive Study on Optimizing Systems with Data Processing Units](https://arxiv.org/pdf/2301.06070.pdf)
* [A Methodology and Framework to Determine the Isolation Capabilities of Virtualisation Technologies](https://dl.acm.org/doi/pdf/10.1145/3578244.3583728)
* [A Modular Approach to Design an Experimental Framework for Resource Management Research](https://assets.researchsquare.com/files/rs-3400308/v1_covered_90a108f8-065c-4e38-9c56-990424f66afd.pdf?c=1697164725)
* [A Performance Evaluation of Embedded Multi-core Mixed-criticality System Based on PREEMPT RT Linux](https://www.jstage.jst.go.jp/article/ipsjjip/31/0/31_78/_pdf)
* [Adaptation of Parallel SaaS to Heterogeneous Co-Located Cloud Resources](https://www.mdpi.com/2076-3417/13/8/5115#B56-applsci-13-05115)
* [An Empirical Study of Resource-Stressing Faults in Edge-Computing Applications](https://dl.acm.org/doi/pdf/10.1145/3578354.3592873)
* [Cloud White: Detecting and Estimating QoS Degradation of Latency-Critical Workloads in the Public Cloud](https://www.sciencedirect.com/science/article/pii/S0167739X22002734)
* [Considerations for Benchmarking Network Performance in Containerized Infrastructures](https://datatracker.ietf.org/doc/draft-dcn-bmwg-containerized-infra/)
* [Data Leakage in Isolated Virtualized Enterprise Computing SystemsSystems](https://scholar.smu.edu/cgi/viewcontent.cgi?article=1034&context=engineering_compsci_etds)
* [Data Station: Delegated, Trustworthy, and Auditable Computation to Enable Data-Sharing Consortia with a Data Escrow](https://arxiv.org/pdf/2305.03842.pdf)
* [Dynamic Resource Management for Cloud-native Bulk Synchronous Parallel Applications](http://www.dre.vanderbilt.edu/~gokhale/WWW/papers/ISORC23_BSP.pdf)
* [EnergAt: Fine-Grained Energy Attribution for Multi-Tenancy](https://hotcarbon.org/2023/pdf/a4-he.pdf)
* [Enhancing Empirical Software Performance Engineering Research with Kernel-Level Events: A Comprehensive System Tracing Approach](https://papers.ssrn.com/sol3/papers.cfm?abstract_id=4556983)
* [Estimating Cloud Application Performance Based on Micro-Benchmark Profiling](https://research.chalmers.se/publication/506903/file/506903_Fulltext.pdf)
* [Experimental and numerical analysis of the thermal behaviour of a single-phase immersion-cooled data centre](https://www.sciencedirect.com/science/article/pii/S1359431123012899)
* [Feasibility Study for a Python-Based Embedded Real-Time Control System](https://www.mdpi.com/2079-9292/12/6/1426)
* [Fight Hardware with Hardware: System-wide Detection and Mitigation of Side-Channel Attacks using Performance Counters](https://dl.acm.org/doi/10.1145/3519601)
* [Finding flaky tests in JavaScript applications using stress and test suite reordering](https://repositories.lib.utexas.edu/handle/2152/120282)
* [Green coding : an empirical approach to harness the energy consumption ofsoftware services](https://theses.hal.science/tel-04074973/document)
* [Gotham Testbed: a Reproducible IoT Testbed for Security Experiments and Dataset Generation](https://arxiv.org/pdf/2207.13981.pdf)
* [Heterogeneous Anomaly Detection for Software Systems via Semi-supervised Cross-modal Attention](https://arxiv.org/pdf/2302.06914.pdf)
* [Introducing k4.0s: a Model for Mixed-Criticality Container Orchestration in Industry 4.0 ](https://arxiv.org/pdf/2205.14188.pdf)
* [Lightweight Implementation of Per-packet Service Protection in eBPF/XDP](https://arxiv.org/pdf/2312.07152.pdf)
* [Profiling with Trust: System Monitoring from Trusted Execution Environments](https://assets.researchsquare.com/files/rs-3169665/v1_covered_63751076-8387-429e-8296-3f3cc4c3ed34.pdf?c=1689832627)
* [Quantifying the Security Profile of Linux Applications](https://dl.acm.org/doi/10.1145/3609510.3609814)
* [PSPRAY: Timing Side-Channel based Linux Kernel Heap Exploitation Technique](https://lifeasageek.github.io/papers/yoochan-pspray.pdf)
* [Robust and accurate performance anomaly detection and prediction for cloud applications: a novel ensemble learning-based framework](https://journalofcloudcomputing.springeropen.com/articles/10.1186/s13677-022-00383-6#Fn4)
* [ROS2 Real-time Performance Optimization and Evaluation](https://cjme.springeropen.com/articles/10.1186/s10033-023-00976-5)
* [Targeted Deanonymization via the Cache Side Channel: Attacks and Defenses](https://leakuidatorplusteam.github.io/preprint.pdf)
* [The Power of Telemetry: Uncovering Software-Based Side-Channel Attacks on Apple M1/M2 Systems](https://arxiv.org/pdf/2306.16391.pdf)
* [Thermal-Aware on-Device Inference Using Single-Layer Parallelization with Heterogeneous Processors](https://www.sciopen.com/article/pdf/10.26599/TST.2021.9010075.pdf)
* [Towards Fast, Adaptive, and Hardware-Assisted User-Space Scheduling](https://arxiv.org/pdf/2308.02896.pdf)
* [Towards Serverless Optimization with In-place Scaling](https://arxiv.org/pdf/2311.09526.pdf)
* [Validating Full-System RISC-V Simulator: A Systematic Approach](https://infoscience.epfl.ch/record/302433)

2024:
* [A Comparison of Real-Time Linux-Based Architectures for Embedded Musical Applications](https://www.researchgate.net/publication/358135895_A_Comparison_of_Real-Time_Linux-Based_Architectures_for_Embedded_Musical_Applications)
* [A Preliminary Assessment of the real-time capabilities of Real-Time Linux on Raspberry Pi 5](https://www.ecrts.org/wp-content/uploads/2024/07/ospert24-proceedings.pdf)
* [An experimental approach for evaluating cache allocation policies in multicore for real-time mixed-criticality systems](https://hal.science/hal-04627006/document)
* [Anomaly Detection Within Mission-Critical Call Processing](https://arxiv.org/html/2408.14599v1)
* [BARO: Robust Root Cause Analysis for Microservices via Multivariate Bayesian Online Change Point Detection](https://arxiv.org/pdf/2405.09330)
* [Disambiguating Performance Anomalies from Workload Changes in Cloud-Native Applications](https://dl.acm.org/doi/pdf/10.1145/3629526.3645046)
* [Enhancing the PSI framework in Linux Kernel for predictive and accurate workload analysis](https://lpc.events/event/18/contributions/1884/attachments/1439/3069/LPC2024_PIntu_PSI.pdf)
* [Evaluation of Thermal Stress on Heterogeneous IoT-Based Federated Learning](https://www.mdpi.com/2079-9292/13/16/3140)
* [Exemplary Determination of Cgroups-Based QoS Isolation for a Database Workload](https://dl.acm.org/doi/pdf/10.1145/3629527.3652267)
* [IdleLeak: Exploiting Idle State Side Effects for Information Leakage](https://www.sicheroder.net/files/idleleak.pdf) * [Profiling with trust: system monitoring from trusted execution environments](https://www.researchgate.net/publication/378265673_Profiling_with_trust_system_monitoring_from_trusted_execution_environments)
* [Impact of power consumption in containerized clouds: A comprehensive analysis of open-source power measurement tools](https://www.sciencedirect.com/science/article/pii/S1389128624002032)
* [Interference-free Operating System: A 6 Years’ Experience in Mitigating Cross-Core Interference in Linux](https://arxiv.org/pdf/2412.18104)
* [Take a Step Further: Understanding Page Spray in Linux Kernel Exploitation](https://arxiv.org/html/2406.02624v2)
* [Nona: Accurate Power Prediction Model Using Neural Networks](https://dl.acm.org/doi/pdf/10.1145/3649329.3655668)
* [Optimizing Network Performance: Benchmarking of NVIDIA Bluefield-2 Offloading Capabilities](https://sol.sbc.org.br/index.php/errc/article/view/35428/35215)
* [Performance Analysis of Intel Total Memory Encryption Multi-Key](https://scholar.afit.edu/cgi/viewcontent.cgi?article=8692&context=etd)
* [SRFS: Parallel Processing Fault-tolerant ROS2-based Flight Software for the Space Ranger Cubes](https://arxiv.org/pdf/2412.08164)
* [Virtualization vs. Containerization, a Comparative Approach for Application Deployment in the Computing Continuum Focused on the Edge](https://www.researchgate.net/publication/385953515_Virtualization_vs_Containerization_a_Comparative_Approach_for_Application_Deployment_in_the_Computing_Continuum_Focused_on_the_Edge)

2025:
 * [A comprehensive performance evaluation of TEEs for confidential DNA alignment](https://iris.unito.it/retrieve/c4c635a3-4b06-4b75-9bdb-c36abb43ae76/1-s2.0-S0167739X25003267-main.pdf)
 * [A measurement-based approach to analyze the power consumption of the softwarized 5G core](https://arxiv.org/pdf/2502.13879)
 * [Adaptive Machine Learning for Resource-Constrained Environments](https://arxiv.org/pdf/2503.18634)
 * [Anomaly-Based Intrusion Detection for IoMT Networks: Design, Implementation, Dataset Generation, and ML Algorithms Evaluation](https://gala.gre.ac.uk/id/eprint/50712/1/50712%20MANTAS_Anomaly-Based_Intrusion_Detection_For_IoMT_Networks_Design_Implementation_Dataset%20Generation_And_ML_Algorithms_Evaluations_%28OA%29_2025.pdf)
 * [ASTREA: Introducing Agentic Intelligence for Orbital Themral Autonomy](https://arxiv.org/html/2509.13380v2)
 * [AUTOGUARDX: A Comprehensive Cybersecurity Framework for Connected Vehicles](https://arxiv.org/pdf/2508.18155)
 * [Benchmarking of CPU-intensive Stream Data Processing in The Edge Computing Systems](https://arxiv.org/html/2505.07755v1)
 * [CINERGY: Reasoning over the Worst Case Power Consumption of Cloud Virtual Machines](https://hal.science/hal-04981001/document)
 * [Container-level Energy Observability in Kubernetes Clusters](https://arxiv.org/pdf/2504.10702)
 * [Data Center Model for Transient Stability Analysis of Power Systems](https://arxiv.org/pdf/2505.16575)
 * [Dodoor: Efficient Randomized Decentralized Scheduling with Load Caching for Heterogeneous Tasks and Clusters](https://arxiv.org/pdf/2510.12889)
 * [Ecoscape: Fault Tolerance Benchmark for Adaptive Remediation Strategies in Real-Time Edge ML](https://arxiv.org/html/2507.22702v1)
 * [Efficient Fault Localization in a Cloud Stack Using End-to-End Application Service Topology](https://arxiv.org/html/2509.05511v1)
 * [FALCON: A Framework for Fault Prediction in Open RAN Using Multi-Level Telemetry](https://arxiv.org/pdf/2503.06197)
 * [FUKURO: An Agent-Driven Framework for Real-Time Remote Host Resource Managemen](https://rsisinternational.org/journals/ijriss/download_pdf.php?id=2021)
 * [GAL-MAD: Towards Explainable Anomaly Detection in Microservice Applications using Graph Attention Networks](https://www.arxiv.org/pdf/2504.00058)
 * [Graph Neural Networks for Anomaly Detection in Cloud Infrastructure](https://www.scirp.org/pdf/jcc_1733321.pdf)
 * [KernelSnitch: Side-Channel Attacks on Kernel Data Structures](https://www.ndss-symposium.org/wp-content/uploads/2025-223-paper.pdf)
 * [METRION: A Framework for Accurate Software Energy Measurement](https://arxiv.org/html/2512.06806v1)
 * [Non-Intrusive MLOps-Driven Performance Intelligence in Software Data Planes](https://arxiv.org/pdf/2506.17658)
 * [On Fault Tolerance of Data Storage Systems: A Holistic Perspective](https://arxiv.org/pdf/2507.03849v1)
 * [Performance Prediction of On-NIC Network Functions with Multi-Resource Contention and Traffic Awareness](https://arxiv.org/html/2405.05529v5)
 * [Profiling with trust: system monitoring from trusted execution environments](https://www.researchgate.net/publication/378265673_Profiling_with_trust_system_monitoring_from_trusted_execution_environments)
 * [RAS-IoT: A Container-Based Solution for IoT Application Replacement](https://link.springer.com/chapter/10.1007/978-3-031-87766-7_37)
 * [RCAEval: A Benchmark for Root Cause Analysis of Microservice Systems with Telemetry Data](https://arxiv.org/html/2412.17015v4)
 * [Research on AutoTune: A Lightweight Feedback-Driven Kernel Parameter Tuning System for High-Concurrency VMware Environments](https://www.jetir.org/papers/JETIR2505703.pdf)
 * [ROS 2 Agnocast: Supporting Unsized Message Types for True Zero-Copy Publish/Subscribe IPC](https://www.arxiv.org/pdf/2506.16882)
 * [Rubicon: Precise Microarchitectural Attacks with Page-Granular Massaging](https://comsec-files.ethz.ch/papers/rubicon_eurosp25.pdf)
 * [SPAM: Streamlined Prefetcher-Aware Multi-Threaded Cache Covert-Channel Attack](https://www.cse.iitb.ac.in/~biswa/CAL25.pdf)
 * [SPY-PMU: Side-Channel Profiling of Your Performance Monitoring Unit to Leak Remote User Activity](https://eprint.iacr.org/2025/014)
 * [Slice+Slice Baby: Generating Last-Level Cache Eviction Sets in the Blink of an Eye](https://arxiv.org/pdf/2504.11208)
 * [SkyForge Core: A Triple Modular Redundant Computing Architecture for Small Satellites](https://pillars.taylor.edu/cgi/viewcontent.cgi?article=1000&context=physics-engineering-student-papers)
 * [Systematic Analysis of Kernel Security Performance and Energy Costs](https://dl.acm.org/doi/pdf/10.1145/3708821.3736197)
 * [Towards Accurate RISC-V Full System Simulation via Component-level Calibration](https://arodes.hes-so.ch/record/16139/files/Zapater_2025_Towards_accurate_RISC-V_full_system_simulation.pdf)
 * [TUNA: Tuning Unstable and Noisy Cloud Applications](https://www.microsoft.com/en-us/research/wp-content/uploads/2025/02/TUNA_EuroSys_2025.pdf)
 * [TZ-LLM: Protecting On-Device Large Language Models with Arm TrustZone](https://arxiv.org/pdf/2511.13717)
 * [When Radiation Meets Linux: Analyzing Soft Errors in Linux on COTS SoCs under Proton Irradiation](https://arxiv.org/html/2503.03722v1)
 * [When Things Heat Up: Detecting Malicious Activity Using CPU Thermal Sensors](https://www.mdpi.com/2624-800X/5/3/56)
 * [xPUE: Extending Power Usage Effectiveness Metrics for Cloud Infrastructures](https://arxiv.org/pdf/2503.07124)

