/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.template;

import org.apache.ecs.Element;
import org.apache.ecs.HtmlColor;
import org.apache.ecs.html.Link;
import org.apache.ecs.html.Meta;
import org.apache.ecs.html.Title;
import org.apache.turbine.services.pull.ApplicationTool;
import org.apache.turbine.util.RunData;

public class TemplatePageAttributes
implements ApplicationTool {
    private RunData data = null;
    private String cachedTitle = null;

    public void init(Object data) {
        this.data = (RunData)data;
        this.cachedTitle = null;
    }

    public void refresh() {
    }

    public TemplatePageAttributes setTitle(String intitle) {
        Title title = this.data.getPage().getTitle();
        this.cachedTitle = this.cachedTitle != null ? this.cachedTitle + intitle : intitle;
        title.addElement(intitle);
        return this;
    }

    public String getTitle() {
        if (this.cachedTitle == null) {
            return "";
        }
        return this.cachedTitle;
    }

    public TemplatePageAttributes setStyleSheet(String url) {
        this.data.getPage().getHead().addElement((Element)new Link().setRel("stylesheet").setType("text/css").setHref(url));
        return this;
    }

    public TemplatePageAttributes setKeywords(String keywords) {
        this.data.getPage().getHead().addElement((Element)new Meta().setName("keywords").setContent(keywords));
        return this;
    }

    public TemplatePageAttributes setHttpEquiv(String httpEquiv, String content) {
        this.data.getPage().getHead().addElement((Element)new Meta().setHttpEquiv(httpEquiv).setContent(content));
        return this;
    }

    public TemplatePageAttributes setDescription(String description) {
        this.data.getPage().getHead().addElement((Element)new Meta().setName("description").setContent(description));
        return this;
    }

    public TemplatePageAttributes setBackground(String url) {
        this.data.getPage().getBody().setBackground(url);
        return this;
    }

    public TemplatePageAttributes setBgColor(String color) {
        String hexColor = HtmlColor.getColor((String)color);
        if (hexColor == null) {
            hexColor = color;
        }
        this.data.getPage().getBody().setBgColor(hexColor);
        return this;
    }

    public TemplatePageAttributes setTextColor(String color) {
        String hexColor = HtmlColor.getColor((String)color);
        if (hexColor == null) {
            hexColor = color;
        }
        this.data.getPage().getBody().setText(hexColor);
        return this;
    }

    public TemplatePageAttributes setLinkColor(String color) {
        String hexColor = HtmlColor.getColor((String)color);
        if (hexColor == null) {
            hexColor = color;
        }
        this.data.getPage().getBody().setLink(hexColor);
        return this;
    }

    public TemplatePageAttributes setVlinkColor(String color) {
        String hexColor = HtmlColor.getColor((String)color);
        if (hexColor == null) {
            hexColor = color;
        }
        this.data.getPage().getBody().setVlink(hexColor);
        return this;
    }

    public TemplatePageAttributes addAttribute(String name, String value) {
        this.data.getPage().getBody().addAttribute(name, value);
        return this;
    }

    public String toString() {
        return "";
    }

    public TemplatePageAttributes() {
    }

    public TemplatePageAttributes(RunData data) {
        this.data = data;
    }
}

