/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.core.component;

import org.apache.turbine.util.Log;
import org.chefproject.core.ChatMessage;
import org.chefproject.core.UsageSession;
import org.chefproject.core.User;
import org.chefproject.core.component.BaseDelivery;
import org.chefproject.core.component.RefreshDelivery;
import org.chefproject.service.UsageSessionService;
import org.chefproject.util.Different;
import org.chefproject.util.Reference;
import org.chefproject.util.Validator;

public class ChatDelivery
extends BaseDelivery {
    protected String m_messageId = null;
    protected boolean m_beepOnDelivery = false;

    public ChatDelivery(String address, String elementId, String messageID, boolean beepOnDelivery) {
        super(address, elementId);
        this.m_messageId = messageID;
        this.m_beepOnDelivery = beepOnDelivery;
    }

    public void setMessage(String id) {
        this.m_messageId = id;
    }

    public String getMessage() {
        return this.m_messageId;
    }

    public String compose() {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", this + ".compose() element: " + this.m_elementId + ", message: " + this.m_messageId);
        }
        UsageSession mysession = UsageSessionService.getSession();
        Reference ref = new Reference(this.m_messageId);
        ChatMessage msg = (ChatMessage)ref.getResource();
        User sender = msg.getHeader().getFrom();
        User myself = mysession.getUser();
        String browserID = mysession.getBrowserId();
        String jsCommand = browserID.equals("UnknownBrowser") ? RefreshDelivery.composeRefresh(this.m_elementId) : BaseDelivery.ifExistsScript("parent." + this.m_elementId) + "\n" + "{\n" + "\tparent." + this.m_elementId + ".appendMessage(\"" + sender.getDisplayName() + "\", \"" + msg.getHeader().getDate().toStringLocalDate() + "\", \"" + msg.getHeader().getDate().toStringLocalTime() + "\", \"" + Validator.escapeHtml(msg.getBody()) + "\");\n}\n";
        if (this.m_beepOnDelivery && sender.compareTo(myself) != 0) {
            jsCommand = jsCommand + "beep = true;\n";
        }
        return jsCommand;
    }

    public String toString() {
        return super.toString() + " : " + this.m_messageId;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ChatDelivery cob = (ChatDelivery)obj;
        return !Different.different(cob.getMessage(), this.getMessage());
    }
}

