// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

using System;

namespace System.Windows.Input
{
    /////////////////////////////////////////////////////////////////////////
    /// <summary>
    /// The type of the tablet device (Stylus, Touch)
    /// </summary>
    /// <ExternalAPI/>
    public enum TabletDeviceType
    {
        /// <summary> Stylus input coming from a Stylus digitizer </summary>
        Stylus      = 0,

        /// <summary> Stylus input coming from a Touch digitizer </summary>
        Touch       = 1
    }
}

