/*******************************************************************************
 * This file is part of BOINC.
 * http://boinc.berkeley.edu
 * Copyright (C) 2012 University of California
 * 
 * BOINC is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation,
 * either version 3 of the License, or (at your option) any later version.
 * 
 * BOINC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with BOINC.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/

package edu.berkeley.boinc.rpc;

import android.os.Parcel;
import android.os.Parcelable;

public class Notice implements Parcelable {
	public int seqno = -1;
    public String title = "";
    public String description = "";
    public double create_time;
    public double arrival_time; 
    public boolean is_private;
    public String category = "";
        // assigned by RSS source.  Reserved values:
        // "client": generated by client
        // "server": scheduler RPC message
    public String link = "";
        // URL where original message can be seen, if any
    public String project_name;
        // if notice is associated with a project
    
    public boolean isServerNotice;
    public boolean isClientNotice;
    
	@Override
	public int describeContents() {
		// TODO Auto-generated method stub
		return 0;
	}
	@Override
	public void writeToParcel(Parcel dest, int flags) {
		// TODO Auto-generated method stub
		dest.writeInt(seqno);
		dest.writeString(title);
		dest.writeString(description);
		dest.writeDouble(create_time);
		dest.writeDouble(arrival_time);
		dest.writeString(category);
		dest.writeString(link);
		dest.writeString(project_name);
		
		dest.writeBooleanArray(new boolean[] {
				is_private,
				isServerNotice,
				isClientNotice});
	}
	
	public Notice() {}
	
	private Notice(Parcel in) {
		seqno = in.readInt();
		title = in.readString();
		description = in.readString();
		create_time = in.readDouble();
		arrival_time = in.readDouble();
		category = in.readString();
		link = in.readString();
		project_name = in.readString();
		
		boolean[] bArray = in.createBooleanArray();
		is_private = bArray[0];
		isServerNotice = bArray[1];
		isClientNotice = bArray[2];
		
	}
	
	public static final Parcelable.Creator<Notice> CREATOR = new Parcelable.Creator<Notice>() {
		public Notice createFromParcel(Parcel in) {
		    return new Notice(in);
		}
		public Notice[] newArray(int size) {
		    return new Notice[size];
		}
	};
}
