/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ext.xerces.impl.xs;

import org.apache.jena.ext.xerces.impl.dv.xs.SchemaDVFactoryImpl;
import org.apache.jena.ext.xerces.impl.dv.xs.XSSimpleTypeDecl;

public final class XSDeclarationPool {
    private static final int CHUNK_SHIFT = 8;
    private static final int CHUNK_SIZE = 256;
    private static final int CHUNK_MASK = 255;
    private static final int INITIAL_CHUNK_COUNT = 4;
    private XSSimpleTypeDecl[][] fSTDecl = new XSSimpleTypeDecl[4][];
    private int fSTDeclIndex = 0;
    private SchemaDVFactoryImpl dvFactory;

    public void setDVFactory(SchemaDVFactoryImpl dvFactory) {
        this.dvFactory = dvFactory;
    }

    public final XSSimpleTypeDecl getSimpleTypeDecl() {
        int chunk = this.fSTDeclIndex >> 8;
        int index = this.fSTDeclIndex & 0xFF;
        this.ensureSTDeclCapacity(chunk);
        if (this.fSTDecl[chunk][index] == null) {
            this.fSTDecl[chunk][index] = this.dvFactory.newXSSimpleTypeDecl();
        } else {
            this.fSTDecl[chunk][index].reset();
        }
        ++this.fSTDeclIndex;
        return this.fSTDecl[chunk][index];
    }

    private boolean ensureSTDeclCapacity(int chunk) {
        if (chunk >= this.fSTDecl.length) {
            this.fSTDecl = XSDeclarationPool.resize(this.fSTDecl, this.fSTDecl.length * 2);
        } else if (this.fSTDecl[chunk] != null) {
            return false;
        }
        this.fSTDecl[chunk] = new XSSimpleTypeDecl[256];
        return true;
    }

    private static XSSimpleTypeDecl[][] resize(XSSimpleTypeDecl[][] array, int newsize) {
        XSSimpleTypeDecl[][] newarray = new XSSimpleTypeDecl[newsize][];
        System.arraycopy(array, 0, newarray, 0, array.length);
        return newarray;
    }

    public void reset() {
        this.fSTDeclIndex = 0;
    }
}

