/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4; fill-column: 100 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */
#pragma once

#include <rtl/ustring.hxx>

inline constexpr OUString STR_HTML_GENERATOR
    = u"%PRODUCTNAME %PRODUCTVERSION%PRODUCTEXTENSION (%1)"_ustr;

// Do not translate STR_TEMPLATE_NAME*_DEF names!!
// STR_TEMPLATE_NAME*_DEF strings must EXACTLY fit dc:title tag in meta.xml of each template file
inline constexpr OUString STR_TEMPLATE_NAME1_DEF = u"Grey Elegant"_ustr;
inline constexpr OUString STR_TEMPLATE_NAME2_DEF = u"Beehive"_ustr;
inline constexpr OUString STR_TEMPLATE_NAME3_DEF = u"Blue Curve"_ustr;
inline constexpr OUString STR_TEMPLATE_NAME4_DEF = u"Blueprint Plans"_ustr;
inline constexpr OUString STR_TEMPLATE_NAME5_DEF = u"Candy"_ustr;
inline constexpr OUString STR_TEMPLATE_NAME6_DEF = u"Yellow Idea"_ustr;
inline constexpr OUString STR_TEMPLATE_NAME7_DEF = u"DNA"_ustr;
inline constexpr OUString STR_TEMPLATE_NAME8_DEF = u"Focus"_ustr;
inline constexpr OUString STR_TEMPLATE_NAME9_DEF = u"Forestbird"_ustr;
inline constexpr OUString STR_TEMPLATE_NAME10_DEF = u"Freshes"_ustr;
inline constexpr OUString STR_TEMPLATE_NAME11_DEF = u"Inspiration"_ustr;
inline constexpr OUString STR_TEMPLATE_NAME12_DEF = u"Lights"_ustr;
inline constexpr OUString STR_TEMPLATE_NAME13_DEF = u"Growing Liberty"_ustr;
inline constexpr OUString STR_TEMPLATE_NAME14_DEF = u"Metropolis"_ustr;
inline constexpr OUString STR_TEMPLATE_NAME15_DEF = u"Midnightblue"_ustr;
inline constexpr OUString STR_TEMPLATE_NAME16_DEF = u"Nature Illustration"_ustr;
inline constexpr OUString STR_TEMPLATE_NAME17_DEF = u"Pencil"_ustr;
inline constexpr OUString STR_TEMPLATE_NAME18_DEF = u"Piano"_ustr;
inline constexpr OUString STR_TEMPLATE_NAME19_DEF = u"Portfolio"_ustr;
inline constexpr OUString STR_TEMPLATE_NAME20_DEF = u"Progress"_ustr;
inline constexpr OUString STR_TEMPLATE_NAME21_DEF = u"Sunset"_ustr;
inline constexpr OUString STR_TEMPLATE_NAME22_DEF = u"Vintage"_ustr;
inline constexpr OUString STR_TEMPLATE_NAME23_DEF = u"Vivid"_ustr;
inline constexpr OUString STR_TEMPLATE_NAME24_DEF = u"CV"_ustr;
inline constexpr OUString STR_TEMPLATE_NAME25_DEF = u"Resume"_ustr;
inline constexpr OUString STR_TEMPLATE_NAME26_DEF = u"Default"_ustr;
inline constexpr OUString STR_TEMPLATE_NAME27_DEF = u"Modern"_ustr;
inline constexpr OUString STR_TEMPLATE_NAME28_DEF = u"Modern business letter sans-serif"_ustr;
inline constexpr OUString STR_TEMPLATE_NAME29_DEF = u"Modern business letter serif"_ustr;
inline constexpr OUString STR_TEMPLATE_NAME30_DEF = u"Businesscard with logo"_ustr;
inline constexpr OUString STR_TEMPLATE_NAME31_DEF = u"Simple"_ustr;
inline constexpr OUString STR_TEMPLATE_NAME32_DEF = u"BPMN"_ustr;
inline constexpr OUString STR_TEMPLATE_NAME33_DEF = u"Simplified Chinese Normal"_ustr;
inline constexpr OUString STR_TEMPLATE_NAME34_DEF = u"Japanese Normal"_ustr;

inline constexpr OUString CMIS_TYPE_STRING = u"String"_ustr;
#define CMIS_TYPE_INTEGER "Integer"
#define CMIS_TYPE_DECIMAL "Decimal"
#define CMIS_TYPE_DATETIME "Datetime"
#define CMIS_TYPE_BOOL "Bool"

/* vim:set shiftwidth=4 softtabstop=4 expandtab cinoptions=b1,g0,N-s cinkeys+=0=break: */
