/*
 * Decompiled with CFR 0.152.
 */
package org.xmlopen.zipspy;

import java.io.ByteArrayInputStream;
import java.net.URL;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.log4j.PropertyConfigurator;
import org.junit.Test;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;
import org.xmlopen.zipspy.ZipArchive;
import org.xmlopen.zipspy.ZipLocalHeader;

public class ZipArchiveTest
extends TestCase {
    ZipArchive za;

    protected void setUp() throws Exception {
        super.setUp();
        URL url = new URL("file:etc/testdata/maria.xlsx");
        this.za = new ZipArchive(url);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void test_notNull() {
        ZipArchiveTest.assertTrue((this.za != null ? 1 : 0) != 0);
    }

    @Test
    public void test_headerCount() {
        ZipArchiveTest.assertTrue((this.za.getLocalHeaderCount() == 14 ? 1 : 0) != 0);
    }

    @Test
    public void test_countsMatch() {
        ZipArchiveTest.assertTrue((this.za.getLocalHeaderCount() == this.za.getCentralRecordCount() ? 1 : 0) != 0);
    }

    @Test
    public void test_aHeader() {
        ZipLocalHeader h = this.za.getLocalHeader(0);
        ZipArchiveTest.assertTrue((h.getExtractVersion()[0] == 20 ? 1 : 0) != 0);
        ZipArchiveTest.assertTrue((h.getExtractVersion()[1] == 0 ? 1 : 0) != 0);
        ZipArchiveTest.assertTrue((h.getGeneral() == 6 ? 1 : 0) != 0);
        ZipArchiveTest.assertTrue((h.getMethod()[0] == 8 ? 1 : 0) != 0);
        ZipArchiveTest.assertTrue((h.getMethod()[1] == 0 ? 1 : 0) != 0);
        ZipArchiveTest.assertTrue((h.getModTime()[0] == 0 ? 1 : 0) != 0);
        ZipArchiveTest.assertTrue((h.getModTime()[1] == 0 ? 1 : 0) != 0);
        ZipArchiveTest.assertTrue((h.getModDate()[0] == 33 ? 1 : 0) != 0);
        ZipArchiveTest.assertTrue((h.getModDate()[1] == 0 ? 1 : 0) != 0);
        ZipArchiveTest.assertTrue((h.getCrc32() == 1708292427 ? 1 : 0) != 0);
        ZipArchiveTest.assertTrue((h.getCompressedSize() == 412 ? 1 : 0) != 0);
        ZipArchiveTest.assertTrue((h.getUncompressedSize() == 846 ? 1 : 0) != 0);
        ZipArchiveTest.assertTrue((h.getFilenameLength() == 16 ? 1 : 0) != 0);
        ZipArchiveTest.assertTrue((h.getExtraFieldLength() == 264 ? 1 : 0) != 0);
        ZipArchiveTest.assertTrue((boolean)h.getFilename().equals("docProps/app.xml"));
    }

    @Test
    public void test_xml() {
        String s = this.za.asXmlString();
        boolean ok = true;
        try {
            XMLReader r = XMLReaderFactory.createXMLReader();
            r.parse(new InputSource(new ByteArrayInputStream(s.getBytes())));
        }
        catch (Exception e) {
            ok = false;
        }
        ZipArchiveTest.assertTrue((boolean)ok);
    }

    static {
        String logLvl = System.getProperty("property://probatron.org/officeotron-log-level");
        logLvl = logLvl == null ? "DEBUG" : logLvl;
        Properties p = new Properties();
        p.setProperty("log4j.rootCategory", logLvl + ", A1");
        p.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        p.setProperty("log4j.appender.A1.target", "System.err");
        p.setProperty("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
        p.setProperty("log4j.appender.A1.layout.ConversionPattern", "%c %p - %m%n");
        PropertyConfigurator.configure(p);
    }
}

