/*
 * Decompiled with CFR 0.152.
 */
package org.probatron.officeotron;

import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.ValidationDriver;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.probatron.officeotron.CommentatingErrorHandler;
import org.probatron.officeotron.ODFPackage;
import org.probatron.officeotron.ODFSniffer;
import org.probatron.officeotron.OptionMap;
import org.probatron.officeotron.ReportFactory;
import org.probatron.officeotron.Utils;
import org.probatron.officeotron.ValidationReport;
import org.probatron.officeotron.XMLSniffData;
import org.probatron.officeotron.sessionstorage.ValidationSession;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ODFValidationSession
extends ValidationSession {
    static Logger logger = Logger.getLogger(ODFValidationSession.class);
    private static byte[] schema10;
    private static byte[] schema11;
    private static byte[] schema12;
    private static byte[] manifest12;
    private boolean forceIs;
    private boolean checkIds;
    private boolean uses12;

    public ODFValidationSession(UUID uUID, OptionMap optionMap, ReportFactory reportFactory) {
        super(uUID, reportFactory);
        this.forceIs = optionMap.getBooleanOption("force-is");
        this.checkIds = optionMap.getBooleanOption("check-ids");
        logger.trace("Creating ODFValidationSession. forceIs=" + this.forceIs + "; checkIds=" + this.checkIds);
    }

    @Override
    public void validate() {
        ODFPackage oDFPackage;
        try {
            oDFPackage = this.parseManifest();
        }
        catch (SAXException sAXException) {
            this.getCommentary().addComment("ERROR", "The manifest cannot be parsed");
            return;
        }
        catch (IOException iOException) {
            this.getCommentary().addComment("ERROR", "The manifest cannot be extracted or is corrupt");
            return;
        }
        this.processManifestDocs(oDFPackage);
        if (this.uses12) {
            this.validateManifest();
        }
        this.getCommentary().addComment("Grand total count of validity errors: " + this.getCommentary().getErrCount());
    }

    /*
     * Exception decompiling
     */
    private void validateManifest() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ODFPackage parseManifest() throws SAXException, IOException {
        String string = this.getUrlForEntry("META-INF/manifest.xml").toString();
        ODFPackage oDFPackage = new ODFPackage();
        oDFPackage.process(string);
        return oDFPackage;
    }

    private void processManifestDocs(ODFPackage oDFPackage) {
        for (int i = 0; i < oDFPackage.getItemRefs().size(); ++i) {
            XMLSniffData xMLSniffData;
            String string = oDFPackage.getItemTypes().get(i);
            String string2 = oDFPackage.getItemRefs().get(i);
            if (string2.endsWith("/")) continue;
            if (string.equals("")) {
                this.getCommentary().addComment("WARN", "Manifest entry for \"" + string2 + "\" should have a MIME type, but has an empty string");
            }
            if (string.indexOf("xml") == -1 && !string2.trim().endsWith(".xml")) {
                logger.debug("Skipping entry " + string2);
                continue;
            }
            String string3 = this.getUrlForEntry(string2).toString();
            logger.debug("processing " + string3);
            this.getCommentary().addComment("Processing manifest entry: " + string2);
            this.getCommentary().incIndent();
            ODFSniffer oDFSniffer = new ODFSniffer(this.getCommentary(), this.checkIds);
            try {
                xMLSniffData = oDFSniffer.doSniff(string3);
            }
            catch (Exception exception) {
                logger.fatal("Referenced resource in manifest cannot be found/processed");
                this.getCommentary().addComment("WARN", "Referenced resource in manifest cannot be found/processed");
                this.getCommentary().decIndent();
                continue;
            }
            if (xMLSniffData.getRootNs().equals("urn:oasis:names:tc:opendocument:xmlns:office:1.0")) {
                this.processODFDocument(string3, xMLSniffData);
            }
            logger.trace("Done document processing");
            if (oDFSniffer.getGenerator() != "") {
                this.getCommentary().addComment("The generator value is: \"<b>" + oDFSniffer.getGenerator().trim() + "</b>\"");
            }
            this.getCommentary().decIndent();
        }
    }

    private void processODFDocument(String string, XMLSniffData xMLSniffData) {
        String string2 = Utils.getQAtt(xMLSniffData.getAtts(), "urn:oasis:names:tc:opendocument:xmlns:office:1.0", "version");
        logger.debug("version is " + string2);
        this.getCommentary().addComment("It has root element named &lt;" + xMLSniffData.getRootElementName() + "> in the namespace <tt>" + xMLSniffData.getRootNs() + "</tt>");
        logger.trace("beginning validation with force setting of " + this.forceIs);
        if (this.forceIs) {
            this.getCommentary().addComment("WARN", "Forcing validation against ISO/IEC 26300");
            string2 = "1.0";
        } else if (string2 != null) {
            this.getCommentary().addComment("It claims to be ODF version " + string2);
        } else {
            this.getCommentary().addComment("WARN", "It has no version attribute! (assuming ODF v1.1)");
            string2 = "1.1";
        }
        try {
            this.validateODFDoc(string, string2, this.getCommentary());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateODFDoc(String string, String string2, ValidationReport validationReport) throws IOException, MalformedURLException {
        logger.debug("Beginning document validation ...");
        Class<ODFValidationSession> clazz = ODFValidationSession.class;
        synchronized (ODFValidationSession.class) {
            PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder();
            String[] stringArray = string.split("/");
            CommentatingErrorHandler commentatingErrorHandler = new CommentatingErrorHandler(validationReport, stringArray[stringArray.length - 1]);
            ValidateProperty.ERROR_HANDLER.put(propertyMapBuilder, commentatingErrorHandler);
            ValidationDriver validationDriver = new ValidationDriver(propertyMapBuilder.toPropertyMap());
            InputStream inputStream = null;
            try {
                logger.debug("Loading schema version " + string2);
                byte[] byArray = this.getSchemaForVersion(string2);
                validationDriver.loadSchema(new InputSource(new ByteArrayInputStream(byArray)));
                URLConnection uRLConnection = new URL(string).openConnection();
                inputStream = uRLConnection.getInputStream();
                logger.debug("Calling validate()");
                validationReport.incIndent();
                boolean bl = validationDriver.validate(new InputSource(inputStream));
                logger.debug("Errors in instance:" + commentatingErrorHandler.getInstanceErrCount());
                if (commentatingErrorHandler.getInstanceErrCount() > 10) {
                    validationReport.addComment("(<i>" + (commentatingErrorHandler.getInstanceErrCount() - 10) + " error(s) omitted for the sake of brevity</i>)");
                }
                validationReport.decIndent();
                if (bl) {
                    validationReport.addComment("The document is valid");
                } else {
                    validationReport.addComment("ERROR", "The document is invalid");
                }
                Utils.streamClose(inputStream);
            }
            catch (SAXException sAXException) {
                validationReport.addComment("FATAL", "The resource is not conformant XML: " + sAXException.getMessage());
                logger.error(sAXException.getMessage());
            }
            finally {
                Utils.streamClose(inputStream);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private byte[] getSchemaForVersion(String string) {
        byte[] byArray = null;
        if (string.equals("1.0")) {
            byArray = schema10;
        } else if (string.equals("1.1")) {
            byArray = schema11;
        } else if (string.equals("1.2")) {
            byArray = schema12;
            this.uses12 = true;
        } else {
            logger.fatal("No version found ...");
            return null;
        }
        return byArray;
    }

    static {
        try {
            schema10 = Utils.derefUrl(new URL("http://www.oasis-open.org/committees/download.php/12571/OpenDocument-schema-v1.0-os.rng"));
            schema11 = Utils.derefUrl(new URL("http://docs.oasis-open.org/office/v1.1/OS/OpenDocument-schema-v1.1.rng"));
            schema12 = Utils.derefUrl(new URL("http://docs.oasis-open.org/office/v1.2/csprd03/OpenDocument-v1.2-csprd03-schema.rng"));
            manifest12 = Utils.derefUrl(new URL("http://docs.oasis-open.org/office/v1.2/csprd03/OpenDocument-v1.2-csprd03-manifest-schema.rng"));
        }
        catch (MalformedURLException malformedURLException) {
            logger.fatal(malformedURLException.getMessage());
        }
    }
}

