/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfvalidator;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfvalidator.Logger;
import org.odftoolkit.odfvalidator.MetaFilter;
import org.odftoolkit.odfvalidator.ODFValidatorException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MetaInformation {
    private PrintStream m_aOut;

    public MetaInformation(PrintStream aOut) {
        this.m_aOut = aOut;
    }

    public void getInformation(String aDocFileName) throws ODFValidatorException {
        try {
            OdfPackage aDocFile = OdfPackage.loadPackage(aDocFileName);
            this.getGenerator(aDocFile);
        }
        catch (Exception e) {
            throw new ODFValidatorException(aDocFileName, "", e);
        }
    }

    public void getGenerator(OdfPackage aDocFile) throws ODFValidatorException {
        try {
            InputStream aInStream = aDocFile.getInputStream(OdfPackage.OdfFile.MANIFEST.getPath(), true);
            Logger aLogger = new Logger(aDocFile.getBaseURI(), OdfPackage.OdfFile.MANIFEST.getPath(), this.m_aOut, Logger.LogLevel.INFO);
            this.getInformation(aInStream, aLogger);
        }
        catch (Exception e) {
            throw new ODFValidatorException(aDocFile.getBaseURI(), "", e);
        }
    }

    private void getInformation(InputStream aInStream, Logger aLogger) throws IOException, ODFValidatorException {
        SAXParser aParser = null;
        try {
            SAXParserFactory aParserFactory = SAXParserFactory.newInstance();
            aParserFactory.setNamespaceAware(true);
            aParser = aParserFactory.newSAXParser();
            MetaFilter aFilter = new MetaFilter(aLogger, null);
            aFilter.setParent(aParser.getXMLReader());
            aFilter.parse(new InputSource(aInStream));
        }
        catch (ParserConfigurationException e) {
            throw new ODFValidatorException(e);
        }
        catch (SAXException e) {
            throw new ODFValidatorException(e);
        }
    }
}

