/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfvalidator;

import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfvalidator.Logger;
import org.odftoolkit.odfvalidator.NamespaceFilter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class ContentFilter
extends NamespaceFilter {
    private static final String CD2_SVG_NAMESPACE_URI = "http://www.w3.org/2000/svg";
    private static final String CD2_XSL_NAMESPACE_URI = "http://www.w3.org/1999/XSL/Format";
    private static final String CD2_SMIL_NAMESPACE_URI = "http://www.w3.org/2001/SMIL20/";
    private static final String BASE_OFFICE_NAMESPACE_URI = "http://openoffice.org/2004/office";
    private static final String BASE_DB_NAMESPACE_URI = "http://openoffice.org/2004/database";
    private static final String SVG_NAMESPACE_URI = OdfDocumentNamespace.SVG.getUri();
    private static final String XSL_NAMESPACE_URI = OdfDocumentNamespace.FO.getUri();
    private static final String SMIL_NAMESPACE_URI = OdfDocumentNamespace.SMIL.getUri();
    private static final String DRAW_NAMESPACE_URI = OdfDocumentNamespace.DRAW.getUri();
    private static final String OFFICE_NAMESPACE_URI = OdfDocumentNamespace.OFFICE.getUri();
    private static final String DB_NAMESPACE_URI = OdfDocumentNamespace.DB.getUri();
    private static final String BASE_OFFICE_NAMESPACE_PREFIX = "office";
    private static final String POLYGON = "polygon";
    private static final String CONTOUR_POLYGON = "contour-polygon";
    private static final String POLYLINE = "polyline";
    private static final String POINTS = "points";
    private static final int MAX_POINTS_LEN = 2048;
    private Logger m_aLogger;
    private String m_aLocalElementName;
    private boolean m_bRoot = true;

    ContentFilter(Logger aLogger, String aLocalElementName) {
        this.m_aLogger = aLogger;
        this.m_aLocalElementName = aLocalElementName;
    }

    @Override
    String adaptNamespaceUri(String aUri, String aPrefix) {
        String aNewUri = null;
        if (aUri.equals(CD2_SVG_NAMESPACE_URI)) {
            aNewUri = SVG_NAMESPACE_URI;
        } else if (aUri.equals(CD2_XSL_NAMESPACE_URI)) {
            aNewUri = XSL_NAMESPACE_URI;
        } else if (aUri.equals(CD2_SMIL_NAMESPACE_URI)) {
            aNewUri = SMIL_NAMESPACE_URI;
        } else if (aUri.equals(BASE_OFFICE_NAMESPACE_URI) && (aPrefix == null || aPrefix.startsWith(BASE_OFFICE_NAMESPACE_PREFIX))) {
            aNewUri = OFFICE_NAMESPACE_URI;
        } else if (aUri.equals(BASE_DB_NAMESPACE_URI)) {
            aNewUri = DB_NAMESPACE_URI;
        }
        return aNewUri;
    }

    @Override
    void namespaceUriAdapted(String aUri, String aNewUri) {
        String aMsg = aUri.equals(BASE_OFFICE_NAMESPACE_URI) || aUri.equals(BASE_DB_NAMESPACE_URI) ? "Adapting Base namspace'" + aUri + "'" : "Adapting OpenDocument CD2 namspace'" + aUri + "' (has been stored by old OOo versions)";
        this.m_aLogger.logInfo(aMsg, false);
    }

    @Override
    public void startElement(String aUri, String aLocalName, String aQName, Attributes aAtts) throws SAXException {
        String aPointsValue;
        if (aUri.equals(DRAW_NAMESPACE_URI) && (aLocalName.equals(POLYGON) || aLocalName.equals(POLYLINE) || aLocalName.equals(CONTOUR_POLYGON)) && (aPointsValue = aAtts.getValue(DRAW_NAMESPACE_URI, POINTS)) != null && aPointsValue.length() > 2048) {
            this.m_aLogger.logInfo(String.format("'draw:points' of <%s> has been stripped (value starts with '%s')", aQName, aPointsValue.substring(0, 40)), false);
            AttributesImpl aNewAtts = new AttributesImpl(aAtts);
            int nAttr = aNewAtts.getIndex(DRAW_NAMESPACE_URI, POINTS);
            int nPos = aPointsValue.lastIndexOf(32, 2048);
            String aNewValue = nPos != -1 ? aPointsValue.substring(0, nPos) : "";
            aNewAtts.setValue(nAttr, aNewValue);
            aAtts = aNewAtts;
        }
        super.startElement(aUri, aLocalName, aQName, aAtts);
        if (this.m_bRoot) {
            if (!aUri.equals(OFFICE_NAMESPACE_URI) || !aLocalName.equals(this.m_aLocalElementName)) {
                this.m_aLogger.logError("Invalid root element: " + aQName);
            }
            this.m_bRoot = false;
        }
    }
}

