/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.pkg.rdfa;

import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLOutputFactory;
import org.odftoolkit.odfdom.dom.element.text.TextBookmarkStartElement;
import org.odftoolkit.odfdom.pkg.rdfa.DOMAttributes;
import org.odftoolkit.odfdom.pkg.rdfa.JenaSink;
import org.odftoolkit.odfdom.pkg.rdfa.RDFaParser;
import org.odftoolkit.odfdom.pkg.rdfa.URIExtractor;
import org.w3c.dom.Node;

public class DOMRDFaParser
extends RDFaParser {
    private static final XMLOutputFactory DEFAULT_XML_OUTPUT_FACTORY = XMLOutputFactory.newFactory();
    private static final XMLEventFactory DEFAULT_XML_EVENT_FACTORY = XMLEventFactory.newFactory();

    public static DOMRDFaParser createInstance(JenaSink sink) {
        sink.getExtractor().setForSAX(false);
        return new DOMRDFaParser(sink, sink.getExtractor());
    }

    public DOMRDFaParser(JenaSink sink, XMLOutputFactory outputFactory, XMLEventFactory eventFactory, URIExtractor extractor) {
        super(sink, outputFactory, eventFactory, extractor);
    }

    public DOMRDFaParser(JenaSink sink, URIExtractor extractor) {
        this(sink, DEFAULT_XML_OUTPUT_FACTORY, DEFAULT_XML_EVENT_FACTORY, extractor);
    }

    public void parse(Node node) {
        this.process(node);
    }

    private void process(Node node) {
        switch (node.getNodeType()) {
            case 1: {
                if (!(node instanceof TextBookmarkStartElement)) {
                    this.sink.setContextNode(node);
                }
                this.beginRDFaElement(node.getNamespaceURI(), node.getLocalName(), node.getNodeName(), new DOMAttributes(node.getAttributes()));
                if (node.hasChildNodes()) {
                    Node n = node.getFirstChild();
                    this.process(n);
                    while (n.getNextSibling() != null) {
                        this.process(n.getNextSibling());
                        n = n.getNextSibling();
                    }
                }
                this.endRDFaElement(node.getNamespaceURI(), node.getLocalName(), node.getNodeName());
                break;
            }
            case 3: 
            case 4: {
                this.writeCharacters(node.getNodeValue());
            }
        }
    }
}

