/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys.impl;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.reasoner.TriplePattern;
import org.apache.jena.reasoner.rulesys.Builtin;
import org.apache.jena.reasoner.rulesys.ClauseEntry;
import org.apache.jena.reasoner.rulesys.Functor;
import org.apache.jena.reasoner.rulesys.Node_RuleVariable;
import org.apache.jena.reasoner.rulesys.Rule;
import org.apache.jena.reasoner.rulesys.impl.LPRuleStore;
import org.apache.jena.reasoner.rulesys.impl.LPRuleSyntaxException;

public class RuleClauseCode {
    protected Rule rule;
    protected byte[] code;
    protected Object[] args;
    protected int[] termStart;
    public static final byte GET_CONSTANT = 1;
    public static final byte GET_VARIABLE = 2;
    public static final byte UNIFY_VARIABLE = 3;
    public static final byte GET_TEMP = 4;
    public static final byte UNIFY_TEMP = 18;
    public static final byte PUT_CONSTANT = 5;
    public static final byte PUT_NEW_VARIABLE = 6;
    public static final byte PUT_VARIABLE = 7;
    public static final byte PUT_DEREF_VARIABLE = 20;
    public static final byte PUT_TEMP = 8;
    public static final byte CALL_PREDICATE = 9;
    public static final byte GET_FUNCTOR = 10;
    public static final byte CALL_PREDICATE_INDEX = 23;
    public static final byte CALL_TRIPLE_MATCH = 17;
    public static final byte LAST_CALL_PREDICATE = 19;
    public static final byte CALL_TABLED = 24;
    public static final byte CALL_WILD_TABLED = 25;
    public static final byte PROCEED = 11;
    public static final byte MAKE_FUNCTOR = 12;
    public static final byte CALL_BUILTIN = 13;
    public static final byte CLEAR_VARIABLE = 14;
    public static final byte CLEAR_TEMP = 15;
    public static final byte CLEAR_ARG = 16;
    public static final byte ALLOCATE = 22;
    public static final byte TEST_BOUND = 32;
    public static final byte TEST_UNBOUND = 33;
    public static final int MAX_PERMANENT_VARS = 15;
    public static final int MAX_ARGUMENT_VARS = 8;
    public static final int MAX_TEMPORARY_VARS = 8;
    public static RuleClauseCode returnCodeBlock = new RuleClauseCode(null);

    public RuleClauseCode(Rule rule) {
        this.rule = rule;
    }

    public byte[] getCode() {
        return this.code;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public Rule getRule() {
        return this.rule;
    }

    public void compile(LPRuleStore ruleStore) {
        CompileState state = new CompileState(this.rule);
        int skip = 0;
        ClauseEntry head = this.rule.getHeadElement(0);
        if (!(head instanceof TriplePattern)) {
            throw new LPRuleSyntaxException("Heads of backward rules must be triple patterns", this.rule);
        }
        state.emitHead((TriplePattern)head);
        this.termStart = new int[this.rule.bodyLength()];
        for (int i = skip; i < this.rule.bodyLength(); ++i) {
            this.termStart[i] = state.p;
            ClauseEntry entry = this.rule.getBodyElement(i);
            if (entry instanceof TriplePattern) {
                state.emitBody((TriplePattern)entry, ruleStore);
                continue;
            }
            if (entry instanceof Functor) {
                state.emitBody((Functor)entry);
                continue;
            }
            throw new LPRuleSyntaxException("can't create new bRules in an bRule", this.rule);
        }
        this.code = state.getFinalCode();
        this.args = state.getFinalArgs();
    }

    public int termIndex(int pc) {
        int term;
        if (this.rule == null) {
            return -1;
        }
        for (term = 0; term < this.rule.bodyLength(); ++term) {
            if (pc > this.termStart[term]) continue;
            return term - 1;
        }
        return term - 1;
    }

    public void print(PrintStream out) {
        if (this.code == null) {
            out.println("Code not available");
        } else {
            int argi = 0;
            int p = 0;
            block26: while (p < this.code.length) {
                byte instruction = this.code[p++];
                switch (instruction) {
                    case 1: {
                        out.println("GET_CONSTANT " + this.args[argi++] + ", A" + this.code[p++]);
                        continue block26;
                    }
                    case 2: {
                        out.println("GET_VARIABLE Y" + this.code[p++] + ", A" + this.code[p++]);
                        continue block26;
                    }
                    case 3: {
                        out.println("UNIFY_VARIABLE Y" + this.code[p++] + ", A" + this.code[p++]);
                        continue block26;
                    }
                    case 4: {
                        out.println("GET_TEMP T" + this.code[p++] + ", A" + this.code[p++]);
                        continue block26;
                    }
                    case 18: {
                        out.println("UNIFY_TEMP T" + this.code[p++] + ", A" + this.code[p++]);
                        continue block26;
                    }
                    case 5: {
                        out.println("PUT_CONSTANT " + this.args[argi++] + ", A" + this.code[p++]);
                        continue block26;
                    }
                    case 6: {
                        out.println("PUT_NEW_VARIABLE Y" + this.code[p++] + ", A" + this.code[p++]);
                        continue block26;
                    }
                    case 8: {
                        out.println("PUT_TEMP T" + this.code[p++] + ", A" + this.code[p++]);
                        continue block26;
                    }
                    case 7: {
                        out.println("PUT_VARIABLE Y" + this.code[p++] + ", A" + this.code[p++]);
                        continue block26;
                    }
                    case 20: {
                        out.println("PUT_DEREF_VARIABLE Y" + this.code[p++] + ", A" + this.code[p++]);
                        continue block26;
                    }
                    case 32: {
                        out.println("TEST_BOUND A" + this.code[p++]);
                        continue block26;
                    }
                    case 33: {
                        out.println("TEST_UNBOUND A" + this.code[p++]);
                        continue block26;
                    }
                    case 9: {
                        out.println("CALL_PREDICATE " + this.args[argi++]);
                        continue block26;
                    }
                    case 24: {
                        out.println("CALL_TABLED ");
                        continue block26;
                    }
                    case 25: {
                        out.println("CALL_WILD_TABLED ");
                        continue block26;
                    }
                    case 23: {
                        out.println("CALL_PREDICATE_INDEX " + this.args[argi++]);
                        continue block26;
                    }
                    case 19: {
                        out.println("LAST_CALL_PREDICATE " + this.args[argi++]);
                        continue block26;
                    }
                    case 17: {
                        out.println("CALL_TRIPLE_MATCH");
                        continue block26;
                    }
                    case 11: {
                        out.println("PROCEED");
                        continue block26;
                    }
                    case 12: {
                        out.println("MAKE_FUNCTOR " + this.args[argi++]);
                        continue block26;
                    }
                    case 10: {
                        out.println("GET_FUNCTOR " + this.args[argi++]);
                        continue block26;
                    }
                    case 13: {
                        out.println("CALL_BUILTIN " + ((Builtin)this.args[argi++]).getName() + "/" + this.code[p++]);
                        continue block26;
                    }
                    case 16: {
                        out.println("CLEAR_ARG A" + this.code[p++]);
                        continue block26;
                    }
                    case 22: {
                        out.println("ALLOCATE + " + this.code[p++]);
                        continue block26;
                    }
                }
                out.println("Unused code: " + instruction);
            }
        }
    }

    public String toString() {
        if (this.rule == null) {
            return "[anon]";
        }
        return "[" + this.rule.toShortString() + "]";
    }

    public static void main(String[] args) {
        try {
            LPRuleStore store = new LPRuleStore();
            String test1 = "(?a p ?y) <- (?a p2 ?z).";
            String test2 = "(?a p ?y) <- (?a q2 ?z) (?z q2 ?w).";
            String test3 = "(?a p ?a) <- (?z r2 ?w) (?z r2 ?w).";
            String test4 = "(?a p ?a) <- (?z r2 ?w) (?a r2 ?w).";
            String test5 = "(?a p ?y) <- (?a p ?z), (?z p ?y).";
            String test6 = "(?x p C3) <- (C1 r ?x).";
            String test7 = "(?x p ?y) <- (?x r ?y) (?x q ?y).";
            String test8 = "(?x p ?y) <- (?x p ?z) addOne(?z, ?y).";
            String test9 = "(?x p ?y) <- (?x p ?z) sum(?z, 2, ?y).";
            String test10 = "(?x p ?y) <- (?x p ?v), sum(?v 2 ?y).";
            String test11 = "(b p ?y) <- (a ?y ?v).";
            String test12 = "(?x p ?y) <- (?x p foo(?z, ?y)).";
            String test13 = "(?x p foo(?y,?z)) <- (?x q ?y), (?x q ?z).";
            String test14 = "(?x p ?z) <- (?x e ?z), (?z q ?z).";
            String test15 = "(?x p ?y ) <- bound(?x), (?x p ?y).";
            String test16 = "(a p b ) <- unbound(?x).";
            String test17 = "(?a p ?a) <- (?a q class).";
            String test18 = "(?a p ?a) <- (?a s ?a).";
            String test19 = "(?X p ?T) <- (?X rdf:type c), noValue(?X, p), makeInstance(?X, p, ?T).";
            String test20 = "(a p b ) <- unbound(?x).";
            String testLong = "(?P p ?C) <- (?P q ?D), (?D r xsd(?B, ?S1, ?L1)),(?P p ?E), notEqual(?D, ?E) (?E e xsd(?B, ?S2, ?L2)),min(?S1, ?S2, ?S3),min(?L1, ?L2, ?L3), (?C r xsd(?B, ?S3, ?L3)).";
            String test21 = "(?a p ?y) <- (?x s ?y) (?a p ?x).";
            String test22 = "(?C p ?D) <- (?C rb:xsdBase ?BC), (?D rb:xsdBase ?BD), notEqual(?BC, ?BD).";
            store.addRule(Rule.parseRule(test22));
            System.out.println("Code for p:");
            List<RuleClauseCode> codeList = store.codeFor(NodeFactory.createURI("p"));
            RuleClauseCode code = codeList.get(0);
            code.print(System.out);
        }
        catch (Exception e) {
            System.out.println("Problem: " + e);
            e.printStackTrace();
        }
    }

    static {
        RuleClauseCode.returnCodeBlock.code = new byte[]{11};
    }

    static class TermIndex {
        int termNumber;
        int index;
        Node_RuleVariable var;

        TermIndex(Node_RuleVariable var, int termNumber, int index) {
            this.var = var;
            this.termNumber = termNumber;
            this.index = index;
        }
    }

    static class CompileState {
        byte[] code;
        ArrayList<Object> args;
        int p;
        private List<Node>[] termVarTable;
        private Map<Node_RuleVariable, List<TermIndex>> varOccurrence = new HashMap<Node_RuleVariable, List<TermIndex>>();
        private List<Node_RuleVariable> permanentVars = new ArrayList<Node_RuleVariable>();
        private List<Node_RuleVariable> tempVars = new ArrayList<Node_RuleVariable>();
        int totalOccurrences = 0;
        Set<Node_RuleVariable> seen = new HashSet<Node_RuleVariable>();
        Rule rule;

        CompileState(Rule rule) {
            this.classifyVariables(rule);
            this.rule = rule;
            this.code = new byte[10 + this.totalOccurrences + rule.bodyLength() * 10];
            this.args = new ArrayList();
        }

        int emitBindingTests() {
            Functor f;
            ClauseEntry term;
            int i;
            for (i = 0; i < this.rule.bodyLength() && (term = this.rule.getBodyElement(i)) instanceof Functor && (f = (Functor)term).getArgLength() == 1; ++i) {
                int ai = this.aIndex(f.getArgs()[0]);
                if (ai < 0) continue;
                if (f.getName().equals("bound")) {
                    this.code[this.p++] = 32;
                    this.code[this.p++] = (byte)ai;
                    continue;
                }
                if (!f.getName().equals("unbound")) break;
                this.code[this.p++] = 33;
                this.code[this.p++] = (byte)ai;
            }
            return i;
        }

        int aIndex(Node n) {
            TriplePattern tp = (TriplePattern)this.rule.getHeadElement(0);
            if (tp.getSubject() == n) {
                return 0;
            }
            if (tp.getPredicate() == n) {
                return 1;
            }
            if (tp.getObject() == n) {
                return 2;
            }
            return -1;
        }

        void emitHead(TriplePattern head) {
            if (this.permanentVars.size() > 0) {
                this.code[this.p++] = 22;
                this.code[this.p++] = (byte)this.permanentVars.size();
            }
            this.emitHeadGet(head.getSubject(), 0);
            this.emitHeadGet(head.getPredicate(), 1);
            this.emitHeadGet(head.getObject(), 2);
        }

        void emitHeadGet(Node node, int argi) {
            if (node instanceof Node_RuleVariable) {
                Node_RuleVariable var = (Node_RuleVariable)node;
                if (this.isDummy(var)) {
                    return;
                }
                if (this.isTemp(var)) {
                    List<TermIndex> occurrences = this.varOccurrence.get(var);
                    if (occurrences.size() != 2 || occurrences.get((int)0).index > 2 || occurrences.get((int)0).index != occurrences.get((int)1).index) {
                        this.code[this.p++] = this.seen.add(var) ? 4 : 18;
                        this.code[this.p++] = (byte)this.tempVars.indexOf(var);
                        this.code[this.p++] = (byte)argi;
                    }
                } else {
                    this.code[this.p++] = this.seen.add(var) ? 2 : 3;
                    this.code[this.p++] = (byte)this.permanentVars.indexOf(var);
                    this.code[this.p++] = (byte)argi;
                }
            } else if (Functor.isFunctor(node)) {
                Functor f = (Functor)node.getLiteralValue();
                this.code[this.p++] = 10;
                this.args.add(f);
                Node[] fargs = f.getArgs();
                for (int i = 0; i < fargs.length; ++i) {
                    this.emitHeadGet(fargs[i], i + 3);
                }
            } else {
                this.code[this.p++] = 1;
                this.code[this.p++] = (byte)argi;
                this.args.add(node);
            }
        }

        void emitBody(TriplePattern goal, LPRuleStore store) {
            this.emitBodyPut(goal.getSubject(), 0, false);
            this.emitBodyPut(goal.getPredicate(), 1, false);
            this.emitBodyPut(goal.getObject(), 2, false);
            List<RuleClauseCode> predicateCode = store.codeFor(goal);
            if (predicateCode == null || predicateCode.size() == 0) {
                this.code[this.p++] = 17;
            } else if (goal.getPredicate().isVariable()) {
                this.code[this.p++] = 24;
            } else if (store.isTabled(goal)) {
                this.code[this.p++] = goal.getPredicate().isVariable() ? 25 : 24;
            } else {
                this.code[this.p++] = this.permanentVars.size() == 0 ? 19 : (store.isIndexedPredicate(goal.getPredicate()) && goal.getObject().isVariable() ? 23 : 9);
                this.args.add(new RuleClauseCodeList(predicateCode));
            }
        }

        void emitBodyPut(Node node, int argi, boolean deref) {
            if (argi >= 8) {
                throw new LPRuleSyntaxException("Rule too complex for current implementation\nRule clauses are limited to 8 argument variables\n", this.rule);
            }
            if (node instanceof Node_RuleVariable) {
                Node_RuleVariable var = (Node_RuleVariable)node;
                if (this.isDummy(var)) {
                    this.code[this.p++] = 16;
                    this.code[this.p++] = (byte)argi;
                    return;
                }
                if (this.isTemp(var)) {
                    List<TermIndex> occurrences = this.varOccurrence.get(var);
                    if (occurrences.size() != 2 || occurrences.get((int)0).index != occurrences.get((int)1).index) {
                        this.code[this.p++] = 8;
                        this.code[this.p++] = (byte)this.tempVars.indexOf(var);
                        this.code[this.p++] = (byte)argi;
                    }
                } else {
                    this.code[this.p++] = !this.seen.add(var) ? (deref ? 20 : 7) : 6;
                    this.code[this.p++] = (byte)this.permanentVars.indexOf(var);
                    this.code[this.p++] = (byte)argi;
                }
            } else if (Functor.isFunctor(node)) {
                Functor f = (Functor)node.getLiteralValue();
                Node[] fargs = f.getArgs();
                for (int i = 0; i < fargs.length; ++i) {
                    this.emitBodyPut(fargs[i], i + 3, deref);
                }
                this.code[this.p++] = 12;
                this.args.add(f);
            } else {
                this.code[this.p++] = 5;
                this.code[this.p++] = (byte)argi;
                this.args.add(node);
            }
        }

        void emitBody(Functor functor) {
            Node[] fargs = functor.getArgs();
            Builtin builtin = functor.getImplementor();
            if (builtin == null) {
                throw new LPRuleSyntaxException("Unknown builtin operation " + functor.getName(), this.rule);
            }
            if (builtin.getArgLength() != 0 && builtin.getArgLength() != fargs.length) {
                throw new LPRuleSyntaxException("Wrong number of arguments to functor " + functor.getName() + " : got " + functor.getArgLength() + " : expected " + builtin.getArgLength(), this.rule);
            }
            for (int i = 0; i < fargs.length; ++i) {
                Node node = fargs[i];
                this.emitBodyPut(node, i, true);
            }
            this.code[this.p++] = 13;
            this.code[this.p++] = (byte)fargs.length;
            this.args.add(builtin);
        }

        byte[] getFinalCode() {
            this.code[this.p++] = 11;
            byte[] finalCode = new byte[this.p];
            System.arraycopy(this.code, 0, finalCode, 0, this.p);
            return finalCode;
        }

        Object[] getFinalArgs() {
            return this.args.toArray();
        }

        void classifyVariables(Rule rule) {
            int i;
            List[] termListArray = new List[rule.bodyLength() + 1];
            this.termVarTable = termListArray;
            this.termVarTable[0] = this.termVars(rule.getHeadElement(0));
            this.totalOccurrences += this.termVarTable[0].size();
            for (i = 0; i < rule.bodyLength(); ++i) {
                this.termVarTable[i + 1] = this.termVars(rule.getBodyElement(i));
                this.totalOccurrences += this.termVarTable[i + 1].size();
            }
            for (i = 0; i < rule.bodyLength() + 1; ++i) {
                List<Node> varEnts = this.termVarTable[i];
                for (int j = 0; j < varEnts.size(); ++j) {
                    Node n = varEnts.get(j);
                    if (!n.isVariable()) continue;
                    Node_RuleVariable var = (Node_RuleVariable)n;
                    List<TermIndex> occurrences = this.varOccurrence.get(var);
                    if (occurrences == null) {
                        occurrences = new ArrayList<TermIndex>();
                        this.varOccurrence.put(var, occurrences);
                    }
                    occurrences.add(new TermIndex(var, i, j));
                }
            }
            for (List<TermIndex> occurrences : this.varOccurrence.values()) {
                Node_RuleVariable var = null;
                boolean inFirst = false;
                boolean inLaterBody = false;
                for (TermIndex occurence : occurrences) {
                    var = occurence.var;
                    int termNumber = occurence.termNumber;
                    if (termNumber == 0) {
                        inFirst = true;
                    } else if (termNumber > 1) {
                        inLaterBody = true;
                    }
                    if (termNumber > 0 && !(rule.getBodyElement(termNumber - 1) instanceof Functor)) continue;
                }
                if (this.isDummy(var)) continue;
                if (inLaterBody || !inFirst) {
                    this.permanentVars.add(var);
                    continue;
                }
                this.tempVars.add(var);
            }
            if (this.permanentVars.size() > 15) {
                throw new LPRuleSyntaxException("Rule too complex for current implementation\nRule clauses are limited to 15 permanent variables\n", rule);
            }
            if (this.tempVars.size() > 8) {
                throw new LPRuleSyntaxException("Rule too complex for current implementation\nRule clauses are limited to 8 temporary variables\n", rule);
            }
        }

        boolean isTemp(Node_RuleVariable var) {
            return !this.isDummy(var) && !this.permanentVars.contains(var);
        }

        boolean isDummy(Node_RuleVariable var) {
            List<TermIndex> occurances = this.varOccurrence.get(var);
            return occurances == null || occurances.size() <= 1;
        }

        private List<Node> termVars(ClauseEntry term) {
            ArrayList<Node> result = new ArrayList<Node>();
            if (term instanceof TriplePattern) {
                TriplePattern goal = (TriplePattern)term;
                result.add(goal.getSubject());
                result.add(goal.getPredicate());
                Node obj = goal.getObject();
                if (Functor.isFunctor(obj)) {
                    result.add(obj);
                    result.addAll(this.termVars((Functor)obj.getLiteralValue()));
                } else {
                    result.add(obj);
                }
            } else if (term instanceof Functor) {
                Node[] args;
                for (Node arg : args = ((Functor)term).getArgs()) {
                    result.add(arg);
                }
            }
            return result;
        }

        public static class RuleClauseCodeList {
            private final List<RuleClauseCode> list;

            public RuleClauseCodeList(List<RuleClauseCode> list) {
                this.list = list;
            }

            List<RuleClauseCode> getList() {
                return this.list;
            }
        }
    }
}

