/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys;

import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.reasoner.ReasonerFactory;
import org.apache.jena.reasoner.rulesys.OWLFBRuleReasoner;
import org.apache.jena.reasoner.rulesys.Util;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.ReasonerVocabulary;

public class OWLFBRuleReasonerFactory
implements ReasonerFactory {
    private static ReasonerFactory theInstance = new OWLFBRuleReasonerFactory();
    public static final String URI = "http://jena.hpl.hp.com/2003/OWLFBRuleReasoner";
    protected Model capabilities;

    public static ReasonerFactory theInstance() {
        return theInstance;
    }

    @Override
    public Reasoner create(Resource configuration) {
        OWLFBRuleReasoner reasoner = new OWLFBRuleReasoner(this);
        if (configuration != null) {
            Boolean doTrace;
            Boolean doLog = Util.checkBinaryPredicate(ReasonerVocabulary.PROPderivationLogging, configuration);
            if (doLog != null) {
                reasoner.setDerivationLogging(doLog);
            }
            if ((doTrace = Util.checkBinaryPredicate(ReasonerVocabulary.PROPtraceOn, configuration)) != null) {
                reasoner.setTraceOn(doTrace);
            }
        }
        return reasoner;
    }

    @Override
    public Model getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = ModelFactory.createDefaultModel();
            Resource base = this.capabilities.createResource(this.getURI());
            base.addProperty(ReasonerVocabulary.nameP, "OWL BRule Reasoner").addProperty(ReasonerVocabulary.descriptionP, "Experimental OWL reasoner.\nCan separate tbox and abox data if desired to reuse tbox caching or mix them.").addProperty(ReasonerVocabulary.supportsP, RDFS.subClassOf).addProperty(ReasonerVocabulary.supportsP, RDFS.subPropertyOf).addProperty(ReasonerVocabulary.supportsP, RDFS.member).addProperty(ReasonerVocabulary.supportsP, RDFS.range).addProperty(ReasonerVocabulary.supportsP, RDFS.domain).addProperty(ReasonerVocabulary.supportsP, ReasonerVocabulary.individualAsThingP).addProperty(ReasonerVocabulary.supportsP, OWL.ObjectProperty).addProperty(ReasonerVocabulary.supportsP, OWL.DatatypeProperty).addProperty(ReasonerVocabulary.supportsP, OWL.FunctionalProperty).addProperty(ReasonerVocabulary.supportsP, OWL.SymmetricProperty).addProperty(ReasonerVocabulary.supportsP, OWL.TransitiveProperty).addProperty(ReasonerVocabulary.supportsP, OWL.InverseFunctionalProperty).addProperty(ReasonerVocabulary.supportsP, OWL.hasValue).addProperty(ReasonerVocabulary.supportsP, OWL.intersectionOf).addProperty(ReasonerVocabulary.supportsP, OWL.unionOf).addProperty(ReasonerVocabulary.supportsP, OWL.minCardinality).addProperty(ReasonerVocabulary.supportsP, OWL.maxCardinality).addProperty(ReasonerVocabulary.supportsP, OWL.cardinality).addProperty(ReasonerVocabulary.supportsP, OWL.someValuesFrom).addProperty(ReasonerVocabulary.supportsP, OWL.allValuesFrom).addProperty(ReasonerVocabulary.supportsP, OWL.sameAs).addProperty(ReasonerVocabulary.supportsP, OWL.differentFrom).addProperty(ReasonerVocabulary.supportsP, OWL.disjointWith).addProperty(ReasonerVocabulary.versionP, "0.1");
        }
        return this.capabilities;
    }

    @Override
    public String getURI() {
        return URI;
    }
}

