/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner;

import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.reasoner.Finder;
import org.apache.jena.reasoner.TriplePattern;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;

public class FGraph
implements Finder {
    protected Graph graph;

    public FGraph(Graph graph) {
        this.graph = graph;
    }

    @Override
    public ExtendedIterator<Triple> find(TriplePattern pattern) {
        if (this.graph == null) {
            return new NullIterator<Triple>();
        }
        return this.graph.find(pattern.asTripleMatch());
    }

    @Override
    public ExtendedIterator<Triple> findWithContinuation(TriplePattern pattern, Finder continuation) {
        if (this.graph == null) {
            return new NullIterator<Triple>();
        }
        if (continuation == null) {
            return this.graph.find(pattern.asTripleMatch());
        }
        return this.graph.find(pattern.asTripleMatch()).andThen(continuation.find(pattern));
    }

    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public boolean contains(TriplePattern pattern) {
        return this.graph.contains(pattern.getSubject(), pattern.getPredicate(), pattern.getObject());
    }
}

