/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.iri.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.jena.iri.IRIComponents;
import org.apache.jena.iri.ViolationCodes;
import org.apache.jena.iri.impl.AbsLexer;
import org.apache.jena.iri.impl.Lexer;

class LexerPort
extends AbsLexer
implements ViolationCodes,
IRIComponents,
Lexer {
    private static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 2048;
    public static final int YYINITIAL = 0;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 1};
    private static final String ZZ_CMAP_PACKED = "\n\u0000\u0001\u0000%\u0000\u0001\u0002\u0001\u0001\b\u0001\uffc6\u0000";
    private static final char[] ZZ_CMAP = LexerPort.zzUnpackCMap("\n\u0000\u0001\u0000%\u0000\u0001\u0002\u0001\u0001\b\u0001\uffc6\u0000");
    private static final int[] ZZ_ACTION = LexerPort.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0002\u0000\u0001\u0001\u0001\u0002\u0001\u0003\u0001\u0004";
    private static final int[] ZZ_ROWMAP = LexerPort.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\u0003\u0000\u0006\u0000\u0006\u0000\u0006\u0000\u0006";
    private static final int[] ZZ_TRANS = LexerPort.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0003\u0001\u0004\u0001\u0006\u0003\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = LexerPort.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0002\u0000\u0004\t";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[2048];
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;

    private static int[] zzUnpackAction() {
        int[] result = new int[6];
        int offset = 0;
        offset = LexerPort.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[6];
        int offset = 0;
        offset = LexerPort.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[9];
        int offset = 0;
        offset = LexerPort.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[6];
        int offset = 0;
        offset = LexerPort.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    @Override
    char[] zzBuffer() {
        int length;
        this.yyreset(null);
        this.zzAtEOF = true;
        this.zzEndRead = length = this.parser.end(this.range) - this.parser.start(this.range);
        while (length > this.zzBuffer.length) {
            this.zzBuffer = new char[this.zzBuffer.length * 2];
        }
        if (length == 0) {
            this.error(12);
        }
        return this.zzBuffer;
    }

    LexerPort(Reader in) {
        this.zzReader = in;
    }

    LexerPort(InputStream in) {
        this(new InputStreamReader(in));
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 14) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean zzRefill() throws IOException {
        int numRead;
        if (this.zzStartRead > 0) {
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length) {
            char[] newBuffer = new char[this.zzCurrentPos * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, this.zzBuffer.length - this.zzEndRead)) > 0) {
            this.zzEndRead += numRead;
            return false;
        }
        if (numRead == 0) {
            int c = this.zzReader.read();
            if (c == -1) {
                return true;
            }
            this.zzBuffer[this.zzEndRead++] = (char)c;
            return false;
        }
        return true;
    }

    private final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    private final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzEOFDone = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
    }

    private final int yystate() {
        return this.zzLexicalState;
    }

    private final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    @Override
    final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    private final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    private final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    @Override
    public int yylex() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block14: while (true) {
            int zzInput;
            boolean eof;
            int zzMarkedPosL = this.zzMarkedPos;
            this.yychar += zzMarkedPosL - this.zzStartRead;
            if (zzMarkedPosL > this.zzStartRead) {
                switch (zzBufferL[zzMarkedPosL - 1]) {
                    case '\n': 
                    case '\u000b': 
                    case '\f': 
                    case '\u0085': 
                    case '\u2028': 
                    case '\u2029': {
                        this.zzAtBOL = true;
                        break;
                    }
                    case '\r': {
                        if (zzMarkedPosL < zzEndReadL) {
                            this.zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
                            break;
                        }
                        if (this.zzAtEOF) {
                            this.zzAtBOL = false;
                            break;
                        }
                        eof = this.zzRefill();
                        zzMarkedPosL = this.zzMarkedPos;
                        zzEndReadL = this.zzEndRead;
                        zzBufferL = this.zzBuffer;
                        if (eof) {
                            this.zzAtBOL = false;
                            break;
                        }
                        this.zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
                        break;
                    }
                    default: {
                        this.zzAtBOL = false;
                    }
                }
            }
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = this.zzAtBOL ? ZZ_LEXSTATE[this.zzLexicalState + 1] : ZZ_LEXSTATE[this.zzLexicalState];
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = zzBufferL[zzCurrentPosL++];
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = zzBufferL[zzCurrentPosL++];
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                int zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 4: {
                    this.rule(2);
                    if (this.yychar == 0) {
                        this.error(15);
                    }
                }
                case 5: {
                    continue block14;
                }
                case 3: {
                    this.rule(3);
                }
                case 6: {
                    continue block14;
                }
                case 1: {
                    this.rule(4);
                    this.error(0);
                }
                case 7: {
                    continue block14;
                }
                case 2: {
                    this.rule(1);
                }
                case 8: {
                    continue block14;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return -1;
            }
            this.zzScanError(1);
        }
    }
}

