/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.logging;

import java.util.IllegalFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FmtLog {
    public static void trace(Logger log, String fmt, Object ... args) {
        if (log.isTraceEnabled()) {
            log.trace(FmtLog.format(fmt, args));
        }
    }

    public static void trace(Logger log, Throwable th, String fmt, Object ... args) {
        if (log.isTraceEnabled()) {
            log.trace(FmtLog.format(fmt, args), th);
        }
    }

    public static void trace(Class<?> cls, String fmt, Object ... args) {
        FmtLog.trace(FmtLog.log(cls), fmt, args);
    }

    public static void trace(Class<?> cls, Throwable th, String fmt, Object ... args) {
        FmtLog.trace(FmtLog.log(cls), th, fmt, args);
    }

    public static void debug(Logger log, String fmt, Object ... args) {
        if (log.isDebugEnabled()) {
            log.debug(FmtLog.format(fmt, args));
        }
    }

    public static void debug(Logger log, Throwable th, String fmt, Object ... args) {
        if (log.isDebugEnabled()) {
            log.debug(FmtLog.format(fmt, args), th);
        }
    }

    public static void debug(Class<?> cls, String fmt, Object ... args) {
        FmtLog.debug(FmtLog.log(cls), fmt, args);
    }

    public static void debug(Class<?> cls, Throwable th, String fmt, Object ... args) {
        FmtLog.debug(FmtLog.log(cls), th, fmt, args);
    }

    public static void info(Logger log, String fmt, Object ... args) {
        if (log.isInfoEnabled()) {
            log.info(FmtLog.format(fmt, args));
        }
    }

    public static void info(Logger log, Throwable th, String fmt, Object ... args) {
        if (log.isInfoEnabled()) {
            log.info(FmtLog.format(fmt, args), th);
        }
    }

    public static void info(Class<?> cls, String fmt, Object ... args) {
        FmtLog.info(FmtLog.log(cls), fmt, args);
    }

    public static void info(Class<?> cls, Throwable th, String fmt, Object ... args) {
        FmtLog.info(FmtLog.log(cls), th, fmt, args);
    }

    public static void warn(Logger log, String fmt, Object ... args) {
        if (log.isWarnEnabled()) {
            log.warn(FmtLog.format(fmt, args));
        }
    }

    public static void warn(Logger log, Throwable th, String fmt, Object ... args) {
        if (log.isWarnEnabled()) {
            log.warn(FmtLog.format(fmt, args), th);
        }
    }

    public static void warn(Class<?> cls, String fmt, Object ... args) {
        FmtLog.warn(FmtLog.log(cls), fmt, args);
    }

    public static void warn(Class<?> cls, Throwable th, String fmt, Object ... args) {
        FmtLog.warn(FmtLog.log(cls), th, fmt, args);
    }

    public static void error(Logger log, String fmt, Object ... args) {
        if (log.isErrorEnabled()) {
            log.error(FmtLog.format(fmt, args));
        }
    }

    public static void error(Logger log, Throwable th, String fmt, Object ... args) {
        if (log.isErrorEnabled()) {
            log.error(FmtLog.format(fmt, args), th);
        }
    }

    public static void error(Class<?> cls, String fmt, Object ... args) {
        FmtLog.error(FmtLog.log(cls), fmt, args);
    }

    public static void error(Class<?> cls, Throwable th, String fmt, Object ... args) {
        FmtLog.error(FmtLog.log(cls), th, fmt, args);
    }

    private static String format(String fmt, Object[] args) {
        try {
            return String.format(fmt, args);
        }
        catch (IllegalFormatException ex) {
            return fmt + " " + args;
        }
    }

    private static Logger log(Class<?> cls) {
        return LoggerFactory.getLogger(cls);
    }
}

