/*
 * Decompiled with CFR 0.152.
 */
package com.github.andrewoma.dexx.collection;

import com.github.andrewoma.dexx.collection.Builder;
import com.github.andrewoma.dexx.collection.BuilderFactory;
import com.github.andrewoma.dexx.collection.Function;
import com.github.andrewoma.dexx.collection.Pair;
import com.github.andrewoma.dexx.collection.SortedMap;
import com.github.andrewoma.dexx.collection.Traversable;
import com.github.andrewoma.dexx.collection.TreeMap;
import java.util.Comparator;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class SortedMaps {
    private SortedMaps() {
    }

    @NotNull
    public static <K extends Comparable<? super K>, V> SortedMap<K, V> of() {
        return SortedMaps.construct(new Pair[0]);
    }

    @NotNull
    public static <K extends Comparable<? super K>, V> SortedMap<K, V> of(K k, V v) {
        return SortedMaps.construct(SortedMaps.p(k, v));
    }

    @NotNull
    public static <K extends Comparable<? super K>, V> SortedMap<K, V> of(K k1, V v1, K k2, V v2) {
        return SortedMaps.construct(SortedMaps.p(k1, v1), SortedMaps.p(k2, v2));
    }

    @NotNull
    public static <K extends Comparable<? super K>, V> SortedMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        return SortedMaps.construct(SortedMaps.p(k1, v1), SortedMaps.p(k2, v2), SortedMaps.p(k3, v3));
    }

    @NotNull
    public static <K extends Comparable<? super K>, V> SortedMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        return SortedMaps.construct(SortedMaps.p(k1, v1), SortedMaps.p(k2, v2), SortedMaps.p(k3, v3), SortedMaps.p(k4, v4));
    }

    @NotNull
    public static <K extends Comparable<? super K>, V> SortedMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return SortedMaps.construct(SortedMaps.p(k1, v1), SortedMaps.p(k2, v2), SortedMaps.p(k3, v3), SortedMaps.p(k4, v4), SortedMaps.p(k5, v5));
    }

    @NotNull
    public static <K, V> SortedMap<K, V> of(Comparator<? super K> comparator) {
        return SortedMaps.construct(comparator, new Pair[0]);
    }

    @NotNull
    public static <K, V> SortedMap<K, V> of(Comparator<? super K> comparator, K k, V v) {
        return SortedMaps.construct(comparator, SortedMaps.p(k, v));
    }

    @NotNull
    public static <K, V> SortedMap<K, V> of(Comparator<? super K> comparator, K k1, V v1, K k2, V v2) {
        return SortedMaps.construct(comparator, SortedMaps.p(k1, v1), SortedMaps.p(k2, v2));
    }

    @NotNull
    public static <K, V> SortedMap<K, V> of(Comparator<? super K> comparator, K k1, V v1, K k2, V v2, K k3, V v3) {
        return SortedMaps.construct(comparator, SortedMaps.p(k1, v1), SortedMaps.p(k2, v2), SortedMaps.p(k3, v3));
    }

    @NotNull
    public static <K, V> SortedMap<K, V> of(Comparator<? super K> comparator, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        return SortedMaps.construct(comparator, SortedMaps.p(k1, v1), SortedMaps.p(k2, v2), SortedMaps.p(k3, v3), SortedMaps.p(k4, v4));
    }

    @NotNull
    public static <K, V> SortedMap<K, V> of(Comparator<? super K> comparator, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return SortedMaps.construct(comparator, SortedMaps.p(k1, v1), SortedMaps.p(k2, v2), SortedMaps.p(k3, v3), SortedMaps.p(k4, v4), SortedMaps.p(k5, v5));
    }

    private static <K, V> Pair<K, V> p(K k, V v) {
        return new Pair<K, V>(k, v);
    }

    private static <K, V> SortedMap<K, V> construct(Comparator<? super K> comparator, Pair<K, V> ... pairs) {
        SortedMap<K, V> map = new TreeMap<K, V>(comparator, null);
        for (Pair<K, V> pair : pairs) {
            map = map.put(pair.component1(), pair.component2());
        }
        return map;
    }

    private static <K extends Comparable<? super K>, V> SortedMap<K, V> construct(Pair<K, V> ... pairs) {
        SortedMap<K, V> map = new TreeMap<K, V>();
        for (Pair<K, V> pair : pairs) {
            map = map.put(pair.component1(), pair.component2());
        }
        return map;
    }

    @NotNull
    public static <K extends Comparable<? super K>, V> SortedMap<K, V> copyOf(Iterable<Pair<K, V>> iterable) {
        return SortedMaps.copyOf(null, iterable);
    }

    @NotNull
    public static <K extends Comparable<? super K>, V> SortedMap<K, V> copyOf(Iterator<Pair<K, V>> iterator) {
        return SortedMaps.copyOf(null, iterator);
    }

    @NotNull
    public static <K extends Comparable<? super K>, V> SortedMap<K, V> copyOf(Pair<K, V>[] pairs) {
        return SortedMaps.copyOf(null, pairs);
    }

    @NotNull
    public static <K extends Comparable<? super K>, V> SortedMap<K, V> copyOfTraversable(Traversable<Pair<K, V>> traversable) {
        return SortedMaps.copyOfTraversable(null, traversable);
    }

    @NotNull
    public static <K, V> SortedMap<K, V> copyOf(Comparator<? super K> comparator, Iterable<Pair<K, V>> iterable) {
        SortedMap<K, V> result = new TreeMap<K, V>(comparator, null);
        for (Pair<K, V> pair : iterable) {
            result = result.put(pair.component1(), pair.component2());
        }
        return result;
    }

    @NotNull
    public static <K, V> SortedMap<K, V> copyOf(Comparator<? super K> comparator, Iterator<Pair<K, V>> iterator) {
        SortedMap<K, V> result = new TreeMap<K, V>(comparator, null);
        while (iterator.hasNext()) {
            Pair<K, V> pair = iterator.next();
            result = result.put(pair.component1(), pair.component2());
        }
        return result;
    }

    @NotNull
    public static <K, V> SortedMap<K, V> copyOf(Comparator<? super K> comparator, Pair<K, V>[] pairs) {
        SortedMap<K, V> result = new TreeMap<K, V>(comparator, null);
        for (Pair<K, V> pair : pairs) {
            result = result.put(pair.component1(), pair.component2());
        }
        return result;
    }

    @NotNull
    public static <K, V> SortedMap<K, V> copyOfTraversable(Comparator<? super K> comparator, Traversable<Pair<K, V>> traversable) {
        final SortedMap[] result = new TreeMap[]{new TreeMap(comparator, null)};
        traversable.forEach(new Function<Pair<K, V>, Object>(){

            @Override
            public Object invoke(Pair<K, V> pair) {
                result[0] = result[0].put(pair.component1(), pair.component2());
                return null;
            }
        });
        return result[0];
    }

    @NotNull
    public static <K extends Comparable<? super K>, V> BuilderFactory<Pair<K, V>, SortedMap<K, V>> factory() {
        return TreeMap.factory(null, null);
    }

    @NotNull
    public static <K, V> BuilderFactory<Pair<K, V>, SortedMap<K, V>> factory(Comparator<? super K> comparator) {
        return TreeMap.factory(comparator, null);
    }

    @NotNull
    public static <K extends Comparable<? super K>, V> Builder<Pair<K, V>, SortedMap<K, V>> builder() {
        return SortedMaps.factory().newBuilder();
    }

    @NotNull
    public static <K, V> Builder<Pair<K, V>, SortedMap<K, V>> builder(Comparator<? super K> comparator) {
        return SortedMaps.factory(comparator).newBuilder();
    }
}

