// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

// This file is used by Code Analysis to maintain SuppressMessage
// attributes that are applied to this project.
// Project-level suppressions either have no target or are given
// a specific target and scoped to a namespace, type, member, etc.

using System.Diagnostics.CodeAnalysis;

[assembly: SuppressMessage("Build", "CA2213:'PackagesConfigWriter' contains field '_stream' that is of IDisposable type 'Stream', but it is never disposed. Change the Dispose method on 'PackagesConfigWriter' to call Close or Dispose on this field.", Justification = "<Pending>", Scope = "member", Target = "~F:NuGet.Packaging.PackagesConfigWriter._stream")]
[assembly: SuppressMessage("Build", "CA1303:Method 'SelectionCriteria ManagedCodeCriteria.ForFrameworkAndRuntime(NuGetFramework framework, string runtimeIdentifier)' passes a literal string as parameter 'message' of a call to 'NotSupportedException.NotSupportedException(string message)'. Retrieve the following string(s) from a resource table instead: \"FallbackFramework is not supported.\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Client.ManagedCodeConventions.ManagedCodeCriteria.ForFrameworkAndRuntime(NuGet.Frameworks.NuGetFramework,System.String)~NuGet.ContentModel.SelectionCriteria")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'ContentItemGroup ContentItemCollection.FindBestItemGroup(SelectionCriteria criteria, params PatternSet[] definitions)', validate parameter 'criteria' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ContentModel.ContentItemCollection.FindBestItemGroup(NuGet.ContentModel.SelectionCriteria,NuGet.ContentModel.PatternSet[])~NuGet.ContentModel.ContentItemGroup")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IEnumerable<ContentItemGroup> ContentItemCollection.FindItemGroups(PatternSet definition)', validate parameter 'definition' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ContentModel.ContentItemCollection.FindItemGroups(NuGet.ContentModel.PatternSet)~System.Collections.Generic.IEnumerable{NuGet.ContentModel.ContentItemGroup}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void ContentItemCollection.Load(IEnumerable<string> paths)', validate parameter 'paths' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ContentModel.ContentItemCollection.Load(System.Collections.Generic.IEnumerable{System.String})")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'PatternExpression.PatternExpression(PatternDefinition pattern)', validate parameter 'pattern' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ContentModel.Infrastructure.PatternExpression.#ctor(NuGet.ContentModel.PatternDefinition)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'ContentItem PatternExpression.Match(string path, IReadOnlyDictionary<string, ContentPropertyDefinition> propertyDefinitions)', validate parameter 'path' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ContentModel.Infrastructure.PatternExpression.Match(System.String,System.Collections.Generic.IReadOnlyDictionary{System.String,NuGet.ContentModel.ContentPropertyDefinition})~NuGet.ContentModel.ContentItem")]
[assembly: SuppressMessage("Build", "CA2225:Provide a method named 'ToPatternDefinition' or 'FromString' as an alternate for operator op_Implicit.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.ContentModel.PatternDefinition.op_Implicit(System.String)~NuGet.ContentModel.PatternDefinition")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void CollectionExtensions.AddRange<T>(ICollection<T> collection, IEnumerable<T> items)', validate parameter 'collection' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.CollectionExtensions.AddRange``1(System.Collections.Generic.ICollection{``0},System.Collections.Generic.IEnumerable{``0})")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IReadOnlyList<PackageType> NuspecUtility.GetPackageTypes(XElement metadataNode, bool useMetadataNamespace)', validate parameter 'metadataNode' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Core.NuspecUtility.GetPackageTypes(System.Xml.Linq.XElement,System.Boolean)~System.Collections.Generic.IReadOnlyList{NuGet.Packaging.Core.PackageType}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool NuspecUtility.IsServiceable(XElement metadataNode)', validate parameter 'metadataNode' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Core.NuspecUtility.IsServiceable(System.Xml.Linq.XElement)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1303:Method 'PackageDependency.PackageDependency(string id, VersionRange versionRange, IReadOnlyList<string> include, IReadOnlyList<string> exclude)' passes a literal string as parameter 'message' of a call to 'ArgumentException.ArgumentException(string message)'. Retrieve the following string(s) from a resource table instead: \"id\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Core.PackageDependency.#ctor(System.String,NuGet.Versioning.VersionRange,System.Collections.Generic.IReadOnlyList{System.String},System.Collections.Generic.IReadOnlyList{System.String})")]
[assembly: SuppressMessage("Build", "CA1308:In method 'GetHashCode', replace the call to 'ToLowerInvariant' with 'ToUpperInvariant'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Core.PackageDependencyComparer.GetHashCode(NuGet.Packaging.Core.PackageDependency)~System.Int32")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'PackageDependencyInfo.PackageDependencyInfo(PackageIdentity identity, IEnumerable<PackageDependency> dependencies)', validate parameter 'identity' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Core.PackageDependencyInfo.#ctor(NuGet.Packaging.Core.PackageIdentity,System.Collections.Generic.IEnumerable{NuGet.Packaging.Core.PackageDependency})")]
[assembly: SuppressMessage("Build", "CA1054:Change the type of parameter url of method RepositoryMetadata.RepositoryMetadata(string, string, string, string) from string to System.Uri, or provide an overload to RepositoryMetadata.RepositoryMetadata(string, string, string, string) that allows url to be passed as a System.Uri object.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Core.RepositoryMetadata.#ctor(System.String,System.String,System.String,System.String)")]
[assembly: SuppressMessage("Build", "CA1303:Method 'FrameworkAssemblyReference.FrameworkAssemblyReference(string assemblyName, IEnumerable<NuGetFramework> supportedFrameworks)' passes a literal string as parameter 'message' of a call to 'ArgumentException.ArgumentException(string message)'. Retrieve the following string(s) from a resource table instead: \"assemblyName\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.FrameworkAssemblyReference.#ctor(System.String,System.Collections.Generic.IEnumerable{NuGet.Frameworks.NuGetFramework})")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'FrameworkName FrameworkNameUtility.ParseFrameworkFolderName(string path, bool strictParsing, out string effectivePath)', validate parameter 'path' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.FrameworkNameUtility.ParseFrameworkFolderName(System.String,System.Boolean,System.String@)~System.Runtime.Versioning.FrameworkName")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'int FrameworkReference.Compare(FrameworkReference x, FrameworkReference y)', validate parameter 'x' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.FrameworkReference.Compare(NuGet.Packaging.FrameworkReference,NuGet.Packaging.FrameworkReference)~System.Int32")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string FrameworksExtensions.GetFrameworkString(NuGetFramework self)', validate parameter 'self' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.FrameworksExtensions.GetFrameworkString(NuGet.Frameworks.NuGetFramework)~System.String")]
[assembly: SuppressMessage("Build", "CA1822:Member ParseBracket does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Licenses.LicenseExpressionTokenizer.ParseBracket(System.Char)~NuGet.Packaging.Licenses.LicenseExpressionToken")]
[assembly: SuppressMessage("Build", "CA1822:Member ParseTokenType does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Licenses.LicenseExpressionTokenizer.ParseTokenType(System.String)~NuGet.Packaging.Licenses.LicenseExpressionToken")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool NuGetLicenseExpressionExtensions.HasOnlyStandardIdentifiers(NuGetLicenseExpression expression)', validate parameter 'expression' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Licenses.NuGetLicenseExpressionExtensions.HasOnlyStandardIdentifiers(NuGet.Packaging.Licenses.NuGetLicenseExpression)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool NuGetLicenseExpressionExtensions.IsUnlicensed(NuGetLicense license)', validate parameter 'license' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Licenses.NuGetLicenseExpressionExtensions.IsUnlicensed(NuGet.Packaging.Licenses.NuGetLicense)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool NuGetLicenseExpressionExtensions.IsUnlicensed(NuGetLicenseExpression expression)', validate parameter 'expression' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Licenses.NuGetLicenseExpressionExtensions.IsUnlicensed(NuGet.Packaging.Licenses.NuGetLicenseExpression)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void NuGetLicenseExpressionExtensions.OnEachLeafNode(NuGetLicenseExpression expression, Action<NuGetLicense> licenseProcessor, Action<NuGetLicenseException> exceptionProcessor)', validate parameter 'expression' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Licenses.NuGetLicenseExpressionExtensions.OnEachLeafNode(NuGet.Packaging.Licenses.NuGetLicenseExpression,System.Action{NuGet.Packaging.Licenses.NuGetLicense},System.Action{NuGet.Packaging.Licenses.NuGetLicenseException})")]
[assembly: SuppressMessage("Build", "CA1303:Method 'NuGetLicenseExpression NuGetLicenseExpressionParser.Parse(string expression)' passes a literal string as parameter 'message' of a call to 'NuGetLicenseExpressionParsingException.NuGetLicenseExpressionParsingException(string message)'. Retrieve the following string(s) from a resource table instead: \"Should not happen. File a bug with repro steps on NuGet/Home if seen.\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Licenses.NuGetLicenseExpressionParser.Parse(System.String)~NuGet.Packaging.Licenses.NuGetLicenseExpression")]
[assembly: SuppressMessage("Build", "CA1801:Parameter document of method CheckSchemaVersion is never used. Remove the parameter or use it in the method body.", Justification = "Used in net472", Scope = "member", Target = "~M:NuGet.Packaging.Manifest.CheckSchemaVersion(System.Xml.Linq.XDocument)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void Manifest.Validate(Manifest manifest)', validate parameter 'manifest' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Manifest.Validate(NuGet.Packaging.Manifest)")]
[assembly: SuppressMessage("Build", "CA1801:Parameter document of method ValidateManifestSchema is never used. Remove the parameter or use it in the method body.", Justification = "Used in net472", Scope = "member", Target = "~M:NuGet.Packaging.Manifest.ValidateManifestSchema(System.Xml.Linq.XDocument,System.String)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'ManifestMetadata.ManifestMetadata(IPackageMetadata copy)', validate parameter 'copy' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.ManifestMetadata.#ctor(NuGet.Packaging.IPackageMetadata)")]
[assembly: SuppressMessage("Build", "CA1054:Change the type of parameter iconUrl of method ManifestMetadata.SetIconUrl(string) from string to System.Uri, or provide an overload to ManifestMetadata.SetIconUrl(string) that allows iconUrl to be passed as a System.Uri object.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.ManifestMetadata.SetIconUrl(System.String)")]
[assembly: SuppressMessage("Build", "CA1054:Change the type of parameter licenseUrl of method ManifestMetadata.SetLicenseUrl(string) from string to System.Uri, or provide an overload to ManifestMetadata.SetLicenseUrl(string) that allows licenseUrl to be passed as a System.Uri object.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.ManifestMetadata.SetLicenseUrl(System.String)")]
[assembly: SuppressMessage("Build", "CA1054:Change the type of parameter projectUrl of method ManifestMetadata.SetProjectUrl(string) from string to System.Uri, or provide an overload to ManifestMetadata.SetProjectUrl(string) that allows projectUrl to be passed as a System.Uri object.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.ManifestMetadata.SetProjectUrl(System.String)")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'ApplyUMaskToUnixPermissionsFromProcess' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.NuGetExtractionFileIO.ApplyUMaskToUnixPermissionsFromProcess~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1303:Method 'FileStream NuGetExtractionFileIO.DotnetCoreCreateFile(string path)' passes a literal string as parameter 'message' of a call to 'InvalidOperationException.InvalidOperationException(string message)'. Retrieve the following string(s) from a resource table instead: \"libc creat failed, but File.Create did not\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.NuGetExtractionFileIO.DotnetCoreCreateFile(System.String)~System.IO.FileStream")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'NupkgMetadataFile NupkgMetadataFileFormat.Read(TextReader reader, ILogger log, string path)', validate parameter 'log' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.NupkgMetadataFileFormat.Read(System.IO.TextReader,NuGet.Common.ILogger,System.String)~NuGet.Packaging.NupkgMetadataFile")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void NupkgMetadataFileFormat.Write(TextWriter textWriter, NupkgMetadataFile hashFile)', validate parameter 'hashFile' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.NupkgMetadataFileFormat.Write(System.IO.TextWriter,NuGet.Packaging.NupkgMetadataFile)")]
[assembly: SuppressMessage("Build", "CA1801:Parameter frameworkProvider of method .ctor is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackageArchiveReader.#ctor(System.IO.Stream,NuGet.Frameworks.IFrameworkNameProvider,NuGet.Frameworks.IFrameworkCompatibilityProvider)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IEnumerable<string> PackageArchiveReader.CopyFiles(string destination, IEnumerable<string> packageFiles, ExtractPackageFileDelegate extractFile, ILogger logger, CancellationToken token)', validate parameter 'packageFiles' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackageArchiveReader.CopyFiles(System.String,System.Collections.Generic.IEnumerable{System.String},NuGet.Packaging.Core.ExtractPackageFileDelegate,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Collections.Generic.IEnumerable{System.String}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IEnumerable<ZipFilePair> PackageArchiveReader.EnumeratePackageEntries(IEnumerable<string> packageFiles, string packageDirectory)', validate parameter 'packageFiles' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackageArchiveReader.EnumeratePackageEntries(System.Collections.Generic.IEnumerable{System.String},System.String)~System.Collections.Generic.IEnumerable{NuGet.Packaging.ZipFilePair}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Stream PackageArchiveReader.GetStream(string path)', validate parameter 'path' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackageArchiveReader.GetStream(System.String)~System.IO.Stream")]
[assembly: SuppressMessage("Build", "CA1801:Parameter deterministic of method .ctor is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackageBuilder.#ctor(System.Boolean,System.Boolean)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void PackageBuilder.AddFiles(string basePath, string source, string destination, string exclude = null)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackageBuilder.AddFiles(System.String,System.String,System.String,System.String)")]
[assembly: SuppressMessage("Build", "CA1822:Member GenerateRelationshipId does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackageBuilder.GenerateRelationshipId(System.String)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void PackageBuilder.Populate(ManifestMetadata manifestMetadata)', validate parameter 'manifestMetadata' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackageBuilder.Populate(NuGet.Packaging.ManifestMetadata)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void PackageBuilder.PopulateFiles(string basePath, IEnumerable<ManifestFile> files)', validate parameter 'files' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackageBuilder.PopulateFiles(System.String,System.Collections.Generic.IEnumerable{NuGet.Packaging.ManifestFile})")]
[assembly: SuppressMessage("Build", "CA1801:Parameter signVerifyStartTime of method .ctor is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackageExtractionResult.#ctor(System.Boolean,System.TimeSpan,NuGet.Packaging.PackageSignType,System.Boolean,System.DateTimeOffset,System.DateTimeOffset)")]
[assembly: SuppressMessage("Build", "CA1308:In method '.ctor', replace the call to 'ToLowerInvariant' with 'ToUpperInvariant'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackageExtractionTelemetryEvent.#ctor(NuGet.Packaging.PackageSaveMode,NuGet.Common.NuGetOperationStatus,NuGet.Packaging.ExtractionSource,NuGet.Packaging.Core.PackageIdentity)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'PackageExtractionTelemetryEvent.PackageExtractionTelemetryEvent(PackageSaveMode packageSaveMode, NuGetOperationStatus status, ExtractionSource extractionSource, PackageIdentity packageId)', validate parameter 'packageId' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackageExtractionTelemetryEvent.#ctor(NuGet.Packaging.PackageSaveMode,NuGet.Common.NuGetOperationStatus,NuGet.Packaging.ExtractionSource,NuGet.Packaging.Core.PackageIdentity)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<IEnumerable<string>> PackageExtractor.ExtractPackageAsync(string source, PackageReaderBase packageReader, Stream packageStream, PackagePathResolver packagePathResolver, PackageExtractionContext packageExtractionContext, CancellationToken token, Guid parentId = default(Guid))', validate parameter 'packageReader' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackageExtractor.ExtractPackageAsync(System.String,NuGet.Packaging.PackageReaderBase,System.IO.Stream,NuGet.Packaging.PackagePathResolver,NuGet.Packaging.PackageExtractionContext,System.Threading.CancellationToken,System.Guid)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{System.String}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<bool> PackageExtractor.InstallFromSourceAsync(PackageIdentity packageIdentity, IPackageDownloader packageDownloader, VersionFolderPathResolver versionFolderPathResolver, PackageExtractionContext packageExtractionContext, CancellationToken token, Guid parentId = default(Guid))', validate parameter 'versionFolderPathResolver' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackageExtractor.InstallFromSourceAsync(NuGet.Packaging.Core.PackageIdentity,NuGet.Packaging.IPackageDownloader,NuGet.Packaging.VersionFolderPathResolver,NuGet.Packaging.PackageExtractionContext,System.Threading.CancellationToken,System.Guid)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<bool> PackageExtractor.InstallFromSourceAsync(string source, PackageIdentity packageIdentity, Func<Stream, Task> copyToAsync, VersionFolderPathResolver versionFolderPathResolver, PackageExtractionContext packageExtractionContext, CancellationToken token, Guid parentId = default(Guid))', validate parameter 'versionFolderPathResolver' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackageExtractor.InstallFromSourceAsync(System.String,NuGet.Packaging.Core.PackageIdentity,System.Func{System.IO.Stream,System.Threading.Tasks.Task},NuGet.Packaging.VersionFolderPathResolver,NuGet.Packaging.PackageExtractionContext,System.Threading.CancellationToken,System.Guid)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string PackageFileExtractor.ExtractPackageFile(string source, string target, Stream stream)', validate parameter 'stream' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackageFileExtractor.ExtractPackageFile(System.String,System.String,System.IO.Stream)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IEnumerable<string> PackageFolderReader.CopyFiles(string destination, IEnumerable<string> packageFiles, ExtractPackageFileDelegate extractFile, ILogger logger, CancellationToken token)', validate parameter 'packageFiles' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackageFolderReader.CopyFiles(System.String,System.Collections.Generic.IEnumerable{System.String},NuGet.Packaging.Core.ExtractPackageFileDelegate,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Collections.Generic.IEnumerable{System.String}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<IEnumerable<ZipFilePair>> PackageHelper.GetInstalledPackageFilesAsync(PackageArchiveReader packageReader, PackageIdentity packageIdentity, PackagePathResolver packagePathResolver, PackageSaveMode packageSaveMode, CancellationToken cancellationToken)', validate parameter 'packageReader' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackageHelper.GetInstalledPackageFilesAsync(NuGet.Packaging.PackageArchiveReader,NuGet.Packaging.Core.PackageIdentity,NuGet.Packaging.PackagePathResolver,NuGet.Packaging.PackageSaveMode,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{NuGet.Packaging.ZipFilePair}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<string, IEnumerable<ZipFilePair>>> PackageHelper.GetInstalledSatelliteFilesAsync(PackageArchiveReader packageReader, PackagePathResolver packagePathResolver, PackageSaveMode packageSaveMode, CancellationToken cancellationToken)', validate parameter 'packageReader' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackageHelper.GetInstalledSatelliteFilesAsync(NuGet.Packaging.PackageArchiveReader,NuGet.Packaging.PackagePathResolver,NuGet.Packaging.PackageSaveMode,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.String,System.Collections.Generic.IEnumerable{NuGet.Packaging.ZipFilePair}}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<Tuple<string, IEnumerable<string>>> PackageHelper.GetSatelliteFilesAsync(PackageReaderBase packageReader, PackagePathResolver packagePathResolver, CancellationToken cancellationToken)', validate parameter 'packagePathResolver' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackageHelper.GetSatelliteFilesAsync(NuGet.Packaging.PackageReaderBase,NuGet.Packaging.PackagePathResolver,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Tuple{System.String,System.Collections.Generic.IEnumerable{System.String}}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool PackageHelper.IsAssembly(string path)', validate parameter 'path' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackageHelper.IsAssembly(System.String)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool PackageHelper.IsNuspec(string path)', validate parameter 'path' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackageHelper.IsNuspec(System.String)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool PackageHelper.IsRoot(string path)', validate parameter 'path' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackageHelper.IsRoot(System.String)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1303:Method 'bool PackageIdValidator.IsValidPackageId(string packageId)' passes a literal string as parameter 'message' of a call to 'ArgumentException.ArgumentException(string message)'. Retrieve the following string(s) from a resource table instead: \"packageId\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackageIdValidator.IsValidPackageId(System.String)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void PackageIdValidator.ValidatePackageId(string packageId)', validate parameter 'packageId' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackageIdValidator.ValidatePackageId(System.String)")]
[assembly: SuppressMessage("Build", "CA1308:In method 'GetPackageLookupPaths', replace the call to 'ToLowerInvariant' with 'ToUpperInvariant'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackagePathHelper.GetPackageLookupPaths(NuGet.Packaging.Core.PackageIdentity,NuGet.Packaging.PackagePathResolver)~System.Collections.Generic.IEnumerable{System.String}")]
[assembly: SuppressMessage("Build", "CA1822:Member GetId does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackagePathResolver.GetId(NuGet.Packaging.Core.PackageIdentity)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string PackagePathResolver.GetManifestFileName(PackageIdentity packageIdentity)', validate parameter 'packageIdentity' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackagePathResolver.GetManifestFileName(NuGet.Packaging.Core.PackageIdentity)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string PackagePathResolver.GetPackageDownloadMarkerFileName(PackageIdentity packageIdentity)', validate parameter 'packageIdentity' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackagePathResolver.GetPackageDownloadMarkerFileName(NuGet.Packaging.Core.PackageIdentity)~System.String")]
[assembly: SuppressMessage("Build", "CA1822:Member GetVersion does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackagePathResolver.GetVersion(NuGet.Packaging.Core.PackageIdentity)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'NuGetFramework PackageReaderBase.GetFrameworkFromPath(string path, bool allowSubFolders = false)', validate parameter 'path' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackageReaderBase.GetFrameworkFromPath(System.String,System.Boolean)~NuGet.Frameworks.NuGetFramework")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool PackageReaderBase.IsReferenceAssembly(string path)', validate parameter 'path' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackageReaderBase.IsReferenceAssembly(System.String)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1822:Member NormalizeDirectoryPath does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackageReaderBase.NormalizeDirectoryPath(System.String)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string PackageReaderBase.NormalizeDirectoryPath(string path)', validate parameter 'path' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackageReaderBase.NormalizeDirectoryPath(System.String)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void PackageReaderBase.ValidatePackageEntries(string normalizedDestination, IEnumerable<string> packageFiles, PackageIdentity packageIdentity)', validate parameter 'packageFiles' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackageReaderBase.ValidatePackageEntries(System.String,System.Collections.Generic.IEnumerable{System.String},NuGet.Packaging.Core.PackageIdentity)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void PackageReaderBase.ValidatePackageEntry(string normalizedDestination, string normalizedFilePath, PackageIdentity packageIdentity)', validate parameter 'normalizedDestination' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackageReaderBase.ValidatePackageEntry(System.String,System.String,NuGet.Packaging.Core.PackageIdentity)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<IEnumerable<string>> PackageReaderExtensions.GetPackageFilesAsync(IAsyncPackageCoreReader packageReader, PackageSaveMode packageSaveMode, CancellationToken cancellationToken)', validate parameter 'packageReader' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackageReaderExtensions.GetPackageFilesAsync(NuGet.Packaging.Core.IAsyncPackageCoreReader,NuGet.Packaging.PackageSaveMode,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{System.String}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<IEnumerable<string>> PackageReaderExtensions.GetSatelliteFilesAsync(IAsyncPackageContentReader packageReader, string packageLanguage, CancellationToken cancellationToken)', validate parameter 'packageReader' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackageReaderExtensions.GetSatelliteFilesAsync(NuGet.Packaging.IAsyncPackageContentReader,System.String,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{System.String}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool PackagesConfig.HasAttributeValue(XElement node, string attributeName, string targetValue, out XElement element)', validate parameter 'node' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackagesConfig.HasAttributeValue(System.Xml.Linq.XElement,System.String,System.String,System.Xml.Linq.XElement@)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool PackagesConfig.TryGetAttribute(XElement node, string name, out string value)', validate parameter 'node' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackagesConfig.TryGetAttribute(System.Xml.Linq.XElement,System.String,System.String@)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1303:Method 'PackagesConfigWriter.PackagesConfigWriter(Stream stream, bool createNew, IFrameworkNameProvider frameworkMappings)' passes a literal string as parameter 'message' of a call to 'ArgumentException.ArgumentException(string message)'. Retrieve the following string(s) from a resource table instead: \"stream\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackagesConfigWriter.#ctor(System.IO.Stream,System.Boolean,NuGet.Frameworks.IFrameworkNameProvider)")]
[assembly: SuppressMessage("Build", "CA1303:Method 'PackagesConfigWriter.PackagesConfigWriter(string fullPath, bool createNew, IFrameworkNameProvider frameworkMappings)' passes a literal string as parameter 'message' of a call to 'ArgumentException.ArgumentException(string message)'. Retrieve the following string(s) from a resource table instead: \"fullPath\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackagesConfigWriter.#ctor(System.String,System.Boolean,NuGet.Frameworks.IFrameworkNameProvider)")]
[assembly: SuppressMessage("Build", "CA1822:Member FindMatchingPackageNode does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackagesConfigWriter.FindMatchingPackageNode(NuGet.Packaging.PackageReference,System.Xml.Linq.XElement)~System.Xml.Linq.XElement")]
[assembly: SuppressMessage("Build", "CA1822:Member SortPackageNodes does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.PackagesConfigWriter.SortPackageNodes(System.Xml.Linq.XElement)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IEnumerable<PackagingLogMessage> IconUrlDeprecationWarning.Validate(PackageArchiveReader builder)', validate parameter 'builder' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Rules.IconUrlDeprecationWarning.Validate(NuGet.Packaging.PackageArchiveReader)~System.Collections.Generic.IEnumerable{NuGet.Common.PackagingLogMessage}")]
[assembly: SuppressMessage("Build", "CA1822:Member GenerateWarningString does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Rules.NoRefOrLibFolderInPackageRule.GenerateWarningString(System.String[])~System.ValueTuple{System.String,System.String}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IEnumerable<PackagingLogMessage> PathTooLongRule.Validate(PackageArchiveReader builder)', validate parameter 'builder' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Rules.PathTooLongRule.Validate(NuGet.Packaging.PackageArchiveReader)~System.Collections.Generic.IEnumerable{NuGet.Common.PackagingLogMessage}")]
[assembly: SuppressMessage("Build", "CA1822:Member GetAllKeys does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Rules.ReferencesInNuspecMatchRefAssetsRule.GetAllKeys(System.Collections.Generic.IEnumerable{System.Linq.IGrouping{System.String,System.String}})~System.Collections.Generic.List{System.String}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Accuracy Accuracy.Read(byte[] bytes)', validate parameter 'bytes' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.Accuracy.Read(System.Byte[])~NuGet.Packaging.Signing.Accuracy")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'AlgorithmIdentifier AlgorithmIdentifier.Read(byte[] bytes)', validate parameter 'bytes' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.AlgorithmIdentifier.Read(System.Byte[])~NuGet.Packaging.Signing.AlgorithmIdentifier")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<PackageVerificationResult> AllowListVerificationProvider.GetTrustResultAsync(ISignedPackageReader package, PrimarySignature signature, SignedPackageVerifierSettings settings, CancellationToken token)', validate parameter 'settings' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.AllowListVerificationProvider.GetTrustResultAsync(NuGet.Packaging.Signing.ISignedPackageReader,NuGet.Packaging.Signing.PrimarySignature,NuGet.Packaging.Signing.SignedPackageVerifierSettings,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.Packaging.Signing.PackageVerificationResult}")]
#if IS_SIGNING_SUPPORTED
[assembly: SuppressMessage("Build", "CA1822:Member IsSignatureAllowed does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.AllowListVerificationProvider.IsSignatureAllowed(NuGet.Packaging.Signing.PrimarySignature,System.Collections.Generic.IReadOnlyCollection{NuGet.Packaging.Signing.VerificationAllowListEntry})~System.Boolean")]
#endif
[assembly: SuppressMessage("Build", "CA1801:Parameter package of method VerifyAllowList is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.AllowListVerificationProvider.VerifyAllowList(NuGet.Packaging.Signing.ISignedPackageReader,NuGet.Packaging.Signing.PrimarySignature,NuGet.Packaging.Signing.SignedPackageVerifierSettings)~NuGet.Packaging.Signing.PackageVerificationResult")]
#if IS_SIGNING_SUPPORTED
[assembly: SuppressMessage("Build", "CA1303:Method 'string AttributeUtility.GetSignatureTypeOid(SignatureType signatureType)' passes a literal string as parameter 'message' of a call to 'ArgumentException.ArgumentException(string message)'. Retrieve the following string(s) from a resource table instead: \"signatureType\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.AttributeUtility.GetSignatureTypeOid(NuGet.Packaging.Signing.SignatureType)~System.String")]
#endif
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IReadOnlyList<byte[]> CertificateUtility.GetRawDataForCollection(X509Certificate2Collection certificates)', validate parameter 'certificates' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.CertificateUtility.GetRawDataForCollection(System.Security.Cryptography.X509Certificates.X509Certificate2Collection)~System.Collections.Generic.IReadOnlyList{System.Byte[]}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool CertificateUtility.HasExtendedKeyUsage(X509Certificate2 certificate, string ekuOid)', validate parameter 'certificate' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.CertificateUtility.HasExtendedKeyUsage(System.Security.Cryptography.X509Certificates.X509Certificate2,System.String)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool CertificateUtility.IsCertificateValidityPeriodInTheFuture(X509Certificate2 certificate)', validate parameter 'certificate' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.CertificateUtility.IsCertificateValidityPeriodInTheFuture(System.Security.Cryptography.X509Certificates.X509Certificate2)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool CertificateUtility.IsDateInsideValidityPeriod(X509Certificate2 certificate, DateTimeOffset date)', validate parameter 'certificate' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.CertificateUtility.IsDateInsideValidityPeriod(System.Security.Cryptography.X509Certificates.X509Certificate2,System.DateTimeOffset)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool CertificateUtility.IsSignatureAlgorithmSupported(X509Certificate2 certificate)', validate parameter 'certificate' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.CertificateUtility.IsSignatureAlgorithmSupported(System.Security.Cryptography.X509Certificates.X509Certificate2)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'bool CertificateUtility.IsValidForPurposeFast(X509Certificate2 certificate, string ekuOid)', validate parameter 'certificate' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.CertificateUtility.IsValidForPurposeFast(System.Security.Cryptography.X509Certificates.X509Certificate2,System.String)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string CertificateUtility.X509Certificate2CollectionToString(X509Certificate2Collection certCollection, HashAlgorithmName fingerprintAlgorithm)', validate parameter 'certCollection' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.CertificateUtility.X509Certificate2CollectionToString(System.Security.Cryptography.X509Certificates.X509Certificate2Collection,NuGet.Common.HashAlgorithmName)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string CertificateUtility.X509Certificate2ToString(X509Certificate2 cert, HashAlgorithmName fingerprintAlgorithm)', validate parameter 'cert' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.CertificateUtility.X509Certificate2ToString(System.Security.Cryptography.X509Certificates.X509Certificate2,NuGet.Common.HashAlgorithmName)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string CertificateUtility.X509ChainToString(X509Chain chain, HashAlgorithmName fingerprintAlgorithm)', validate parameter 'chain' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.CertificateUtility.X509ChainToString(System.Security.Cryptography.X509Certificates.X509Chain,NuGet.Common.HashAlgorithmName)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'CommitmentTypeIndication CommitmentTypeIndication.Read(byte[] bytes)', validate parameter 'bytes' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.CommitmentTypeIndication.Read(System.Byte[])~NuGet.Packaging.Signing.CommitmentTypeIndication")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'CommitmentTypeQualifier CommitmentTypeQualifier.Read(byte[] bytes)', validate parameter 'bytes' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.CommitmentTypeQualifier.Read(System.Byte[])~NuGet.Packaging.Signing.CommitmentTypeQualifier")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'uint Crc32.CalculateCrc(byte[] data)', validate parameter 'data' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.Crc32.CalculateCrc(System.Byte[])~System.UInt32")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'EssCertId EssCertId.Read(byte[] bytes)', validate parameter 'bytes' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.EssCertId.Read(System.Byte[])~NuGet.Packaging.Signing.EssCertId")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'EssCertIdV2 EssCertIdV2.Read(byte[] bytes)', validate parameter 'bytes' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.EssCertIdV2.Read(System.Byte[])~NuGet.Packaging.Signing.EssCertIdV2")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Extensions Extensions.Read(byte[] bytes)', validate parameter 'bytes' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.Extensions.Read(System.Byte[])~NuGet.Packaging.Signing.Extensions")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'GeneralName GeneralName.Read(byte[] bytes)', validate parameter 'bytes' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.GeneralName.Read(System.Byte[])~NuGet.Packaging.Signing.GeneralName")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<PackageVerificationResult> IntegrityVerificationProvider.GetTrustResultAsync(ISignedPackageReader package, PrimarySignature signature, SignedPackageVerifierSettings settings, CancellationToken token)', validate parameter 'settings' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.IntegrityVerificationProvider.GetTrustResultAsync(NuGet.Packaging.Signing.ISignedPackageReader,NuGet.Packaging.Signing.PrimarySignature,NuGet.Packaging.Signing.SignedPackageVerifierSettings,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.Packaging.Signing.PackageVerificationResult}")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'VerifyPackageIntegrityAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.IntegrityVerificationProvider.VerifyPackageIntegrityAsync(NuGet.Packaging.Signing.ISignedPackageReader,NuGet.Packaging.Signing.PrimarySignature,NuGet.Packaging.Signing.SignedPackageVerifierSettings)~System.Threading.Tasks.Task{NuGet.Packaging.Signing.PackageVerificationResult}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IssuerSerial IssuerSerial.Read(byte[] bytes)', validate parameter 'bytes' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.IssuerSerial.Read(System.Byte[])~NuGet.Packaging.Signing.IssuerSerial")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string KeyPairFileUtility.GetValueOrThrow(Dictionary<string, string> values, string key)', validate parameter 'values' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.KeyPairFileUtility.GetValueOrThrow(System.Collections.Generic.Dictionary{System.String,System.String},System.String)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'MessageImprint MessageImprint.Read(byte[] bytes)', validate parameter 'bytes' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.MessageImprint.Read(System.Byte[])~NuGet.Packaging.Signing.MessageImprint")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'NuGetPackageOwners NuGetPackageOwners.Read(byte[] bytes)', validate parameter 'bytes' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.NuGetPackageOwners.Read(System.Byte[])~NuGet.Packaging.Signing.NuGetPackageOwners")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'NuGetV3ServiceIndexUrl NuGetV3ServiceIndexUrl.Read(byte[] bytes)', validate parameter 'bytes' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.NuGetV3ServiceIndexUrl.Read(System.Byte[])~NuGet.Packaging.Signing.NuGetV3ServiceIndexUrl")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'PolicyInformation PolicyInformation.Read(byte[] bytes)', validate parameter 'bytes' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.PolicyInformation.Read(System.Byte[])~NuGet.Packaging.Signing.PolicyInformation")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'PolicyQualifierInfo PolicyQualifierInfo.Read(byte[] bytes)', validate parameter 'bytes' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.PolicyQualifierInfo.Read(System.Byte[])~NuGet.Packaging.Signing.PolicyQualifierInfo")]
#if IS_SIGNING_SUPPORTED
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'PrimarySignature PrimarySignatureFactory.CreateSignature(SignedCms signedCms)', validate parameter 'signedCms' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.PrimarySignatureFactory.CreateSignature(System.Security.Cryptography.Pkcs.SignedCms)~NuGet.Packaging.Signing.PrimarySignature")]
#endif
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Rfc3161TimestampProvider.Rfc3161TimestampProvider(Uri timeStampServerUrl)', validate parameter 'timeStampServerUrl' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.Rfc3161TimestampProvider.#ctor(System.Uri)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<PrimarySignature> Rfc3161TimestampProvider.TimestampSignatureAsync(PrimarySignature primarySignature, TimestampRequest request, ILogger logger, CancellationToken token)', validate parameter 'primarySignature' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.Rfc3161TimestampProvider.TimestampSignatureAsync(NuGet.Packaging.Signing.PrimarySignature,NuGet.Packaging.Signing.TimestampRequest,NuGet.Common.ILogger,System.Threading.CancellationToken)~System.Threading.Tasks.Task{NuGet.Packaging.Signing.PrimarySignature}")]
#if IS_DESKTOP
[assembly: SuppressMessage("Build", "CA1303:Method 'Rfc3161TimestampRequest.Rfc3161TimestampRequest(byte[] messageHash, HashAlgorithmName hashAlgorithm, Oid requestedPolicyId = null, byte[] nonce = null, bool requestSignerCertificates = false, X509ExtensionCollection extensions = null)' passes a literal string as parameter 'message' of a call to 'ArgumentException.ArgumentException(string message, string paramName)'. Retrieve the following string(s) from a resource table instead: \"Hash is not the correct size for the identified algorithm\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.Rfc3161TimestampRequest.#ctor(System.Byte[],System.Security.Cryptography.HashAlgorithmName,System.Security.Cryptography.Oid,System.Byte[],System.Boolean,System.Security.Cryptography.X509Certificates.X509ExtensionCollection)")]
[assembly: SuppressMessage("Build", "CA1303:Method 'Rfc3161TimestampRequest.Rfc3161TimestampRequest(byte[] messageHash, Oid hashAlgorithmId, Oid requestedPolicyId = null, byte[] nonce = null, bool requestSignerCertificates = false, X509ExtensionCollection extensions = null)' passes a literal string as parameter 'message' of a call to 'ArgumentException.ArgumentException(string message, string paramName)'. Retrieve the following string(s) from a resource table instead: \"Nonce must be null or non-empty\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.Rfc3161TimestampRequest.#ctor(System.Byte[],System.Security.Cryptography.Oid,System.Security.Cryptography.Oid,System.Byte[],System.Boolean,System.Security.Cryptography.X509Certificates.X509ExtensionCollection)")]
#endif
#if IS_SIGNING_SUPPORTED
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Signature.Signature(SignerInfo signerInfo, SignatureType type)', validate parameter 'signerInfo' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.Signature.#ctor(System.Security.Cryptography.Pkcs.SignerInfo,NuGet.Packaging.Signing.SignatureType)")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'Verify' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.Signature.Verify(NuGet.Packaging.Signing.Timestamp,NuGet.Packaging.Signing.SignatureVerifySettings,NuGet.Common.HashAlgorithmName,System.Security.Cryptography.X509Certificates.X509Certificate2Collection)~NuGet.Packaging.Signing.SignatureVerificationSummary")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'IsUntrustedRootAllowed' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.SignatureTrustAndValidityVerificationProvider.IsUntrustedRootAllowed(NuGet.Packaging.Signing.Signature)~System.Boolean")]
#endif
[assembly: SuppressMessage("Build", "CA1031:Modify 'IsSigned' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.SignedPackageArchiveUtility.IsSigned(System.IO.BinaryReader)~System.Boolean")]
#if IS_SIGNING_SUPPORTED
[assembly: SuppressMessage("Build", "CA1031:Modify 'VerifySignedPackageIntegrity' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.SignedPackageArchiveUtility.VerifySignedPackageIntegrity(System.IO.BinaryReader,System.Security.Cryptography.HashAlgorithm,System.Byte[])~System.Boolean")]
#endif
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'SigningCertificate SigningCertificate.Read(byte[] bytes)', validate parameter 'bytes' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.SigningCertificate.Read(System.Byte[])~NuGet.Packaging.Signing.SigningCertificate")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'SigningCertificateV2 SigningCertificateV2.Read(byte[] bytes)', validate parameter 'bytes' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.SigningCertificateV2.Read(System.Byte[])~NuGet.Packaging.Signing.SigningCertificateV2")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task SigningUtility.SignAsync(SigningOptions options, SignPackageRequest signRequest, CancellationToken token)', validate parameter 'options' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.SigningUtility.SignAsync(NuGet.Packaging.Signing.SigningOptions,NuGet.Packaging.Signing.SignPackageRequest,System.Threading.CancellationToken)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'Remove' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.TrustedSignersProvider.Remove(System.Collections.Generic.IReadOnlyList{NuGet.Configuration.TrustedSignerItem})")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'TstInfo TstInfo.Read(byte[] bytes)', validate parameter 'bytes' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.TstInfo.Read(System.Byte[])~NuGet.Packaging.Signing.TstInfo")]
#if IS_SIGNING_SUPPORTED
[assembly: SuppressMessage("Build", "CA1031:Modify 'ValidateTimestamp' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Signing.VerificationUtility.ValidateTimestamp(NuGet.Packaging.Signing.Timestamp,NuGet.Packaging.Signing.Signature,System.Boolean,System.Collections.Generic.List{NuGet.Packaging.Signing.SignatureLog},NuGet.Packaging.Signing.SigningSpecifications)~NuGet.Packaging.Signing.SignatureVerificationStatusFlags")]
#endif
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string StreamExtensions.CopyToFile(Stream inputStream, string fileFullPath)', validate parameter 'inputStream' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.StreamExtensions.CopyToFile(System.IO.Stream,System.String)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string VersionFolderPathResolver.GetHashFileName(string packageId, NuGetVersion version)', validate parameter 'packageId' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.VersionFolderPathResolver.GetHashFileName(System.String,NuGet.Versioning.NuGetVersion)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string VersionFolderPathResolver.GetManifestFileName(string packageId, NuGetVersion version)', validate parameter 'packageId' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.VersionFolderPathResolver.GetManifestFileName(System.String,NuGet.Versioning.NuGetVersion)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string VersionFolderPathResolver.GetManifestFilePath(string packageId, NuGetVersion version)', validate parameter 'packageId' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.VersionFolderPathResolver.GetManifestFilePath(System.String,NuGet.Versioning.NuGetVersion)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string VersionFolderPathResolver.GetPackageDirectory(string packageId, NuGetVersion version)', validate parameter 'version' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.VersionFolderPathResolver.GetPackageDirectory(System.String,NuGet.Versioning.NuGetVersion)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string VersionFolderPathResolver.GetPackageDownloadMarkerFileName(string packageId)', validate parameter 'packageId' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.VersionFolderPathResolver.GetPackageDownloadMarkerFileName(System.String)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string VersionFolderPathResolver.GetPackageFileName(string packageId, NuGetVersion version)', validate parameter 'packageId' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.VersionFolderPathResolver.GetPackageFileName(System.String,NuGet.Versioning.NuGetVersion)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string VersionFolderPathResolver.GetVersionListDirectory(string packageId)', validate parameter 'packageId' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.VersionFolderPathResolver.GetVersionListDirectory(System.String)~System.String")]
[assembly: SuppressMessage("Build", "CA1308:In method 'Normalize', replace the call to 'ToLowerInvariant' with 'ToUpperInvariant'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.VersionFolderPathResolver.Normalize(NuGet.Versioning.NuGetVersion)~System.String")]
[assembly: SuppressMessage("Build", "CA1308:In method 'Normalize', replace the call to 'ToLowerInvariant' with 'ToUpperInvariant'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.VersionFolderPathResolver.Normalize(System.String)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IEnumerable<XElement> XElementExtensions.ElementsNoNamespace(XContainer container, string localName)', validate parameter 'container' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.XElementExtensions.ElementsNoNamespace(System.Xml.Linq.XContainer,System.String)~System.Collections.Generic.IEnumerable{System.Xml.Linq.XElement}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'XElement XElementExtensions.Except(XElement source, XElement target)', validate parameter 'source' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.XElementExtensions.Except(System.Xml.Linq.XElement,System.Xml.Linq.XElement)~System.Xml.Linq.XElement")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string XElementExtensions.GetOptionalAttributeValue(XElement element, string localName, string namespaceName = null)', validate parameter 'element' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.XElementExtensions.GetOptionalAttributeValue(System.Xml.Linq.XElement,System.String,System.String)~System.String")]
[assembly: SuppressMessage("Build", "CA1308:In method 'GetXElementFromLicenseMetadata', replace the call to 'ToLowerInvariant' with 'ToUpperInvariant'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.Xml.PackageMetadataXmlExtensions.GetXElementFromLicenseMetadata(System.Xml.Linq.XNamespace,NuGet.Packaging.LicenseMetadata)~System.Xml.Linq.XElement")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IEnumerable<string> ZipArchiveExtensions.GetFiles(ZipArchive zipArchive)', validate parameter 'zipArchive' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.ZipArchiveExtensions.GetFiles(System.IO.Compression.ZipArchive)~System.Collections.Generic.IEnumerable{System.String}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'ZipArchiveEntry ZipArchiveExtensions.LookupEntry(ZipArchive zipArchive, string path)', validate parameter 'zipArchive' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.ZipArchiveExtensions.LookupEntry(System.IO.Compression.ZipArchive,System.String)~System.IO.Compression.ZipArchiveEntry")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'string ZipArchiveExtensions.SaveAsFile(ZipArchiveEntry entry, string fileFullPath, ILogger logger)', validate parameter 'entry' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Packaging.ZipArchiveExtensions.SaveAsFile(System.IO.Compression.ZipArchiveEntry,System.String,NuGet.Common.ILogger)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'RuntimeGraph JsonRuntimeFormat.ReadRuntimeGraph(JToken json)', validate parameter 'json' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.RuntimeModel.JsonRuntimeFormat.ReadRuntimeGraph(Newtonsoft.Json.Linq.JToken)~NuGet.RuntimeModel.RuntimeGraph")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void JsonRuntimeFormat.WriteRuntimeGraph(IObjectWriter writer, RuntimeGraph runtimeGraph)', validate parameter 'writer' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.RuntimeModel.JsonRuntimeFormat.WriteRuntimeGraph(NuGet.RuntimeModel.IObjectWriter,NuGet.RuntimeModel.RuntimeGraph)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'RuntimeDescription RuntimeDescription.Merge(RuntimeDescription left, RuntimeDescription right)', validate parameter 'right' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.RuntimeModel.RuntimeDescription.Merge(NuGet.RuntimeModel.RuntimeDescription,NuGet.RuntimeModel.RuntimeDescription)~NuGet.RuntimeModel.RuntimeDescription")]
[assembly: SuppressMessage("Build", "CA1303:Method 'RuntimeDescription RuntimeDescription.Merge(RuntimeDescription left, RuntimeDescription right)' passes a literal string as parameter 'message' of a call to 'InvalidOperationException.InvalidOperationException(string message)'. Retrieve the following string(s) from a resource table instead: \"TODO: Unable to merge runtimes, they do not have the same identifier\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.RuntimeModel.RuntimeDescription.Merge(NuGet.RuntimeModel.RuntimeDescription,NuGet.RuntimeModel.RuntimeDescription)~NuGet.RuntimeModel.RuntimeDescription")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'RuntimeGraph RuntimeGraph.Merge(RuntimeGraph left, RuntimeGraph right)', validate parameter 'right' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.RuntimeModel.RuntimeGraph.Merge(NuGet.RuntimeModel.RuntimeGraph,NuGet.RuntimeModel.RuntimeGraph)~NuGet.RuntimeModel.RuntimeGraph")]
[assembly: SuppressMessage("Build", "CA2227:Change 'Entries' to be read-only by removing the property setter.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.ContentModel.SelectionCriteria.Entries")]
[assembly: SuppressMessage("Build", "CA2227:Change 'Properties' to be read-only by removing the property setter.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.ContentModel.SelectionCriteriaEntry.Properties")]
[assembly: SuppressMessage("Build", "CA1303:Method 'SelectionCriteriaEntryBuilder SelectionCriteriaEntryBuilder.this[string key, object value].get' passes a literal string as parameter 'message' of a call to 'Exception.Exception(string message)'. Retrieve the following string(s) from a resource table instead: \"Undefined property used for criteria\".", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.ContentModel.SelectionCriteriaEntryBuilder.Item(System.String,System.Object)")]
[assembly: SuppressMessage("Build", "CA1303:Method 'SelectionCriteriaEntryBuilder SelectionCriteriaEntryBuilder.this[string key, string value].get' passes a literal string as parameter 'message' of a call to 'Exception.Exception(string message)'. Retrieve the following string(s) from a resource table instead: \"Undefined value used for criteria\".", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.ContentModel.SelectionCriteriaEntryBuilder.Item(System.String,System.String)")]
[assembly: SuppressMessage("Build", "CA1056:Change the type of property IRepositoryCertificateInfo.ContentUrl from string to System.Uri.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Packaging.Core.IRepositoryCertificateInfo.ContentUrl")]
[assembly: SuppressMessage("Build", "CA1056:Change the type of property RepositoryMetadata.Url from string to System.Uri.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Packaging.Core.RepositoryMetadata.Url")]
[assembly: SuppressMessage("Build", "CA2227:Change 'PackageAssemblyReferences' to be read-only by removing the property setter.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Packaging.PackageBuilder.PackageAssemblyReferences")]
[assembly: SuppressMessage("Build", "CA2227:Change 'PackageTypes' to be read-only by removing the property setter.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Packaging.PackageBuilder.PackageTypes")]
[assembly: SuppressMessage("Build", "CA2227:Change 'TargetFrameworks' to be read-only by removing the property setter.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Packaging.PackageBuilder.TargetFrameworks")]
[assembly: SuppressMessage("Build", "CA1819:Properties should not return arrays", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Packaging.PackagingConstants.Folders.Known")]
[assembly: SuppressMessage("Build", "CA1822:Member CompatMatchFoundWarningMessageFormat does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Packaging.Rules.DependenciesGroupsForEachTFMRule.CompatMatchFoundWarningMessageFormat")]
[assembly: SuppressMessage("Build", "CA1819:Properties should not return arrays", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Packaging.Signing.CommitmentTypeQualifier.Qualifier")]
[assembly: SuppressMessage("Build", "CA1819:Properties should not return arrays", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Packaging.Signing.EssCertId.CertificateHash")]
[assembly: SuppressMessage("Build", "CA1819:Properties should not return arrays", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Packaging.Signing.EssCertIdV2.CertificateHash")]
[assembly: SuppressMessage("Build", "CA1819:Properties should not return arrays", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Packaging.Signing.Extension.Value")]
[assembly: SuppressMessage("Build", "CA1819:Properties should not return arrays", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Packaging.Signing.IssuerSerial.SerialNumber")]
[assembly: SuppressMessage("Build", "CA1819:Properties should not return arrays", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Packaging.Signing.MessageImprint.HashedMessage")]
[assembly: SuppressMessage("Build", "CA1819:Properties should not return arrays", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Packaging.Signing.PolicyQualifierInfo.Qualifier")]
[assembly: SuppressMessage("Build", "CA2227:Change 'CentralDirectoryHeaders' to be read-only by removing the property setter.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Packaging.Signing.SignedPackageArchiveMetadata.CentralDirectoryHeaders")]
[assembly: SuppressMessage("Build", "CA1819:Properties should not return arrays", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Packaging.Signing.SigningSpecifications.AllowedHashAlgorithmOids")]
[assembly: SuppressMessage("Build", "CA1819:Properties should not return arrays", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Packaging.Signing.SigningSpecifications.AllowedHashAlgorithms")]
[assembly: SuppressMessage("Build", "CA1819:Properties should not return arrays", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Packaging.Signing.SigningSpecifications.AllowedSignatureAlgorithmOids")]
[assembly: SuppressMessage("Build", "CA1819:Properties should not return arrays", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Packaging.Signing.SigningSpecifications.AllowedSignatureAlgorithms")]
[assembly: SuppressMessage("Build", "CA1819:Properties should not return arrays", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Packaging.Signing.TimestampRequest.HashedMessage")]
[assembly: SuppressMessage("Build", "CA1819:Properties should not return arrays", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Packaging.Signing.TstInfo.Nonce")]
[assembly: SuppressMessage("Build", "CA1819:Properties should not return arrays", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Packaging.Signing.TstInfo.SerialNumber")]
[assembly: SuppressMessage("Build", "CA1819:Properties should not return arrays", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Packaging.Signing.TstInfo.Tsa")]
[assembly: SuppressMessage("Build", "CA1012:Abstract type NuspecCoreReaderBase should not have constructors", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.Packaging.Core.NuspecCoreReaderBase")]
[assembly: SuppressMessage("Build", "CA2237:Add [Serializable] to PackagingException as this type implements ISerializable", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.Packaging.Core.PackagingException")]
[assembly: SuppressMessage("Build", "CA1012:Abstract type PackageReaderBase should not have constructors", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.Packaging.PackageReaderBase")]
[assembly: SuppressMessage("Build", "CA1012:Abstract type PackageVerificationResult should not have constructors", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.Packaging.Signing.PackageVerificationResult")]
[assembly: SuppressMessage("Build", "CA1067:Type NuGet.Packaging.Signing.SignatureLog should override Equals because it implements IEquatable<T>", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.Packaging.Signing.SignatureLog")]
[assembly: SuppressMessage("Build", "CA1801:Parameter token of method SignAsync is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.Packaging.Signing.SigningUtility")]
[assembly: SuppressMessage("Build", "CA1012:Abstract type VerificationAllowListEntry should not have constructors", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.Packaging.Signing.VerificationAllowListEntry")]
[assembly: SuppressMessage("Build", "CA1067:Type NuGet.RuntimeModel.RuntimeGraph.RuntimeCompatKey should override Equals because it implements IEquatable<T>", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.RuntimeModel.RuntimeGraph.RuntimeCompatKey")]
[assembly: SuppressMessage("Build", "CA1067:Type NuGet.RuntimeModel.RuntimeGraph.RuntimeDependencyKey should override Equals because it implements IEquatable<T>", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.RuntimeModel.RuntimeGraph.RuntimeDependencyKey")]
[assembly: SuppressMessage("ApiDesign", "RS0026:Do not add multiple public overloads with optional parameters", Justification = "API already shipped", Scope = "member", Target = "~M:NuGet.Packaging.PackageExtractor.ExtractPackageAsync(System.String,System.IO.Stream,NuGet.Packaging.PackagePathResolver,NuGet.Packaging.PackageExtractionContext,System.Threading.CancellationToken,System.Guid)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{System.String}}")]
[assembly: SuppressMessage("ApiDesign", "RS0026:Do not add multiple public overloads with optional parameters", Justification = "API already shipped", Scope = "member", Target = "~M:NuGet.Packaging.PackageExtractor.ExtractPackageAsync(System.String,NuGet.Packaging.PackageReaderBase,System.IO.Stream,NuGet.Packaging.PackagePathResolver,NuGet.Packaging.PackageExtractionContext,System.Threading.CancellationToken,System.Guid)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{System.String}}")]
[assembly: SuppressMessage("ApiDesign", "RS0026:Do not add multiple public overloads with optional parameters", Justification = "API already shipped", Scope = "member", Target = "~M:NuGet.Packaging.PackageExtractor.ExtractPackageAsync(System.String,NuGet.Packaging.PackageReaderBase,NuGet.Packaging.PackagePathResolver,NuGet.Packaging.PackageExtractionContext,System.Threading.CancellationToken,System.Guid)~System.Threading.Tasks.Task{System.Collections.Generic.IEnumerable{System.String}}")]
[assembly: SuppressMessage("ApiDesign", "RS0026:Do not add multiple public overloads with optional parameters", Justification = "API already shipped", Scope = "member", Target = "~M:NuGet.Packaging.PackageExtractor.InstallFromSourceAsync(System.String,NuGet.Packaging.Core.PackageIdentity,System.Func{System.IO.Stream,System.Threading.Tasks.Task},NuGet.Packaging.VersionFolderPathResolver,NuGet.Packaging.PackageExtractionContext,System.Threading.CancellationToken,System.Guid)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("ApiDesign", "RS0026:Do not add multiple public overloads with optional parameters", Justification = "API already shipped", Scope = "member", Target = "~M:NuGet.Packaging.PackageExtractor.InstallFromSourceAsync(NuGet.Packaging.Core.PackageIdentity,NuGet.Packaging.IPackageDownloader,NuGet.Packaging.VersionFolderPathResolver,NuGet.Packaging.PackageExtractionContext,System.Threading.CancellationToken,System.Guid)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("ApiDesign", "RS0027:Public API with optional parameter(s) should have the most parameters amongst its public overloads.", Justification = "API already shipped", Scope = "member", Target = "~M:NuGet.Packaging.PackageArchiveReader.#ctor(System.String,NuGet.Frameworks.IFrameworkNameProvider,NuGet.Frameworks.IFrameworkCompatibilityProvider)")]
[assembly: SuppressMessage("Reliability", "CA2000:Dispose objects before losing scope", Justification = "The method that raised the warning returns an IDisposable object that wraps local disposable object", Scope = "member", Target = "~M:NuGet.Packaging.NuGetExtractionFileIO.DotnetCoreCreateFile(System.String)~System.IO.FileStream")]
[assembly: SuppressMessage("Security", "IA5352:Do Not Misuse Cryptographic APIs ", Justification = "A self-issued certificate cannot be revoked.", Scope = "member", Target = "~M:NuGet.Packaging.Signing.CertificateUtility.IsSelfIssued(System.Security.Cryptography.X509Certificates.X509Certificate2)~System.Boolean")]
[assembly: SuppressMessage("Security", "IA5352:Do Not Misuse Cryptographic APIs ", Justification = "NuGet builds a certificate chain for a certificate potentially several times. Sometimes the goal is to simply have a complete chain ignoring trust. Ultimately NuGet does build the certificate chain again with the default of RevocationMode.Online later.", Scope = "member", Target = "~M:NuGet.Packaging.Signing.SignatureUtility.GetCertificateChain(System.Security.Cryptography.X509Certificates.X509Certificate2,System.Security.Cryptography.X509Certificates.X509Certificate2Collection,NuGet.Packaging.Signing.CertificateType,System.Boolean)~NuGet.Packaging.Signing.IX509CertificateChain")]
