// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// <auto-generated />

using System;
using System.CodeDom.Compiler;
using System.Collections.Generic;
using Microsoft.Extensions.Primitives;
using Microsoft.Net.Http.Headers;

namespace Microsoft.AspNetCore.HttpSys.Internal
{
    [GeneratedCode("TextTemplatingFileGenerator", "")]
    internal partial class RequestHeaders
    {
        // Tracks if individual fields have been read from native or set directly.
        // Once read or set, their presence in the collection is marked by if their StringValues is null or not.
        private UInt32 _flag0, _flag1;

        private StringValues _Accept;
        private StringValues _AcceptCharset;
        private StringValues _AcceptEncoding;
        private StringValues _AcceptLanguage;
        private StringValues _Allow;
        private StringValues _Authorization;
        private StringValues _CacheControl;
        private StringValues _Connection;
        private StringValues _ContentEncoding;
        private StringValues _ContentLanguage;
        private StringValues _ContentLength;
        private StringValues _ContentLocation;
        private StringValues _ContentMD5;
        private StringValues _ContentRange;
        private StringValues _ContentType;
        private StringValues _Cookie;
        private StringValues _Date;
        private StringValues _Expect;
        private StringValues _Expires;
        private StringValues _From;
        private StringValues _Host;
        private StringValues _IfMatch;
        private StringValues _IfModifiedSince;
        private StringValues _IfNoneMatch;
        private StringValues _IfRange;
        private StringValues _IfUnmodifiedSince;
        private StringValues _KeepAlive;
        private StringValues _LastModified;
        private StringValues _MaxForwards;
        private StringValues _Pragma;
        private StringValues _ProxyAuthorization;
        private StringValues _Range;
        private StringValues _Referer;
        private StringValues _TE;
        private StringValues _Trailer;
        private StringValues _TransferEncoding;
        private StringValues _Translate;
        private StringValues _Upgrade;
        private StringValues _UserAgent;
        private StringValues _Via;
        private StringValues _Warning;

        public StringValues Accept
        {
            get
            {
                if ((_flag0 & 0x1u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.Accept);
                    if (nativeValue != null)
                    {
                        _Accept = nativeValue;
                    }
                    _flag0 |= 0x1u;
                }

                if (_Accept.Count > 0)
                {
                    return _Accept;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag0 |= 0x1u;

                if (value.Count > 0)
                {
                    _Accept = value;
                }
                else
                {
                    _Accept = default;
                }
            }
        }

        public StringValues AcceptCharset
        {
            get
            {
                if ((_flag0 & 0x2u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.AcceptCharset);
                    if (nativeValue != null)
                    {
                        _AcceptCharset = nativeValue;
                    }
                    _flag0 |= 0x2u;
                }

                if (_AcceptCharset.Count > 0)
                {
                    return _AcceptCharset;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag0 |= 0x2u;

                if (value.Count > 0)
                {
                    _AcceptCharset = value;
                }
                else
                {
                    _AcceptCharset = default;
                }
            }
        }

        public StringValues AcceptEncoding
        {
            get
            {
                if ((_flag0 & 0x4u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.AcceptEncoding);
                    if (nativeValue != null)
                    {
                        _AcceptEncoding = nativeValue;
                    }
                    _flag0 |= 0x4u;
                }

                if (_AcceptEncoding.Count > 0)
                {
                    return _AcceptEncoding;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag0 |= 0x4u;

                if (value.Count > 0)
                {
                    _AcceptEncoding = value;
                }
                else
                {
                    _AcceptEncoding = default;
                }
            }
        }

        public StringValues AcceptLanguage
        {
            get
            {
                if ((_flag0 & 0x8u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.AcceptLanguage);
                    if (nativeValue != null)
                    {
                        _AcceptLanguage = nativeValue;
                    }
                    _flag0 |= 0x8u;
                }

                if (_AcceptLanguage.Count > 0)
                {
                    return _AcceptLanguage;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag0 |= 0x8u;

                if (value.Count > 0)
                {
                    _AcceptLanguage = value;
                }
                else
                {
                    _AcceptLanguage = default;
                }
            }
        }

        public StringValues Allow
        {
            get
            {
                if ((_flag0 & 0x10u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.Allow);
                    if (nativeValue != null)
                    {
                        _Allow = nativeValue;
                    }
                    _flag0 |= 0x10u;
                }

                if (_Allow.Count > 0)
                {
                    return _Allow;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag0 |= 0x10u;

                if (value.Count > 0)
                {
                    _Allow = value;
                }
                else
                {
                    _Allow = default;
                }
            }
        }

        public StringValues Authorization
        {
            get
            {
                if ((_flag0 & 0x20u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.Authorization);
                    if (nativeValue != null)
                    {
                        _Authorization = nativeValue;
                    }
                    _flag0 |= 0x20u;
                }

                if (_Authorization.Count > 0)
                {
                    return _Authorization;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag0 |= 0x20u;

                if (value.Count > 0)
                {
                    _Authorization = value;
                }
                else
                {
                    _Authorization = default;
                }
            }
        }

        public StringValues CacheControl
        {
            get
            {
                if ((_flag0 & 0x40u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.CacheControl);
                    if (nativeValue != null)
                    {
                        _CacheControl = nativeValue;
                    }
                    _flag0 |= 0x40u;
                }

                if (_CacheControl.Count > 0)
                {
                    return _CacheControl;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag0 |= 0x40u;

                if (value.Count > 0)
                {
                    _CacheControl = value;
                }
                else
                {
                    _CacheControl = default;
                }
            }
        }

        public StringValues Connection
        {
            get
            {
                if ((_flag0 & 0x80u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.Connection);
                    if (nativeValue != null)
                    {
                        _Connection = nativeValue;
                    }
                    _flag0 |= 0x80u;
                }

                if (_Connection.Count > 0)
                {
                    return _Connection;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag0 |= 0x80u;

                if (value.Count > 0)
                {
                    _Connection = value;
                }
                else
                {
                    _Connection = default;
                }
            }
        }

        public StringValues ContentEncoding
        {
            get
            {
                if ((_flag0 & 0x100u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.ContentEncoding);
                    if (nativeValue != null)
                    {
                        _ContentEncoding = nativeValue;
                    }
                    _flag0 |= 0x100u;
                }

                if (_ContentEncoding.Count > 0)
                {
                    return _ContentEncoding;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag0 |= 0x100u;

                if (value.Count > 0)
                {
                    _ContentEncoding = value;
                }
                else
                {
                    _ContentEncoding = default;
                }
            }
        }

        public StringValues ContentLanguage
        {
            get
            {
                if ((_flag0 & 0x200u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.ContentLanguage);
                    if (nativeValue != null)
                    {
                        _ContentLanguage = nativeValue;
                    }
                    _flag0 |= 0x200u;
                }

                if (_ContentLanguage.Count > 0)
                {
                    return _ContentLanguage;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag0 |= 0x200u;

                if (value.Count > 0)
                {
                    _ContentLanguage = value;
                }
                else
                {
                    _ContentLanguage = default;
                }
            }
        }

        public StringValues ContentLength
        {
            get
            {
                if ((_flag0 & 0x400u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.ContentLength);
                    if (nativeValue != null)
                    {
                        _ContentLength = nativeValue;
                    }
                    _flag0 |= 0x400u;
                }

                if (_ContentLength.Count > 0)
                {
                    return _ContentLength;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag0 |= 0x400u;

                if (value.Count > 0)
                {
                    _ContentLength = value;
                }
                else
                {
                    _ContentLength = default;
                }
            }
        }

        public StringValues ContentLocation
        {
            get
            {
                if ((_flag0 & 0x800u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.ContentLocation);
                    if (nativeValue != null)
                    {
                        _ContentLocation = nativeValue;
                    }
                    _flag0 |= 0x800u;
                }

                if (_ContentLocation.Count > 0)
                {
                    return _ContentLocation;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag0 |= 0x800u;

                if (value.Count > 0)
                {
                    _ContentLocation = value;
                }
                else
                {
                    _ContentLocation = default;
                }
            }
        }

        public StringValues ContentMD5
        {
            get
            {
                if ((_flag0 & 0x1000u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.ContentMd5);
                    if (nativeValue != null)
                    {
                        _ContentMD5 = nativeValue;
                    }
                    _flag0 |= 0x1000u;
                }

                if (_ContentMD5.Count > 0)
                {
                    return _ContentMD5;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag0 |= 0x1000u;

                if (value.Count > 0)
                {
                    _ContentMD5 = value;
                }
                else
                {
                    _ContentMD5 = default;
                }
            }
        }

        public StringValues ContentRange
        {
            get
            {
                if ((_flag0 & 0x2000u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.ContentRange);
                    if (nativeValue != null)
                    {
                        _ContentRange = nativeValue;
                    }
                    _flag0 |= 0x2000u;
                }

                if (_ContentRange.Count > 0)
                {
                    return _ContentRange;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag0 |= 0x2000u;

                if (value.Count > 0)
                {
                    _ContentRange = value;
                }
                else
                {
                    _ContentRange = default;
                }
            }
        }

        public StringValues ContentType
        {
            get
            {
                if ((_flag0 & 0x4000u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.ContentType);
                    if (nativeValue != null)
                    {
                        _ContentType = nativeValue;
                    }
                    _flag0 |= 0x4000u;
                }

                if (_ContentType.Count > 0)
                {
                    return _ContentType;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag0 |= 0x4000u;

                if (value.Count > 0)
                {
                    _ContentType = value;
                }
                else
                {
                    _ContentType = default;
                }
            }
        }

        public StringValues Cookie
        {
            get
            {
                if ((_flag0 & 0x8000u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.Cookie);
                    if (nativeValue != null)
                    {
                        _Cookie = nativeValue;
                    }
                    _flag0 |= 0x8000u;
                }

                if (_Cookie.Count > 0)
                {
                    return _Cookie;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag0 |= 0x8000u;

                if (value.Count > 0)
                {
                    _Cookie = value;
                }
                else
                {
                    _Cookie = default;
                }
            }
        }

        public StringValues Date
        {
            get
            {
                if ((_flag0 & 0x10000u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.Date);
                    if (nativeValue != null)
                    {
                        _Date = nativeValue;
                    }
                    _flag0 |= 0x10000u;
                }

                if (_Date.Count > 0)
                {
                    return _Date;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag0 |= 0x10000u;

                if (value.Count > 0)
                {
                    _Date = value;
                }
                else
                {
                    _Date = default;
                }
            }
        }

        public StringValues Expect
        {
            get
            {
                if ((_flag0 & 0x20000u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.Expect);
                    if (nativeValue != null)
                    {
                        _Expect = nativeValue;
                    }
                    _flag0 |= 0x20000u;
                }

                if (_Expect.Count > 0)
                {
                    return _Expect;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag0 |= 0x20000u;

                if (value.Count > 0)
                {
                    _Expect = value;
                }
                else
                {
                    _Expect = default;
                }
            }
        }

        public StringValues Expires
        {
            get
            {
                if ((_flag0 & 0x40000u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.Expires);
                    if (nativeValue != null)
                    {
                        _Expires = nativeValue;
                    }
                    _flag0 |= 0x40000u;
                }

                if (_Expires.Count > 0)
                {
                    return _Expires;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag0 |= 0x40000u;

                if (value.Count > 0)
                {
                    _Expires = value;
                }
                else
                {
                    _Expires = default;
                }
            }
        }

        public StringValues From
        {
            get
            {
                if ((_flag0 & 0x80000u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.From);
                    if (nativeValue != null)
                    {
                        _From = nativeValue;
                    }
                    _flag0 |= 0x80000u;
                }

                if (_From.Count > 0)
                {
                    return _From;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag0 |= 0x80000u;

                if (value.Count > 0)
                {
                    _From = value;
                }
                else
                {
                    _From = default;
                }
            }
        }

        public StringValues Host
        {
            get
            {
                if ((_flag0 & 0x100000u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.Host);
                    if (nativeValue != null)
                    {
                        _Host = nativeValue;
                    }
                    _flag0 |= 0x100000u;
                }

                if (_Host.Count > 0)
                {
                    return _Host;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag0 |= 0x100000u;

                if (value.Count > 0)
                {
                    _Host = value;
                }
                else
                {
                    _Host = default;
                }
            }
        }

        public StringValues IfMatch
        {
            get
            {
                if ((_flag0 & 0x200000u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.IfMatch);
                    if (nativeValue != null)
                    {
                        _IfMatch = nativeValue;
                    }
                    _flag0 |= 0x200000u;
                }

                if (_IfMatch.Count > 0)
                {
                    return _IfMatch;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag0 |= 0x200000u;

                if (value.Count > 0)
                {
                    _IfMatch = value;
                }
                else
                {
                    _IfMatch = default;
                }
            }
        }

        public StringValues IfModifiedSince
        {
            get
            {
                if ((_flag0 & 0x400000u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.IfModifiedSince);
                    if (nativeValue != null)
                    {
                        _IfModifiedSince = nativeValue;
                    }
                    _flag0 |= 0x400000u;
                }

                if (_IfModifiedSince.Count > 0)
                {
                    return _IfModifiedSince;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag0 |= 0x400000u;

                if (value.Count > 0)
                {
                    _IfModifiedSince = value;
                }
                else
                {
                    _IfModifiedSince = default;
                }
            }
        }

        public StringValues IfNoneMatch
        {
            get
            {
                if ((_flag0 & 0x800000u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.IfNoneMatch);
                    if (nativeValue != null)
                    {
                        _IfNoneMatch = nativeValue;
                    }
                    _flag0 |= 0x800000u;
                }

                if (_IfNoneMatch.Count > 0)
                {
                    return _IfNoneMatch;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag0 |= 0x800000u;

                if (value.Count > 0)
                {
                    _IfNoneMatch = value;
                }
                else
                {
                    _IfNoneMatch = default;
                }
            }
        }

        public StringValues IfRange
        {
            get
            {
                if ((_flag0 & 0x1000000u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.IfRange);
                    if (nativeValue != null)
                    {
                        _IfRange = nativeValue;
                    }
                    _flag0 |= 0x1000000u;
                }

                if (_IfRange.Count > 0)
                {
                    return _IfRange;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag0 |= 0x1000000u;

                if (value.Count > 0)
                {
                    _IfRange = value;
                }
                else
                {
                    _IfRange = default;
                }
            }
        }

        public StringValues IfUnmodifiedSince
        {
            get
            {
                if ((_flag0 & 0x2000000u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.IfUnmodifiedSince);
                    if (nativeValue != null)
                    {
                        _IfUnmodifiedSince = nativeValue;
                    }
                    _flag0 |= 0x2000000u;
                }

                if (_IfUnmodifiedSince.Count > 0)
                {
                    return _IfUnmodifiedSince;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag0 |= 0x2000000u;

                if (value.Count > 0)
                {
                    _IfUnmodifiedSince = value;
                }
                else
                {
                    _IfUnmodifiedSince = default;
                }
            }
        }

        public StringValues KeepAlive
        {
            get
            {
                if ((_flag0 & 0x4000000u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.KeepAlive);
                    if (nativeValue != null)
                    {
                        _KeepAlive = nativeValue;
                    }
                    _flag0 |= 0x4000000u;
                }

                if (_KeepAlive.Count > 0)
                {
                    return _KeepAlive;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag0 |= 0x4000000u;

                if (value.Count > 0)
                {
                    _KeepAlive = value;
                }
                else
                {
                    _KeepAlive = default;
                }
            }
        }

        public StringValues LastModified
        {
            get
            {
                if ((_flag0 & 0x8000000u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.LastModified);
                    if (nativeValue != null)
                    {
                        _LastModified = nativeValue;
                    }
                    _flag0 |= 0x8000000u;
                }

                if (_LastModified.Count > 0)
                {
                    return _LastModified;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag0 |= 0x8000000u;

                if (value.Count > 0)
                {
                    _LastModified = value;
                }
                else
                {
                    _LastModified = default;
                }
            }
        }

        public StringValues MaxForwards
        {
            get
            {
                if ((_flag0 & 0x10000000u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.MaxForwards);
                    if (nativeValue != null)
                    {
                        _MaxForwards = nativeValue;
                    }
                    _flag0 |= 0x10000000u;
                }

                if (_MaxForwards.Count > 0)
                {
                    return _MaxForwards;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag0 |= 0x10000000u;

                if (value.Count > 0)
                {
                    _MaxForwards = value;
                }
                else
                {
                    _MaxForwards = default;
                }
            }
        }

        public StringValues Pragma
        {
            get
            {
                if ((_flag0 & 0x20000000u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.Pragma);
                    if (nativeValue != null)
                    {
                        _Pragma = nativeValue;
                    }
                    _flag0 |= 0x20000000u;
                }

                if (_Pragma.Count > 0)
                {
                    return _Pragma;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag0 |= 0x20000000u;

                if (value.Count > 0)
                {
                    _Pragma = value;
                }
                else
                {
                    _Pragma = default;
                }
            }
        }

        public StringValues ProxyAuthorization
        {
            get
            {
                if ((_flag0 & 0x40000000u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.ProxyAuthorization);
                    if (nativeValue != null)
                    {
                        _ProxyAuthorization = nativeValue;
                    }
                    _flag0 |= 0x40000000u;
                }

                if (_ProxyAuthorization.Count > 0)
                {
                    return _ProxyAuthorization;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag0 |= 0x40000000u;

                if (value.Count > 0)
                {
                    _ProxyAuthorization = value;
                }
                else
                {
                    _ProxyAuthorization = default;
                }
            }
        }

        public StringValues Range
        {
            get
            {
                if ((_flag0 & 0x80000000u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.Range);
                    if (nativeValue != null)
                    {
                        _Range = nativeValue;
                    }
                    _flag0 |= 0x80000000u;
                }

                if (_Range.Count > 0)
                {
                    return _Range;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag0 |= 0x80000000u;

                if (value.Count > 0)
                {
                    _Range = value;
                }
                else
                {
                    _Range = default;
                }
            }
        }

        public StringValues Referer
        {
            get
            {
                if ((_flag1 & 0x1u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.Referer);
                    if (nativeValue != null)
                    {
                        _Referer = nativeValue;
                    }
                    _flag1 |= 0x1u;
                }

                if (_Referer.Count > 0)
                {
                    return _Referer;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag1 |= 0x1u;

                if (value.Count > 0)
                {
                    _Referer = value;
                }
                else
                {
                    _Referer = default;
                }
            }
        }

        public StringValues TE
        {
            get
            {
                if ((_flag1 & 0x2u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.Te);
                    if (nativeValue != null)
                    {
                        _TE = nativeValue;
                    }
                    _flag1 |= 0x2u;
                }

                if (_TE.Count > 0)
                {
                    return _TE;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag1 |= 0x2u;

                if (value.Count > 0)
                {
                    _TE = value;
                }
                else
                {
                    _TE = default;
                }
            }
        }

        public StringValues Trailer
        {
            get
            {
                if ((_flag1 & 0x4u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.Trailer);
                    if (nativeValue != null)
                    {
                        _Trailer = nativeValue;
                    }
                    _flag1 |= 0x4u;
                }

                if (_Trailer.Count > 0)
                {
                    return _Trailer;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag1 |= 0x4u;

                if (value.Count > 0)
                {
                    _Trailer = value;
                }
                else
                {
                    _Trailer = default;
                }
            }
        }

        public StringValues TransferEncoding
        {
            get
            {
                if ((_flag1 & 0x8u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.TransferEncoding);
                    if (nativeValue != null)
                    {
                        _TransferEncoding = nativeValue;
                    }
                    _flag1 |= 0x8u;
                }

                if (_TransferEncoding.Count > 0)
                {
                    return _TransferEncoding;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag1 |= 0x8u;

                if (value.Count > 0)
                {
                    _TransferEncoding = value;
                }
                else
                {
                    _TransferEncoding = default;
                }
            }
        }

        public StringValues Translate
        {
            get
            {
                if ((_flag1 & 0x10u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.Translate);
                    if (nativeValue != null)
                    {
                        _Translate = nativeValue;
                    }
                    _flag1 |= 0x10u;
                }

                if (_Translate.Count > 0)
                {
                    return _Translate;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag1 |= 0x10u;

                if (value.Count > 0)
                {
                    _Translate = value;
                }
                else
                {
                    _Translate = default;
                }
            }
        }

        public StringValues Upgrade
        {
            get
            {
                if ((_flag1 & 0x20u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.Upgrade);
                    if (nativeValue != null)
                    {
                        _Upgrade = nativeValue;
                    }
                    _flag1 |= 0x20u;
                }

                if (_Upgrade.Count > 0)
                {
                    return _Upgrade;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag1 |= 0x20u;

                if (value.Count > 0)
                {
                    _Upgrade = value;
                }
                else
                {
                    _Upgrade = default;
                }
            }
        }

        public StringValues UserAgent
        {
            get
            {
                if ((_flag1 & 0x40u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.UserAgent);
                    if (nativeValue != null)
                    {
                        _UserAgent = nativeValue;
                    }
                    _flag1 |= 0x40u;
                }

                if (_UserAgent.Count > 0)
                {
                    return _UserAgent;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag1 |= 0x40u;

                if (value.Count > 0)
                {
                    _UserAgent = value;
                }
                else
                {
                    _UserAgent = default;
                }
            }
        }

        public StringValues Via
        {
            get
            {
                if ((_flag1 & 0x80u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.Via);
                    if (nativeValue != null)
                    {
                        _Via = nativeValue;
                    }
                    _flag1 |= 0x80u;
                }

                if (_Via.Count > 0)
                {
                    return _Via;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag1 |= 0x80u;

                if (value.Count > 0)
                {
                    _Via = value;
                }
                else
                {
                    _Via = default;
                }
            }
        }

        public StringValues Warning
        {
            get
            {
                if ((_flag1 & 0x100u) == 0)
                {
                    string nativeValue = GetKnownHeader(HttpSysRequestHeader.Warning);
                    if (nativeValue != null)
                    {
                        _Warning = nativeValue;
                    }
                    _flag1 |= 0x100u;
                }

                if (_Warning.Count > 0)
                {
                    return _Warning;
                }
                return StringValues.Empty;
            }
            set
            {
                _flag1 |= 0x100u;

                if (value.Count > 0)
                {
                    _Warning = value;
                }
                else
                {
                    _Warning = default;
                }
            }
        }

        private bool PropertiesContainsKey(string key)
        {
            switch (key.Length)
            {
                case 2:
                    if (string.Equals(key, HeaderNames.TE, StringComparison.OrdinalIgnoreCase))
                    {
                        return TE.Count > 0;
                    }
                    break;
                case 3:
                    if (string.Equals(key, HeaderNames.Via, StringComparison.OrdinalIgnoreCase))
                    {
                        return Via.Count > 0;
                    }
                    break;
                case 4:
                    if (string.Equals(key, HeaderNames.Date, StringComparison.OrdinalIgnoreCase))
                    {
                        return Date.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.From, StringComparison.OrdinalIgnoreCase))
                    {
                        return From.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.Host, StringComparison.OrdinalIgnoreCase))
                    {
                        return Host.Count > 0;
                    }
                    break;
                case 5:
                    if (string.Equals(key, HeaderNames.Allow, StringComparison.OrdinalIgnoreCase))
                    {
                        return Allow.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.Range, StringComparison.OrdinalIgnoreCase))
                    {
                        return Range.Count > 0;
                    }
                    break;
                case 6:
                    if (string.Equals(key, HeaderNames.Accept, StringComparison.OrdinalIgnoreCase))
                    {
                        return Accept.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.Cookie, StringComparison.OrdinalIgnoreCase))
                    {
                        return Cookie.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.Expect, StringComparison.OrdinalIgnoreCase))
                    {
                        return Expect.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.Pragma, StringComparison.OrdinalIgnoreCase))
                    {
                        return Pragma.Count > 0;
                    }
                    break;
                case 7:
                    if (string.Equals(key, HeaderNames.Expires, StringComparison.OrdinalIgnoreCase))
                    {
                        return Expires.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.Referer, StringComparison.OrdinalIgnoreCase))
                    {
                        return Referer.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.Trailer, StringComparison.OrdinalIgnoreCase))
                    {
                        return Trailer.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.Upgrade, StringComparison.OrdinalIgnoreCase))
                    {
                        return Upgrade.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.Warning, StringComparison.OrdinalIgnoreCase))
                    {
                        return Warning.Count > 0;
                    }
                    break;
                case 8:
                    if (string.Equals(key, HeaderNames.IfMatch, StringComparison.OrdinalIgnoreCase))
                    {
                        return IfMatch.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.IfRange, StringComparison.OrdinalIgnoreCase))
                    {
                        return IfRange.Count > 0;
                    }
                    break;
                case 9:
                    if (string.Equals(key, HeaderNames.Translate, StringComparison.OrdinalIgnoreCase))
                    {
                        return Translate.Count > 0;
                    }
                    break;
                case 10:
                    if (string.Equals(key, HeaderNames.Connection, StringComparison.OrdinalIgnoreCase))
                    {
                        return Connection.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.KeepAlive, StringComparison.OrdinalIgnoreCase))
                    {
                        return KeepAlive.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.UserAgent, StringComparison.OrdinalIgnoreCase))
                    {
                        return UserAgent.Count > 0;
                    }
                    break;
                case 11:
                    if (string.Equals(key, HeaderNames.ContentMD5, StringComparison.OrdinalIgnoreCase))
                    {
                        return ContentMD5.Count > 0;
                    }
                    break;
                case 12:
                    if (string.Equals(key, HeaderNames.ContentType, StringComparison.OrdinalIgnoreCase))
                    {
                        return ContentType.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.MaxForwards, StringComparison.OrdinalIgnoreCase))
                    {
                        return MaxForwards.Count > 0;
                    }
                    break;
                case 13:
                    if (string.Equals(key, HeaderNames.Authorization, StringComparison.OrdinalIgnoreCase))
                    {
                        return Authorization.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.CacheControl, StringComparison.OrdinalIgnoreCase))
                    {
                        return CacheControl.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.ContentRange, StringComparison.OrdinalIgnoreCase))
                    {
                        return ContentRange.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.IfNoneMatch, StringComparison.OrdinalIgnoreCase))
                    {
                        return IfNoneMatch.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.LastModified, StringComparison.OrdinalIgnoreCase))
                    {
                        return LastModified.Count > 0;
                    }
                    break;
                case 14:
                    if (string.Equals(key, HeaderNames.AcceptCharset, StringComparison.OrdinalIgnoreCase))
                    {
                        return AcceptCharset.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.ContentLength, StringComparison.OrdinalIgnoreCase))
                    {
                        return ContentLength.Count > 0;
                    }
                    break;
                case 15:
                    if (string.Equals(key, HeaderNames.AcceptEncoding, StringComparison.OrdinalIgnoreCase))
                    {
                        return AcceptEncoding.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.AcceptLanguage, StringComparison.OrdinalIgnoreCase))
                    {
                        return AcceptLanguage.Count > 0;
                    }
                    break;
                case 16:
                    if (string.Equals(key, HeaderNames.ContentEncoding, StringComparison.OrdinalIgnoreCase))
                    {
                        return ContentEncoding.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.ContentLanguage, StringComparison.OrdinalIgnoreCase))
                    {
                        return ContentLanguage.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.ContentLocation, StringComparison.OrdinalIgnoreCase))
                    {
                        return ContentLocation.Count > 0;
                    }
                    break;
                case 17:
                    if (string.Equals(key, HeaderNames.IfModifiedSince, StringComparison.OrdinalIgnoreCase))
                    {
                        return IfModifiedSince.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.TransferEncoding, StringComparison.OrdinalIgnoreCase))
                    {
                        return TransferEncoding.Count > 0;
                    }
                    break;
                case 19:
                    if (string.Equals(key, HeaderNames.IfUnmodifiedSince, StringComparison.OrdinalIgnoreCase))
                    {
                        return IfUnmodifiedSince.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.ProxyAuthorization, StringComparison.OrdinalIgnoreCase))
                    {
                        return ProxyAuthorization.Count > 0;
                    }
                    break;
            }
            return false;
        }

        private bool PropertiesTryGetValue(string key, out StringValues value)
        {
            switch (key.Length)
            {
                case 2:
                    if (string.Equals(key, HeaderNames.TE, StringComparison.OrdinalIgnoreCase))
                    {
                        value = TE;
                        return value.Count > 0;
                    }
                    break;
                case 3:
                    if (string.Equals(key, HeaderNames.Via, StringComparison.OrdinalIgnoreCase))
                    {
                        value = Via;
                        return value.Count > 0;
                    }
                    break;
                case 4:
                    if (string.Equals(key, HeaderNames.Date, StringComparison.OrdinalIgnoreCase))
                    {
                        value = Date;
                        return value.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.From, StringComparison.OrdinalIgnoreCase))
                    {
                        value = From;
                        return value.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.Host, StringComparison.OrdinalIgnoreCase))
                    {
                        value = Host;
                        return value.Count > 0;
                    }
                    break;
                case 5:
                    if (string.Equals(key, HeaderNames.Allow, StringComparison.OrdinalIgnoreCase))
                    {
                        value = Allow;
                        return value.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.Range, StringComparison.OrdinalIgnoreCase))
                    {
                        value = Range;
                        return value.Count > 0;
                    }
                    break;
                case 6:
                    if (string.Equals(key, HeaderNames.Accept, StringComparison.OrdinalIgnoreCase))
                    {
                        value = Accept;
                        return value.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.Cookie, StringComparison.OrdinalIgnoreCase))
                    {
                        value = Cookie;
                        return value.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.Expect, StringComparison.OrdinalIgnoreCase))
                    {
                        value = Expect;
                        return value.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.Pragma, StringComparison.OrdinalIgnoreCase))
                    {
                        value = Pragma;
                        return value.Count > 0;
                    }
                    break;
                case 7:
                    if (string.Equals(key, HeaderNames.Expires, StringComparison.OrdinalIgnoreCase))
                    {
                        value = Expires;
                        return value.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.Referer, StringComparison.OrdinalIgnoreCase))
                    {
                        value = Referer;
                        return value.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.Trailer, StringComparison.OrdinalIgnoreCase))
                    {
                        value = Trailer;
                        return value.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.Upgrade, StringComparison.OrdinalIgnoreCase))
                    {
                        value = Upgrade;
                        return value.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.Warning, StringComparison.OrdinalIgnoreCase))
                    {
                        value = Warning;
                        return value.Count > 0;
                    }
                    break;
                case 8:
                    if (string.Equals(key, HeaderNames.IfMatch, StringComparison.OrdinalIgnoreCase))
                    {
                        value = IfMatch;
                        return value.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.IfRange, StringComparison.OrdinalIgnoreCase))
                    {
                        value = IfRange;
                        return value.Count > 0;
                    }
                    break;
                case 9:
                    if (string.Equals(key, HeaderNames.Translate, StringComparison.OrdinalIgnoreCase))
                    {
                        value = Translate;
                        return value.Count > 0;
                    }
                    break;
                case 10:
                    if (string.Equals(key, HeaderNames.Connection, StringComparison.OrdinalIgnoreCase))
                    {
                        value = Connection;
                        return value.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.KeepAlive, StringComparison.OrdinalIgnoreCase))
                    {
                        value = KeepAlive;
                        return value.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.UserAgent, StringComparison.OrdinalIgnoreCase))
                    {
                        value = UserAgent;
                        return value.Count > 0;
                    }
                    break;
                case 11:
                    if (string.Equals(key, HeaderNames.ContentMD5, StringComparison.OrdinalIgnoreCase))
                    {
                        value = ContentMD5;
                        return value.Count > 0;
                    }
                    break;
                case 12:
                    if (string.Equals(key, HeaderNames.ContentType, StringComparison.OrdinalIgnoreCase))
                    {
                        value = ContentType;
                        return value.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.MaxForwards, StringComparison.OrdinalIgnoreCase))
                    {
                        value = MaxForwards;
                        return value.Count > 0;
                    }
                    break;
                case 13:
                    if (string.Equals(key, HeaderNames.Authorization, StringComparison.OrdinalIgnoreCase))
                    {
                        value = Authorization;
                        return value.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.CacheControl, StringComparison.OrdinalIgnoreCase))
                    {
                        value = CacheControl;
                        return value.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.ContentRange, StringComparison.OrdinalIgnoreCase))
                    {
                        value = ContentRange;
                        return value.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.IfNoneMatch, StringComparison.OrdinalIgnoreCase))
                    {
                        value = IfNoneMatch;
                        return value.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.LastModified, StringComparison.OrdinalIgnoreCase))
                    {
                        value = LastModified;
                        return value.Count > 0;
                    }
                    break;
                case 14:
                    if (string.Equals(key, HeaderNames.AcceptCharset, StringComparison.OrdinalIgnoreCase))
                    {
                        value = AcceptCharset;
                        return value.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.ContentLength, StringComparison.OrdinalIgnoreCase))
                    {
                        value = ContentLength;
                        return value.Count > 0;
                    }
                    break;
                case 15:
                    if (string.Equals(key, HeaderNames.AcceptEncoding, StringComparison.OrdinalIgnoreCase))
                    {
                        value = AcceptEncoding;
                        return value.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.AcceptLanguage, StringComparison.OrdinalIgnoreCase))
                    {
                        value = AcceptLanguage;
                        return value.Count > 0;
                    }
                    break;
                case 16:
                    if (string.Equals(key, HeaderNames.ContentEncoding, StringComparison.OrdinalIgnoreCase))
                    {
                        value = ContentEncoding;
                        return value.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.ContentLanguage, StringComparison.OrdinalIgnoreCase))
                    {
                        value = ContentLanguage;
                        return value.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.ContentLocation, StringComparison.OrdinalIgnoreCase))
                    {
                        value = ContentLocation;
                        return value.Count > 0;
                    }
                    break;
                case 17:
                    if (string.Equals(key, HeaderNames.IfModifiedSince, StringComparison.OrdinalIgnoreCase))
                    {
                        value = IfModifiedSince;
                        return value.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.TransferEncoding, StringComparison.OrdinalIgnoreCase))
                    {
                        value = TransferEncoding;
                        return value.Count > 0;
                    }
                    break;
                case 19:
                    if (string.Equals(key, HeaderNames.IfUnmodifiedSince, StringComparison.OrdinalIgnoreCase))
                    {
                        value = IfUnmodifiedSince;
                        return value.Count > 0;
                    }
                    if (string.Equals(key, HeaderNames.ProxyAuthorization, StringComparison.OrdinalIgnoreCase))
                    {
                        value = ProxyAuthorization;
                        return value.Count > 0;
                    }
                    break;
            }
            value = default;
            return false;
        }

        private bool PropertiesTrySetValue(string key, StringValues value)
        {
            switch (key.Length)
            {
                case 2:
                    if (string.Equals(key, HeaderNames.TE, StringComparison.OrdinalIgnoreCase))
                    {
                        TE = value;
                        return true;
                    }
                    break;
                case 3:
                    if (string.Equals(key, HeaderNames.Via, StringComparison.OrdinalIgnoreCase))
                    {
                        Via = value;
                        return true;
                    }
                    break;
                case 4:
                    if (string.Equals(key, HeaderNames.Date, StringComparison.OrdinalIgnoreCase))
                    {
                        Date = value;
                        return true;
                    }
                    if (string.Equals(key, HeaderNames.From, StringComparison.OrdinalIgnoreCase))
                    {
                        From = value;
                        return true;
                    }
                    if (string.Equals(key, HeaderNames.Host, StringComparison.OrdinalIgnoreCase))
                    {
                        Host = value;
                        return true;
                    }
                    break;
                case 5:
                    if (string.Equals(key, HeaderNames.Allow, StringComparison.OrdinalIgnoreCase))
                    {
                        Allow = value;
                        return true;
                    }
                    if (string.Equals(key, HeaderNames.Range, StringComparison.OrdinalIgnoreCase))
                    {
                        Range = value;
                        return true;
                    }
                    break;
                case 6:
                    if (string.Equals(key, HeaderNames.Accept, StringComparison.OrdinalIgnoreCase))
                    {
                        Accept = value;
                        return true;
                    }
                    if (string.Equals(key, HeaderNames.Cookie, StringComparison.OrdinalIgnoreCase))
                    {
                        Cookie = value;
                        return true;
                    }
                    if (string.Equals(key, HeaderNames.Expect, StringComparison.OrdinalIgnoreCase))
                    {
                        Expect = value;
                        return true;
                    }
                    if (string.Equals(key, HeaderNames.Pragma, StringComparison.OrdinalIgnoreCase))
                    {
                        Pragma = value;
                        return true;
                    }
                    break;
                case 7:
                    if (string.Equals(key, HeaderNames.Expires, StringComparison.OrdinalIgnoreCase))
                    {
                        Expires = value;
                        return true;
                    }
                    if (string.Equals(key, HeaderNames.Referer, StringComparison.OrdinalIgnoreCase))
                    {
                        Referer = value;
                        return true;
                    }
                    if (string.Equals(key, HeaderNames.Trailer, StringComparison.OrdinalIgnoreCase))
                    {
                        Trailer = value;
                        return true;
                    }
                    if (string.Equals(key, HeaderNames.Upgrade, StringComparison.OrdinalIgnoreCase))
                    {
                        Upgrade = value;
                        return true;
                    }
                    if (string.Equals(key, HeaderNames.Warning, StringComparison.OrdinalIgnoreCase))
                    {
                        Warning = value;
                        return true;
                    }
                    break;
                case 8:
                    if (string.Equals(key, HeaderNames.IfMatch, StringComparison.OrdinalIgnoreCase))
                    {
                        IfMatch = value;
                        return true;
                    }
                    if (string.Equals(key, HeaderNames.IfRange, StringComparison.OrdinalIgnoreCase))
                    {
                        IfRange = value;
                        return true;
                    }
                    break;
                case 9:
                    if (string.Equals(key, HeaderNames.Translate, StringComparison.OrdinalIgnoreCase))
                    {
                        Translate = value;
                        return true;
                    }
                    break;
                case 10:
                    if (string.Equals(key, HeaderNames.Connection, StringComparison.OrdinalIgnoreCase))
                    {
                        Connection = value;
                        return true;
                    }
                    if (string.Equals(key, HeaderNames.KeepAlive, StringComparison.OrdinalIgnoreCase))
                    {
                        KeepAlive = value;
                        return true;
                    }
                    if (string.Equals(key, HeaderNames.UserAgent, StringComparison.OrdinalIgnoreCase))
                    {
                        UserAgent = value;
                        return true;
                    }
                    break;
                case 11:
                    if (string.Equals(key, HeaderNames.ContentMD5, StringComparison.OrdinalIgnoreCase))
                    {
                        ContentMD5 = value;
                        return true;
                    }
                    break;
                case 12:
                    if (string.Equals(key, HeaderNames.ContentType, StringComparison.OrdinalIgnoreCase))
                    {
                        ContentType = value;
                        return true;
                    }
                    if (string.Equals(key, HeaderNames.MaxForwards, StringComparison.OrdinalIgnoreCase))
                    {
                        MaxForwards = value;
                        return true;
                    }
                    break;
                case 13:
                    if (string.Equals(key, HeaderNames.Authorization, StringComparison.OrdinalIgnoreCase))
                    {
                        Authorization = value;
                        return true;
                    }
                    if (string.Equals(key, HeaderNames.CacheControl, StringComparison.OrdinalIgnoreCase))
                    {
                        CacheControl = value;
                        return true;
                    }
                    if (string.Equals(key, HeaderNames.ContentRange, StringComparison.OrdinalIgnoreCase))
                    {
                        ContentRange = value;
                        return true;
                    }
                    if (string.Equals(key, HeaderNames.IfNoneMatch, StringComparison.OrdinalIgnoreCase))
                    {
                        IfNoneMatch = value;
                        return true;
                    }
                    if (string.Equals(key, HeaderNames.LastModified, StringComparison.OrdinalIgnoreCase))
                    {
                        LastModified = value;
                        return true;
                    }
                    break;
                case 14:
                    if (string.Equals(key, HeaderNames.AcceptCharset, StringComparison.OrdinalIgnoreCase))
                    {
                        AcceptCharset = value;
                        return true;
                    }
                    if (string.Equals(key, HeaderNames.ContentLength, StringComparison.OrdinalIgnoreCase))
                    {
                        ContentLength = value;
                        return true;
                    }
                    break;
                case 15:
                    if (string.Equals(key, HeaderNames.AcceptEncoding, StringComparison.OrdinalIgnoreCase))
                    {
                        AcceptEncoding = value;
                        return true;
                    }
                    if (string.Equals(key, HeaderNames.AcceptLanguage, StringComparison.OrdinalIgnoreCase))
                    {
                        AcceptLanguage = value;
                        return true;
                    }
                    break;
                case 16:
                    if (string.Equals(key, HeaderNames.ContentEncoding, StringComparison.OrdinalIgnoreCase))
                    {
                        ContentEncoding = value;
                        return true;
                    }
                    if (string.Equals(key, HeaderNames.ContentLanguage, StringComparison.OrdinalIgnoreCase))
                    {
                        ContentLanguage = value;
                        return true;
                    }
                    if (string.Equals(key, HeaderNames.ContentLocation, StringComparison.OrdinalIgnoreCase))
                    {
                        ContentLocation = value;
                        return true;
                    }
                    break;
                case 17:
                    if (string.Equals(key, HeaderNames.IfModifiedSince, StringComparison.OrdinalIgnoreCase))
                    {
                        IfModifiedSince = value;
                        return true;
                    }
                    if (string.Equals(key, HeaderNames.TransferEncoding, StringComparison.OrdinalIgnoreCase))
                    {
                        TransferEncoding = value;
                        return true;
                    }
                    break;
                case 19:
                    if (string.Equals(key, HeaderNames.IfUnmodifiedSince, StringComparison.OrdinalIgnoreCase))
                    {
                        IfUnmodifiedSince = value;
                        return true;
                    }
                    if (string.Equals(key, HeaderNames.ProxyAuthorization, StringComparison.OrdinalIgnoreCase))
                    {
                        ProxyAuthorization = value;
                        return true;
                    }
                    break;
            }
            return false;
        }

        private bool PropertiesTryRemove(string key)
        {
            switch (key.Length)
            {
                case 2:
                    if (string.Equals(key, HeaderNames.TE, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.Te))
                        {
                            TE = default;
                            return true;
                        }
                        return false;
                    }

                    break;
                case 3:
                    if (string.Equals(key, HeaderNames.Via, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.Via))
                        {
                            Via = default;
                            return true;
                        }
                        return false;
                    }

                    break;
                case 4:
                    if (string.Equals(key, HeaderNames.Date, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.Date))
                        {
                            Date = default;
                            return true;
                        }
                        return false;
                    }

                    if (string.Equals(key, HeaderNames.From, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.From))
                        {
                            From = default;
                            return true;
                        }
                        return false;
                    }

                    if (string.Equals(key, HeaderNames.Host, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.Host))
                        {
                            Host = default;
                            return true;
                        }
                        return false;
                    }

                    break;
                case 5:
                    if (string.Equals(key, HeaderNames.Allow, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.Allow))
                        {
                            Allow = default;
                            return true;
                        }
                        return false;
                    }

                    if (string.Equals(key, HeaderNames.Range, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.Range))
                        {
                            Range = default;
                            return true;
                        }
                        return false;
                    }

                    break;
                case 6:
                    if (string.Equals(key, HeaderNames.Accept, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.Accept))
                        {
                            Accept = default;
                            return true;
                        }
                        return false;
                    }

                    if (string.Equals(key, HeaderNames.Cookie, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.Cookie))
                        {
                            Cookie = default;
                            return true;
                        }
                        return false;
                    }

                    if (string.Equals(key, HeaderNames.Expect, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.Expect))
                        {
                            Expect = default;
                            return true;
                        }
                        return false;
                    }

                    if (string.Equals(key, HeaderNames.Pragma, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.Pragma))
                        {
                            Pragma = default;
                            return true;
                        }
                        return false;
                    }

                    break;
                case 7:
                    if (string.Equals(key, HeaderNames.Expires, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.Expires))
                        {
                            Expires = default;
                            return true;
                        }
                        return false;
                    }

                    if (string.Equals(key, HeaderNames.Referer, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.Referer))
                        {
                            Referer = default;
                            return true;
                        }
                        return false;
                    }

                    if (string.Equals(key, HeaderNames.Trailer, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.Trailer))
                        {
                            Trailer = default;
                            return true;
                        }
                        return false;
                    }

                    if (string.Equals(key, HeaderNames.Upgrade, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.Upgrade))
                        {
                            Upgrade = default;
                            return true;
                        }
                        return false;
                    }

                    if (string.Equals(key, HeaderNames.Warning, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.Warning))
                        {
                            Warning = default;
                            return true;
                        }
                        return false;
                    }

                    break;
                case 8:
                    if (string.Equals(key, HeaderNames.IfMatch, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.IfMatch))
                        {
                            IfMatch = default;
                            return true;
                        }
                        return false;
                    }

                    if (string.Equals(key, HeaderNames.IfRange, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.IfRange))
                        {
                            IfRange = default;
                            return true;
                        }
                        return false;
                    }

                    break;
                case 9:
                    if (string.Equals(key, HeaderNames.Translate, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.Translate))
                        {
                            Translate = default;
                            return true;
                        }
                        return false;
                    }

                    break;
                case 10:
                    if (string.Equals(key, HeaderNames.Connection, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.Connection))
                        {
                            Connection = default;
                            return true;
                        }
                        return false;
                    }

                    if (string.Equals(key, HeaderNames.KeepAlive, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.KeepAlive))
                        {
                            KeepAlive = default;
                            return true;
                        }
                        return false;
                    }

                    if (string.Equals(key, HeaderNames.UserAgent, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.UserAgent))
                        {
                            UserAgent = default;
                            return true;
                        }
                        return false;
                    }

                    break;
                case 11:
                    if (string.Equals(key, HeaderNames.ContentMD5, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.ContentMd5))
                        {
                            ContentMD5 = default;
                            return true;
                        }
                        return false;
                    }

                    break;
                case 12:
                    if (string.Equals(key, HeaderNames.ContentType, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.ContentType))
                        {
                            ContentType = default;
                            return true;
                        }
                        return false;
                    }

                    if (string.Equals(key, HeaderNames.MaxForwards, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.MaxForwards))
                        {
                            MaxForwards = default;
                            return true;
                        }
                        return false;
                    }

                    break;
                case 13:
                    if (string.Equals(key, HeaderNames.Authorization, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.Authorization))
                        {
                            Authorization = default;
                            return true;
                        }
                        return false;
                    }

                    if (string.Equals(key, HeaderNames.CacheControl, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.CacheControl))
                        {
                            CacheControl = default;
                            return true;
                        }
                        return false;
                    }

                    if (string.Equals(key, HeaderNames.ContentRange, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.ContentRange))
                        {
                            ContentRange = default;
                            return true;
                        }
                        return false;
                    }

                    if (string.Equals(key, HeaderNames.IfNoneMatch, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.IfNoneMatch))
                        {
                            IfNoneMatch = default;
                            return true;
                        }
                        return false;
                    }

                    if (string.Equals(key, HeaderNames.LastModified, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.LastModified))
                        {
                            LastModified = default;
                            return true;
                        }
                        return false;
                    }

                    break;
                case 14:
                    if (string.Equals(key, HeaderNames.AcceptCharset, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.AcceptCharset))
                        {
                            AcceptCharset = default;
                            return true;
                        }
                        return false;
                    }

                    if (string.Equals(key, HeaderNames.ContentLength, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.ContentLength))
                        {
                            ContentLength = default;
                            return true;
                        }
                        return false;
                    }

                    break;
                case 15:
                    if (string.Equals(key, HeaderNames.AcceptEncoding, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.AcceptEncoding))
                        {
                            AcceptEncoding = default;
                            return true;
                        }
                        return false;
                    }

                    if (string.Equals(key, HeaderNames.AcceptLanguage, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.AcceptLanguage))
                        {
                            AcceptLanguage = default;
                            return true;
                        }
                        return false;
                    }

                    break;
                case 16:
                    if (string.Equals(key, HeaderNames.ContentEncoding, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.ContentEncoding))
                        {
                            ContentEncoding = default;
                            return true;
                        }
                        return false;
                    }

                    if (string.Equals(key, HeaderNames.ContentLanguage, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.ContentLanguage))
                        {
                            ContentLanguage = default;
                            return true;
                        }
                        return false;
                    }

                    if (string.Equals(key, HeaderNames.ContentLocation, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.ContentLocation))
                        {
                            ContentLocation = default;
                            return true;
                        }
                        return false;
                    }

                    break;
                case 17:
                    if (string.Equals(key, HeaderNames.IfModifiedSince, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.IfModifiedSince))
                        {
                            IfModifiedSince = default;
                            return true;
                        }
                        return false;
                    }

                    if (string.Equals(key, HeaderNames.TransferEncoding, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.TransferEncoding))
                        {
                            TransferEncoding = default;
                            return true;
                        }
                        return false;
                    }

                    break;
                case 19:
                    if (string.Equals(key, HeaderNames.IfUnmodifiedSince, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.IfUnmodifiedSince))
                        {
                            IfUnmodifiedSince = default;
                            return true;
                        }
                        return false;
                    }

                    if (string.Equals(key, HeaderNames.ProxyAuthorization, StringComparison.Ordinal))
                    {
                        if (HasKnownHeader(HttpSysRequestHeader.ProxyAuthorization))
                        {
                            ProxyAuthorization = default;
                            return true;
                        }
                        return false;
                    }

                    break;
            }
            return false;
        }

        private IEnumerable<string> PropertiesKeys()
        {
            if (Accept.Count > 0)
            {
                yield return HeaderNames.Accept;
            }
            if (AcceptCharset.Count > 0)
            {
                yield return HeaderNames.AcceptCharset;
            }
            if (AcceptEncoding.Count > 0)
            {
                yield return HeaderNames.AcceptEncoding;
            }
            if (AcceptLanguage.Count > 0)
            {
                yield return HeaderNames.AcceptLanguage;
            }
            if (Allow.Count > 0)
            {
                yield return HeaderNames.Allow;
            }
            if (Authorization.Count > 0)
            {
                yield return HeaderNames.Authorization;
            }
            if (CacheControl.Count > 0)
            {
                yield return HeaderNames.CacheControl;
            }
            if (Connection.Count > 0)
            {
                yield return HeaderNames.Connection;
            }
            if (ContentEncoding.Count > 0)
            {
                yield return HeaderNames.ContentEncoding;
            }
            if (ContentLanguage.Count > 0)
            {
                yield return HeaderNames.ContentLanguage;
            }
            if (ContentLength.Count > 0)
            {
                yield return HeaderNames.ContentLength;
            }
            if (ContentLocation.Count > 0)
            {
                yield return HeaderNames.ContentLocation;
            }
            if (ContentMD5.Count > 0)
            {
                yield return HeaderNames.ContentMD5;
            }
            if (ContentRange.Count > 0)
            {
                yield return HeaderNames.ContentRange;
            }
            if (ContentType.Count > 0)
            {
                yield return HeaderNames.ContentType;
            }
            if (Cookie.Count > 0)
            {
                yield return HeaderNames.Cookie;
            }
            if (Date.Count > 0)
            {
                yield return HeaderNames.Date;
            }
            if (Expect.Count > 0)
            {
                yield return HeaderNames.Expect;
            }
            if (Expires.Count > 0)
            {
                yield return HeaderNames.Expires;
            }
            if (From.Count > 0)
            {
                yield return HeaderNames.From;
            }
            if (Host.Count > 0)
            {
                yield return HeaderNames.Host;
            }
            if (IfMatch.Count > 0)
            {
                yield return HeaderNames.IfMatch;
            }
            if (IfModifiedSince.Count > 0)
            {
                yield return HeaderNames.IfModifiedSince;
            }
            if (IfNoneMatch.Count > 0)
            {
                yield return HeaderNames.IfNoneMatch;
            }
            if (IfRange.Count > 0)
            {
                yield return HeaderNames.IfRange;
            }
            if (IfUnmodifiedSince.Count > 0)
            {
                yield return HeaderNames.IfUnmodifiedSince;
            }
            if (KeepAlive.Count > 0)
            {
                yield return HeaderNames.KeepAlive;
            }
            if (LastModified.Count > 0)
            {
                yield return HeaderNames.LastModified;
            }
            if (MaxForwards.Count > 0)
            {
                yield return HeaderNames.MaxForwards;
            }
            if (Pragma.Count > 0)
            {
                yield return HeaderNames.Pragma;
            }
            if (ProxyAuthorization.Count > 0)
            {
                yield return HeaderNames.ProxyAuthorization;
            }
            if (Range.Count > 0)
            {
                yield return HeaderNames.Range;
            }
            if (Referer.Count > 0)
            {
                yield return HeaderNames.Referer;
            }
            if (TE.Count > 0)
            {
                yield return HeaderNames.TE;
            }
            if (Trailer.Count > 0)
            {
                yield return HeaderNames.Trailer;
            }
            if (TransferEncoding.Count > 0)
            {
                yield return HeaderNames.TransferEncoding;
            }
            if (Translate.Count > 0)
            {
                yield return HeaderNames.Translate;
            }
            if (Upgrade.Count > 0)
            {
                yield return HeaderNames.Upgrade;
            }
            if (UserAgent.Count > 0)
            {
                yield return HeaderNames.UserAgent;
            }
            if (Via.Count > 0)
            {
                yield return HeaderNames.Via;
            }
            if (Warning.Count > 0)
            {
                yield return HeaderNames.Warning;
            }
        }

        private IEnumerable<StringValues> PropertiesValues()
        {
            if (Accept.Count > 0)
            {
                yield return Accept;
            }
            if (AcceptCharset.Count > 0)
            {
                yield return AcceptCharset;
            }
            if (AcceptEncoding.Count > 0)
            {
                yield return AcceptEncoding;
            }
            if (AcceptLanguage.Count > 0)
            {
                yield return AcceptLanguage;
            }
            if (Allow.Count > 0)
            {
                yield return Allow;
            }
            if (Authorization.Count > 0)
            {
                yield return Authorization;
            }
            if (CacheControl.Count > 0)
            {
                yield return CacheControl;
            }
            if (Connection.Count > 0)
            {
                yield return Connection;
            }
            if (ContentEncoding.Count > 0)
            {
                yield return ContentEncoding;
            }
            if (ContentLanguage.Count > 0)
            {
                yield return ContentLanguage;
            }
            if (ContentLength.Count > 0)
            {
                yield return ContentLength;
            }
            if (ContentLocation.Count > 0)
            {
                yield return ContentLocation;
            }
            if (ContentMD5.Count > 0)
            {
                yield return ContentMD5;
            }
            if (ContentRange.Count > 0)
            {
                yield return ContentRange;
            }
            if (ContentType.Count > 0)
            {
                yield return ContentType;
            }
            if (Cookie.Count > 0)
            {
                yield return Cookie;
            }
            if (Date.Count > 0)
            {
                yield return Date;
            }
            if (Expect.Count > 0)
            {
                yield return Expect;
            }
            if (Expires.Count > 0)
            {
                yield return Expires;
            }
            if (From.Count > 0)
            {
                yield return From;
            }
            if (Host.Count > 0)
            {
                yield return Host;
            }
            if (IfMatch.Count > 0)
            {
                yield return IfMatch;
            }
            if (IfModifiedSince.Count > 0)
            {
                yield return IfModifiedSince;
            }
            if (IfNoneMatch.Count > 0)
            {
                yield return IfNoneMatch;
            }
            if (IfRange.Count > 0)
            {
                yield return IfRange;
            }
            if (IfUnmodifiedSince.Count > 0)
            {
                yield return IfUnmodifiedSince;
            }
            if (KeepAlive.Count > 0)
            {
                yield return KeepAlive;
            }
            if (LastModified.Count > 0)
            {
                yield return LastModified;
            }
            if (MaxForwards.Count > 0)
            {
                yield return MaxForwards;
            }
            if (Pragma.Count > 0)
            {
                yield return Pragma;
            }
            if (ProxyAuthorization.Count > 0)
            {
                yield return ProxyAuthorization;
            }
            if (Range.Count > 0)
            {
                yield return Range;
            }
            if (Referer.Count > 0)
            {
                yield return Referer;
            }
            if (TE.Count > 0)
            {
                yield return TE;
            }
            if (Trailer.Count > 0)
            {
                yield return Trailer;
            }
            if (TransferEncoding.Count > 0)
            {
                yield return TransferEncoding;
            }
            if (Translate.Count > 0)
            {
                yield return Translate;
            }
            if (Upgrade.Count > 0)
            {
                yield return Upgrade;
            }
            if (UserAgent.Count > 0)
            {
                yield return UserAgent;
            }
            if (Via.Count > 0)
            {
                yield return Via;
            }
            if (Warning.Count > 0)
            {
                yield return Warning;
            }
        }

        private IEnumerable<KeyValuePair<string, StringValues>> PropertiesEnumerable()
        {
            if (Accept.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.Accept, Accept);
            }
            if (AcceptCharset.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.AcceptCharset, AcceptCharset);
            }
            if (AcceptEncoding.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.AcceptEncoding, AcceptEncoding);
            }
            if (AcceptLanguage.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.AcceptLanguage, AcceptLanguage);
            }
            if (Allow.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.Allow, Allow);
            }
            if (Authorization.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.Authorization, Authorization);
            }
            if (CacheControl.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.CacheControl, CacheControl);
            }
            if (Connection.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.Connection, Connection);
            }
            if (ContentEncoding.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.ContentEncoding, ContentEncoding);
            }
            if (ContentLanguage.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.ContentLanguage, ContentLanguage);
            }
            if (ContentLength.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.ContentLength, ContentLength);
            }
            if (ContentLocation.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.ContentLocation, ContentLocation);
            }
            if (ContentMD5.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.ContentMD5, ContentMD5);
            }
            if (ContentRange.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.ContentRange, ContentRange);
            }
            if (ContentType.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.ContentType, ContentType);
            }
            if (Cookie.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.Cookie, Cookie);
            }
            if (Date.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.Date, Date);
            }
            if (Expect.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.Expect, Expect);
            }
            if (Expires.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.Expires, Expires);
            }
            if (From.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.From, From);
            }
            if (Host.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.Host, Host);
            }
            if (IfMatch.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.IfMatch, IfMatch);
            }
            if (IfModifiedSince.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.IfModifiedSince, IfModifiedSince);
            }
            if (IfNoneMatch.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.IfNoneMatch, IfNoneMatch);
            }
            if (IfRange.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.IfRange, IfRange);
            }
            if (IfUnmodifiedSince.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.IfUnmodifiedSince, IfUnmodifiedSince);
            }
            if (KeepAlive.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.KeepAlive, KeepAlive);
            }
            if (LastModified.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.LastModified, LastModified);
            }
            if (MaxForwards.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.MaxForwards, MaxForwards);
            }
            if (Pragma.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.Pragma, Pragma);
            }
            if (ProxyAuthorization.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.ProxyAuthorization, ProxyAuthorization);
            }
            if (Range.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.Range, Range);
            }
            if (Referer.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.Referer, Referer);
            }
            if (TE.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.TE, TE);
            }
            if (Trailer.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.Trailer, Trailer);
            }
            if (TransferEncoding.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.TransferEncoding, TransferEncoding);
            }
            if (Translate.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.Translate, Translate);
            }
            if (Upgrade.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.Upgrade, Upgrade);
            }
            if (UserAgent.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.UserAgent, UserAgent);
            }
            if (Via.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.Via, Via);
            }
            if (Warning.Count > 0)
            {
                yield return new KeyValuePair<string, StringValues>(HeaderNames.Warning, Warning);
            }
        }

        private static ReadOnlySpan<byte> HeaderKeys => new byte[]
        {
            (byte)HttpSysRequestHeader.Accept,
            (byte)HttpSysRequestHeader.AcceptCharset,
            (byte)HttpSysRequestHeader.AcceptEncoding,
            (byte)HttpSysRequestHeader.AcceptLanguage,
            (byte)HttpSysRequestHeader.Allow,
            (byte)HttpSysRequestHeader.Authorization,
            (byte)HttpSysRequestHeader.CacheControl,
            (byte)HttpSysRequestHeader.Connection,
            (byte)HttpSysRequestHeader.ContentEncoding,
            (byte)HttpSysRequestHeader.ContentLanguage,
            (byte)HttpSysRequestHeader.ContentLength,
            (byte)HttpSysRequestHeader.ContentLocation,
            (byte)HttpSysRequestHeader.ContentMd5,
            (byte)HttpSysRequestHeader.ContentRange,
            (byte)HttpSysRequestHeader.ContentType,
            (byte)HttpSysRequestHeader.Cookie,
            (byte)HttpSysRequestHeader.Date,
            (byte)HttpSysRequestHeader.Expect,
            (byte)HttpSysRequestHeader.Expires,
            (byte)HttpSysRequestHeader.From,
            (byte)HttpSysRequestHeader.Host,
            (byte)HttpSysRequestHeader.IfMatch,
            (byte)HttpSysRequestHeader.IfModifiedSince,
            (byte)HttpSysRequestHeader.IfNoneMatch,
            (byte)HttpSysRequestHeader.IfRange,
            (byte)HttpSysRequestHeader.IfUnmodifiedSince,
            (byte)HttpSysRequestHeader.KeepAlive,
            (byte)HttpSysRequestHeader.LastModified,
            (byte)HttpSysRequestHeader.MaxForwards,
            (byte)HttpSysRequestHeader.Pragma,
            (byte)HttpSysRequestHeader.ProxyAuthorization,
            (byte)HttpSysRequestHeader.Range,
            (byte)HttpSysRequestHeader.Referer,
            (byte)HttpSysRequestHeader.Te,
            (byte)HttpSysRequestHeader.Trailer,
            (byte)HttpSysRequestHeader.TransferEncoding,
            (byte)HttpSysRequestHeader.Translate,
            (byte)HttpSysRequestHeader.Upgrade,
            (byte)HttpSysRequestHeader.UserAgent,
            (byte)HttpSysRequestHeader.Via,
            (byte)HttpSysRequestHeader.Warning,
        };

        private string GetHeaderKeyName(HttpSysRequestHeader header) => header switch
        {
            HttpSysRequestHeader.Accept => HeaderNames.Accept,
            HttpSysRequestHeader.AcceptCharset => HeaderNames.AcceptCharset,
            HttpSysRequestHeader.AcceptEncoding => HeaderNames.AcceptEncoding,
            HttpSysRequestHeader.AcceptLanguage => HeaderNames.AcceptLanguage,
            HttpSysRequestHeader.Allow => HeaderNames.Allow,
            HttpSysRequestHeader.Authorization => HeaderNames.Authorization,
            HttpSysRequestHeader.CacheControl => HeaderNames.CacheControl,
            HttpSysRequestHeader.Connection => HeaderNames.Connection,
            HttpSysRequestHeader.ContentEncoding => HeaderNames.ContentEncoding,
            HttpSysRequestHeader.ContentLanguage => HeaderNames.ContentLanguage,
            HttpSysRequestHeader.ContentLength => HeaderNames.ContentLength,
            HttpSysRequestHeader.ContentLocation => HeaderNames.ContentLocation,
            HttpSysRequestHeader.ContentMd5 => HeaderNames.ContentMD5,
            HttpSysRequestHeader.ContentRange => HeaderNames.ContentRange,
            HttpSysRequestHeader.ContentType => HeaderNames.ContentType,
            HttpSysRequestHeader.Cookie => HeaderNames.Cookie,
            HttpSysRequestHeader.Date => HeaderNames.Date,
            HttpSysRequestHeader.Expect => HeaderNames.Expect,
            HttpSysRequestHeader.Expires => HeaderNames.Expires,
            HttpSysRequestHeader.From => HeaderNames.From,
            HttpSysRequestHeader.Host => HeaderNames.Host,
            HttpSysRequestHeader.IfMatch => HeaderNames.IfMatch,
            HttpSysRequestHeader.IfModifiedSince => HeaderNames.IfModifiedSince,
            HttpSysRequestHeader.IfNoneMatch => HeaderNames.IfNoneMatch,
            HttpSysRequestHeader.IfRange => HeaderNames.IfRange,
            HttpSysRequestHeader.IfUnmodifiedSince => HeaderNames.IfUnmodifiedSince,
            HttpSysRequestHeader.KeepAlive => HeaderNames.KeepAlive,
            HttpSysRequestHeader.LastModified => HeaderNames.LastModified,
            HttpSysRequestHeader.MaxForwards => HeaderNames.MaxForwards,
            HttpSysRequestHeader.Pragma => HeaderNames.Pragma,
            HttpSysRequestHeader.ProxyAuthorization => HeaderNames.ProxyAuthorization,
            HttpSysRequestHeader.Range => HeaderNames.Range,
            HttpSysRequestHeader.Referer => HeaderNames.Referer,
            HttpSysRequestHeader.Te => HeaderNames.TE,
            HttpSysRequestHeader.Trailer => HeaderNames.Trailer,
            HttpSysRequestHeader.TransferEncoding => HeaderNames.TransferEncoding,
            HttpSysRequestHeader.Translate => HeaderNames.Translate,
            HttpSysRequestHeader.Upgrade => HeaderNames.Upgrade,
            HttpSysRequestHeader.UserAgent => HeaderNames.UserAgent,
            HttpSysRequestHeader.Via => HeaderNames.Via,
            HttpSysRequestHeader.Warning => HeaderNames.Warning,
            _ => throw new NotImplementedException()
        };

        private bool HasKnownHeader(HttpSysRequestHeader header) => header switch
        {
            HttpSysRequestHeader.Accept => (_flag0 & 0x1u) != 0 ? _Accept.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.Accept),
            HttpSysRequestHeader.AcceptCharset => (_flag0 & 0x2u) != 0 ? _AcceptCharset.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.AcceptCharset),
            HttpSysRequestHeader.AcceptEncoding => (_flag0 & 0x4u) != 0 ? _AcceptEncoding.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.AcceptEncoding),
            HttpSysRequestHeader.AcceptLanguage => (_flag0 & 0x8u) != 0 ? _AcceptLanguage.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.AcceptLanguage),
            HttpSysRequestHeader.Allow => (_flag0 & 0x10u) != 0 ? _Allow.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.Allow),
            HttpSysRequestHeader.Authorization => (_flag0 & 0x20u) != 0 ? _Authorization.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.Authorization),
            HttpSysRequestHeader.CacheControl => (_flag0 & 0x40u) != 0 ? _CacheControl.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.CacheControl),
            HttpSysRequestHeader.Connection => (_flag0 & 0x80u) != 0 ? _Connection.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.Connection),
            HttpSysRequestHeader.ContentEncoding => (_flag0 & 0x100u) != 0 ? _ContentEncoding.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.ContentEncoding),
            HttpSysRequestHeader.ContentLanguage => (_flag0 & 0x200u) != 0 ? _ContentLanguage.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.ContentLanguage),
            HttpSysRequestHeader.ContentLength => (_flag0 & 0x400u) != 0 ? _ContentLength.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.ContentLength),
            HttpSysRequestHeader.ContentLocation => (_flag0 & 0x800u) != 0 ? _ContentLocation.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.ContentLocation),
            HttpSysRequestHeader.ContentMd5 => (_flag0 & 0x1000u) != 0 ? _ContentMD5.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.ContentMd5),
            HttpSysRequestHeader.ContentRange => (_flag0 & 0x2000u) != 0 ? _ContentRange.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.ContentRange),
            HttpSysRequestHeader.ContentType => (_flag0 & 0x4000u) != 0 ? _ContentType.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.ContentType),
            HttpSysRequestHeader.Cookie => (_flag0 & 0x8000u) != 0 ? _Cookie.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.Cookie),
            HttpSysRequestHeader.Date => (_flag0 & 0x10000u) != 0 ? _Date.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.Date),
            HttpSysRequestHeader.Expect => (_flag0 & 0x20000u) != 0 ? _Expect.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.Expect),
            HttpSysRequestHeader.Expires => (_flag0 & 0x40000u) != 0 ? _Expires.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.Expires),
            HttpSysRequestHeader.From => (_flag0 & 0x80000u) != 0 ? _From.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.From),
            HttpSysRequestHeader.Host => (_flag0 & 0x100000u) != 0 ? _Host.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.Host),
            HttpSysRequestHeader.IfMatch => (_flag0 & 0x200000u) != 0 ? _IfMatch.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.IfMatch),
            HttpSysRequestHeader.IfModifiedSince => (_flag0 & 0x400000u) != 0 ? _IfModifiedSince.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.IfModifiedSince),
            HttpSysRequestHeader.IfNoneMatch => (_flag0 & 0x800000u) != 0 ? _IfNoneMatch.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.IfNoneMatch),
            HttpSysRequestHeader.IfRange => (_flag0 & 0x1000000u) != 0 ? _IfRange.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.IfRange),
            HttpSysRequestHeader.IfUnmodifiedSince => (_flag0 & 0x2000000u) != 0 ? _IfUnmodifiedSince.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.IfUnmodifiedSince),
            HttpSysRequestHeader.KeepAlive => (_flag0 & 0x4000000u) != 0 ? _KeepAlive.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.KeepAlive),
            HttpSysRequestHeader.LastModified => (_flag0 & 0x8000000u) != 0 ? _LastModified.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.LastModified),
            HttpSysRequestHeader.MaxForwards => (_flag0 & 0x10000000u) != 0 ? _MaxForwards.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.MaxForwards),
            HttpSysRequestHeader.Pragma => (_flag0 & 0x20000000u) != 0 ? _Pragma.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.Pragma),
            HttpSysRequestHeader.ProxyAuthorization => (_flag0 & 0x40000000u) != 0 ? _ProxyAuthorization.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.ProxyAuthorization),
            HttpSysRequestHeader.Range => (_flag0 & 0x80000000u) != 0 ? _Range.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.Range),
            HttpSysRequestHeader.Referer => (_flag1 & 0x1u) != 0 ? _Referer.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.Referer),
            HttpSysRequestHeader.Te => (_flag1 & 0x2u) != 0 ? _TE.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.Te),
            HttpSysRequestHeader.Trailer => (_flag1 & 0x4u) != 0 ? _Trailer.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.Trailer),
            HttpSysRequestHeader.TransferEncoding => (_flag1 & 0x8u) != 0 ? _TransferEncoding.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.TransferEncoding),
            HttpSysRequestHeader.Translate => (_flag1 & 0x10u) != 0 ? _Translate.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.Translate),
            HttpSysRequestHeader.Upgrade => (_flag1 & 0x20u) != 0 ? _Upgrade.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.Upgrade),
            HttpSysRequestHeader.UserAgent => (_flag1 & 0x40u) != 0 ? _UserAgent.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.UserAgent),
            HttpSysRequestHeader.Via => (_flag1 & 0x80u) != 0 ? _Via.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.Via),
            HttpSysRequestHeader.Warning => (_flag1 & 0x100u) != 0 ? _Warning.Count > 0 : _requestMemoryBlob.HasKnownHeader(HttpSysRequestHeader.Warning),
            _ => throw new NotImplementedException()
        };
    }
}
