/*
  ZynAddSubFX - a software synthesizer

  Fl_Osc_Output.H - OSC Based Value Output
  Copyright (C) 2016 Mark McCurry

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
*/
#pragma once
#include <FL/Fl_Value_Output.H>
#include "Fl_Osc_Widget.H"

class Fl_Osc_Output:public Fl_Value_Output, public Fl_Osc_Widget
{
    public:
        Fl_Osc_Output(int x, int y, int w, int h, const char *label = NULL);
        void init(const char *path);
        void OSC_value(char);
        void OSC_value(float);
        using Fl_Osc_Widget::OSC_value;
        
        void update(void);
        void callback(Fl_Callback *cb, void *p = NULL);

        float newvalue() const;

        void cb(void);
    private:
        float newvalue_;
        std::pair<Fl_Callback*, void*> cb_data;
};
