package ONVIF::Device::Types::RecordingJobTrack;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %SourceTag_of :ATTR(:get<SourceTag>);
my %Destination_of :ATTR(:get<Destination>);

__PACKAGE__->_factory(
    [ qw(        SourceTag
        Destination

    ) ],
    {
        'SourceTag' => \%SourceTag_of,
        'Destination' => \%Destination_of,
    },
    {
        'SourceTag' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'Destination' => 'ONVIF::Device::Types::TrackReference',
    },
    {

        'SourceTag' => 'SourceTag',
        'Destination' => 'Destination',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Device::Types::RecordingJobTrack

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
RecordingJobTrack from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * SourceTag


=item * Destination




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Device::Types::RecordingJobTrack
   SourceTag =>  $some_value, # string
   Destination => $some_value, # TrackReference
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

