package ONVIF::Analytics::Types::SearchCapabilities;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %XAddr_of :ATTR(:get<XAddr>);
my %MetadataSearch_of :ATTR(:get<MetadataSearch>);

__PACKAGE__->_factory(
    [ qw(        XAddr
        MetadataSearch

    ) ],
    {
        'XAddr' => \%XAddr_of,
        'MetadataSearch' => \%MetadataSearch_of,
    },
    {
        'XAddr' => 'SOAP::WSDL::XSD::Typelib::Builtin::anyURI',
        'MetadataSearch' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
    },
    {

        'XAddr' => 'XAddr',
        'MetadataSearch' => 'MetadataSearch',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Analytics::Types::SearchCapabilities

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
SearchCapabilities from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * XAddr


=item * MetadataSearch




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Analytics::Types::SearchCapabilities
   XAddr =>  $some_value, # anyURI
   MetadataSearch =>  $some_value, # boolean
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

