package ONVIF::Media::Types::ReceiverCapabilities;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %XAddr_of :ATTR(:get<XAddr>);
my %RTP_Multicast_of :ATTR(:get<RTP_Multicast>);
my %RTP_TCP_of :ATTR(:get<RTP_TCP>);
my %RTP_RTSP_TCP_of :ATTR(:get<RTP_RTSP_TCP>);
my %SupportedReceivers_of :ATTR(:get<SupportedReceivers>);
my %MaximumRTSPURILength_of :ATTR(:get<MaximumRTSPURILength>);

__PACKAGE__->_factory(
    [ qw(        XAddr
        RTP_Multicast
        RTP_TCP
        RTP_RTSP_TCP
        SupportedReceivers
        MaximumRTSPURILength

    ) ],
    {
        'XAddr' => \%XAddr_of,
        'RTP_Multicast' => \%RTP_Multicast_of,
        'RTP_TCP' => \%RTP_TCP_of,
        'RTP_RTSP_TCP' => \%RTP_RTSP_TCP_of,
        'SupportedReceivers' => \%SupportedReceivers_of,
        'MaximumRTSPURILength' => \%MaximumRTSPURILength_of,
    },
    {
        'XAddr' => 'SOAP::WSDL::XSD::Typelib::Builtin::anyURI',
        'RTP_Multicast' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'RTP_TCP' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'RTP_RTSP_TCP' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'SupportedReceivers' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'MaximumRTSPURILength' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
    },
    {

        'XAddr' => 'XAddr',
        'RTP_Multicast' => 'RTP_Multicast',
        'RTP_TCP' => 'RTP_TCP',
        'RTP_RTSP_TCP' => 'RTP_RTSP_TCP',
        'SupportedReceivers' => 'SupportedReceivers',
        'MaximumRTSPURILength' => 'MaximumRTSPURILength',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Media::Types::ReceiverCapabilities

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
ReceiverCapabilities from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * XAddr


=item * RTP_Multicast


=item * RTP_TCP


=item * RTP_RTSP_TCP


=item * SupportedReceivers


=item * MaximumRTSPURILength




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Media::Types::ReceiverCapabilities
   XAddr =>  $some_value, # anyURI
   RTP_Multicast =>  $some_value, # boolean
   RTP_TCP =>  $some_value, # boolean
   RTP_RTSP_TCP =>  $some_value, # boolean
   SupportedReceivers =>  $some_value, # int
   MaximumRTSPURILength =>  $some_value, # int
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

