
package ONVIF::PTZ::Elements::MetadataConfiguration;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'http://www.onvif.org/ver10/schema' }

__PACKAGE__->__set_name('MetadataConfiguration');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();
use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    ONVIF::PTZ::Types::MetadataConfiguration
);

}

1;


=pod

=head1 NAME

ONVIF::PTZ::Elements::MetadataConfiguration

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
MetadataConfiguration from the namespace http://www.onvif.org/ver10/schema.







=head1 METHODS

=head2 new

 my $element = ONVIF::PTZ::Elements::MetadataConfiguration->new($data);

Constructor. The following data structure may be passed to new():

 { # ONVIF::PTZ::Types::MetadataConfiguration
   PTZStatus =>  { # ONVIF::PTZ::Types::PTZFilter
     Status =>  $some_value, # boolean
     Position =>  $some_value, # boolean
   },
   Analytics =>  $some_value, # boolean
   Multicast =>  { # ONVIF::PTZ::Types::MulticastConfiguration
     Address =>  { # ONVIF::PTZ::Types::IPAddress
       Type => $some_value, # IPType
       IPv4Address => $some_value, # IPv4Address
       IPv6Address => $some_value, # IPv6Address
     },
     Port =>  $some_value, # int
     TTL =>  $some_value, # int
     AutoStart =>  $some_value, # boolean
   },
   SessionTimeout =>  $some_value, # duration
   AnalyticsEngineConfiguration =>  { # ONVIF::PTZ::Types::AnalyticsEngineConfiguration
     AnalyticsModule =>  { # ONVIF::PTZ::Types::Config
       Parameters =>  { # ONVIF::PTZ::Types::ItemList
         SimpleItem => ,
         ElementItem =>  {
         },
         Extension =>  { # ONVIF::PTZ::Types::ItemListExtension
         },
       },
     },
     Extension =>  { # ONVIF::PTZ::Types::AnalyticsEngineConfigurationExtension
     },
   },
   Extension =>  { # ONVIF::PTZ::Types::MetadataConfigurationExtension
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

