package ONVIF::Media::Types::VideoOutput;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(ONVIF::Media::Types::DeviceEntity);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Layout_of :ATTR(:get<Layout>);
my %Resolution_of :ATTR(:get<Resolution>);
my %RefreshRate_of :ATTR(:get<RefreshRate>);
my %AspectRatio_of :ATTR(:get<AspectRatio>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        Layout
        Resolution
        RefreshRate
        AspectRatio
        Extension

    ) ],
    {
        'Layout' => \%Layout_of,
        'Resolution' => \%Resolution_of,
        'RefreshRate' => \%RefreshRate_of,
        'AspectRatio' => \%AspectRatio_of,
        'Extension' => \%Extension_of,
    },
    {
        'Layout' => 'ONVIF::Media::Types::Layout',
        'Resolution' => 'ONVIF::Media::Types::VideoResolution',
        'RefreshRate' => 'SOAP::WSDL::XSD::Typelib::Builtin::float',
        'AspectRatio' => 'SOAP::WSDL::XSD::Typelib::Builtin::float',
        'Extension' => 'ONVIF::Media::Types::VideoOutputExtension',
    },
    {

        'Layout' => 'Layout',
        'Resolution' => 'Resolution',
        'RefreshRate' => 'RefreshRate',
        'AspectRatio' => 'AspectRatio',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Media::Types::VideoOutput

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
VideoOutput from the namespace http://www.onvif.org/ver10/schema.

Representation of a physical video outputs.




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Layout


=item * Resolution


=item * RefreshRate


=item * AspectRatio


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Media::Types::VideoOutput
   Layout =>  { # ONVIF::Media::Types::Layout
     PaneLayout =>  { # ONVIF::Media::Types::PaneLayout
       Pane => $some_value, # ReferenceToken
       Area => ,
     },
     Extension =>  { # ONVIF::Media::Types::LayoutExtension
     },
   },
   Resolution =>  { # ONVIF::Media::Types::VideoResolution
     Width =>  $some_value, # int
     Height =>  $some_value, # int
   },
   RefreshRate =>  $some_value, # float
   AspectRatio =>  $some_value, # float
   Extension =>  { # ONVIF::Media::Types::VideoOutputExtension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

