
package ONVIF::Media::Elements::GetStreamUri;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'http://www.onvif.org/ver10/media/wsdl' }

__PACKAGE__->__set_name('GetStreamUri');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    SOAP::WSDL::XSD::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %StreamSetup_of :ATTR(:get<StreamSetup>);
my %ProfileToken_of :ATTR(:get<ProfileToken>);

__PACKAGE__->_factory(
    [ qw(        StreamSetup
        ProfileToken

    ) ],
    {
        'StreamSetup' => \%StreamSetup_of,
        'ProfileToken' => \%ProfileToken_of,
    },
    {
        'StreamSetup' => 'ONVIF::Media::Types::StreamSetup',
        'ProfileToken' => 'ONVIF::Media::Types::ReferenceToken',
    },
    {

        'StreamSetup' => 'StreamSetup',
        'ProfileToken' => 'ProfileToken',
    }
);

} # end BLOCK







} # end of BLOCK



1;


=pod

=head1 NAME

ONVIF::Media::Elements::GetStreamUri

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
GetStreamUri from the namespace http://www.onvif.org/ver10/media/wsdl.







=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * StreamSetup

 $element->set_StreamSetup($data);
 $element->get_StreamSetup();




=item * ProfileToken

 $element->set_ProfileToken($data);
 $element->get_ProfileToken();





=back


=head1 METHODS

=head2 new

 my $element = ONVIF::Media::Elements::GetStreamUri->new($data);

Constructor. The following data structure may be passed to new():

 {
   StreamSetup =>  { # ONVIF::Media::Types::StreamSetup
     Stream => $some_value, # StreamType
     Transport =>  { # ONVIF::Media::Types::Transport
       Protocol => $some_value, # TransportProtocol
     },
   },
   ProfileToken => $some_value, # ReferenceToken
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

