
package ONVIF::Device::Elements::SetDynamicDNS;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'http://www.onvif.org/ver10/device/wsdl' }

__PACKAGE__->__set_name('SetDynamicDNS');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    SOAP::WSDL::XSD::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Type_of :ATTR(:get<Type>);
my %Name_of :ATTR(:get<Name>);
my %TTL_of :ATTR(:get<TTL>);

__PACKAGE__->_factory(
    [ qw(        Type
        Name
        TTL

    ) ],
    {
        'Type' => \%Type_of,
        'Name' => \%Name_of,
        'TTL' => \%TTL_of,
    },
    {
        'Type' => 'ONVIF::Device::Types::DynamicDNSType',
        'Name' => 'ONVIF::Device::Types::DNSName',
        'TTL' => 'SOAP::WSDL::XSD::Typelib::Builtin::duration',
    },
    {

        'Type' => 'Type',
        'Name' => 'Name',
        'TTL' => 'TTL',
    }
);

} # end BLOCK







} # end of BLOCK



1;


=pod

=head1 NAME

ONVIF::Device::Elements::SetDynamicDNS

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
SetDynamicDNS from the namespace http://www.onvif.org/ver10/device/wsdl.







=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Type

 $element->set_Type($data);
 $element->get_Type();




=item * Name

 $element->set_Name($data);
 $element->get_Name();




=item * TTL

 $element->set_TTL($data);
 $element->get_TTL();





=back


=head1 METHODS

=head2 new

 my $element = ONVIF::Device::Elements::SetDynamicDNS->new($data);

Constructor. The following data structure may be passed to new():

 {
   Type => $some_value, # DynamicDNSType
   Name => $some_value, # DNSName
   TTL =>  $some_value, # duration
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

