/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared.resolver.aws;

import com.netflix.discovery.shared.resolver.ClusterResolver;
import com.netflix.discovery.shared.resolver.EndpointRandomizer;
import com.netflix.discovery.shared.resolver.ResolverUtils;
import com.netflix.discovery.shared.resolver.aws.AwsEndpoint;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZoneAffinityClusterResolver
implements ClusterResolver<AwsEndpoint> {
    private static final Logger logger = LoggerFactory.getLogger(ZoneAffinityClusterResolver.class);
    private final ClusterResolver<AwsEndpoint> delegate;
    private final String myZone;
    private final boolean zoneAffinity;
    private final EndpointRandomizer randomizer;

    public ZoneAffinityClusterResolver(ClusterResolver<AwsEndpoint> delegate, String myZone, boolean zoneAffinity, EndpointRandomizer randomizer) {
        this.delegate = delegate;
        this.myZone = myZone;
        this.zoneAffinity = zoneAffinity;
        this.randomizer = randomizer;
    }

    @Override
    public String getRegion() {
        return this.delegate.getRegion();
    }

    @Override
    public List<AwsEndpoint> getClusterEndpoints() {
        List<AwsEndpoint>[] parts = ResolverUtils.splitByZone(this.delegate.getClusterEndpoints(), this.myZone);
        List<AwsEndpoint> myZoneEndpoints = parts[0];
        List<AwsEndpoint> remainingEndpoints = parts[1];
        List<AwsEndpoint> randomizedList = this.randomizeAndMerge(myZoneEndpoints, remainingEndpoints);
        if (!this.zoneAffinity) {
            Collections.reverse(randomizedList);
        }
        logger.debug("Local zone={}; resolved to: {}", (Object)this.myZone, randomizedList);
        return randomizedList;
    }

    private List<AwsEndpoint> randomizeAndMerge(List<AwsEndpoint> myZoneEndpoints, List<AwsEndpoint> remainingEndpoints) {
        if (myZoneEndpoints.isEmpty()) {
            return this.randomizer.randomize(remainingEndpoints);
        }
        if (remainingEndpoints.isEmpty()) {
            return this.randomizer.randomize(myZoneEndpoints);
        }
        List<AwsEndpoint> mergedList = this.randomizer.randomize(myZoneEndpoints);
        mergedList.addAll(this.randomizer.randomize(remainingEndpoints));
        return mergedList;
    }
}

