/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.converters.jackson;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.converters.KeyFormatter;
import com.netflix.discovery.converters.jackson.serializer.ApplicationsXmlBeanSerializer;
import com.netflix.discovery.converters.jackson.serializer.InstanceInfoXmlBeanSerializer;
import com.netflix.discovery.shared.Applications;

public final class EurekaJacksonXmlModifiers {
    private EurekaJacksonXmlModifiers() {
    }

    public static BeanSerializerModifier createXmlSerializerModifier(final KeyFormatter keyFormatter) {
        return new BeanSerializerModifier(){

            public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
                if (beanDesc.getBeanClass().isAssignableFrom(Applications.class)) {
                    return new ApplicationsXmlBeanSerializer((BeanSerializerBase)serializer, keyFormatter);
                }
                if (beanDesc.getBeanClass().isAssignableFrom(InstanceInfo.class)) {
                    return new InstanceInfoXmlBeanSerializer((BeanSerializerBase)serializer);
                }
                return serializer;
            }
        };
    }
}

