/*
 *========================================================================
 * $Id: libwulf_llist.h 76 2004-07-07 01:08:58Z rgb $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

/*
 * (Doubly) Linked list interface.  We double link it to make it
 * easier to remove an element -- walk until we find it, free the
 * data pointer, put its next pointer into the next pointer of its
 * previous pointer, and free the element.
 *
 * We need to define an element in the list
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef struct ListElement {
  void *data;			/* Contents of THIS list element */
  struct ListElement *prev;	/* Pointer to the PREVIOUS list element */
  struct ListElement *next;	/* Pointer to the NEXT list element */
} ListElement;

/*
 * Then we need to define the list itself -- basically a wrapper
 * struct that contains pointers to the head and tail of the (doubly
 * linked) list.
 */
typedef struct List_ {
  int size;			/* Number of elements */
  struct ListElement *head;	/* starting point for a walkthrough */
  struct ListElement *tail;	/* endpoint of a walkthrough */
} List;

List *newlist();
void add_list(List *list,void *data,int size);
void rm_list(List *list,void *data,int size);
void delete_list(List *list);


