/* dnd.cc
 * This file belongs to Worker, a file manager for UN*X/X11.
 * Copyright (C) 2001-2007,2013 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "dnd.h"
#include "lister.h"
#include "listermode.h"
#include "virtualdirmode.hh"
#include "nmrowdata.h"
#include "worker.h"
#include "fileentry.hh"
#include <aguix/fieldlvrowdata.h>

DNDMsg::DNDMsg(Worker *tworker)
{
  this->worker=tworker;

  sl=el=NULL;
  slm=elm=NULL;

  start.specialinfo.rowDataP = NULL;
  end.specialinfo.rowDataP = NULL;
}

DNDMsg::DNDMsg(Worker *tworker,AGDNDSTART s,AGDNDEND e)
{
  this->worker=tworker;

  sl=el=NULL;
  slm=elm=NULL;
  
  start.specialinfo.rowDataP = NULL;
  end.specialinfo.rowDataP = NULL;
  setStart(&s);
  setEnd(&e);
}

const FileEntry *DNDMsg::getFE() const
{
    NMRowData *rdp = dynamic_cast< NMRowData *>( start.specialinfo.rowDataP );
    if ( rdp ) {
        return rdp->getFE();
    }
    return NULL;
}

std::string DNDMsg::getDestDir() const
{
  if(elm!=NULL) {
    if ( auto vdm = dynamic_cast< VirtualDirMode *>( elm ) ) {
        return vdm->getCurrentDirectory();
    }
  }
  return NULL;
}

Lister *DNDMsg::getDestLister() const
{
  return el;
}

ListerMode *DNDMsg::getDestMode() const
{
  return elm;
}

Lister *DNDMsg::getSourceLister() const
{
  return sl;
}

ListerMode *DNDMsg::getSourceMode() const
{
  return slm;
}

void DNDMsg::setStart(AGDNDSTART*s)
{
  Lister *l1,*l2;
  ListerMode *lm1=NULL,*lm2=NULL;
  Widget *wel;

  if ( start.specialinfo.rowDataP != NULL ) delete start.specialinfo.rowDataP;
  start=*s;
  if ( s->specialinfo.rowDataP != NULL ) start.specialinfo.rowDataP = s->specialinfo.rowDataP->duplicate();
  else start.specialinfo.rowDataP = NULL;

  sl=NULL;
  slm=NULL;
  
  l1=worker->getLister(0);
  lm1=l1->getActiveMode();
  l2=worker->getLister(1);
  lm2=l2->getActiveMode();

/*  if((lm1!=NULL)&&(lm2!=NULL)) {
    gel=start.element;
    if(lm1->isyours(gel)==true) {
      slm=lm1;
      sl=l1;
    } else if(lm2->isyours(gel)==true) {
      slm=lm2;
      sl=l2;
    }
  }*/
  wel = start.element;
  if(lm1!=NULL) {
    if ( lm1->isyours( wel ) == true ) {
      slm=lm1;
      sl=l1;
    }
  }
  if((sl==NULL)&&(lm2!=NULL)) {
    if ( lm2->isyours( wel ) == true ) {
      slm=lm2;
      sl=l2;
    }
  }
}

void DNDMsg::setEnd(AGDNDEND*e)
{
  Lister *l1,*l2;
  ListerMode *lm1=NULL,*lm2=NULL;
  Widget *wel;

  if ( end.specialinfo.rowDataP != NULL ) delete end.specialinfo.rowDataP;
  end=*e;
  if ( e->specialinfo.rowDataP != NULL ) end.specialinfo.rowDataP = e->specialinfo.rowDataP->duplicate();
  else end.specialinfo.rowDataP = NULL;

  el=NULL;
  elm=NULL;
  
  l1=worker->getLister(0);
  lm1=l1->getActiveMode();
  l2=worker->getLister(1);
  lm2=l2->getActiveMode();

/*  if((lm1!=NULL)&&(lm2!=NULL)) {
    gel=end.element;
    if(lm1->isyours(gel)==true) {
      elm=lm1;
      el=l1;
    } else if(lm2->isyours(gel)==true) {
      elm=lm2;
      el=l2;
    }
  }*/
  wel = end.element;
  if ( wel != NULL ) {
    if(lm1!=NULL) {
      if ( lm1->isyours( wel ) == true ) {
        elm=lm1;
        el=l1;
      }
    }
    if((el==NULL)&&(lm2!=NULL)) {
      if ( lm2->isyours( wel ) == true ) {
        elm=lm2;
        el=l2;
      }
    }
  } else if(end.window!=NULL) {
    if(l1!=NULL)
      if(l1->getAWindow()==end.window) el=l1;
    if(el==NULL)
      if(l2!=NULL)
        if(l2->getAWindow()==end.window) el=l2;
  }
}

const AGDNDSTART *DNDMsg::getStart()
{
  return &start;
}

const AGDNDEND *DNDMsg::getEnd()
{
  return &end;
}

DNDMsg::~DNDMsg()
{
  if ( start.specialinfo.rowDataP != NULL ) delete start.specialinfo.rowDataP;
  if ( end.specialinfo.rowDataP != NULL ) delete end.specialinfo.rowDataP;
}

