/* persdeeppathstore.cc
 * This file belongs to Worker, a file manager for UN*X/X11.
 * Copyright (C) 2012 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "persdeeppathstore.hh"
#include <iostream>
#include <fstream>
#include <sstream>
#include "nwc_fsentry.hh"

PersDeepPathStore::PersDeepPathStore( const std::string &filename ) : m_filename( filename ),
                                                                      m_lastmod( 0 ),
                                                                      m_lastsize( 0 )
{
}

void PersDeepPathStore::storePath( const std::string &path )
{
    read();

    bool changed = false;

    m_store.storePath( path, &changed );

    if ( changed ) {
        write();
    }
}

std::list< std::string > PersDeepPathStore::getPaths()
{
    read();
    return m_store.getPaths();
}

void PersDeepPathStore::read()
{
    NWC::FSEntry fe( m_filename );

    if ( ! fe.entryExists() ) return;

    if ( fe.isLink() ) {
        if ( fe.stat_dest_lastmod() == m_lastmod &&
             fe.stat_dest_size() == m_lastsize ) return;
    } else {
        if ( fe.stat_lastmod() == m_lastmod &&
             fe.stat_size() == m_lastsize ) return;
    }

    std::ifstream ifile( m_filename.c_str() );
    std::string line;

    m_store.clear();
    
    if ( fe.isLink() ) {
        m_lastmod = fe.stat_dest_lastmod();
        m_lastsize = fe.stat_dest_size();
    } else {
        m_lastmod = fe.stat_lastmod();
        m_lastsize = fe.stat_size();
    }

    if ( ifile.is_open() ) {

        m_store.clear();

        while ( std::getline( ifile, line ) ) {
            m_store.storePath( line );
        }
    }
}

void PersDeepPathStore::write()
{
    std::ofstream ofile( m_filename.c_str() );
    std::list< std::string > l = m_store.getPaths();

    for ( std::list< std::string >::const_iterator it1 = l.begin();
          it1 != l.end();
          it1++ ) {
        ofile << *it1 << std::endl;
    }
    //TODO set lastsize and lastmod to avoid next read?
}
