# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.7
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.




"""
Python wrappers around the WiredTiger C API

This provides an API similar to the C API, with the following modifications:
  - Many C functions are exposed as OO methods. See the Python examples and test suite
  - Errors are handled in a Pythonic way; wrap calls in try/except blocks
  - Cursors have extra accessor methods and iterators that are higher-level than the C API
  - Statistics cursors behave a little differently and are best handled using the C-like functions
  - C Constants starting with WT_STAT_DSRC are instead exposed under wiredtiger.stat.dsrc
  - C Constants starting with WT_STAT_CONN are instead exposed under wiredtiger.stat.conn

"""


from sys import version_info
if version_info >= (3, 0, 0):
    new_instancemethod = lambda func, inst, cls: _wiredtiger.SWIG_PyInstanceMethod_New(func)
else:
    from new import instancemethod as new_instancemethod
if version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_wiredtiger', [dirname(__file__)])
        except ImportError:
            import _wiredtiger
            return _wiredtiger
        if fp is not None:
            try:
                _mod = imp.load_module('_wiredtiger', fp, pathname, description)
            finally:
                fp.close()
            return _mod
    _wiredtiger = swig_import_helper()
    del swig_import_helper
else:
    import _wiredtiger
del version_info
try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.


def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        object.__setattr__(self, name, value)
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr_nondynamic(self, class_type, name, static=1):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    if (not static):
        return object.__getattr__(self, name)
    else:
        raise AttributeError(name)

def _swig_getattr(self, class_type, name):
    return _swig_getattr_nondynamic(self, class_type, name, 0)


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except AttributeError:
    class _object:
        pass
    _newclass = 0



def _swig_setattr_nondynamic_method(set):
    def set_attr(self, name, value):
        if (name == "thisown"):
            return self.this.own(value)
        if hasattr(self, name) or (name == "this"):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add attributes to %s" % self)
    return set_attr



from packing import pack, unpack
## @endcond


WiredTigerError = _wiredtiger.WiredTigerError

## @cond DISABLE
# Implements the iterable contract
class IterableCursor:
	def __init__(self, cursor):
		self.cursor = cursor

	def __iter__(self):
		return self

	def next(self):
		if self.cursor.next() == WT_NOTFOUND:
			raise StopIteration
		return self.cursor.get_keys() + self.cursor.get_values()
## @endcond

# An abstract class, which must be subclassed with notify() overridden.
class AsyncCallback:
	def __init__(self):
		raise NotImplementedError

	def notify(self, op, op_ret, flags):
		raise NotImplementedError



def diagnostic_build():
    """diagnostic_build() -> int"""
    return _wiredtiger.diagnostic_build()

def verbose_build():
    """verbose_build() -> int"""
    return _wiredtiger.verbose_build()

_wiredtiger.WIREDTIGER_VERSION_MAJOR_swigconstant(_wiredtiger)
WIREDTIGER_VERSION_MAJOR = _wiredtiger.WIREDTIGER_VERSION_MAJOR

_wiredtiger.WIREDTIGER_VERSION_MINOR_swigconstant(_wiredtiger)
WIREDTIGER_VERSION_MINOR = _wiredtiger.WIREDTIGER_VERSION_MINOR

_wiredtiger.WIREDTIGER_VERSION_PATCH_swigconstant(_wiredtiger)
WIREDTIGER_VERSION_PATCH = _wiredtiger.WIREDTIGER_VERSION_PATCH

_wiredtiger.WIREDTIGER_VERSION_STRING_swigconstant(_wiredtiger)
WIREDTIGER_VERSION_STRING = _wiredtiger.WIREDTIGER_VERSION_STRING
class Modify(object):
    """Proxy of C __wt_modify struct"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def __init__(self, data = '', offset = 0, size = 0):
    	self.data = data
    	self.offset = offset
    	self.size = size

Modify_swigregister = _wiredtiger.Modify_swigregister
Modify_swigregister(Modify)

class Cursor(object):
    """Proxy of C __wt_cursor struct"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    session = _swig_property(_wiredtiger.Cursor_session_get)
    uri = _swig_property(_wiredtiger.Cursor_uri_get)

    def next(self, cursor):
        """next(self, cursor) -> int"""
        return _wiredtiger.Cursor_next(self, cursor)


    def prev(self, cursor):
        """prev(self, cursor) -> int"""
        return _wiredtiger.Cursor_prev(self, cursor)


    def reset(self, cursor):
        """reset(self, cursor) -> int"""
        return _wiredtiger.Cursor_reset(self, cursor)


    def search(self, cursor):
        """search(self, cursor) -> int"""
        return _wiredtiger.Cursor_search(self, cursor)


    def insert(self, cursor):
        """insert(self, cursor) -> int"""
        return _wiredtiger.Cursor_insert(self, cursor)


    def update(self, cursor):
        """update(self, cursor) -> int"""
        return _wiredtiger.Cursor_update(self, cursor)


    def remove(self, cursor):
        """remove(self, cursor) -> int"""
        return _wiredtiger.Cursor_remove(self, cursor)


    def reserve(self, cursor):
        """reserve(self, cursor) -> int"""
        return _wiredtiger.Cursor_reserve(self, cursor)


    def close(self, *args):
    	'''close(self, config) -> int

    	@copydoc __wt_cursor::close'''
    	try:
    		self._freecb()
    		return _wiredtiger.Cursor_close(self, *args)
    	finally:
    		self.this = None



    def reconfigure(self, *args):
        """reconfigure(self, cursor, config) -> int"""
        return _wiredtiger.Cursor_reconfigure(self, *args)


    def compare(self, *args):
    	'''compare (self, other) -> int

    	@copydoc class::compare'''
    	return self._compare(*args)


    def equals(self, *args):
    	'''equals (self, other) -> int

    	@copydoc class::equals'''
    	return self._equals(*args)


    def search_near(self, *args):
    	'''search_near (self) -> int

    	@copydoc class::search_near'''
    	return self._search_near(*args)


    def _set_key(self, data):
        """_set_key(self, data)"""
        return _wiredtiger.Cursor__set_key(self, data)


    def _set_key_str(self, str):
        """_set_key_str(self, str)"""
        return _wiredtiger.Cursor__set_key_str(self, str)


    def _set_recno(self, recno):
        """_set_recno(self, recno) -> int_void"""
        return _wiredtiger.Cursor__set_recno(self, recno)


    def _set_value(self, data):
        """_set_value(self, data)"""
        return _wiredtiger.Cursor__set_value(self, data)


    def _set_value_str(self, str):
        """_set_value_str(self, str)"""
        return _wiredtiger.Cursor__set_value_str(self, str)


    def _get_key(self):
        """_get_key(self) -> int_void"""
        return _wiredtiger.Cursor__get_key(self)


    def _get_json_key(self):
        """_get_json_key(self) -> int_void"""
        return _wiredtiger.Cursor__get_json_key(self)


    def _get_recno(self):
        """_get_recno(self) -> int_void"""
        return _wiredtiger.Cursor__get_recno(self)


    def _get_value(self):
        """_get_value(self) -> int_void"""
        return _wiredtiger.Cursor__get_value(self)


    def _get_json_value(self):
        """_get_json_value(self) -> int_void"""
        return _wiredtiger.Cursor__get_json_value(self)


    def _compare(self, other):
        """_compare(self, other) -> int"""
        return _wiredtiger.Cursor__compare(self, other)


    def _equals(self, other):
        """_equals(self, other) -> int"""
        return _wiredtiger.Cursor__equals(self, other)


    def _search_near(self):
        """_search_near(self) -> int"""
        return _wiredtiger.Cursor__search_near(self)


    def _freecb(self):
        """_freecb(self) -> int"""
        return _wiredtiger.Cursor__freecb(self)


    def modify(self, list):
        """modify(self, list) -> int"""
        return _wiredtiger.Cursor_modify(self, list)


    def get_key(self):
    	'''get_key(self) -> object

    	@copydoc WT_CURSOR::get_key
    	Returns only the first column.'''
    	k = self.get_keys()
    	if len(k) == 1:
    		return k[0]
    	return k

    def get_keys(self):
    	'''get_keys(self) -> (object, ...)

    	@copydoc WT_CURSOR::get_key'''
    	if self.is_json:
    		return [self._get_json_key()]
    	elif self.is_column:
    		return [self._get_recno(),]
    	else:
    		return unpack(self.key_format, self._get_key())

    def get_value(self):
    	'''get_value(self) -> object

    	@copydoc WT_CURSOR::get_value
    	Returns only the first column.'''
    	v = self.get_values()
    	if len(v) == 1:
    		return v[0]
    	return v

    def get_values(self):
    	'''get_values(self) -> (object, ...)

    	@copydoc WT_CURSOR::get_value'''
    	if self.is_json:
    		return [self._get_json_value()]
    	else:
    		return unpack(self.value_format, self._get_value())

    def set_key(self, *args):
    	'''set_key(self) -> None

    	@copydoc WT_CURSOR::set_key'''
    	if len(args) == 1 and type(args[0]) == tuple:
    		args = args[0]
    	if self.is_column:
    		self._set_recno(long(args[0]))
    	elif self.is_json:
    		self._set_key_str(args[0])
    	else:
    # Keep the Python string pinned
    		self._key = pack(self.key_format, *args)
    		self._set_key(self._key)

    def set_value(self, *args):
    	'''set_value(self) -> None

    	@copydoc WT_CURSOR::set_value'''
    	if self.is_json:
    		self._set_value_str(args[0])
    	else:
    		if len(args) == 1 and type(args[0]) == tuple:
    			args = args[0]
    # Keep the Python string pinned
    		self._value = pack(self.value_format, *args)
    		self._set_value(self._value)

    def __iter__(self):
    	'''Cursor objects support iteration, equivalent to calling
    	WT_CURSOR::next until it returns ::WT_NOTFOUND.'''
    	if not hasattr(self, '_iterable'):
    		self._iterable = IterableCursor(self)
    	return self._iterable

    def __delitem__(self, key):
    	'''Python convenience for removing'''
    	self.set_key(key)
    	if self.remove() != 0:
    		raise KeyError

    def __getitem__(self, key):
    	'''Python convenience for searching'''
    	self.set_key(key)
    	if self.search() != 0:
    		raise KeyError
    	return self.get_value()

    def __setitem__(self, key, value):
    	'''Python convenience for inserting'''
    	self.set_key(key)
    	self.set_value(value)
    	if self.insert() != 0:
    		raise KeyError

Cursor.next = new_instancemethod(_wiredtiger.Cursor_next, None, Cursor)
Cursor.prev = new_instancemethod(_wiredtiger.Cursor_prev, None, Cursor)
Cursor.reset = new_instancemethod(_wiredtiger.Cursor_reset, None, Cursor)
Cursor.search = new_instancemethod(_wiredtiger.Cursor_search, None, Cursor)
Cursor.insert = new_instancemethod(_wiredtiger.Cursor_insert, None, Cursor)
Cursor.update = new_instancemethod(_wiredtiger.Cursor_update, None, Cursor)
Cursor.remove = new_instancemethod(_wiredtiger.Cursor_remove, None, Cursor)
Cursor.reserve = new_instancemethod(_wiredtiger.Cursor_reserve, None, Cursor)
Cursor.reconfigure = new_instancemethod(_wiredtiger.Cursor_reconfigure, None, Cursor)
Cursor._set_key = new_instancemethod(_wiredtiger.Cursor__set_key, None, Cursor)
Cursor._set_key_str = new_instancemethod(_wiredtiger.Cursor__set_key_str, None, Cursor)
Cursor._set_recno = new_instancemethod(_wiredtiger.Cursor__set_recno, None, Cursor)
Cursor._set_value = new_instancemethod(_wiredtiger.Cursor__set_value, None, Cursor)
Cursor._set_value_str = new_instancemethod(_wiredtiger.Cursor__set_value_str, None, Cursor)
Cursor._get_key = new_instancemethod(_wiredtiger.Cursor__get_key, None, Cursor)
Cursor._get_json_key = new_instancemethod(_wiredtiger.Cursor__get_json_key, None, Cursor)
Cursor._get_recno = new_instancemethod(_wiredtiger.Cursor__get_recno, None, Cursor)
Cursor._get_value = new_instancemethod(_wiredtiger.Cursor__get_value, None, Cursor)
Cursor._get_json_value = new_instancemethod(_wiredtiger.Cursor__get_json_value, None, Cursor)
Cursor._compare = new_instancemethod(_wiredtiger.Cursor__compare, None, Cursor)
Cursor._equals = new_instancemethod(_wiredtiger.Cursor__equals, None, Cursor)
Cursor._search_near = new_instancemethod(_wiredtiger.Cursor__search_near, None, Cursor)
Cursor._freecb = new_instancemethod(_wiredtiger.Cursor__freecb, None, Cursor)
Cursor.modify = new_instancemethod(_wiredtiger.Cursor_modify, None, Cursor)
Cursor_swigregister = _wiredtiger.Cursor_swigregister
Cursor_swigregister(Cursor)


_wiredtiger.WT_AOP_NONE_swigconstant(_wiredtiger)
WT_AOP_NONE = _wiredtiger.WT_AOP_NONE

_wiredtiger.WT_AOP_COMPACT_swigconstant(_wiredtiger)
WT_AOP_COMPACT = _wiredtiger.WT_AOP_COMPACT

_wiredtiger.WT_AOP_INSERT_swigconstant(_wiredtiger)
WT_AOP_INSERT = _wiredtiger.WT_AOP_INSERT

_wiredtiger.WT_AOP_REMOVE_swigconstant(_wiredtiger)
WT_AOP_REMOVE = _wiredtiger.WT_AOP_REMOVE

_wiredtiger.WT_AOP_SEARCH_swigconstant(_wiredtiger)
WT_AOP_SEARCH = _wiredtiger.WT_AOP_SEARCH

_wiredtiger.WT_AOP_UPDATE_swigconstant(_wiredtiger)
WT_AOP_UPDATE = _wiredtiger.WT_AOP_UPDATE
class AsyncOp(object):
    """Proxy of C __wt_async_op struct"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    connection = _swig_property(_wiredtiger.AsyncOp_connection_get)

    def search(self, op):
        """search(self, op) -> int"""
        return _wiredtiger.AsyncOp_search(self, op)


    def insert(self, op):
        """insert(self, op) -> int"""
        return _wiredtiger.AsyncOp_insert(self, op)


    def update(self, op):
        """update(self, op) -> int"""
        return _wiredtiger.AsyncOp_update(self, op)


    def remove(self, op):
        """remove(self, op) -> int"""
        return _wiredtiger.AsyncOp_remove(self, op)


    def compact(self, op):
        """compact(self, op) -> int"""
        return _wiredtiger.AsyncOp_compact(self, op)


    def get_id(self, op):
        """get_id(self, op) -> uint64_t"""
        return _wiredtiger.AsyncOp_get_id(self, op)


    def get_type(self, op):
        """get_type(self, op) -> WT_ASYNC_OPTYPE"""
        return _wiredtiger.AsyncOp_get_type(self, op)


    def _set_key(self, data):
        """_set_key(self, data)"""
        return _wiredtiger.AsyncOp__set_key(self, data)


    def _set_recno(self, recno):
        """_set_recno(self, recno) -> int_void"""
        return _wiredtiger.AsyncOp__set_recno(self, recno)


    def _set_value(self, data):
        """_set_value(self, data)"""
        return _wiredtiger.AsyncOp__set_value(self, data)


    def _get_key(self):
        """_get_key(self) -> int_void"""
        return _wiredtiger.AsyncOp__get_key(self)


    def _get_recno(self):
        """_get_recno(self) -> int_void"""
        return _wiredtiger.AsyncOp__get_recno(self)


    def _get_value(self):
        """_get_value(self) -> int_void"""
        return _wiredtiger.AsyncOp__get_value(self)


    def _freecb(self):
        """_freecb(self) -> int"""
        return _wiredtiger.AsyncOp__freecb(self)


    def get_key(self):
    	'''get_key(self) -> object

    	@copydoc WT_ASYNC_OP::get_key
    	Returns only the first column.'''
    	k = self.get_keys()
    	if len(k) == 1:
    		return k[0]
    	return k

    def get_keys(self):
    	'''get_keys(self) -> (object, ...)

    	@copydoc WT_ASYNC_OP::get_key'''
    	if self.is_column:
    		return [self._get_recno(),]
    	else:
    		return unpack(self.key_format, self._get_key())

    def get_value(self):
    	'''get_value(self) -> object

    	@copydoc WT_ASYNC_OP::get_value
    	Returns only the first column.'''
    	v = self.get_values()
    	if len(v) == 1:
    		return v[0]
    	return v

    def get_values(self):
    	'''get_values(self) -> (object, ...)

    	@copydoc WT_ASYNC_OP::get_value'''
    	return unpack(self.value_format, self._get_value())

    def set_key(self, *args):
    	'''set_key(self) -> None

    	@copydoc WT_ASYNC_OP::set_key'''
    	if len(args) == 1 and type(args[0]) == tuple:
    		args = args[0]
    	if self.is_column:
    		self._set_recno(long(args[0]))
    	else:
    # Keep the Python string pinned
    		self._key = pack(self.key_format, *args)
    		self._set_key(self._key)

    def set_value(self, *args):
    	'''set_value(self) -> None

    	@copydoc WT_ASYNC_OP::set_value'''
    	if len(args) == 1 and type(args[0]) == tuple:
    		args = args[0]
    # Keep the Python string pinned
    	self._value = pack(self.value_format, *args)
    	self._set_value(self._value)

    def __getitem__(self, key):
    	'''Python convenience for searching'''
    	self.set_key(key)
    	if self.search() != 0:
    		raise KeyError
    	return self.get_value()

    def __setitem__(self, key, value):
    	'''Python convenience for inserting'''
    	self.set_key(key)
    	self.set_key(value)
    	self.insert()

AsyncOp.search = new_instancemethod(_wiredtiger.AsyncOp_search, None, AsyncOp)
AsyncOp.insert = new_instancemethod(_wiredtiger.AsyncOp_insert, None, AsyncOp)
AsyncOp.update = new_instancemethod(_wiredtiger.AsyncOp_update, None, AsyncOp)
AsyncOp.remove = new_instancemethod(_wiredtiger.AsyncOp_remove, None, AsyncOp)
AsyncOp.compact = new_instancemethod(_wiredtiger.AsyncOp_compact, None, AsyncOp)
AsyncOp.get_id = new_instancemethod(_wiredtiger.AsyncOp_get_id, None, AsyncOp)
AsyncOp.get_type = new_instancemethod(_wiredtiger.AsyncOp_get_type, None, AsyncOp)
AsyncOp._set_key = new_instancemethod(_wiredtiger.AsyncOp__set_key, None, AsyncOp)
AsyncOp._set_recno = new_instancemethod(_wiredtiger.AsyncOp__set_recno, None, AsyncOp)
AsyncOp._set_value = new_instancemethod(_wiredtiger.AsyncOp__set_value, None, AsyncOp)
AsyncOp._get_key = new_instancemethod(_wiredtiger.AsyncOp__get_key, None, AsyncOp)
AsyncOp._get_recno = new_instancemethod(_wiredtiger.AsyncOp__get_recno, None, AsyncOp)
AsyncOp._get_value = new_instancemethod(_wiredtiger.AsyncOp__get_value, None, AsyncOp)
AsyncOp._freecb = new_instancemethod(_wiredtiger.AsyncOp__freecb, None, AsyncOp)
AsyncOp_swigregister = _wiredtiger.AsyncOp_swigregister
AsyncOp_swigregister(AsyncOp)

class Session(object):
    """Proxy of C __wt_session struct"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    connection = _swig_property(_wiredtiger.Session_connection_get)

    def alter(self, *args):
        """alter(self, session, name, config) -> int"""
        return _wiredtiger.Session_alter(self, *args)


    def close(self, *args):
    	'''close(self, config) -> int

    	@copydoc __wt_session::close'''
    	try:
    		self._freecb()
    		return _wiredtiger.Session_close(self, *args)
    	finally:
    		self.this = None



    def reconfigure(self, *args):
        """reconfigure(self, session, config) -> int"""
        return _wiredtiger.Session_reconfigure(self, *args)


    def strerror(self, session, error):
        """strerror(self, session, error) -> char const *"""
        return _wiredtiger.Session_strerror(self, session, error)


    def open_cursor(self, *args):
        """open_cursor(self, session, uri, to_dup, config) -> int"""
        return _wiredtiger.Session_open_cursor(self, *args)


    def create(self, *args):
        """create(self, session, name, config) -> int"""
        return _wiredtiger.Session_create(self, *args)


    def compact(self, *args):
        """compact(self, session, name, config) -> int"""
        return _wiredtiger.Session_compact(self, *args)


    def drop(self, *args):
        """drop(self, session, name, config) -> int"""
        return _wiredtiger.Session_drop(self, *args)


    def join(self, *args):
        """join(self, session, join_cursor, ref_cursor, config) -> int"""
        return _wiredtiger.Session_join(self, *args)


    def log_flush(self, *args):
        """log_flush(self, session, config) -> int"""
        return _wiredtiger.Session_log_flush(self, *args)


    def rebalance(self, *args):
        """rebalance(self, session, uri, config) -> int"""
        return _wiredtiger.Session_rebalance(self, *args)


    def rename(self, *args):
        """rename(self, session, uri, newuri, config) -> int"""
        return _wiredtiger.Session_rename(self, *args)


    def reset(self, session):
        """reset(self, session) -> int"""
        return _wiredtiger.Session_reset(self, session)


    def salvage(self, *args):
        """salvage(self, session, name, config) -> int"""
        return _wiredtiger.Session_salvage(self, *args)


    def truncate(self, *args):
        """truncate(self, session, name, start, stop, config) -> int"""
        return _wiredtiger.Session_truncate(self, *args)


    def upgrade(self, *args):
        """upgrade(self, session, name, config) -> int"""
        return _wiredtiger.Session_upgrade(self, *args)


    def verify(self, *args):
        """verify(self, session, name, config) -> int"""
        return _wiredtiger.Session_verify(self, *args)


    def begin_transaction(self, *args):
        """begin_transaction(self, session, config) -> int"""
        return _wiredtiger.Session_begin_transaction(self, *args)


    def commit_transaction(self, *args):
        """commit_transaction(self, session, config) -> int"""
        return _wiredtiger.Session_commit_transaction(self, *args)


    def rollback_transaction(self, *args):
        """rollback_transaction(self, session, config) -> int"""
        return _wiredtiger.Session_rollback_transaction(self, *args)


    def checkpoint(self, *args):
        """checkpoint(self, session, config) -> int"""
        return _wiredtiger.Session_checkpoint(self, *args)


    def snapshot(self, *args):
        """snapshot(self, session, config) -> int"""
        return _wiredtiger.Session_snapshot(self, *args)


    def transaction_pinned_range(self, session, range):
        """transaction_pinned_range(self, session, range) -> int"""
        return _wiredtiger.Session_transaction_pinned_range(self, session, range)


    def transaction_sync(self, *args):
        """transaction_sync(self, session, config) -> int"""
        return _wiredtiger.Session_transaction_sync(self, *args)


    def _log_printf(self, msg):
        """_log_printf(self, msg) -> int"""
        return _wiredtiger.Session__log_printf(self, msg)


    def _freecb(self):
        """_freecb(self) -> int"""
        return _wiredtiger.Session__freecb(self)


    def log_printf(self, *args):
    	'''log_printf (self, msg) -> int

    	@copydoc class::log_printf'''
    	return self._log_printf(*args)

Session.alter = new_instancemethod(_wiredtiger.Session_alter, None, Session)
Session.reconfigure = new_instancemethod(_wiredtiger.Session_reconfigure, None, Session)
Session.strerror = new_instancemethod(_wiredtiger.Session_strerror, None, Session)
Session.open_cursor = new_instancemethod(_wiredtiger.Session_open_cursor, None, Session)
Session.create = new_instancemethod(_wiredtiger.Session_create, None, Session)
Session.compact = new_instancemethod(_wiredtiger.Session_compact, None, Session)
Session.drop = new_instancemethod(_wiredtiger.Session_drop, None, Session)
Session.join = new_instancemethod(_wiredtiger.Session_join, None, Session)
Session.log_flush = new_instancemethod(_wiredtiger.Session_log_flush, None, Session)
Session.rebalance = new_instancemethod(_wiredtiger.Session_rebalance, None, Session)
Session.rename = new_instancemethod(_wiredtiger.Session_rename, None, Session)
Session.reset = new_instancemethod(_wiredtiger.Session_reset, None, Session)
Session.salvage = new_instancemethod(_wiredtiger.Session_salvage, None, Session)
Session.truncate = new_instancemethod(_wiredtiger.Session_truncate, None, Session)
Session.upgrade = new_instancemethod(_wiredtiger.Session_upgrade, None, Session)
Session.verify = new_instancemethod(_wiredtiger.Session_verify, None, Session)
Session.begin_transaction = new_instancemethod(_wiredtiger.Session_begin_transaction, None, Session)
Session.commit_transaction = new_instancemethod(_wiredtiger.Session_commit_transaction, None, Session)
Session.rollback_transaction = new_instancemethod(_wiredtiger.Session_rollback_transaction, None, Session)
Session.checkpoint = new_instancemethod(_wiredtiger.Session_checkpoint, None, Session)
Session.snapshot = new_instancemethod(_wiredtiger.Session_snapshot, None, Session)
Session.transaction_pinned_range = new_instancemethod(_wiredtiger.Session_transaction_pinned_range, None, Session)
Session.transaction_sync = new_instancemethod(_wiredtiger.Session_transaction_sync, None, Session)
Session._log_printf = new_instancemethod(_wiredtiger.Session__log_printf, None, Session)
Session._freecb = new_instancemethod(_wiredtiger.Session__freecb, None, Session)
Session_swigregister = _wiredtiger.Session_swigregister
Session_swigregister(Session)

class Connection(object):
    """Proxy of C __wt_connection struct"""
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def async_flush(self, connection):
        """async_flush(self, connection) -> int"""
        return _wiredtiger.Connection_async_flush(self, connection)


    def async_new_op(self, *args):
        """async_new_op(self, connection, uri, config, callback) -> int"""
        return _wiredtiger.Connection_async_new_op(self, *args)


    def close(self, *args):
    	'''close(self, config) -> int

    	@copydoc __wt_connection::close'''
    	try:
    		self._freecb()
    		return _wiredtiger.Connection_close(self, *args)
    	finally:
    		self.this = None



    def reconfigure(self, *args):
        """reconfigure(self, connection, config) -> int"""
        return _wiredtiger.Connection_reconfigure(self, *args)


    def get_home(self, connection):
        """get_home(self, connection) -> char const *"""
        return _wiredtiger.Connection_get_home(self, connection)


    def configure_method(self, *args):
        """configure_method(self, connection, method, uri, config, type, check) -> int"""
        return _wiredtiger.Connection_configure_method(self, *args)


    def is_new(self, connection):
        """is_new(self, connection) -> int"""
        return _wiredtiger.Connection_is_new(self, connection)


    def open_session(self, *args):
        """open_session(self, connection, config) -> int"""
        return _wiredtiger.Connection_open_session(self, *args)


    def load_extension(self, *args):
        """load_extension(self, connection, path, config) -> int"""
        return _wiredtiger.Connection_load_extension(self, *args)


    def set_file_system(self, *args):
        """set_file_system(self, connection, fs, config) -> int"""
        return _wiredtiger.Connection_set_file_system(self, *args)


    def _freecb(self):
        """_freecb(self) -> int"""
        return _wiredtiger.Connection__freecb(self)

Connection.async_flush = new_instancemethod(_wiredtiger.Connection_async_flush, None, Connection)
Connection.async_new_op = new_instancemethod(_wiredtiger.Connection_async_new_op, None, Connection)
Connection.reconfigure = new_instancemethod(_wiredtiger.Connection_reconfigure, None, Connection)
Connection.get_home = new_instancemethod(_wiredtiger.Connection_get_home, None, Connection)
Connection.configure_method = new_instancemethod(_wiredtiger.Connection_configure_method, None, Connection)
Connection.is_new = new_instancemethod(_wiredtiger.Connection_is_new, None, Connection)
Connection.open_session = new_instancemethod(_wiredtiger.Connection_open_session, None, Connection)
Connection.load_extension = new_instancemethod(_wiredtiger.Connection_load_extension, None, Connection)
Connection.set_file_system = new_instancemethod(_wiredtiger.Connection_set_file_system, None, Connection)
Connection._freecb = new_instancemethod(_wiredtiger.Connection__freecb, None, Connection)
Connection_swigregister = _wiredtiger.Connection_swigregister
Connection_swigregister(Connection)


def wiredtiger_open(*args):
    """wiredtiger_open(home, config) -> int"""
    return _wiredtiger.wiredtiger_open(*args)

def wiredtiger_strerror(error):
    """wiredtiger_strerror(error) -> char const *"""
    return _wiredtiger.wiredtiger_strerror(error)

def wiredtiger_version():
    """wiredtiger_version() -> char const *"""
    return _wiredtiger.wiredtiger_version()

_wiredtiger.WT_ROLLBACK_swigconstant(_wiredtiger)
WT_ROLLBACK = _wiredtiger.WT_ROLLBACK

_wiredtiger.WT_DUPLICATE_KEY_swigconstant(_wiredtiger)
WT_DUPLICATE_KEY = _wiredtiger.WT_DUPLICATE_KEY

_wiredtiger.WT_ERROR_swigconstant(_wiredtiger)
WT_ERROR = _wiredtiger.WT_ERROR

_wiredtiger.WT_NOTFOUND_swigconstant(_wiredtiger)
WT_NOTFOUND = _wiredtiger.WT_NOTFOUND

_wiredtiger.WT_PANIC_swigconstant(_wiredtiger)
WT_PANIC = _wiredtiger.WT_PANIC

_wiredtiger.WT_RESTART_swigconstant(_wiredtiger)
WT_RESTART = _wiredtiger.WT_RESTART

_wiredtiger.WT_RUN_RECOVERY_swigconstant(_wiredtiger)
WT_RUN_RECOVERY = _wiredtiger.WT_RUN_RECOVERY

_wiredtiger.WT_CACHE_FULL_swigconstant(_wiredtiger)
WT_CACHE_FULL = _wiredtiger.WT_CACHE_FULL

_wiredtiger.WT_DEADLOCK_swigconstant(_wiredtiger)
WT_DEADLOCK = _wiredtiger.WT_DEADLOCK

_wiredtiger.WT_LOGREC_CHECKPOINT_swigconstant(_wiredtiger)
WT_LOGREC_CHECKPOINT = _wiredtiger.WT_LOGREC_CHECKPOINT

_wiredtiger.WT_LOGREC_COMMIT_swigconstant(_wiredtiger)
WT_LOGREC_COMMIT = _wiredtiger.WT_LOGREC_COMMIT

_wiredtiger.WT_LOGREC_FILE_SYNC_swigconstant(_wiredtiger)
WT_LOGREC_FILE_SYNC = _wiredtiger.WT_LOGREC_FILE_SYNC

_wiredtiger.WT_LOGREC_MESSAGE_swigconstant(_wiredtiger)
WT_LOGREC_MESSAGE = _wiredtiger.WT_LOGREC_MESSAGE

_wiredtiger.WT_LOGOP_INVALID_swigconstant(_wiredtiger)
WT_LOGOP_INVALID = _wiredtiger.WT_LOGOP_INVALID

_wiredtiger.WT_LOGOP_COL_PUT_swigconstant(_wiredtiger)
WT_LOGOP_COL_PUT = _wiredtiger.WT_LOGOP_COL_PUT

_wiredtiger.WT_LOGOP_COL_REMOVE_swigconstant(_wiredtiger)
WT_LOGOP_COL_REMOVE = _wiredtiger.WT_LOGOP_COL_REMOVE

_wiredtiger.WT_LOGOP_COL_TRUNCATE_swigconstant(_wiredtiger)
WT_LOGOP_COL_TRUNCATE = _wiredtiger.WT_LOGOP_COL_TRUNCATE

_wiredtiger.WT_LOGOP_ROW_PUT_swigconstant(_wiredtiger)
WT_LOGOP_ROW_PUT = _wiredtiger.WT_LOGOP_ROW_PUT

_wiredtiger.WT_LOGOP_ROW_REMOVE_swigconstant(_wiredtiger)
WT_LOGOP_ROW_REMOVE = _wiredtiger.WT_LOGOP_ROW_REMOVE

_wiredtiger.WT_LOGOP_ROW_TRUNCATE_swigconstant(_wiredtiger)
WT_LOGOP_ROW_TRUNCATE = _wiredtiger.WT_LOGOP_ROW_TRUNCATE

_wiredtiger.WT_STAT_CONN_LSM_WORK_QUEUE_APP_swigconstant(_wiredtiger)
WT_STAT_CONN_LSM_WORK_QUEUE_APP = _wiredtiger.WT_STAT_CONN_LSM_WORK_QUEUE_APP

_wiredtiger.WT_STAT_CONN_LSM_WORK_QUEUE_MANAGER_swigconstant(_wiredtiger)
WT_STAT_CONN_LSM_WORK_QUEUE_MANAGER = _wiredtiger.WT_STAT_CONN_LSM_WORK_QUEUE_MANAGER

_wiredtiger.WT_STAT_CONN_LSM_ROWS_MERGED_swigconstant(_wiredtiger)
WT_STAT_CONN_LSM_ROWS_MERGED = _wiredtiger.WT_STAT_CONN_LSM_ROWS_MERGED

_wiredtiger.WT_STAT_CONN_LSM_CHECKPOINT_THROTTLE_swigconstant(_wiredtiger)
WT_STAT_CONN_LSM_CHECKPOINT_THROTTLE = _wiredtiger.WT_STAT_CONN_LSM_CHECKPOINT_THROTTLE

_wiredtiger.WT_STAT_CONN_LSM_MERGE_THROTTLE_swigconstant(_wiredtiger)
WT_STAT_CONN_LSM_MERGE_THROTTLE = _wiredtiger.WT_STAT_CONN_LSM_MERGE_THROTTLE

_wiredtiger.WT_STAT_CONN_LSM_WORK_QUEUE_SWITCH_swigconstant(_wiredtiger)
WT_STAT_CONN_LSM_WORK_QUEUE_SWITCH = _wiredtiger.WT_STAT_CONN_LSM_WORK_QUEUE_SWITCH

_wiredtiger.WT_STAT_CONN_LSM_WORK_UNITS_DISCARDED_swigconstant(_wiredtiger)
WT_STAT_CONN_LSM_WORK_UNITS_DISCARDED = _wiredtiger.WT_STAT_CONN_LSM_WORK_UNITS_DISCARDED

_wiredtiger.WT_STAT_CONN_LSM_WORK_UNITS_DONE_swigconstant(_wiredtiger)
WT_STAT_CONN_LSM_WORK_UNITS_DONE = _wiredtiger.WT_STAT_CONN_LSM_WORK_UNITS_DONE

_wiredtiger.WT_STAT_CONN_LSM_WORK_UNITS_CREATED_swigconstant(_wiredtiger)
WT_STAT_CONN_LSM_WORK_UNITS_CREATED = _wiredtiger.WT_STAT_CONN_LSM_WORK_UNITS_CREATED

_wiredtiger.WT_STAT_CONN_LSM_WORK_QUEUE_MAX_swigconstant(_wiredtiger)
WT_STAT_CONN_LSM_WORK_QUEUE_MAX = _wiredtiger.WT_STAT_CONN_LSM_WORK_QUEUE_MAX

_wiredtiger.WT_STAT_CONN_ASYNC_CUR_QUEUE_swigconstant(_wiredtiger)
WT_STAT_CONN_ASYNC_CUR_QUEUE = _wiredtiger.WT_STAT_CONN_ASYNC_CUR_QUEUE

_wiredtiger.WT_STAT_CONN_ASYNC_MAX_QUEUE_swigconstant(_wiredtiger)
WT_STAT_CONN_ASYNC_MAX_QUEUE = _wiredtiger.WT_STAT_CONN_ASYNC_MAX_QUEUE

_wiredtiger.WT_STAT_CONN_ASYNC_ALLOC_RACE_swigconstant(_wiredtiger)
WT_STAT_CONN_ASYNC_ALLOC_RACE = _wiredtiger.WT_STAT_CONN_ASYNC_ALLOC_RACE

_wiredtiger.WT_STAT_CONN_ASYNC_FLUSH_swigconstant(_wiredtiger)
WT_STAT_CONN_ASYNC_FLUSH = _wiredtiger.WT_STAT_CONN_ASYNC_FLUSH

_wiredtiger.WT_STAT_CONN_ASYNC_ALLOC_VIEW_swigconstant(_wiredtiger)
WT_STAT_CONN_ASYNC_ALLOC_VIEW = _wiredtiger.WT_STAT_CONN_ASYNC_ALLOC_VIEW

_wiredtiger.WT_STAT_CONN_ASYNC_FULL_swigconstant(_wiredtiger)
WT_STAT_CONN_ASYNC_FULL = _wiredtiger.WT_STAT_CONN_ASYNC_FULL

_wiredtiger.WT_STAT_CONN_ASYNC_NOWORK_swigconstant(_wiredtiger)
WT_STAT_CONN_ASYNC_NOWORK = _wiredtiger.WT_STAT_CONN_ASYNC_NOWORK

_wiredtiger.WT_STAT_CONN_ASYNC_OP_ALLOC_swigconstant(_wiredtiger)
WT_STAT_CONN_ASYNC_OP_ALLOC = _wiredtiger.WT_STAT_CONN_ASYNC_OP_ALLOC

_wiredtiger.WT_STAT_CONN_ASYNC_OP_COMPACT_swigconstant(_wiredtiger)
WT_STAT_CONN_ASYNC_OP_COMPACT = _wiredtiger.WT_STAT_CONN_ASYNC_OP_COMPACT

_wiredtiger.WT_STAT_CONN_ASYNC_OP_INSERT_swigconstant(_wiredtiger)
WT_STAT_CONN_ASYNC_OP_INSERT = _wiredtiger.WT_STAT_CONN_ASYNC_OP_INSERT

_wiredtiger.WT_STAT_CONN_ASYNC_OP_REMOVE_swigconstant(_wiredtiger)
WT_STAT_CONN_ASYNC_OP_REMOVE = _wiredtiger.WT_STAT_CONN_ASYNC_OP_REMOVE

_wiredtiger.WT_STAT_CONN_ASYNC_OP_SEARCH_swigconstant(_wiredtiger)
WT_STAT_CONN_ASYNC_OP_SEARCH = _wiredtiger.WT_STAT_CONN_ASYNC_OP_SEARCH

_wiredtiger.WT_STAT_CONN_ASYNC_OP_UPDATE_swigconstant(_wiredtiger)
WT_STAT_CONN_ASYNC_OP_UPDATE = _wiredtiger.WT_STAT_CONN_ASYNC_OP_UPDATE

_wiredtiger.WT_STAT_CONN_BLOCK_PRELOAD_swigconstant(_wiredtiger)
WT_STAT_CONN_BLOCK_PRELOAD = _wiredtiger.WT_STAT_CONN_BLOCK_PRELOAD

_wiredtiger.WT_STAT_CONN_BLOCK_READ_swigconstant(_wiredtiger)
WT_STAT_CONN_BLOCK_READ = _wiredtiger.WT_STAT_CONN_BLOCK_READ

_wiredtiger.WT_STAT_CONN_BLOCK_WRITE_swigconstant(_wiredtiger)
WT_STAT_CONN_BLOCK_WRITE = _wiredtiger.WT_STAT_CONN_BLOCK_WRITE

_wiredtiger.WT_STAT_CONN_BLOCK_BYTE_READ_swigconstant(_wiredtiger)
WT_STAT_CONN_BLOCK_BYTE_READ = _wiredtiger.WT_STAT_CONN_BLOCK_BYTE_READ

_wiredtiger.WT_STAT_CONN_BLOCK_BYTE_WRITE_swigconstant(_wiredtiger)
WT_STAT_CONN_BLOCK_BYTE_WRITE = _wiredtiger.WT_STAT_CONN_BLOCK_BYTE_WRITE

_wiredtiger.WT_STAT_CONN_BLOCK_BYTE_WRITE_CHECKPOINT_swigconstant(_wiredtiger)
WT_STAT_CONN_BLOCK_BYTE_WRITE_CHECKPOINT = _wiredtiger.WT_STAT_CONN_BLOCK_BYTE_WRITE_CHECKPOINT

_wiredtiger.WT_STAT_CONN_BLOCK_MAP_READ_swigconstant(_wiredtiger)
WT_STAT_CONN_BLOCK_MAP_READ = _wiredtiger.WT_STAT_CONN_BLOCK_MAP_READ

_wiredtiger.WT_STAT_CONN_BLOCK_BYTE_MAP_READ_swigconstant(_wiredtiger)
WT_STAT_CONN_BLOCK_BYTE_MAP_READ = _wiredtiger.WT_STAT_CONN_BLOCK_BYTE_MAP_READ

_wiredtiger.WT_STAT_CONN_CACHE_READ_APP_COUNT_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_READ_APP_COUNT = _wiredtiger.WT_STAT_CONN_CACHE_READ_APP_COUNT

_wiredtiger.WT_STAT_CONN_CACHE_READ_APP_TIME_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_READ_APP_TIME = _wiredtiger.WT_STAT_CONN_CACHE_READ_APP_TIME

_wiredtiger.WT_STAT_CONN_CACHE_WRITE_APP_COUNT_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_WRITE_APP_COUNT = _wiredtiger.WT_STAT_CONN_CACHE_WRITE_APP_COUNT

_wiredtiger.WT_STAT_CONN_CACHE_WRITE_APP_TIME_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_WRITE_APP_TIME = _wiredtiger.WT_STAT_CONN_CACHE_WRITE_APP_TIME

_wiredtiger.WT_STAT_CONN_CACHE_BYTES_IMAGE_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_BYTES_IMAGE = _wiredtiger.WT_STAT_CONN_CACHE_BYTES_IMAGE

_wiredtiger.WT_STAT_CONN_CACHE_BYTES_INUSE_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_BYTES_INUSE = _wiredtiger.WT_STAT_CONN_CACHE_BYTES_INUSE

_wiredtiger.WT_STAT_CONN_CACHE_BYTES_OTHER_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_BYTES_OTHER = _wiredtiger.WT_STAT_CONN_CACHE_BYTES_OTHER

_wiredtiger.WT_STAT_CONN_CACHE_BYTES_READ_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_BYTES_READ = _wiredtiger.WT_STAT_CONN_CACHE_BYTES_READ

_wiredtiger.WT_STAT_CONN_CACHE_BYTES_WRITE_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_BYTES_WRITE = _wiredtiger.WT_STAT_CONN_CACHE_BYTES_WRITE

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_CHECKPOINT_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_CHECKPOINT = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_CHECKPOINT

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_GET_REF_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_GET_REF = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_GET_REF

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_GET_REF_EMPTY_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_GET_REF_EMPTY = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_GET_REF_EMPTY

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_GET_REF_EMPTY2_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_GET_REF_EMPTY2 = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_GET_REF_EMPTY2

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_AGGRESSIVE_SET_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_AGGRESSIVE_SET = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_AGGRESSIVE_SET

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_EMPTY_SCORE_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_EMPTY_SCORE = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_EMPTY_SCORE

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_QUEUE_EMPTY_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_QUEUE_EMPTY = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_QUEUE_EMPTY

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_QUEUE_NOT_EMPTY_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_QUEUE_NOT_EMPTY = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_QUEUE_NOT_EMPTY

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_SERVER_EVICTING_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_SERVER_EVICTING = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_SERVER_EVICTING

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_SERVER_SLEPT_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_SERVER_SLEPT = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_SERVER_SLEPT

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_SLOW_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_SLOW = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_SLOW

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_STATE_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_STATE = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_STATE

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_WALKS_ABANDONED_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_WALKS_ABANDONED = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_WALKS_ABANDONED

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_ACTIVE_WORKERS_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_ACTIVE_WORKERS = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_ACTIVE_WORKERS

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_WORKER_CREATED_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_WORKER_CREATED = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_WORKER_CREATED

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_WORKER_EVICTING_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_WORKER_EVICTING = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_WORKER_EVICTING

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_WORKER_REMOVED_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_WORKER_REMOVED = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_WORKER_REMOVED

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_STABLE_STATE_WORKERS_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_STABLE_STATE_WORKERS = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_STABLE_STATE_WORKERS

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_FORCE_FAIL_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_FORCE_FAIL = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_FORCE_FAIL

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_FORCE_FAIL_TIME_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_FORCE_FAIL_TIME = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_FORCE_FAIL_TIME

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_WALKS_ACTIVE_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_WALKS_ACTIVE = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_WALKS_ACTIVE

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_WALKS_STARTED_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_WALKS_STARTED = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_WALKS_STARTED

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_FORCE_RETUNE_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_FORCE_RETUNE = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_FORCE_RETUNE

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_HAZARD_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_HAZARD = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_HAZARD

_wiredtiger.WT_STAT_CONN_CACHE_HAZARD_CHECKS_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_HAZARD_CHECKS = _wiredtiger.WT_STAT_CONN_CACHE_HAZARD_CHECKS

_wiredtiger.WT_STAT_CONN_CACHE_HAZARD_WALKS_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_HAZARD_WALKS = _wiredtiger.WT_STAT_CONN_CACHE_HAZARD_WALKS

_wiredtiger.WT_STAT_CONN_CACHE_HAZARD_MAX_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_HAZARD_MAX = _wiredtiger.WT_STAT_CONN_CACHE_HAZARD_MAX

_wiredtiger.WT_STAT_CONN_CACHE_INMEM_SPLITTABLE_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_INMEM_SPLITTABLE = _wiredtiger.WT_STAT_CONN_CACHE_INMEM_SPLITTABLE

_wiredtiger.WT_STAT_CONN_CACHE_INMEM_SPLIT_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_INMEM_SPLIT = _wiredtiger.WT_STAT_CONN_CACHE_INMEM_SPLIT

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_INTERNAL_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_INTERNAL = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_INTERNAL

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_SPLIT_INTERNAL_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_SPLIT_INTERNAL = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_SPLIT_INTERNAL

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_SPLIT_LEAF_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_SPLIT_LEAF = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_SPLIT_LEAF

_wiredtiger.WT_STAT_CONN_CACHE_LOOKASIDE_INSERT_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_LOOKASIDE_INSERT = _wiredtiger.WT_STAT_CONN_CACHE_LOOKASIDE_INSERT

_wiredtiger.WT_STAT_CONN_CACHE_LOOKASIDE_REMOVE_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_LOOKASIDE_REMOVE = _wiredtiger.WT_STAT_CONN_CACHE_LOOKASIDE_REMOVE

_wiredtiger.WT_STAT_CONN_CACHE_BYTES_MAX_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_BYTES_MAX = _wiredtiger.WT_STAT_CONN_CACHE_BYTES_MAX

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_MAXIMUM_PAGE_SIZE_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_MAXIMUM_PAGE_SIZE = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_MAXIMUM_PAGE_SIZE

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_DIRTY_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_DIRTY = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_DIRTY

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_APP_DIRTY_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_APP_DIRTY = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_APP_DIRTY

_wiredtiger.WT_STAT_CONN_CACHE_READ_OVERFLOW_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_READ_OVERFLOW = _wiredtiger.WT_STAT_CONN_CACHE_READ_OVERFLOW

_wiredtiger.WT_STAT_CONN_CACHE_OVERFLOW_VALUE_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_OVERFLOW_VALUE = _wiredtiger.WT_STAT_CONN_CACHE_OVERFLOW_VALUE

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_DEEPEN_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_DEEPEN = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_DEEPEN

_wiredtiger.WT_STAT_CONN_CACHE_WRITE_LOOKASIDE_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_WRITE_LOOKASIDE = _wiredtiger.WT_STAT_CONN_CACHE_WRITE_LOOKASIDE

_wiredtiger.WT_STAT_CONN_CACHE_PAGES_INUSE_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_PAGES_INUSE = _wiredtiger.WT_STAT_CONN_CACHE_PAGES_INUSE

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_FORCE_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_FORCE = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_FORCE

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_FORCE_TIME_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_FORCE_TIME = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_FORCE_TIME

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_FORCE_DELETE_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_FORCE_DELETE = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_FORCE_DELETE

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_FORCE_DELETE_TIME_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_FORCE_DELETE_TIME = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_FORCE_DELETE_TIME

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_APP_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_APP = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_APP

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_PAGES_QUEUED_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_PAGES_QUEUED = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_PAGES_QUEUED

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_PAGES_QUEUED_URGENT_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_PAGES_QUEUED_URGENT = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_PAGES_QUEUED_URGENT

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_PAGES_QUEUED_OLDEST_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_PAGES_QUEUED_OLDEST = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_PAGES_QUEUED_OLDEST

_wiredtiger.WT_STAT_CONN_CACHE_READ_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_READ = _wiredtiger.WT_STAT_CONN_CACHE_READ

_wiredtiger.WT_STAT_CONN_CACHE_READ_LOOKASIDE_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_READ_LOOKASIDE = _wiredtiger.WT_STAT_CONN_CACHE_READ_LOOKASIDE

_wiredtiger.WT_STAT_CONN_CACHE_PAGES_REQUESTED_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_PAGES_REQUESTED = _wiredtiger.WT_STAT_CONN_CACHE_PAGES_REQUESTED

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_PAGES_SEEN_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_PAGES_SEEN = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_PAGES_SEEN

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_FAIL_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_FAIL = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_FAIL

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_WALK_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_WALK = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_WALK

_wiredtiger.WT_STAT_CONN_CACHE_WRITE_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_WRITE = _wiredtiger.WT_STAT_CONN_CACHE_WRITE

_wiredtiger.WT_STAT_CONN_CACHE_WRITE_RESTORE_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_WRITE_RESTORE = _wiredtiger.WT_STAT_CONN_CACHE_WRITE_RESTORE

_wiredtiger.WT_STAT_CONN_CACHE_OVERHEAD_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_OVERHEAD = _wiredtiger.WT_STAT_CONN_CACHE_OVERHEAD

_wiredtiger.WT_STAT_CONN_CACHE_BYTES_INTERNAL_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_BYTES_INTERNAL = _wiredtiger.WT_STAT_CONN_CACHE_BYTES_INTERNAL

_wiredtiger.WT_STAT_CONN_CACHE_BYTES_LEAF_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_BYTES_LEAF = _wiredtiger.WT_STAT_CONN_CACHE_BYTES_LEAF

_wiredtiger.WT_STAT_CONN_CACHE_BYTES_DIRTY_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_BYTES_DIRTY = _wiredtiger.WT_STAT_CONN_CACHE_BYTES_DIRTY

_wiredtiger.WT_STAT_CONN_CACHE_PAGES_DIRTY_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_PAGES_DIRTY = _wiredtiger.WT_STAT_CONN_CACHE_PAGES_DIRTY

_wiredtiger.WT_STAT_CONN_CACHE_EVICTION_CLEAN_swigconstant(_wiredtiger)
WT_STAT_CONN_CACHE_EVICTION_CLEAN = _wiredtiger.WT_STAT_CONN_CACHE_EVICTION_CLEAN

_wiredtiger.WT_STAT_CONN_COND_AUTO_WAIT_RESET_swigconstant(_wiredtiger)
WT_STAT_CONN_COND_AUTO_WAIT_RESET = _wiredtiger.WT_STAT_CONN_COND_AUTO_WAIT_RESET

_wiredtiger.WT_STAT_CONN_COND_AUTO_WAIT_swigconstant(_wiredtiger)
WT_STAT_CONN_COND_AUTO_WAIT = _wiredtiger.WT_STAT_CONN_COND_AUTO_WAIT

_wiredtiger.WT_STAT_CONN_TIME_TRAVEL_swigconstant(_wiredtiger)
WT_STAT_CONN_TIME_TRAVEL = _wiredtiger.WT_STAT_CONN_TIME_TRAVEL

_wiredtiger.WT_STAT_CONN_FILE_OPEN_swigconstant(_wiredtiger)
WT_STAT_CONN_FILE_OPEN = _wiredtiger.WT_STAT_CONN_FILE_OPEN

_wiredtiger.WT_STAT_CONN_MEMORY_ALLOCATION_swigconstant(_wiredtiger)
WT_STAT_CONN_MEMORY_ALLOCATION = _wiredtiger.WT_STAT_CONN_MEMORY_ALLOCATION

_wiredtiger.WT_STAT_CONN_MEMORY_FREE_swigconstant(_wiredtiger)
WT_STAT_CONN_MEMORY_FREE = _wiredtiger.WT_STAT_CONN_MEMORY_FREE

_wiredtiger.WT_STAT_CONN_MEMORY_GROW_swigconstant(_wiredtiger)
WT_STAT_CONN_MEMORY_GROW = _wiredtiger.WT_STAT_CONN_MEMORY_GROW

_wiredtiger.WT_STAT_CONN_COND_WAIT_swigconstant(_wiredtiger)
WT_STAT_CONN_COND_WAIT = _wiredtiger.WT_STAT_CONN_COND_WAIT

_wiredtiger.WT_STAT_CONN_RWLOCK_READ_swigconstant(_wiredtiger)
WT_STAT_CONN_RWLOCK_READ = _wiredtiger.WT_STAT_CONN_RWLOCK_READ

_wiredtiger.WT_STAT_CONN_RWLOCK_WRITE_swigconstant(_wiredtiger)
WT_STAT_CONN_RWLOCK_WRITE = _wiredtiger.WT_STAT_CONN_RWLOCK_WRITE

_wiredtiger.WT_STAT_CONN_FSYNC_IO_swigconstant(_wiredtiger)
WT_STAT_CONN_FSYNC_IO = _wiredtiger.WT_STAT_CONN_FSYNC_IO

_wiredtiger.WT_STAT_CONN_READ_IO_swigconstant(_wiredtiger)
WT_STAT_CONN_READ_IO = _wiredtiger.WT_STAT_CONN_READ_IO

_wiredtiger.WT_STAT_CONN_WRITE_IO_swigconstant(_wiredtiger)
WT_STAT_CONN_WRITE_IO = _wiredtiger.WT_STAT_CONN_WRITE_IO

_wiredtiger.WT_STAT_CONN_CURSOR_CREATE_swigconstant(_wiredtiger)
WT_STAT_CONN_CURSOR_CREATE = _wiredtiger.WT_STAT_CONN_CURSOR_CREATE

_wiredtiger.WT_STAT_CONN_CURSOR_INSERT_swigconstant(_wiredtiger)
WT_STAT_CONN_CURSOR_INSERT = _wiredtiger.WT_STAT_CONN_CURSOR_INSERT

_wiredtiger.WT_STAT_CONN_CURSOR_MODIFY_swigconstant(_wiredtiger)
WT_STAT_CONN_CURSOR_MODIFY = _wiredtiger.WT_STAT_CONN_CURSOR_MODIFY

_wiredtiger.WT_STAT_CONN_CURSOR_NEXT_swigconstant(_wiredtiger)
WT_STAT_CONN_CURSOR_NEXT = _wiredtiger.WT_STAT_CONN_CURSOR_NEXT

_wiredtiger.WT_STAT_CONN_CURSOR_PREV_swigconstant(_wiredtiger)
WT_STAT_CONN_CURSOR_PREV = _wiredtiger.WT_STAT_CONN_CURSOR_PREV

_wiredtiger.WT_STAT_CONN_CURSOR_REMOVE_swigconstant(_wiredtiger)
WT_STAT_CONN_CURSOR_REMOVE = _wiredtiger.WT_STAT_CONN_CURSOR_REMOVE

_wiredtiger.WT_STAT_CONN_CURSOR_RESERVE_swigconstant(_wiredtiger)
WT_STAT_CONN_CURSOR_RESERVE = _wiredtiger.WT_STAT_CONN_CURSOR_RESERVE

_wiredtiger.WT_STAT_CONN_CURSOR_RESET_swigconstant(_wiredtiger)
WT_STAT_CONN_CURSOR_RESET = _wiredtiger.WT_STAT_CONN_CURSOR_RESET

_wiredtiger.WT_STAT_CONN_CURSOR_RESTART_swigconstant(_wiredtiger)
WT_STAT_CONN_CURSOR_RESTART = _wiredtiger.WT_STAT_CONN_CURSOR_RESTART

_wiredtiger.WT_STAT_CONN_CURSOR_SEARCH_swigconstant(_wiredtiger)
WT_STAT_CONN_CURSOR_SEARCH = _wiredtiger.WT_STAT_CONN_CURSOR_SEARCH

_wiredtiger.WT_STAT_CONN_CURSOR_SEARCH_NEAR_swigconstant(_wiredtiger)
WT_STAT_CONN_CURSOR_SEARCH_NEAR = _wiredtiger.WT_STAT_CONN_CURSOR_SEARCH_NEAR

_wiredtiger.WT_STAT_CONN_CURSOR_UPDATE_swigconstant(_wiredtiger)
WT_STAT_CONN_CURSOR_UPDATE = _wiredtiger.WT_STAT_CONN_CURSOR_UPDATE

_wiredtiger.WT_STAT_CONN_CURSOR_TRUNCATE_swigconstant(_wiredtiger)
WT_STAT_CONN_CURSOR_TRUNCATE = _wiredtiger.WT_STAT_CONN_CURSOR_TRUNCATE

_wiredtiger.WT_STAT_CONN_DH_CONN_HANDLE_COUNT_swigconstant(_wiredtiger)
WT_STAT_CONN_DH_CONN_HANDLE_COUNT = _wiredtiger.WT_STAT_CONN_DH_CONN_HANDLE_COUNT

_wiredtiger.WT_STAT_CONN_DH_SWEEP_REF_swigconstant(_wiredtiger)
WT_STAT_CONN_DH_SWEEP_REF = _wiredtiger.WT_STAT_CONN_DH_SWEEP_REF

_wiredtiger.WT_STAT_CONN_DH_SWEEP_CLOSE_swigconstant(_wiredtiger)
WT_STAT_CONN_DH_SWEEP_CLOSE = _wiredtiger.WT_STAT_CONN_DH_SWEEP_CLOSE

_wiredtiger.WT_STAT_CONN_DH_SWEEP_REMOVE_swigconstant(_wiredtiger)
WT_STAT_CONN_DH_SWEEP_REMOVE = _wiredtiger.WT_STAT_CONN_DH_SWEEP_REMOVE

_wiredtiger.WT_STAT_CONN_DH_SWEEP_TOD_swigconstant(_wiredtiger)
WT_STAT_CONN_DH_SWEEP_TOD = _wiredtiger.WT_STAT_CONN_DH_SWEEP_TOD

_wiredtiger.WT_STAT_CONN_DH_SWEEPS_swigconstant(_wiredtiger)
WT_STAT_CONN_DH_SWEEPS = _wiredtiger.WT_STAT_CONN_DH_SWEEPS

_wiredtiger.WT_STAT_CONN_DH_SESSION_HANDLES_swigconstant(_wiredtiger)
WT_STAT_CONN_DH_SESSION_HANDLES = _wiredtiger.WT_STAT_CONN_DH_SESSION_HANDLES

_wiredtiger.WT_STAT_CONN_DH_SESSION_SWEEPS_swigconstant(_wiredtiger)
WT_STAT_CONN_DH_SESSION_SWEEPS = _wiredtiger.WT_STAT_CONN_DH_SESSION_SWEEPS

_wiredtiger.WT_STAT_CONN_LOCK_CHECKPOINT_COUNT_swigconstant(_wiredtiger)
WT_STAT_CONN_LOCK_CHECKPOINT_COUNT = _wiredtiger.WT_STAT_CONN_LOCK_CHECKPOINT_COUNT

_wiredtiger.WT_STAT_CONN_LOCK_CHECKPOINT_WAIT_APPLICATION_swigconstant(_wiredtiger)
WT_STAT_CONN_LOCK_CHECKPOINT_WAIT_APPLICATION = _wiredtiger.WT_STAT_CONN_LOCK_CHECKPOINT_WAIT_APPLICATION

_wiredtiger.WT_STAT_CONN_LOCK_CHECKPOINT_WAIT_INTERNAL_swigconstant(_wiredtiger)
WT_STAT_CONN_LOCK_CHECKPOINT_WAIT_INTERNAL = _wiredtiger.WT_STAT_CONN_LOCK_CHECKPOINT_WAIT_INTERNAL

_wiredtiger.WT_STAT_CONN_LOCK_DHANDLE_WAIT_APPLICATION_swigconstant(_wiredtiger)
WT_STAT_CONN_LOCK_DHANDLE_WAIT_APPLICATION = _wiredtiger.WT_STAT_CONN_LOCK_DHANDLE_WAIT_APPLICATION

_wiredtiger.WT_STAT_CONN_LOCK_DHANDLE_WAIT_INTERNAL_swigconstant(_wiredtiger)
WT_STAT_CONN_LOCK_DHANDLE_WAIT_INTERNAL = _wiredtiger.WT_STAT_CONN_LOCK_DHANDLE_WAIT_INTERNAL

_wiredtiger.WT_STAT_CONN_LOCK_DHANDLE_READ_COUNT_swigconstant(_wiredtiger)
WT_STAT_CONN_LOCK_DHANDLE_READ_COUNT = _wiredtiger.WT_STAT_CONN_LOCK_DHANDLE_READ_COUNT

_wiredtiger.WT_STAT_CONN_LOCK_DHANDLE_WRITE_COUNT_swigconstant(_wiredtiger)
WT_STAT_CONN_LOCK_DHANDLE_WRITE_COUNT = _wiredtiger.WT_STAT_CONN_LOCK_DHANDLE_WRITE_COUNT

_wiredtiger.WT_STAT_CONN_LOCK_METADATA_COUNT_swigconstant(_wiredtiger)
WT_STAT_CONN_LOCK_METADATA_COUNT = _wiredtiger.WT_STAT_CONN_LOCK_METADATA_COUNT

_wiredtiger.WT_STAT_CONN_LOCK_METADATA_WAIT_APPLICATION_swigconstant(_wiredtiger)
WT_STAT_CONN_LOCK_METADATA_WAIT_APPLICATION = _wiredtiger.WT_STAT_CONN_LOCK_METADATA_WAIT_APPLICATION

_wiredtiger.WT_STAT_CONN_LOCK_METADATA_WAIT_INTERNAL_swigconstant(_wiredtiger)
WT_STAT_CONN_LOCK_METADATA_WAIT_INTERNAL = _wiredtiger.WT_STAT_CONN_LOCK_METADATA_WAIT_INTERNAL

_wiredtiger.WT_STAT_CONN_LOCK_SCHEMA_COUNT_swigconstant(_wiredtiger)
WT_STAT_CONN_LOCK_SCHEMA_COUNT = _wiredtiger.WT_STAT_CONN_LOCK_SCHEMA_COUNT

_wiredtiger.WT_STAT_CONN_LOCK_SCHEMA_WAIT_APPLICATION_swigconstant(_wiredtiger)
WT_STAT_CONN_LOCK_SCHEMA_WAIT_APPLICATION = _wiredtiger.WT_STAT_CONN_LOCK_SCHEMA_WAIT_APPLICATION

_wiredtiger.WT_STAT_CONN_LOCK_SCHEMA_WAIT_INTERNAL_swigconstant(_wiredtiger)
WT_STAT_CONN_LOCK_SCHEMA_WAIT_INTERNAL = _wiredtiger.WT_STAT_CONN_LOCK_SCHEMA_WAIT_INTERNAL

_wiredtiger.WT_STAT_CONN_LOCK_TABLE_WAIT_APPLICATION_swigconstant(_wiredtiger)
WT_STAT_CONN_LOCK_TABLE_WAIT_APPLICATION = _wiredtiger.WT_STAT_CONN_LOCK_TABLE_WAIT_APPLICATION

_wiredtiger.WT_STAT_CONN_LOCK_TABLE_WAIT_INTERNAL_swigconstant(_wiredtiger)
WT_STAT_CONN_LOCK_TABLE_WAIT_INTERNAL = _wiredtiger.WT_STAT_CONN_LOCK_TABLE_WAIT_INTERNAL

_wiredtiger.WT_STAT_CONN_LOCK_TABLE_READ_COUNT_swigconstant(_wiredtiger)
WT_STAT_CONN_LOCK_TABLE_READ_COUNT = _wiredtiger.WT_STAT_CONN_LOCK_TABLE_READ_COUNT

_wiredtiger.WT_STAT_CONN_LOCK_TABLE_WRITE_COUNT_swigconstant(_wiredtiger)
WT_STAT_CONN_LOCK_TABLE_WRITE_COUNT = _wiredtiger.WT_STAT_CONN_LOCK_TABLE_WRITE_COUNT

_wiredtiger.WT_STAT_CONN_LOG_SLOT_SWITCH_BUSY_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_SLOT_SWITCH_BUSY = _wiredtiger.WT_STAT_CONN_LOG_SLOT_SWITCH_BUSY

_wiredtiger.WT_STAT_CONN_LOG_BYTES_PAYLOAD_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_BYTES_PAYLOAD = _wiredtiger.WT_STAT_CONN_LOG_BYTES_PAYLOAD

_wiredtiger.WT_STAT_CONN_LOG_BYTES_WRITTEN_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_BYTES_WRITTEN = _wiredtiger.WT_STAT_CONN_LOG_BYTES_WRITTEN

_wiredtiger.WT_STAT_CONN_LOG_ZERO_FILLS_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_ZERO_FILLS = _wiredtiger.WT_STAT_CONN_LOG_ZERO_FILLS

_wiredtiger.WT_STAT_CONN_LOG_FLUSH_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_FLUSH = _wiredtiger.WT_STAT_CONN_LOG_FLUSH

_wiredtiger.WT_STAT_CONN_LOG_FORCE_WRITE_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_FORCE_WRITE = _wiredtiger.WT_STAT_CONN_LOG_FORCE_WRITE

_wiredtiger.WT_STAT_CONN_LOG_FORCE_WRITE_SKIP_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_FORCE_WRITE_SKIP = _wiredtiger.WT_STAT_CONN_LOG_FORCE_WRITE_SKIP

_wiredtiger.WT_STAT_CONN_LOG_COMPRESS_WRITES_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_COMPRESS_WRITES = _wiredtiger.WT_STAT_CONN_LOG_COMPRESS_WRITES

_wiredtiger.WT_STAT_CONN_LOG_COMPRESS_WRITE_FAILS_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_COMPRESS_WRITE_FAILS = _wiredtiger.WT_STAT_CONN_LOG_COMPRESS_WRITE_FAILS

_wiredtiger.WT_STAT_CONN_LOG_COMPRESS_SMALL_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_COMPRESS_SMALL = _wiredtiger.WT_STAT_CONN_LOG_COMPRESS_SMALL

_wiredtiger.WT_STAT_CONN_LOG_RELEASE_WRITE_LSN_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_RELEASE_WRITE_LSN = _wiredtiger.WT_STAT_CONN_LOG_RELEASE_WRITE_LSN

_wiredtiger.WT_STAT_CONN_LOG_SCANS_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_SCANS = _wiredtiger.WT_STAT_CONN_LOG_SCANS

_wiredtiger.WT_STAT_CONN_LOG_SCAN_REREADS_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_SCAN_REREADS = _wiredtiger.WT_STAT_CONN_LOG_SCAN_REREADS

_wiredtiger.WT_STAT_CONN_LOG_WRITE_LSN_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_WRITE_LSN = _wiredtiger.WT_STAT_CONN_LOG_WRITE_LSN

_wiredtiger.WT_STAT_CONN_LOG_WRITE_LSN_SKIP_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_WRITE_LSN_SKIP = _wiredtiger.WT_STAT_CONN_LOG_WRITE_LSN_SKIP

_wiredtiger.WT_STAT_CONN_LOG_SYNC_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_SYNC = _wiredtiger.WT_STAT_CONN_LOG_SYNC

_wiredtiger.WT_STAT_CONN_LOG_SYNC_DURATION_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_SYNC_DURATION = _wiredtiger.WT_STAT_CONN_LOG_SYNC_DURATION

_wiredtiger.WT_STAT_CONN_LOG_SYNC_DIR_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_SYNC_DIR = _wiredtiger.WT_STAT_CONN_LOG_SYNC_DIR

_wiredtiger.WT_STAT_CONN_LOG_SYNC_DIR_DURATION_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_SYNC_DIR_DURATION = _wiredtiger.WT_STAT_CONN_LOG_SYNC_DIR_DURATION

_wiredtiger.WT_STAT_CONN_LOG_WRITES_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_WRITES = _wiredtiger.WT_STAT_CONN_LOG_WRITES

_wiredtiger.WT_STAT_CONN_LOG_SLOT_CONSOLIDATED_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_SLOT_CONSOLIDATED = _wiredtiger.WT_STAT_CONN_LOG_SLOT_CONSOLIDATED

_wiredtiger.WT_STAT_CONN_LOG_MAX_FILESIZE_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_MAX_FILESIZE = _wiredtiger.WT_STAT_CONN_LOG_MAX_FILESIZE

_wiredtiger.WT_STAT_CONN_LOG_PREALLOC_MAX_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_PREALLOC_MAX = _wiredtiger.WT_STAT_CONN_LOG_PREALLOC_MAX

_wiredtiger.WT_STAT_CONN_LOG_PREALLOC_MISSED_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_PREALLOC_MISSED = _wiredtiger.WT_STAT_CONN_LOG_PREALLOC_MISSED

_wiredtiger.WT_STAT_CONN_LOG_PREALLOC_FILES_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_PREALLOC_FILES = _wiredtiger.WT_STAT_CONN_LOG_PREALLOC_FILES

_wiredtiger.WT_STAT_CONN_LOG_PREALLOC_USED_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_PREALLOC_USED = _wiredtiger.WT_STAT_CONN_LOG_PREALLOC_USED

_wiredtiger.WT_STAT_CONN_LOG_SCAN_RECORDS_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_SCAN_RECORDS = _wiredtiger.WT_STAT_CONN_LOG_SCAN_RECORDS

_wiredtiger.WT_STAT_CONN_LOG_SLOT_CLOSE_RACE_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_SLOT_CLOSE_RACE = _wiredtiger.WT_STAT_CONN_LOG_SLOT_CLOSE_RACE

_wiredtiger.WT_STAT_CONN_LOG_SLOT_CLOSE_UNBUF_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_SLOT_CLOSE_UNBUF = _wiredtiger.WT_STAT_CONN_LOG_SLOT_CLOSE_UNBUF

_wiredtiger.WT_STAT_CONN_LOG_SLOT_CLOSES_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_SLOT_CLOSES = _wiredtiger.WT_STAT_CONN_LOG_SLOT_CLOSES

_wiredtiger.WT_STAT_CONN_LOG_SLOT_RACES_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_SLOT_RACES = _wiredtiger.WT_STAT_CONN_LOG_SLOT_RACES

_wiredtiger.WT_STAT_CONN_LOG_SLOT_YIELD_RACE_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_SLOT_YIELD_RACE = _wiredtiger.WT_STAT_CONN_LOG_SLOT_YIELD_RACE

_wiredtiger.WT_STAT_CONN_LOG_SLOT_IMMEDIATE_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_SLOT_IMMEDIATE = _wiredtiger.WT_STAT_CONN_LOG_SLOT_IMMEDIATE

_wiredtiger.WT_STAT_CONN_LOG_SLOT_YIELD_CLOSE_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_SLOT_YIELD_CLOSE = _wiredtiger.WT_STAT_CONN_LOG_SLOT_YIELD_CLOSE

_wiredtiger.WT_STAT_CONN_LOG_SLOT_YIELD_SLEEP_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_SLOT_YIELD_SLEEP = _wiredtiger.WT_STAT_CONN_LOG_SLOT_YIELD_SLEEP

_wiredtiger.WT_STAT_CONN_LOG_SLOT_YIELD_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_SLOT_YIELD = _wiredtiger.WT_STAT_CONN_LOG_SLOT_YIELD

_wiredtiger.WT_STAT_CONN_LOG_SLOT_ACTIVE_CLOSED_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_SLOT_ACTIVE_CLOSED = _wiredtiger.WT_STAT_CONN_LOG_SLOT_ACTIVE_CLOSED

_wiredtiger.WT_STAT_CONN_LOG_SLOT_YIELD_DURATION_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_SLOT_YIELD_DURATION = _wiredtiger.WT_STAT_CONN_LOG_SLOT_YIELD_DURATION

_wiredtiger.WT_STAT_CONN_LOG_SLOT_NO_FREE_SLOTS_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_SLOT_NO_FREE_SLOTS = _wiredtiger.WT_STAT_CONN_LOG_SLOT_NO_FREE_SLOTS

_wiredtiger.WT_STAT_CONN_LOG_SLOT_UNBUFFERED_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_SLOT_UNBUFFERED = _wiredtiger.WT_STAT_CONN_LOG_SLOT_UNBUFFERED

_wiredtiger.WT_STAT_CONN_LOG_COMPRESS_MEM_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_COMPRESS_MEM = _wiredtiger.WT_STAT_CONN_LOG_COMPRESS_MEM

_wiredtiger.WT_STAT_CONN_LOG_BUFFER_SIZE_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_BUFFER_SIZE = _wiredtiger.WT_STAT_CONN_LOG_BUFFER_SIZE

_wiredtiger.WT_STAT_CONN_LOG_COMPRESS_LEN_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_COMPRESS_LEN = _wiredtiger.WT_STAT_CONN_LOG_COMPRESS_LEN

_wiredtiger.WT_STAT_CONN_LOG_SLOT_COALESCED_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_SLOT_COALESCED = _wiredtiger.WT_STAT_CONN_LOG_SLOT_COALESCED

_wiredtiger.WT_STAT_CONN_LOG_CLOSE_YIELDS_swigconstant(_wiredtiger)
WT_STAT_CONN_LOG_CLOSE_YIELDS = _wiredtiger.WT_STAT_CONN_LOG_CLOSE_YIELDS

_wiredtiger.WT_STAT_CONN_REC_PAGE_DELETE_FAST_swigconstant(_wiredtiger)
WT_STAT_CONN_REC_PAGE_DELETE_FAST = _wiredtiger.WT_STAT_CONN_REC_PAGE_DELETE_FAST

_wiredtiger.WT_STAT_CONN_REC_PAGES_swigconstant(_wiredtiger)
WT_STAT_CONN_REC_PAGES = _wiredtiger.WT_STAT_CONN_REC_PAGES

_wiredtiger.WT_STAT_CONN_REC_PAGES_EVICTION_swigconstant(_wiredtiger)
WT_STAT_CONN_REC_PAGES_EVICTION = _wiredtiger.WT_STAT_CONN_REC_PAGES_EVICTION

_wiredtiger.WT_STAT_CONN_REC_PAGE_DELETE_swigconstant(_wiredtiger)
WT_STAT_CONN_REC_PAGE_DELETE = _wiredtiger.WT_STAT_CONN_REC_PAGE_DELETE

_wiredtiger.WT_STAT_CONN_REC_SPLIT_STASHED_BYTES_swigconstant(_wiredtiger)
WT_STAT_CONN_REC_SPLIT_STASHED_BYTES = _wiredtiger.WT_STAT_CONN_REC_SPLIT_STASHED_BYTES

_wiredtiger.WT_STAT_CONN_REC_SPLIT_STASHED_OBJECTS_swigconstant(_wiredtiger)
WT_STAT_CONN_REC_SPLIT_STASHED_OBJECTS = _wiredtiger.WT_STAT_CONN_REC_SPLIT_STASHED_OBJECTS

_wiredtiger.WT_STAT_CONN_SESSION_CURSOR_OPEN_swigconstant(_wiredtiger)
WT_STAT_CONN_SESSION_CURSOR_OPEN = _wiredtiger.WT_STAT_CONN_SESSION_CURSOR_OPEN

_wiredtiger.WT_STAT_CONN_SESSION_OPEN_swigconstant(_wiredtiger)
WT_STAT_CONN_SESSION_OPEN = _wiredtiger.WT_STAT_CONN_SESSION_OPEN

_wiredtiger.WT_STAT_CONN_SESSION_TABLE_ALTER_FAIL_swigconstant(_wiredtiger)
WT_STAT_CONN_SESSION_TABLE_ALTER_FAIL = _wiredtiger.WT_STAT_CONN_SESSION_TABLE_ALTER_FAIL

_wiredtiger.WT_STAT_CONN_SESSION_TABLE_ALTER_SUCCESS_swigconstant(_wiredtiger)
WT_STAT_CONN_SESSION_TABLE_ALTER_SUCCESS = _wiredtiger.WT_STAT_CONN_SESSION_TABLE_ALTER_SUCCESS

_wiredtiger.WT_STAT_CONN_SESSION_TABLE_ALTER_SKIP_swigconstant(_wiredtiger)
WT_STAT_CONN_SESSION_TABLE_ALTER_SKIP = _wiredtiger.WT_STAT_CONN_SESSION_TABLE_ALTER_SKIP

_wiredtiger.WT_STAT_CONN_SESSION_TABLE_COMPACT_FAIL_swigconstant(_wiredtiger)
WT_STAT_CONN_SESSION_TABLE_COMPACT_FAIL = _wiredtiger.WT_STAT_CONN_SESSION_TABLE_COMPACT_FAIL

_wiredtiger.WT_STAT_CONN_SESSION_TABLE_COMPACT_SUCCESS_swigconstant(_wiredtiger)
WT_STAT_CONN_SESSION_TABLE_COMPACT_SUCCESS = _wiredtiger.WT_STAT_CONN_SESSION_TABLE_COMPACT_SUCCESS

_wiredtiger.WT_STAT_CONN_SESSION_TABLE_CREATE_FAIL_swigconstant(_wiredtiger)
WT_STAT_CONN_SESSION_TABLE_CREATE_FAIL = _wiredtiger.WT_STAT_CONN_SESSION_TABLE_CREATE_FAIL

_wiredtiger.WT_STAT_CONN_SESSION_TABLE_CREATE_SUCCESS_swigconstant(_wiredtiger)
WT_STAT_CONN_SESSION_TABLE_CREATE_SUCCESS = _wiredtiger.WT_STAT_CONN_SESSION_TABLE_CREATE_SUCCESS

_wiredtiger.WT_STAT_CONN_SESSION_TABLE_DROP_FAIL_swigconstant(_wiredtiger)
WT_STAT_CONN_SESSION_TABLE_DROP_FAIL = _wiredtiger.WT_STAT_CONN_SESSION_TABLE_DROP_FAIL

_wiredtiger.WT_STAT_CONN_SESSION_TABLE_DROP_SUCCESS_swigconstant(_wiredtiger)
WT_STAT_CONN_SESSION_TABLE_DROP_SUCCESS = _wiredtiger.WT_STAT_CONN_SESSION_TABLE_DROP_SUCCESS

_wiredtiger.WT_STAT_CONN_SESSION_TABLE_REBALANCE_FAIL_swigconstant(_wiredtiger)
WT_STAT_CONN_SESSION_TABLE_REBALANCE_FAIL = _wiredtiger.WT_STAT_CONN_SESSION_TABLE_REBALANCE_FAIL

_wiredtiger.WT_STAT_CONN_SESSION_TABLE_REBALANCE_SUCCESS_swigconstant(_wiredtiger)
WT_STAT_CONN_SESSION_TABLE_REBALANCE_SUCCESS = _wiredtiger.WT_STAT_CONN_SESSION_TABLE_REBALANCE_SUCCESS

_wiredtiger.WT_STAT_CONN_SESSION_TABLE_RENAME_FAIL_swigconstant(_wiredtiger)
WT_STAT_CONN_SESSION_TABLE_RENAME_FAIL = _wiredtiger.WT_STAT_CONN_SESSION_TABLE_RENAME_FAIL

_wiredtiger.WT_STAT_CONN_SESSION_TABLE_RENAME_SUCCESS_swigconstant(_wiredtiger)
WT_STAT_CONN_SESSION_TABLE_RENAME_SUCCESS = _wiredtiger.WT_STAT_CONN_SESSION_TABLE_RENAME_SUCCESS

_wiredtiger.WT_STAT_CONN_SESSION_TABLE_SALVAGE_FAIL_swigconstant(_wiredtiger)
WT_STAT_CONN_SESSION_TABLE_SALVAGE_FAIL = _wiredtiger.WT_STAT_CONN_SESSION_TABLE_SALVAGE_FAIL

_wiredtiger.WT_STAT_CONN_SESSION_TABLE_SALVAGE_SUCCESS_swigconstant(_wiredtiger)
WT_STAT_CONN_SESSION_TABLE_SALVAGE_SUCCESS = _wiredtiger.WT_STAT_CONN_SESSION_TABLE_SALVAGE_SUCCESS

_wiredtiger.WT_STAT_CONN_SESSION_TABLE_TRUNCATE_FAIL_swigconstant(_wiredtiger)
WT_STAT_CONN_SESSION_TABLE_TRUNCATE_FAIL = _wiredtiger.WT_STAT_CONN_SESSION_TABLE_TRUNCATE_FAIL

_wiredtiger.WT_STAT_CONN_SESSION_TABLE_TRUNCATE_SUCCESS_swigconstant(_wiredtiger)
WT_STAT_CONN_SESSION_TABLE_TRUNCATE_SUCCESS = _wiredtiger.WT_STAT_CONN_SESSION_TABLE_TRUNCATE_SUCCESS

_wiredtiger.WT_STAT_CONN_SESSION_TABLE_VERIFY_FAIL_swigconstant(_wiredtiger)
WT_STAT_CONN_SESSION_TABLE_VERIFY_FAIL = _wiredtiger.WT_STAT_CONN_SESSION_TABLE_VERIFY_FAIL

_wiredtiger.WT_STAT_CONN_SESSION_TABLE_VERIFY_SUCCESS_swigconstant(_wiredtiger)
WT_STAT_CONN_SESSION_TABLE_VERIFY_SUCCESS = _wiredtiger.WT_STAT_CONN_SESSION_TABLE_VERIFY_SUCCESS

_wiredtiger.WT_STAT_CONN_THREAD_FSYNC_ACTIVE_swigconstant(_wiredtiger)
WT_STAT_CONN_THREAD_FSYNC_ACTIVE = _wiredtiger.WT_STAT_CONN_THREAD_FSYNC_ACTIVE

_wiredtiger.WT_STAT_CONN_THREAD_READ_ACTIVE_swigconstant(_wiredtiger)
WT_STAT_CONN_THREAD_READ_ACTIVE = _wiredtiger.WT_STAT_CONN_THREAD_READ_ACTIVE

_wiredtiger.WT_STAT_CONN_THREAD_WRITE_ACTIVE_swigconstant(_wiredtiger)
WT_STAT_CONN_THREAD_WRITE_ACTIVE = _wiredtiger.WT_STAT_CONN_THREAD_WRITE_ACTIVE

_wiredtiger.WT_STAT_CONN_APPLICATION_EVICT_TIME_swigconstant(_wiredtiger)
WT_STAT_CONN_APPLICATION_EVICT_TIME = _wiredtiger.WT_STAT_CONN_APPLICATION_EVICT_TIME

_wiredtiger.WT_STAT_CONN_APPLICATION_CACHE_TIME_swigconstant(_wiredtiger)
WT_STAT_CONN_APPLICATION_CACHE_TIME = _wiredtiger.WT_STAT_CONN_APPLICATION_CACHE_TIME

_wiredtiger.WT_STAT_CONN_PAGE_BUSY_BLOCKED_swigconstant(_wiredtiger)
WT_STAT_CONN_PAGE_BUSY_BLOCKED = _wiredtiger.WT_STAT_CONN_PAGE_BUSY_BLOCKED

_wiredtiger.WT_STAT_CONN_PAGE_FORCIBLE_EVICT_BLOCKED_swigconstant(_wiredtiger)
WT_STAT_CONN_PAGE_FORCIBLE_EVICT_BLOCKED = _wiredtiger.WT_STAT_CONN_PAGE_FORCIBLE_EVICT_BLOCKED

_wiredtiger.WT_STAT_CONN_PAGE_LOCKED_BLOCKED_swigconstant(_wiredtiger)
WT_STAT_CONN_PAGE_LOCKED_BLOCKED = _wiredtiger.WT_STAT_CONN_PAGE_LOCKED_BLOCKED

_wiredtiger.WT_STAT_CONN_PAGE_READ_BLOCKED_swigconstant(_wiredtiger)
WT_STAT_CONN_PAGE_READ_BLOCKED = _wiredtiger.WT_STAT_CONN_PAGE_READ_BLOCKED

_wiredtiger.WT_STAT_CONN_PAGE_SLEEP_swigconstant(_wiredtiger)
WT_STAT_CONN_PAGE_SLEEP = _wiredtiger.WT_STAT_CONN_PAGE_SLEEP

_wiredtiger.WT_STAT_CONN_TXN_SNAPSHOTS_CREATED_swigconstant(_wiredtiger)
WT_STAT_CONN_TXN_SNAPSHOTS_CREATED = _wiredtiger.WT_STAT_CONN_TXN_SNAPSHOTS_CREATED

_wiredtiger.WT_STAT_CONN_TXN_SNAPSHOTS_DROPPED_swigconstant(_wiredtiger)
WT_STAT_CONN_TXN_SNAPSHOTS_DROPPED = _wiredtiger.WT_STAT_CONN_TXN_SNAPSHOTS_DROPPED

_wiredtiger.WT_STAT_CONN_TXN_BEGIN_swigconstant(_wiredtiger)
WT_STAT_CONN_TXN_BEGIN = _wiredtiger.WT_STAT_CONN_TXN_BEGIN

_wiredtiger.WT_STAT_CONN_TXN_CHECKPOINT_RUNNING_swigconstant(_wiredtiger)
WT_STAT_CONN_TXN_CHECKPOINT_RUNNING = _wiredtiger.WT_STAT_CONN_TXN_CHECKPOINT_RUNNING

_wiredtiger.WT_STAT_CONN_TXN_CHECKPOINT_GENERATION_swigconstant(_wiredtiger)
WT_STAT_CONN_TXN_CHECKPOINT_GENERATION = _wiredtiger.WT_STAT_CONN_TXN_CHECKPOINT_GENERATION

_wiredtiger.WT_STAT_CONN_TXN_CHECKPOINT_TIME_MAX_swigconstant(_wiredtiger)
WT_STAT_CONN_TXN_CHECKPOINT_TIME_MAX = _wiredtiger.WT_STAT_CONN_TXN_CHECKPOINT_TIME_MAX

_wiredtiger.WT_STAT_CONN_TXN_CHECKPOINT_TIME_MIN_swigconstant(_wiredtiger)
WT_STAT_CONN_TXN_CHECKPOINT_TIME_MIN = _wiredtiger.WT_STAT_CONN_TXN_CHECKPOINT_TIME_MIN

_wiredtiger.WT_STAT_CONN_TXN_CHECKPOINT_TIME_RECENT_swigconstant(_wiredtiger)
WT_STAT_CONN_TXN_CHECKPOINT_TIME_RECENT = _wiredtiger.WT_STAT_CONN_TXN_CHECKPOINT_TIME_RECENT

_wiredtiger.WT_STAT_CONN_TXN_CHECKPOINT_SCRUB_TARGET_swigconstant(_wiredtiger)
WT_STAT_CONN_TXN_CHECKPOINT_SCRUB_TARGET = _wiredtiger.WT_STAT_CONN_TXN_CHECKPOINT_SCRUB_TARGET

_wiredtiger.WT_STAT_CONN_TXN_CHECKPOINT_SCRUB_TIME_swigconstant(_wiredtiger)
WT_STAT_CONN_TXN_CHECKPOINT_SCRUB_TIME = _wiredtiger.WT_STAT_CONN_TXN_CHECKPOINT_SCRUB_TIME

_wiredtiger.WT_STAT_CONN_TXN_CHECKPOINT_TIME_TOTAL_swigconstant(_wiredtiger)
WT_STAT_CONN_TXN_CHECKPOINT_TIME_TOTAL = _wiredtiger.WT_STAT_CONN_TXN_CHECKPOINT_TIME_TOTAL

_wiredtiger.WT_STAT_CONN_TXN_CHECKPOINT_swigconstant(_wiredtiger)
WT_STAT_CONN_TXN_CHECKPOINT = _wiredtiger.WT_STAT_CONN_TXN_CHECKPOINT

_wiredtiger.WT_STAT_CONN_TXN_CHECKPOINT_SKIPPED_swigconstant(_wiredtiger)
WT_STAT_CONN_TXN_CHECKPOINT_SKIPPED = _wiredtiger.WT_STAT_CONN_TXN_CHECKPOINT_SKIPPED

_wiredtiger.WT_STAT_CONN_TXN_FAIL_CACHE_swigconstant(_wiredtiger)
WT_STAT_CONN_TXN_FAIL_CACHE = _wiredtiger.WT_STAT_CONN_TXN_FAIL_CACHE

_wiredtiger.WT_STAT_CONN_TXN_CHECKPOINT_FSYNC_POST_swigconstant(_wiredtiger)
WT_STAT_CONN_TXN_CHECKPOINT_FSYNC_POST = _wiredtiger.WT_STAT_CONN_TXN_CHECKPOINT_FSYNC_POST

_wiredtiger.WT_STAT_CONN_TXN_CHECKPOINT_FSYNC_POST_DURATION_swigconstant(_wiredtiger)
WT_STAT_CONN_TXN_CHECKPOINT_FSYNC_POST_DURATION = _wiredtiger.WT_STAT_CONN_TXN_CHECKPOINT_FSYNC_POST_DURATION

_wiredtiger.WT_STAT_CONN_TXN_PINNED_RANGE_swigconstant(_wiredtiger)
WT_STAT_CONN_TXN_PINNED_RANGE = _wiredtiger.WT_STAT_CONN_TXN_PINNED_RANGE

_wiredtiger.WT_STAT_CONN_TXN_PINNED_CHECKPOINT_RANGE_swigconstant(_wiredtiger)
WT_STAT_CONN_TXN_PINNED_CHECKPOINT_RANGE = _wiredtiger.WT_STAT_CONN_TXN_PINNED_CHECKPOINT_RANGE

_wiredtiger.WT_STAT_CONN_TXN_PINNED_SNAPSHOT_RANGE_swigconstant(_wiredtiger)
WT_STAT_CONN_TXN_PINNED_SNAPSHOT_RANGE = _wiredtiger.WT_STAT_CONN_TXN_PINNED_SNAPSHOT_RANGE

_wiredtiger.WT_STAT_CONN_TXN_SYNC_swigconstant(_wiredtiger)
WT_STAT_CONN_TXN_SYNC = _wiredtiger.WT_STAT_CONN_TXN_SYNC

_wiredtiger.WT_STAT_CONN_TXN_COMMIT_swigconstant(_wiredtiger)
WT_STAT_CONN_TXN_COMMIT = _wiredtiger.WT_STAT_CONN_TXN_COMMIT

_wiredtiger.WT_STAT_CONN_TXN_ROLLBACK_swigconstant(_wiredtiger)
WT_STAT_CONN_TXN_ROLLBACK = _wiredtiger.WT_STAT_CONN_TXN_ROLLBACK

_wiredtiger.WT_STAT_CONN_TXN_UPDATE_CONFLICT_swigconstant(_wiredtiger)
WT_STAT_CONN_TXN_UPDATE_CONFLICT = _wiredtiger.WT_STAT_CONN_TXN_UPDATE_CONFLICT

_wiredtiger.WT_STAT_DSRC_BLOOM_FALSE_POSITIVE_swigconstant(_wiredtiger)
WT_STAT_DSRC_BLOOM_FALSE_POSITIVE = _wiredtiger.WT_STAT_DSRC_BLOOM_FALSE_POSITIVE

_wiredtiger.WT_STAT_DSRC_BLOOM_HIT_swigconstant(_wiredtiger)
WT_STAT_DSRC_BLOOM_HIT = _wiredtiger.WT_STAT_DSRC_BLOOM_HIT

_wiredtiger.WT_STAT_DSRC_BLOOM_MISS_swigconstant(_wiredtiger)
WT_STAT_DSRC_BLOOM_MISS = _wiredtiger.WT_STAT_DSRC_BLOOM_MISS

_wiredtiger.WT_STAT_DSRC_BLOOM_PAGE_EVICT_swigconstant(_wiredtiger)
WT_STAT_DSRC_BLOOM_PAGE_EVICT = _wiredtiger.WT_STAT_DSRC_BLOOM_PAGE_EVICT

_wiredtiger.WT_STAT_DSRC_BLOOM_PAGE_READ_swigconstant(_wiredtiger)
WT_STAT_DSRC_BLOOM_PAGE_READ = _wiredtiger.WT_STAT_DSRC_BLOOM_PAGE_READ

_wiredtiger.WT_STAT_DSRC_BLOOM_COUNT_swigconstant(_wiredtiger)
WT_STAT_DSRC_BLOOM_COUNT = _wiredtiger.WT_STAT_DSRC_BLOOM_COUNT

_wiredtiger.WT_STAT_DSRC_LSM_CHUNK_COUNT_swigconstant(_wiredtiger)
WT_STAT_DSRC_LSM_CHUNK_COUNT = _wiredtiger.WT_STAT_DSRC_LSM_CHUNK_COUNT

_wiredtiger.WT_STAT_DSRC_LSM_GENERATION_MAX_swigconstant(_wiredtiger)
WT_STAT_DSRC_LSM_GENERATION_MAX = _wiredtiger.WT_STAT_DSRC_LSM_GENERATION_MAX

_wiredtiger.WT_STAT_DSRC_LSM_LOOKUP_NO_BLOOM_swigconstant(_wiredtiger)
WT_STAT_DSRC_LSM_LOOKUP_NO_BLOOM = _wiredtiger.WT_STAT_DSRC_LSM_LOOKUP_NO_BLOOM

_wiredtiger.WT_STAT_DSRC_LSM_CHECKPOINT_THROTTLE_swigconstant(_wiredtiger)
WT_STAT_DSRC_LSM_CHECKPOINT_THROTTLE = _wiredtiger.WT_STAT_DSRC_LSM_CHECKPOINT_THROTTLE

_wiredtiger.WT_STAT_DSRC_LSM_MERGE_THROTTLE_swigconstant(_wiredtiger)
WT_STAT_DSRC_LSM_MERGE_THROTTLE = _wiredtiger.WT_STAT_DSRC_LSM_MERGE_THROTTLE

_wiredtiger.WT_STAT_DSRC_BLOOM_SIZE_swigconstant(_wiredtiger)
WT_STAT_DSRC_BLOOM_SIZE = _wiredtiger.WT_STAT_DSRC_BLOOM_SIZE

_wiredtiger.WT_STAT_DSRC_BLOCK_EXTENSION_swigconstant(_wiredtiger)
WT_STAT_DSRC_BLOCK_EXTENSION = _wiredtiger.WT_STAT_DSRC_BLOCK_EXTENSION

_wiredtiger.WT_STAT_DSRC_BLOCK_ALLOC_swigconstant(_wiredtiger)
WT_STAT_DSRC_BLOCK_ALLOC = _wiredtiger.WT_STAT_DSRC_BLOCK_ALLOC

_wiredtiger.WT_STAT_DSRC_BLOCK_FREE_swigconstant(_wiredtiger)
WT_STAT_DSRC_BLOCK_FREE = _wiredtiger.WT_STAT_DSRC_BLOCK_FREE

_wiredtiger.WT_STAT_DSRC_BLOCK_CHECKPOINT_SIZE_swigconstant(_wiredtiger)
WT_STAT_DSRC_BLOCK_CHECKPOINT_SIZE = _wiredtiger.WT_STAT_DSRC_BLOCK_CHECKPOINT_SIZE

_wiredtiger.WT_STAT_DSRC_ALLOCATION_SIZE_swigconstant(_wiredtiger)
WT_STAT_DSRC_ALLOCATION_SIZE = _wiredtiger.WT_STAT_DSRC_ALLOCATION_SIZE

_wiredtiger.WT_STAT_DSRC_BLOCK_REUSE_BYTES_swigconstant(_wiredtiger)
WT_STAT_DSRC_BLOCK_REUSE_BYTES = _wiredtiger.WT_STAT_DSRC_BLOCK_REUSE_BYTES

_wiredtiger.WT_STAT_DSRC_BLOCK_MAGIC_swigconstant(_wiredtiger)
WT_STAT_DSRC_BLOCK_MAGIC = _wiredtiger.WT_STAT_DSRC_BLOCK_MAGIC

_wiredtiger.WT_STAT_DSRC_BLOCK_MAJOR_swigconstant(_wiredtiger)
WT_STAT_DSRC_BLOCK_MAJOR = _wiredtiger.WT_STAT_DSRC_BLOCK_MAJOR

_wiredtiger.WT_STAT_DSRC_BLOCK_SIZE_swigconstant(_wiredtiger)
WT_STAT_DSRC_BLOCK_SIZE = _wiredtiger.WT_STAT_DSRC_BLOCK_SIZE

_wiredtiger.WT_STAT_DSRC_BLOCK_MINOR_swigconstant(_wiredtiger)
WT_STAT_DSRC_BLOCK_MINOR = _wiredtiger.WT_STAT_DSRC_BLOCK_MINOR

_wiredtiger.WT_STAT_DSRC_BTREE_CHECKPOINT_GENERATION_swigconstant(_wiredtiger)
WT_STAT_DSRC_BTREE_CHECKPOINT_GENERATION = _wiredtiger.WT_STAT_DSRC_BTREE_CHECKPOINT_GENERATION

_wiredtiger.WT_STAT_DSRC_BTREE_COLUMN_FIX_swigconstant(_wiredtiger)
WT_STAT_DSRC_BTREE_COLUMN_FIX = _wiredtiger.WT_STAT_DSRC_BTREE_COLUMN_FIX

_wiredtiger.WT_STAT_DSRC_BTREE_COLUMN_INTERNAL_swigconstant(_wiredtiger)
WT_STAT_DSRC_BTREE_COLUMN_INTERNAL = _wiredtiger.WT_STAT_DSRC_BTREE_COLUMN_INTERNAL

_wiredtiger.WT_STAT_DSRC_BTREE_COLUMN_RLE_swigconstant(_wiredtiger)
WT_STAT_DSRC_BTREE_COLUMN_RLE = _wiredtiger.WT_STAT_DSRC_BTREE_COLUMN_RLE

_wiredtiger.WT_STAT_DSRC_BTREE_COLUMN_DELETED_swigconstant(_wiredtiger)
WT_STAT_DSRC_BTREE_COLUMN_DELETED = _wiredtiger.WT_STAT_DSRC_BTREE_COLUMN_DELETED

_wiredtiger.WT_STAT_DSRC_BTREE_COLUMN_VARIABLE_swigconstant(_wiredtiger)
WT_STAT_DSRC_BTREE_COLUMN_VARIABLE = _wiredtiger.WT_STAT_DSRC_BTREE_COLUMN_VARIABLE

_wiredtiger.WT_STAT_DSRC_BTREE_FIXED_LEN_swigconstant(_wiredtiger)
WT_STAT_DSRC_BTREE_FIXED_LEN = _wiredtiger.WT_STAT_DSRC_BTREE_FIXED_LEN

_wiredtiger.WT_STAT_DSRC_BTREE_MAXINTLKEY_swigconstant(_wiredtiger)
WT_STAT_DSRC_BTREE_MAXINTLKEY = _wiredtiger.WT_STAT_DSRC_BTREE_MAXINTLKEY

_wiredtiger.WT_STAT_DSRC_BTREE_MAXINTLPAGE_swigconstant(_wiredtiger)
WT_STAT_DSRC_BTREE_MAXINTLPAGE = _wiredtiger.WT_STAT_DSRC_BTREE_MAXINTLPAGE

_wiredtiger.WT_STAT_DSRC_BTREE_MAXLEAFKEY_swigconstant(_wiredtiger)
WT_STAT_DSRC_BTREE_MAXLEAFKEY = _wiredtiger.WT_STAT_DSRC_BTREE_MAXLEAFKEY

_wiredtiger.WT_STAT_DSRC_BTREE_MAXLEAFPAGE_swigconstant(_wiredtiger)
WT_STAT_DSRC_BTREE_MAXLEAFPAGE = _wiredtiger.WT_STAT_DSRC_BTREE_MAXLEAFPAGE

_wiredtiger.WT_STAT_DSRC_BTREE_MAXLEAFVALUE_swigconstant(_wiredtiger)
WT_STAT_DSRC_BTREE_MAXLEAFVALUE = _wiredtiger.WT_STAT_DSRC_BTREE_MAXLEAFVALUE

_wiredtiger.WT_STAT_DSRC_BTREE_MAXIMUM_DEPTH_swigconstant(_wiredtiger)
WT_STAT_DSRC_BTREE_MAXIMUM_DEPTH = _wiredtiger.WT_STAT_DSRC_BTREE_MAXIMUM_DEPTH

_wiredtiger.WT_STAT_DSRC_BTREE_ENTRIES_swigconstant(_wiredtiger)
WT_STAT_DSRC_BTREE_ENTRIES = _wiredtiger.WT_STAT_DSRC_BTREE_ENTRIES

_wiredtiger.WT_STAT_DSRC_BTREE_OVERFLOW_swigconstant(_wiredtiger)
WT_STAT_DSRC_BTREE_OVERFLOW = _wiredtiger.WT_STAT_DSRC_BTREE_OVERFLOW

_wiredtiger.WT_STAT_DSRC_BTREE_COMPACT_REWRITE_swigconstant(_wiredtiger)
WT_STAT_DSRC_BTREE_COMPACT_REWRITE = _wiredtiger.WT_STAT_DSRC_BTREE_COMPACT_REWRITE

_wiredtiger.WT_STAT_DSRC_BTREE_ROW_INTERNAL_swigconstant(_wiredtiger)
WT_STAT_DSRC_BTREE_ROW_INTERNAL = _wiredtiger.WT_STAT_DSRC_BTREE_ROW_INTERNAL

_wiredtiger.WT_STAT_DSRC_BTREE_ROW_LEAF_swigconstant(_wiredtiger)
WT_STAT_DSRC_BTREE_ROW_LEAF = _wiredtiger.WT_STAT_DSRC_BTREE_ROW_LEAF

_wiredtiger.WT_STAT_DSRC_CACHE_BYTES_INUSE_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_BYTES_INUSE = _wiredtiger.WT_STAT_DSRC_CACHE_BYTES_INUSE

_wiredtiger.WT_STAT_DSRC_CACHE_BYTES_READ_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_BYTES_READ = _wiredtiger.WT_STAT_DSRC_CACHE_BYTES_READ

_wiredtiger.WT_STAT_DSRC_CACHE_BYTES_WRITE_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_BYTES_WRITE = _wiredtiger.WT_STAT_DSRC_CACHE_BYTES_WRITE

_wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_CHECKPOINT_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_EVICTION_CHECKPOINT = _wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_CHECKPOINT

_wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_FAIL_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_EVICTION_FAIL = _wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_FAIL

_wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_HAZARD_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_EVICTION_HAZARD = _wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_HAZARD

_wiredtiger.WT_STAT_DSRC_CACHE_INMEM_SPLITTABLE_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_INMEM_SPLITTABLE = _wiredtiger.WT_STAT_DSRC_CACHE_INMEM_SPLITTABLE

_wiredtiger.WT_STAT_DSRC_CACHE_INMEM_SPLIT_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_INMEM_SPLIT = _wiredtiger.WT_STAT_DSRC_CACHE_INMEM_SPLIT

_wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_INTERNAL_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_EVICTION_INTERNAL = _wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_INTERNAL

_wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_SPLIT_INTERNAL_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_EVICTION_SPLIT_INTERNAL = _wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_SPLIT_INTERNAL

_wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_SPLIT_LEAF_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_EVICTION_SPLIT_LEAF = _wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_SPLIT_LEAF

_wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_DIRTY_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_EVICTION_DIRTY = _wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_DIRTY

_wiredtiger.WT_STAT_DSRC_CACHE_READ_OVERFLOW_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_READ_OVERFLOW = _wiredtiger.WT_STAT_DSRC_CACHE_READ_OVERFLOW

_wiredtiger.WT_STAT_DSRC_CACHE_OVERFLOW_VALUE_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_OVERFLOW_VALUE = _wiredtiger.WT_STAT_DSRC_CACHE_OVERFLOW_VALUE

_wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_DEEPEN_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_EVICTION_DEEPEN = _wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_DEEPEN

_wiredtiger.WT_STAT_DSRC_CACHE_WRITE_LOOKASIDE_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_WRITE_LOOKASIDE = _wiredtiger.WT_STAT_DSRC_CACHE_WRITE_LOOKASIDE

_wiredtiger.WT_STAT_DSRC_CACHE_READ_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_READ = _wiredtiger.WT_STAT_DSRC_CACHE_READ

_wiredtiger.WT_STAT_DSRC_CACHE_READ_LOOKASIDE_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_READ_LOOKASIDE = _wiredtiger.WT_STAT_DSRC_CACHE_READ_LOOKASIDE

_wiredtiger.WT_STAT_DSRC_CACHE_PAGES_REQUESTED_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_PAGES_REQUESTED = _wiredtiger.WT_STAT_DSRC_CACHE_PAGES_REQUESTED

_wiredtiger.WT_STAT_DSRC_CACHE_WRITE_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_WRITE = _wiredtiger.WT_STAT_DSRC_CACHE_WRITE

_wiredtiger.WT_STAT_DSRC_CACHE_WRITE_RESTORE_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_WRITE_RESTORE = _wiredtiger.WT_STAT_DSRC_CACHE_WRITE_RESTORE

_wiredtiger.WT_STAT_DSRC_CACHE_BYTES_DIRTY_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_BYTES_DIRTY = _wiredtiger.WT_STAT_DSRC_CACHE_BYTES_DIRTY

_wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_CLEAN_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_EVICTION_CLEAN = _wiredtiger.WT_STAT_DSRC_CACHE_EVICTION_CLEAN

_wiredtiger.WT_STAT_DSRC_CACHE_STATE_GEN_AVG_GAP_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_STATE_GEN_AVG_GAP = _wiredtiger.WT_STAT_DSRC_CACHE_STATE_GEN_AVG_GAP

_wiredtiger.WT_STAT_DSRC_CACHE_STATE_AVG_WRITTEN_SIZE_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_STATE_AVG_WRITTEN_SIZE = _wiredtiger.WT_STAT_DSRC_CACHE_STATE_AVG_WRITTEN_SIZE

_wiredtiger.WT_STAT_DSRC_CACHE_STATE_PAGES_CLEAN_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_STATE_PAGES_CLEAN = _wiredtiger.WT_STAT_DSRC_CACHE_STATE_PAGES_CLEAN

_wiredtiger.WT_STAT_DSRC_CACHE_STATE_GEN_CURRENT_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_STATE_GEN_CURRENT = _wiredtiger.WT_STAT_DSRC_CACHE_STATE_GEN_CURRENT

_wiredtiger.WT_STAT_DSRC_CACHE_STATE_PAGES_DIRTY_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_STATE_PAGES_DIRTY = _wiredtiger.WT_STAT_DSRC_CACHE_STATE_PAGES_DIRTY

_wiredtiger.WT_STAT_DSRC_CACHE_STATE_ROOT_ENTRIES_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_STATE_ROOT_ENTRIES = _wiredtiger.WT_STAT_DSRC_CACHE_STATE_ROOT_ENTRIES

_wiredtiger.WT_STAT_DSRC_CACHE_STATE_PAGES_INTERNAL_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_STATE_PAGES_INTERNAL = _wiredtiger.WT_STAT_DSRC_CACHE_STATE_PAGES_INTERNAL

_wiredtiger.WT_STAT_DSRC_CACHE_STATE_PAGES_LEAF_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_STATE_PAGES_LEAF = _wiredtiger.WT_STAT_DSRC_CACHE_STATE_PAGES_LEAF

_wiredtiger.WT_STAT_DSRC_CACHE_STATE_GEN_MAX_GAP_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_STATE_GEN_MAX_GAP = _wiredtiger.WT_STAT_DSRC_CACHE_STATE_GEN_MAX_GAP

_wiredtiger.WT_STAT_DSRC_CACHE_STATE_MAX_PAGESIZE_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_STATE_MAX_PAGESIZE = _wiredtiger.WT_STAT_DSRC_CACHE_STATE_MAX_PAGESIZE

_wiredtiger.WT_STAT_DSRC_CACHE_STATE_MIN_WRITTEN_SIZE_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_STATE_MIN_WRITTEN_SIZE = _wiredtiger.WT_STAT_DSRC_CACHE_STATE_MIN_WRITTEN_SIZE

_wiredtiger.WT_STAT_DSRC_CACHE_STATE_SMALLER_ALLOC_SIZE_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_STATE_SMALLER_ALLOC_SIZE = _wiredtiger.WT_STAT_DSRC_CACHE_STATE_SMALLER_ALLOC_SIZE

_wiredtiger.WT_STAT_DSRC_CACHE_STATE_MEMORY_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_STATE_MEMORY = _wiredtiger.WT_STAT_DSRC_CACHE_STATE_MEMORY

_wiredtiger.WT_STAT_DSRC_CACHE_STATE_QUEUED_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_STATE_QUEUED = _wiredtiger.WT_STAT_DSRC_CACHE_STATE_QUEUED

_wiredtiger.WT_STAT_DSRC_CACHE_STATE_NOT_QUEUEABLE_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_STATE_NOT_QUEUEABLE = _wiredtiger.WT_STAT_DSRC_CACHE_STATE_NOT_QUEUEABLE

_wiredtiger.WT_STAT_DSRC_CACHE_STATE_REFS_SKIPPED_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_STATE_REFS_SKIPPED = _wiredtiger.WT_STAT_DSRC_CACHE_STATE_REFS_SKIPPED

_wiredtiger.WT_STAT_DSRC_CACHE_STATE_ROOT_SIZE_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_STATE_ROOT_SIZE = _wiredtiger.WT_STAT_DSRC_CACHE_STATE_ROOT_SIZE

_wiredtiger.WT_STAT_DSRC_CACHE_STATE_PAGES_swigconstant(_wiredtiger)
WT_STAT_DSRC_CACHE_STATE_PAGES = _wiredtiger.WT_STAT_DSRC_CACHE_STATE_PAGES

_wiredtiger.WT_STAT_DSRC_COMPRESS_READ_swigconstant(_wiredtiger)
WT_STAT_DSRC_COMPRESS_READ = _wiredtiger.WT_STAT_DSRC_COMPRESS_READ

_wiredtiger.WT_STAT_DSRC_COMPRESS_WRITE_swigconstant(_wiredtiger)
WT_STAT_DSRC_COMPRESS_WRITE = _wiredtiger.WT_STAT_DSRC_COMPRESS_WRITE

_wiredtiger.WT_STAT_DSRC_COMPRESS_WRITE_FAIL_swigconstant(_wiredtiger)
WT_STAT_DSRC_COMPRESS_WRITE_FAIL = _wiredtiger.WT_STAT_DSRC_COMPRESS_WRITE_FAIL

_wiredtiger.WT_STAT_DSRC_COMPRESS_WRITE_TOO_SMALL_swigconstant(_wiredtiger)
WT_STAT_DSRC_COMPRESS_WRITE_TOO_SMALL = _wiredtiger.WT_STAT_DSRC_COMPRESS_WRITE_TOO_SMALL

_wiredtiger.WT_STAT_DSRC_COMPRESS_RAW_FAIL_TEMPORARY_swigconstant(_wiredtiger)
WT_STAT_DSRC_COMPRESS_RAW_FAIL_TEMPORARY = _wiredtiger.WT_STAT_DSRC_COMPRESS_RAW_FAIL_TEMPORARY

_wiredtiger.WT_STAT_DSRC_COMPRESS_RAW_FAIL_swigconstant(_wiredtiger)
WT_STAT_DSRC_COMPRESS_RAW_FAIL = _wiredtiger.WT_STAT_DSRC_COMPRESS_RAW_FAIL

_wiredtiger.WT_STAT_DSRC_COMPRESS_RAW_OK_swigconstant(_wiredtiger)
WT_STAT_DSRC_COMPRESS_RAW_OK = _wiredtiger.WT_STAT_DSRC_COMPRESS_RAW_OK

_wiredtiger.WT_STAT_DSRC_CURSOR_INSERT_BULK_swigconstant(_wiredtiger)
WT_STAT_DSRC_CURSOR_INSERT_BULK = _wiredtiger.WT_STAT_DSRC_CURSOR_INSERT_BULK

_wiredtiger.WT_STAT_DSRC_CURSOR_CREATE_swigconstant(_wiredtiger)
WT_STAT_DSRC_CURSOR_CREATE = _wiredtiger.WT_STAT_DSRC_CURSOR_CREATE

_wiredtiger.WT_STAT_DSRC_CURSOR_INSERT_BYTES_swigconstant(_wiredtiger)
WT_STAT_DSRC_CURSOR_INSERT_BYTES = _wiredtiger.WT_STAT_DSRC_CURSOR_INSERT_BYTES

_wiredtiger.WT_STAT_DSRC_CURSOR_REMOVE_BYTES_swigconstant(_wiredtiger)
WT_STAT_DSRC_CURSOR_REMOVE_BYTES = _wiredtiger.WT_STAT_DSRC_CURSOR_REMOVE_BYTES

_wiredtiger.WT_STAT_DSRC_CURSOR_UPDATE_BYTES_swigconstant(_wiredtiger)
WT_STAT_DSRC_CURSOR_UPDATE_BYTES = _wiredtiger.WT_STAT_DSRC_CURSOR_UPDATE_BYTES

_wiredtiger.WT_STAT_DSRC_CURSOR_INSERT_swigconstant(_wiredtiger)
WT_STAT_DSRC_CURSOR_INSERT = _wiredtiger.WT_STAT_DSRC_CURSOR_INSERT

_wiredtiger.WT_STAT_DSRC_CURSOR_MODIFY_swigconstant(_wiredtiger)
WT_STAT_DSRC_CURSOR_MODIFY = _wiredtiger.WT_STAT_DSRC_CURSOR_MODIFY

_wiredtiger.WT_STAT_DSRC_CURSOR_NEXT_swigconstant(_wiredtiger)
WT_STAT_DSRC_CURSOR_NEXT = _wiredtiger.WT_STAT_DSRC_CURSOR_NEXT

_wiredtiger.WT_STAT_DSRC_CURSOR_PREV_swigconstant(_wiredtiger)
WT_STAT_DSRC_CURSOR_PREV = _wiredtiger.WT_STAT_DSRC_CURSOR_PREV

_wiredtiger.WT_STAT_DSRC_CURSOR_REMOVE_swigconstant(_wiredtiger)
WT_STAT_DSRC_CURSOR_REMOVE = _wiredtiger.WT_STAT_DSRC_CURSOR_REMOVE

_wiredtiger.WT_STAT_DSRC_CURSOR_RESERVE_swigconstant(_wiredtiger)
WT_STAT_DSRC_CURSOR_RESERVE = _wiredtiger.WT_STAT_DSRC_CURSOR_RESERVE

_wiredtiger.WT_STAT_DSRC_CURSOR_RESET_swigconstant(_wiredtiger)
WT_STAT_DSRC_CURSOR_RESET = _wiredtiger.WT_STAT_DSRC_CURSOR_RESET

_wiredtiger.WT_STAT_DSRC_CURSOR_RESTART_swigconstant(_wiredtiger)
WT_STAT_DSRC_CURSOR_RESTART = _wiredtiger.WT_STAT_DSRC_CURSOR_RESTART

_wiredtiger.WT_STAT_DSRC_CURSOR_SEARCH_swigconstant(_wiredtiger)
WT_STAT_DSRC_CURSOR_SEARCH = _wiredtiger.WT_STAT_DSRC_CURSOR_SEARCH

_wiredtiger.WT_STAT_DSRC_CURSOR_SEARCH_NEAR_swigconstant(_wiredtiger)
WT_STAT_DSRC_CURSOR_SEARCH_NEAR = _wiredtiger.WT_STAT_DSRC_CURSOR_SEARCH_NEAR

_wiredtiger.WT_STAT_DSRC_CURSOR_TRUNCATE_swigconstant(_wiredtiger)
WT_STAT_DSRC_CURSOR_TRUNCATE = _wiredtiger.WT_STAT_DSRC_CURSOR_TRUNCATE

_wiredtiger.WT_STAT_DSRC_CURSOR_UPDATE_swigconstant(_wiredtiger)
WT_STAT_DSRC_CURSOR_UPDATE = _wiredtiger.WT_STAT_DSRC_CURSOR_UPDATE

_wiredtiger.WT_STAT_DSRC_REC_DICTIONARY_swigconstant(_wiredtiger)
WT_STAT_DSRC_REC_DICTIONARY = _wiredtiger.WT_STAT_DSRC_REC_DICTIONARY

_wiredtiger.WT_STAT_DSRC_REC_PAGE_DELETE_FAST_swigconstant(_wiredtiger)
WT_STAT_DSRC_REC_PAGE_DELETE_FAST = _wiredtiger.WT_STAT_DSRC_REC_PAGE_DELETE_FAST

_wiredtiger.WT_STAT_DSRC_REC_SUFFIX_COMPRESSION_swigconstant(_wiredtiger)
WT_STAT_DSRC_REC_SUFFIX_COMPRESSION = _wiredtiger.WT_STAT_DSRC_REC_SUFFIX_COMPRESSION

_wiredtiger.WT_STAT_DSRC_REC_MULTIBLOCK_INTERNAL_swigconstant(_wiredtiger)
WT_STAT_DSRC_REC_MULTIBLOCK_INTERNAL = _wiredtiger.WT_STAT_DSRC_REC_MULTIBLOCK_INTERNAL

_wiredtiger.WT_STAT_DSRC_REC_OVERFLOW_KEY_INTERNAL_swigconstant(_wiredtiger)
WT_STAT_DSRC_REC_OVERFLOW_KEY_INTERNAL = _wiredtiger.WT_STAT_DSRC_REC_OVERFLOW_KEY_INTERNAL

_wiredtiger.WT_STAT_DSRC_REC_PREFIX_COMPRESSION_swigconstant(_wiredtiger)
WT_STAT_DSRC_REC_PREFIX_COMPRESSION = _wiredtiger.WT_STAT_DSRC_REC_PREFIX_COMPRESSION

_wiredtiger.WT_STAT_DSRC_REC_MULTIBLOCK_LEAF_swigconstant(_wiredtiger)
WT_STAT_DSRC_REC_MULTIBLOCK_LEAF = _wiredtiger.WT_STAT_DSRC_REC_MULTIBLOCK_LEAF

_wiredtiger.WT_STAT_DSRC_REC_OVERFLOW_KEY_LEAF_swigconstant(_wiredtiger)
WT_STAT_DSRC_REC_OVERFLOW_KEY_LEAF = _wiredtiger.WT_STAT_DSRC_REC_OVERFLOW_KEY_LEAF

_wiredtiger.WT_STAT_DSRC_REC_MULTIBLOCK_MAX_swigconstant(_wiredtiger)
WT_STAT_DSRC_REC_MULTIBLOCK_MAX = _wiredtiger.WT_STAT_DSRC_REC_MULTIBLOCK_MAX

_wiredtiger.WT_STAT_DSRC_REC_OVERFLOW_VALUE_swigconstant(_wiredtiger)
WT_STAT_DSRC_REC_OVERFLOW_VALUE = _wiredtiger.WT_STAT_DSRC_REC_OVERFLOW_VALUE

_wiredtiger.WT_STAT_DSRC_REC_PAGE_MATCH_swigconstant(_wiredtiger)
WT_STAT_DSRC_REC_PAGE_MATCH = _wiredtiger.WT_STAT_DSRC_REC_PAGE_MATCH

_wiredtiger.WT_STAT_DSRC_REC_PAGES_swigconstant(_wiredtiger)
WT_STAT_DSRC_REC_PAGES = _wiredtiger.WT_STAT_DSRC_REC_PAGES

_wiredtiger.WT_STAT_DSRC_REC_PAGES_EVICTION_swigconstant(_wiredtiger)
WT_STAT_DSRC_REC_PAGES_EVICTION = _wiredtiger.WT_STAT_DSRC_REC_PAGES_EVICTION

_wiredtiger.WT_STAT_DSRC_REC_PAGE_DELETE_swigconstant(_wiredtiger)
WT_STAT_DSRC_REC_PAGE_DELETE = _wiredtiger.WT_STAT_DSRC_REC_PAGE_DELETE

_wiredtiger.WT_STAT_DSRC_SESSION_COMPACT_swigconstant(_wiredtiger)
WT_STAT_DSRC_SESSION_COMPACT = _wiredtiger.WT_STAT_DSRC_SESSION_COMPACT

_wiredtiger.WT_STAT_DSRC_SESSION_CURSOR_OPEN_swigconstant(_wiredtiger)
WT_STAT_DSRC_SESSION_CURSOR_OPEN = _wiredtiger.WT_STAT_DSRC_SESSION_CURSOR_OPEN

_wiredtiger.WT_STAT_DSRC_TXN_UPDATE_CONFLICT_swigconstant(_wiredtiger)
WT_STAT_DSRC_TXN_UPDATE_CONFLICT = _wiredtiger.WT_STAT_DSRC_TXN_UPDATE_CONFLICT

_wiredtiger.WT_STAT_JOIN_MAIN_ACCESS_swigconstant(_wiredtiger)
WT_STAT_JOIN_MAIN_ACCESS = _wiredtiger.WT_STAT_JOIN_MAIN_ACCESS

_wiredtiger.WT_STAT_JOIN_BLOOM_FALSE_POSITIVE_swigconstant(_wiredtiger)
WT_STAT_JOIN_BLOOM_FALSE_POSITIVE = _wiredtiger.WT_STAT_JOIN_BLOOM_FALSE_POSITIVE

_wiredtiger.WT_STAT_JOIN_MEMBERSHIP_CHECK_swigconstant(_wiredtiger)
WT_STAT_JOIN_MEMBERSHIP_CHECK = _wiredtiger.WT_STAT_JOIN_MEMBERSHIP_CHECK

_wiredtiger.WT_STAT_JOIN_BLOOM_INSERT_swigconstant(_wiredtiger)
WT_STAT_JOIN_BLOOM_INSERT = _wiredtiger.WT_STAT_JOIN_BLOOM_INSERT

_wiredtiger.WT_STAT_JOIN_ITERATED_swigconstant(_wiredtiger)
WT_STAT_JOIN_ITERATED = _wiredtiger.WT_STAT_JOIN_ITERATED

class stat:
	'''keys for statistics cursors'''

	class conn:
		'''keys for cursors on connection statistics'''
		pass

	class dsrc:
		'''keys for cursors on data source statistics'''
		pass

## @}

import sys
# All names starting with 'WT_STAT_DSRC_' are renamed to
# the wiredtiger.stat.dsrc class, those starting with 'WT_STAT_CONN' are
# renamed to wiredtiger.stat.conn class.
def _rename_with_prefix(prefix, toclass):
	curmodule = sys.modules[__name__]
	for name in dir(curmodule):
		if name.startswith(prefix):
			shortname = name[len(prefix):].lower()
			setattr(toclass, shortname, getattr(curmodule, name))
			delattr(curmodule, name)

_rename_with_prefix('WT_STAT_CONN_', stat.conn)
_rename_with_prefix('WT_STAT_DSRC_', stat.dsrc)
del _rename_with_prefix



