#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2013 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

from winswitch.virt.rdp_client_base import RDPClientBase, ENABLE_KEYMAP_OPTION
from winswitch.virt.client_options_base import ClientOptionsBase
from winswitch.globals import WIN32, OSX
from winswitch.virt.options_common import KEYMAP

class	RDPClientUtil(RDPClientBase, ClientOptionsBase):
	"""
	adds fullscreen option widget to RDPClientBase
	"""

	def	__init__(self, update_session_status, notify_callback):
		RDPClientBase.__init__(self, update_session_status, notify_callback)

	def get_keymap_widget(self, server_command, options, change_cb=False):
		""" A combo box where users can select the keymap to use	"""
		if not ENABLE_KEYMAP_OPTION:
			return None
		if WIN32 or OSX or len(self.keymaps)==0:
			return	None
		import gtk
		cb = gtk.combo_box_new_text()
		i = 1
		cb.append_text("")
		for keymap in self.keymaps.keys():
			cb.append_text(keymap)
			if keymap==self.default_keymap:
				cb.set_active(i)
			i += 1
		self.setup_combo_callback(cb, KEYMAP, change_cb)
		return cb

	def get_options_widgets(self, server, server_command, shadowed_session=None, current_options=None, default_options=None, change_cb=None):
		""" rdp options: fullscreen """
		options = self.get_options(current_options, default_options)
		widgets = [	("Fullscreen", self.get_fullscreen_widget(server, options, change_cb)) ]
		keymap_widget = self.get_keymap_widget(server_command, options, change_cb)
		if keymap_widget:
			widgets.append(("Keymap", keymap_widget))
		return	widgets
