#!/usr/bin/env python

import sys

verbose = "-v" in sys.argv or "--verbose" in sys.argv
from winswitch.util.simple_logger import set_log_to_tty
set_log_to_tty(verbose)

from winswitch.net.local_socket_client import send_message
from winswitch.net.local_common import COMMAND_AWAY, COMMAND_BACK

def command(info, message):
	def usage():
		print("Usage: %s" % sys.argv[0])
		print("")
		print("  -h, --help			This information")
		print("  -v, --verbose		Turn on verbose logging")
		print("")
		print(" Any other arguments are ignored")
		print("")
		for i in info:
			print(i)

	if "-h" in sys.argv or "--help" in sys.argv:
		usage()
		sys.exit(0)

	return send_message(message)

def away():
	INFO=["notifies the Window Switch client that the user is moving",
		  "away from the computer where this command is executed.",
		  "This can be used in combination with 'winswitch_back'",
		  "to automatically move the sessions to another computer."]
	e=command(INFO, COMMAND_AWAY)
	sys.exit(e)

def back():
	INFO=["notifies the Window Switch client that the user is moving",
		  "back to the computer where this command is executed.",
		  "This can be used in combination with 'winswitch_away'",
		  "to automatically move the sessions from another computer."]
	e=command(INFO, COMMAND_BACK)
	sys.exit(e)
