/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jmol.util.DCT;
import org.jmol.util.Huffman;
import org.jmol.util.JpegInfo;
import org.jmol.util.Logger;

public class JpegEncoder
extends Frame {
    private BufferedOutputStream outStream;
    private JpegInfo JpegObj;
    private Huffman Huf;
    private DCT dct;
    private int Quality;

    public JpegEncoder(Image image, int n, OutputStream outputStream, String string) {
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.Quality = n;
        this.JpegObj = new JpegInfo(image, string);
        this.outStream = new BufferedOutputStream(outputStream);
        this.dct = new DCT(this.Quality);
        this.Huf = new Huffman(this.JpegObj.imageWidth, this.JpegObj.imageHeight);
    }

    public static byte[] getBytes(Image image, int n, String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        JpegEncoder.write(image, n, byteArrayOutputStream, string);
        try {
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void write(Image image, int n, OutputStream outputStream, String string) {
        new JpegEncoder(image, n, outputStream, string).Compress();
    }

    public void setQuality(int n) {
        this.dct = new DCT(n);
    }

    public void Compress() {
        JpegEncoder.WriteHeaders(this.outStream, this.JpegObj, this.dct);
        JpegEncoder.WriteCompressedData(this.outStream, this.JpegObj, this.dct, this.Huf);
        JpegEncoder.WriteEOI(this.outStream);
        try {
            this.outStream.flush();
        }
        catch (IOException iOException) {
            Logger.error("IO Error", iOException);
        }
    }

    private static void WriteCompressedData(BufferedOutputStream bufferedOutputStream, JpegInfo jpegInfo, DCT dCT, Huffman huffman) {
        int n;
        float[][] fArray = new float[8][8];
        double[][] dArray = new double[8][8];
        int[] nArray = new int[64];
        int[] nArray2 = new int[jpegInfo.NumberOfComponents];
        int n2 = huffman.ImageWidth % 8 != 0 ? (int)(Math.floor((double)huffman.ImageWidth / 8.0) + 1.0) * 8 : huffman.ImageWidth;
        int n3 = huffman.ImageHeight % 8 != 0 ? (int)(Math.floor((double)huffman.ImageHeight / 8.0) + 1.0) * 8 : huffman.ImageHeight;
        for (n = 0; n < jpegInfo.NumberOfComponents; ++n) {
            n2 = Math.min(n2, jpegInfo.BlockWidth[n]);
            n3 = Math.min(n3, jpegInfo.BlockHeight[n]);
        }
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                n4 = j * 8;
                int n5 = i * 8;
                for (n = 0; n < jpegInfo.NumberOfComponents; ++n) {
                    float[][] fArray2 = jpegInfo.Components[n];
                    int n6 = jpegInfo.VsampFactor[n];
                    int n7 = jpegInfo.HsampFactor[n];
                    int n8 = jpegInfo.QtableNumber[n];
                    int n9 = jpegInfo.DCtableNumber[n];
                    int n10 = jpegInfo.ACtableNumber[n];
                    for (int k = 0; k < n6; ++k) {
                        for (int i2 = 0; i2 < n7; ++i2) {
                            int n11 = i2 * 8;
                            int n12 = k * 8;
                            for (int i3 = 0; i3 < 8; ++i3) {
                                for (int i4 = 0; i4 < 8; ++i4) {
                                    fArray[i3][i4] = fArray2[n5 + n12 + i3][n4 + n11 + i4];
                                }
                            }
                            dArray = DCT.forwardDCT(fArray);
                            nArray = DCT.quantizeBlock(dArray, dCT.divisors[n8]);
                            huffman.HuffmanBlockEncoder(bufferedOutputStream, nArray, nArray2[n], n9, n10);
                            nArray2[n] = nArray[0];
                        }
                    }
                }
            }
        }
        huffman.flushBuffer(bufferedOutputStream);
    }

    private static void WriteEOI(BufferedOutputStream bufferedOutputStream) {
        byte[] byArray = new byte[]{-1, -39};
        JpegEncoder.WriteMarker(byArray, bufferedOutputStream);
    }

    private static void WriteHeaders(BufferedOutputStream bufferedOutputStream, JpegInfo jpegInfo, DCT dCT) {
        int n;
        byte[] byArray = new byte[]{-1, -40};
        JpegEncoder.WriteMarker(byArray, bufferedOutputStream);
        byte[] byArray2 = new byte[]{-1, -32, 0, 16, 74, 70, 73, 70, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0};
        JpegEncoder.WriteArray(byArray2, bufferedOutputStream);
        String string = "";
        string = jpegInfo.getComment();
        int n2 = string.length();
        byte[] byArray3 = new byte[n2 + 4];
        byArray3[0] = -1;
        byArray3[1] = -2;
        byArray3[2] = (byte)(n2 >> 8 & 0xFF);
        byArray3[3] = (byte)(n2 & 0xFF);
        System.arraycopy(jpegInfo.Comment.getBytes(), 0, byArray3, 4, jpegInfo.Comment.length());
        JpegEncoder.WriteArray(byArray3, bufferedOutputStream);
        byte[] byArray4 = new byte[134];
        byArray4[0] = -1;
        byArray4[1] = -37;
        byArray4[2] = 0;
        byArray4[3] = -124;
        int n3 = 4;
        for (n = 0; n < 2; ++n) {
            byArray4[n3++] = (byte)(0 + n);
            int[] nArray = dCT.quantum[n];
            for (int i = 0; i < 64; ++i) {
                byArray4[n3++] = (byte)nArray[Huffman.jpegNaturalOrder[i]];
            }
        }
        JpegEncoder.WriteArray(byArray4, bufferedOutputStream);
        byte[] byArray5 = new byte[19];
        byArray5[0] = -1;
        byArray5[1] = -64;
        byArray5[2] = 0;
        byArray5[3] = 17;
        byArray5[4] = (byte)jpegInfo.Precision;
        byArray5[5] = (byte)(jpegInfo.imageHeight >> 8 & 0xFF);
        byArray5[6] = (byte)(jpegInfo.imageHeight & 0xFF);
        byArray5[7] = (byte)(jpegInfo.imageWidth >> 8 & 0xFF);
        byArray5[8] = (byte)(jpegInfo.imageWidth & 0xFF);
        byArray5[9] = (byte)jpegInfo.NumberOfComponents;
        int n4 = 10;
        for (n = 0; n < byArray5[9]; ++n) {
            byArray5[n4++] = (byte)jpegInfo.CompID[n];
            byArray5[n4++] = (byte)((jpegInfo.HsampFactor[n] << 4) + jpegInfo.VsampFactor[n]);
            byArray5[n4++] = (byte)jpegInfo.QtableNumber[n];
        }
        JpegEncoder.WriteArray(byArray5, bufferedOutputStream);
        JpegEncoder.WriteDHTHeader(Huffman.bitsDCluminance, Huffman.valDCluminance, bufferedOutputStream);
        JpegEncoder.WriteDHTHeader(Huffman.bitsACluminance, Huffman.valACluminance, bufferedOutputStream);
        JpegEncoder.WriteDHTHeader(Huffman.bitsDCchrominance, Huffman.valDCchrominance, bufferedOutputStream);
        JpegEncoder.WriteDHTHeader(Huffman.bitsACchrominance, Huffman.valACchrominance, bufferedOutputStream);
        byte[] byArray6 = new byte[14];
        byArray6[0] = -1;
        byArray6[1] = -38;
        byArray6[2] = 0;
        byArray6[3] = 12;
        byArray6[4] = (byte)jpegInfo.NumberOfComponents;
        n4 = 5;
        for (n = 0; n < byArray6[4]; ++n) {
            byArray6[n4++] = (byte)jpegInfo.CompID[n];
            byArray6[n4++] = (byte)((jpegInfo.DCtableNumber[n] << 4) + jpegInfo.ACtableNumber[n]);
        }
        byArray6[n4++] = (byte)jpegInfo.Ss;
        byArray6[n4++] = (byte)jpegInfo.Se;
        byArray6[n4++] = (byte)((jpegInfo.Ah << 4) + jpegInfo.Al);
        JpegEncoder.WriteArray(byArray6, bufferedOutputStream);
    }

    static void WriteDHTHeader(int[] nArray, int[] nArray2, BufferedOutputStream bufferedOutputStream) {
        int n;
        int n2 = 4;
        int n3 = 4;
        byte[] byArray = new byte[17];
        byte[] byArray2 = new byte[4];
        byArray2[0] = -1;
        byArray2[1] = -60;
        int n4 = 0;
        byArray[n2++ - n3] = (byte)nArray[0];
        for (n = 1; n < 17; ++n) {
            int n5 = nArray[n];
            byArray[n2++ - n3] = (byte)n5;
            n4 += n5;
        }
        int n6 = n2;
        byte[] byArray3 = new byte[n4];
        for (n = 0; n < n4; ++n) {
            byArray3[n2++ - n6] = (byte)nArray2[n];
        }
        byte[] byArray4 = new byte[n2];
        System.arraycopy(byArray2, 0, byArray4, 0, n3);
        System.arraycopy(byArray, 0, byArray4, n3, 17);
        System.arraycopy(byArray3, 0, byArray4, n3 + 17, n4);
        byArray2 = byArray4;
        n3 = n2;
        byArray2[2] = (byte)(n2 - 2 >> 8 & 0xFF);
        byArray2[3] = (byte)(n2 - 2 & 0xFF);
        JpegEncoder.WriteArray(byArray2, bufferedOutputStream);
    }

    static void WriteMarker(byte[] byArray, BufferedOutputStream bufferedOutputStream) {
        try {
            bufferedOutputStream.write(byArray, 0, 2);
        }
        catch (IOException iOException) {
            Logger.error("IO Error", iOException);
        }
    }

    static void WriteArray(byte[] byArray, BufferedOutputStream bufferedOutputStream) {
        try {
            int n = ((byArray[2] & 0xFF) << 8) + (byArray[3] & 0xFF) + 2;
            bufferedOutputStream.write(byArray, 0, n);
        }
        catch (IOException iOException) {
            Logger.error("IO Error", iOException);
        }
    }
}

