/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import java.util.Vector;
import org.jmol.adapter.readers.quantum.GamessReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class GamessUKReader
extends GamessReader {
    private Vector symmetries;
    private Vector occupancies;

    protected boolean checkLine() throws Exception {
        if (this.line.contains("BASIS OPTIONS")) {
            this.readBasisInfo();
            return true;
        }
        if (this.line.contains("$CONTRL OPTIONS")) {
            this.readControlInfo();
            return true;
        }
        if (this.line.indexOf("contracted primitive functions") >= 0) {
            this.readGaussianBasis("======================================================", "======");
            return false;
        }
        if (this.line.indexOf("molecular geometry") >= 0) {
            if (!this.doGetModel(++this.modelNumber)) {
                return this.checkLastModel();
            }
            this.atomNames = new Vector();
            this.readAtomsInBohrCoordinates();
            return true;
        }
        if (!this.doProcessLines) {
            return true;
        }
        if (this.line.indexOf("FREQUENCY_INFO_WOULD_BE_HERE") >= 0) {
            return true;
        }
        if (this.line.indexOf("SYMMETRY ASSIGNMENT") >= 0) {
            this.readOrbitalSymmetryAndOccupancy();
            return false;
        }
        if (this.line.indexOf("- ALPHA SET -") >= 0) {
            this.alphaBeta = "alpha";
        } else if (this.line.indexOf("- BETA SET -") >= 0) {
            this.alphaBeta = "beta";
        } else if (this.line.indexOf("eigenvectors") >= 0) {
            this.readMolecularOrbitals(3);
            this.setOrbitalSymmetryAndOccupancy();
            return false;
        }
        return this.checkNboLine();
    }

    protected void readAtomsInBohrCoordinates() throws Exception {
        this.discardLinesUntilContains("*****");
        this.discardLinesUntilContains("atom");
        this.discardLinesUntilContains("*****");
        this.atomSetCollection.newAtomSet();
        while (this.readLine() != null && this.line.indexOf("*****") < 0) {
            if (this.line.charAt(14) == ' ') continue;
            String[] stringArray = this.getTokens();
            String string = stringArray[1];
            int n = (int)this.parseFloat(stringArray[2]);
            float f = this.parseFloat(stringArray[3]);
            float f2 = this.parseFloat(stringArray[4]);
            float f3 = this.parseFloat(stringArray[5]);
            if (Float.isNaN(f) || Float.isNaN(f2) || Float.isNaN(f3)) break;
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.atomName = string;
            atom.set(f, f2, f3);
            atom.scale(0.5291772f);
            atom.elementSymbol = AtomSetCollectionReader.getElementSymbol(n);
            this.atomNames.addElement(string);
        }
    }

    protected String fixShellTag(String string) {
        return string.substring(1).toUpperCase();
    }

    private void readOrbitalSymmetryAndOccupancy() throws Exception {
        this.discardLines(4);
        this.symmetries = new Vector();
        this.occupancies = new Vector();
        while (this.readLine() != null && this.line.indexOf("====") < 0) {
            String[] stringArray = GamessUKReader.getTokens(this.line.substring(20));
            this.symmetries.addElement(stringArray[0] + " " + stringArray[1]);
            this.occupancies.addElement(new Float(this.parseFloat(stringArray[5])));
        }
    }

    private void setOrbitalSymmetryAndOccupancy() {
        if (this.symmetries.size() < this.orbitals.size()) {
            return;
        }
        int n = this.orbitals.size();
        while (--n >= 0) {
            Hashtable hashtable = (Hashtable)this.orbitals.elementAt(n);
            hashtable.put("symmetry", this.symmetries.elementAt(n));
            hashtable.put("occupancy", this.occupancies.elementAt(n));
        }
    }
}

