/*
 * Decompiled with CFR 0.152.
 */
import edu.hws.jcm.awt.Animator;
import edu.hws.jcm.awt.JCMPanel;
import edu.hws.jcm.awt.VariableInput;
import edu.hws.jcm.data.Expression;
import edu.hws.jcm.data.Function;
import edu.hws.jcm.data.ParseError;
import edu.hws.jcm.data.SimpleFunction;
import edu.hws.jcm.data.Value;
import edu.hws.jcm.data.Variable;
import edu.hws.jcm.draw.CoordinateRect;
import edu.hws.jcm.draw.DrawString;
import edu.hws.jcm.draw.Drawable;
import edu.hws.jcm.draw.Graph1D;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Label;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class AnimatedGraph
extends GenericGraphApplet {
    private Function func;
    private Graph1D graph;
    private Animator animator;
    private Variable kVar;
    private VariableInput kMin;
    private VariableInput kMax;
    private VariableInput kIntervals;

    @Override
    protected void setUpParser() {
        int n = 133;
        if (!"no".equalsIgnoreCase(this.getParameter("UseNextAndPrev", "yes"))) {
            n |= 0x30;
        }
        this.animator = new Animator(n);
        this.kVar = this.animator.getValueAsVariable(this.getParameter("Parameter", "k"));
        this.parser.add(this.kVar);
        super.setUpParser();
        this.parameterDefaults = new Hashtable();
        String string = this.xVar.getName() + " / (" + this.kVar.getName() + " - " + this.xVar.getName() + "^2)";
        this.parameterDefaults.put("Function", string);
        if (!"no".equalsIgnoreCase(this.getParameter("UseAnimatorInputs"))) {
            this.parameterDefaults.put("TwoLimitsColumns", "yes");
        }
    }

    @Override
    protected void setUpBottomPanel() {
        super.setUpBottomPanel();
        if (this.inputPanel != null) {
            this.inputPanel.add((Component)this.animator, "South");
        } else {
            this.mainPanel.add((Component)this.animator, "South");
        }
    }

    @Override
    protected void setUpCanvas() {
        Object object;
        super.setUpCanvas();
        if (this.functionInput != null) {
            this.func = this.functionInput.getFunction(this.xVar);
        } else {
            object = this.getParameter("Function");
            this.func = new SimpleFunction((Expression)this.parser.parse((String)object), this.xVar);
        }
        this.graph = new Graph1D(this.func);
        this.graph.setColor(this.getColorParam("GraphColor", Color.magenta));
        this.canvas.add(this.graph);
        if (!"no".equalsIgnoreCase(this.getParameter("UseAnimatorInputs"))) {
            this.kMin = new VariableInput(this.kVar.getName() + "Start", this.getParameter("ParameterMin", "-2"));
            this.kMax = new VariableInput(this.kVar.getName() + "End", this.getParameter("ParameterMax", "2"));
            this.kIntervals = new VariableInput("Intervals", this.getParameter("Intervals", "25"));
            this.kIntervals.setInputStyle(2);
            this.kIntervals.setMin(1.0);
            this.kIntervals.setMax(1000.0);
            this.kMin.setOnUserAction(this.mainController);
            this.kMax.setOnUserAction(this.mainController);
            this.kIntervals.setOnUserAction(this.mainController);
            this.animator.setMin(this.kMin);
            this.animator.setMax(this.kMax);
            this.animator.setIntervals(this.kIntervals);
            if (this.limitsPanel != null) {
                this.mainController.add(this.kMin);
                this.mainController.add(this.kMax);
                this.mainController.add(this.kIntervals);
            } else {
                object = new JCMPanel(9, 0);
                ((Component)object).setBackground(this.getColorParam("PanelBackground", Color.lightGray));
                ((Container)object).add(new Label(this.kMin.getName()));
                ((Container)object).add(this.kMin);
                ((Container)object).add(new Label());
                ((Container)object).add(new Label(this.kMax.getName()));
                ((Container)object).add(this.kMax);
                ((Container)object).add(new Label());
                ((Container)object).add(new Label(this.kIntervals.getName()));
                ((Container)object).add(this.kIntervals);
                ((Container)object).add(new Label());
                this.mainPanel.add((Component)object, "East");
            }
        } else {
            try {
                this.animator.setMin(new Double(this.getParameter("ParameterMin", "-2")));
                this.animator.setMax(new Double(this.getParameter("ParameterMax", "2")));
                this.animator.setIntervals((int)Math.round(new Double(this.getParameter("Intervals", "25"))));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.animator.setOnChange(this.mainController);
        if (!"no".equalsIgnoreCase(this.getParameter("ShowParameter", "yes"))) {
            object = new DrawString(this.kVar.getName() + " = #", 8, new Value[]{this.kVar});
            ((DrawString)object).setBackgroundColor(this.canvas.getBackground());
            Color color = this.getColorParam("ParameterColor", Color.black);
            ((DrawString)object).setColor(color);
            this.canvas.add((Drawable)object);
        }
    }

    @Override
    protected void setUpLimitsPanel() {
        super.setUpLimitsPanel();
        if (this.limitsPanel != null && this.kMin != null) {
            this.limitsPanel.addComponentPair(this.kMin, this.kMax);
            this.limitsPanel.addComponent(this.kIntervals);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doLoadExample(String string) {
        Object object;
        Object object2;
        this.animator.stop();
        int n = string.indexOf(";");
        boolean bl = false;
        double[] dArray = new double[]{-5.0, 5.0, -5.0, 5.0};
        if (n > 0) {
            int n2;
            object2 = string.substring(n + 1);
            string = string.substring(0, n);
            object = new StringTokenizer((String)object2, " ,");
            if (((StringTokenizer)object).countTokens() >= 4) {
                for (n2 = 0; n2 < 4; ++n2) {
                    try {
                        Double d = new Double(((StringTokenizer)object).nextToken());
                        dArray[n2] = d;
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if (((StringTokenizer)object).hasMoreTokens()) {
                try {
                    double d = new Double(((StringTokenizer)object).nextToken());
                    if (this.kMin == null) {
                        this.animator.setMin(d);
                    } else {
                        this.kMin.setVal(d);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (((StringTokenizer)object).hasMoreTokens()) {
                try {
                    double d = new Double(((StringTokenizer)object).nextToken());
                    if (this.kMax == null) {
                        this.animator.setMax(d);
                    } else {
                        this.kMax.setVal(d);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (((StringTokenizer)object).hasMoreTokens()) {
                try {
                    n2 = (int)Math.round(new Double(((StringTokenizer)object).nextToken()));
                    if (this.kIntervals == null) {
                        this.animator.setIntervals(n2);
                    } else {
                        this.kIntervals.setVal(n2);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (((StringTokenizer)object).hasMoreTokens()) {
                try {
                    int n3 = (int)Math.round(new Double(((StringTokenizer)object).nextToken()));
                    this.animator.setLoopStyle(n3);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (((StringTokenizer)object).hasMoreTokens()) {
                try {
                    int n4 = (int)Math.round(new Double(((StringTokenizer)object).nextToken()));
                    bl = n4 == 1;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (this.functionInput != null) {
            this.functionInput.setText(string);
        } else {
            try {
                this.func = new SimpleFunction((Expression)this.parser.parse(string), this.xVar);
                this.graph.setFunction(this.func);
            }
            catch (ParseError parseError) {
                // empty catch block
            }
        }
        object2 = this.canvas.getCoordinateRect(0);
        ((CoordinateRect)object2).setLimits(dArray);
        ((CoordinateRect)object2).setRestoreBuffer();
        this.mainController.compute();
        if (bl) {
            try {
                object = this;
                synchronized (object) {
                    this.wait(250L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.animator.start();
        }
    }

    @Override
    public void stop() {
        this.animator.stop();
        super.stop();
    }
}

