/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.tools;

import java.awt.event.MouseEvent;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Selector;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.objects.AngleObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.ExpressionObject;
import rene.zirkel.objects.FixedAngleObject;
import rene.zirkel.objects.PointObject;

public class SetFixedAngle
extends ObjectConstructor
implements Selector {
    ObjectConstructor OC;
    FixedAngleObject A;
    PointObject P1;
    PointObject P2;
    PointObject P3;

    public SetFixedAngle(ZirkelCanvas zirkelCanvas, FixedAngleObject fixedAngleObject, ObjectConstructor objectConstructor) {
        this.A = fixedAngleObject;
        this.OC = objectConstructor;
        fixedAngleObject.setSelected(true);
        zirkelCanvas.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        if (this.P1 == null) {
            ConstructionObject constructionObject = zirkelCanvas.selectWithSelector(mouseEvent.getX(), mouseEvent.getY(), this);
            if (constructionObject == null) {
                return;
            }
            if (constructionObject instanceof PointObject) {
                this.P1 = (PointObject)constructionObject;
                this.P1.setSelected(true);
                this.showStatus(zirkelCanvas);
                zirkelCanvas.repaint();
            } else if (constructionObject instanceof AngleObject || constructionObject instanceof FixedAngleObject || constructionObject instanceof ExpressionObject) {
                this.A.setFixed(constructionObject.getName());
                this.A.setDragable(false);
                this.A.updateText();
                this.reset(zirkelCanvas);
            }
        } else if (this.P2 == null) {
            this.P2 = zirkelCanvas.selectPoint(mouseEvent.getX(), mouseEvent.getY());
            if (this.P2 != null) {
                this.P2.setSelected(true);
                this.showStatus(zirkelCanvas);
                zirkelCanvas.repaint();
            }
        } else {
            this.P3 = zirkelCanvas.selectPoint(mouseEvent.getX(), mouseEvent.getY());
            if (this.P3 == null) {
                return;
            }
            this.A.setFixed("a(" + this.P1.getName() + "," + this.P2.getName() + "," + this.P3.getName() + ")");
            this.reset(zirkelCanvas);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas, boolean bl) {
        zirkelCanvas.indicateWithSelector(mouseEvent.getX(), mouseEvent.getY(), this);
    }

    public void showStatus(ZirkelCanvas zirkelCanvas) {
        if (this.P1 == null) {
            zirkelCanvas.showStatus(Zirkel.name("message.setfixedangle.first"));
        } else if (this.P2 == null) {
            zirkelCanvas.showStatus(Zirkel.name("message.setfixedangle.second"));
        } else {
            zirkelCanvas.showStatus(Zirkel.name("message.setfixedangle.third"));
        }
    }

    public void reset(ZirkelCanvas zirkelCanvas) {
        super.reset(zirkelCanvas);
        zirkelCanvas.setTool(this.OC);
        zirkelCanvas.validate();
        zirkelCanvas.repaint();
        zirkelCanvas.check();
    }

    public boolean useSmartBoard() {
        return this.P2 != null;
    }

    public boolean isAdmissible(ZirkelCanvas zirkelCanvas, ConstructionObject constructionObject) {
        return (constructionObject instanceof PointObject || constructionObject instanceof AngleObject || constructionObject instanceof FixedAngleObject || constructionObject instanceof ExpressionObject) && !zirkelCanvas.getConstruction().dependsOn(constructionObject, this.A);
    }
}

