/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.util.Enumeration;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.Count;
import rene.zirkel.objects.MoveableObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveLineObject;
import rene.zirkel.objects.SegmentObject;

public class ParallelObject
extends PrimitiveLineObject
implements MoveableObject {
    protected PrimitiveLineObject L;
    static Count N = new Count();
    double x1;
    double y1;
    double x2;
    double y2;
    double x3;
    double y3;

    public ParallelObject(Construction construction, PrimitiveLineObject primitiveLineObject, PointObject pointObject) {
        super(construction);
        this.P1 = pointObject;
        this.L = primitiveLineObject;
        this.validate();
        this.updateText();
    }

    public String getTag() {
        return "Parallel";
    }

    public int getN() {
        return N.next();
    }

    public void updateText() {
        this.setText(ParallelObject.text2(Zirkel.name("text.parallel"), this.P1.getName(), this.L.getName()));
    }

    public void validate() {
        if (!this.P1.valid() || !this.L.valid()) {
            this.Valid = false;
        } else if (this.L instanceof SegmentObject && ((SegmentObject)this.L).getLength() == 0.0) {
            this.Valid = false;
        } else {
            this.Valid = true;
            this.X1 = this.P1.getX();
            this.Y1 = this.P1.getY();
            this.DX = this.L.getDX();
            this.DY = this.L.getDY();
        }
    }

    public void printArgs(XmlWriter xmlWriter) {
        xmlWriter.printArg("point", this.P1.getName());
        xmlWriter.printArg("line", this.L.getName());
        super.printArgs(xmlWriter);
    }

    public Enumeration depending() {
        super.depending();
        return this.depset(this.P1, this.L);
    }

    public void translate() {
        this.P1 = (PointObject)this.P1.getTranslation();
        this.L = (PrimitiveLineObject)this.L.getTranslation();
    }

    public boolean contains(PointObject pointObject) {
        return pointObject == this.P1;
    }

    public boolean hasUnit() {
        return false;
    }

    public void dragTo(double d2, double d3) {
        this.P1.move(this.x1 + (d2 - this.x3), this.y1 + (d3 - this.y3));
    }

    public void move(double d2, double d3) {
    }

    public boolean moveable() {
        return this.P1.moveable();
    }

    public void startDrag(double d2, double d3) {
        this.x1 = this.P1.getX();
        this.y1 = this.P1.getY();
        this.x3 = d2;
        this.y3 = d3;
    }

    public void snap(ZirkelCanvas zirkelCanvas) {
        if (this.moveable()) {
            this.P1.snap(zirkelCanvas);
        }
    }
}

