/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import rene.util.xml.XmlWriter;
import rene.zirkel.construction.Construction;
import rene.zirkel.objects.IntersectionObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.objects.PrimitiveLineObject;
import rene.zirkel.structures.Coordinates;

public class LineCircleIntersectionObject
extends IntersectionObject {
    public LineCircleIntersectionObject(Construction construction, PrimitiveLineObject primitiveLineObject, PrimitiveCircleObject primitiveCircleObject, boolean bl) {
        super(construction, primitiveLineObject, primitiveCircleObject);
        this.First = bl;
        this.validate();
    }

    public void updateCircleDep() {
        ((PrimitiveCircleObject)this.P2).addDep(this);
        ((PrimitiveLineObject)this.P1).addDep(this);
    }

    public void validate() {
        boolean bl = this.Valid;
        this.Valid = this.P1.valid() && this.P2.valid();
        if (!this.Valid) {
            return;
        }
        Coordinates coordinates = PrimitiveLineObject.intersect((PrimitiveLineObject)this.P1, (PrimitiveCircleObject)this.P2);
        if (coordinates == null) {
            if (bl && this.getConstruction().shouldSwitch()) {
                this.doSwitch();
                if (!this.getConstruction().noteSwitch()) {
                    this.Switched = false;
                }
            } else if (bl && this.Alternate && this.Away == null && this.getConstruction().canAlternate()) {
                this.First = !this.First;
            }
            this.Valid = false;
            return;
        }
        if (this.getAway() != null) {
            double d2;
            boolean bl2;
            double d3;
            double d4 = this.getAway().getX();
            double d5 = (d4 - coordinates.X) * (d4 - coordinates.X) + ((d3 = this.getAway().getY()) - coordinates.Y) * (d3 - coordinates.Y);
            boolean bl3 = bl2 = d5 > (d2 = (d4 - coordinates.X1) * (d4 - coordinates.X1) + (d3 - coordinates.Y1) * (d3 - coordinates.Y1));
            if (!this.StayAway) {
                boolean bl4 = bl2 = !bl2;
            }
            if (bl2) {
                this.X = coordinates.X;
                this.Y = coordinates.Y;
                double d6 = coordinates.X1;
                double d7 = coordinates.Y1;
            } else {
                this.X = coordinates.X1;
                this.Y = coordinates.Y1;
                double d8 = coordinates.X;
                double d9 = coordinates.Y;
            }
        } else if (this.First) {
            this.X = coordinates.X;
            this.Y = coordinates.Y;
            double d10 = coordinates.X1;
            double d11 = coordinates.Y1;
        } else {
            this.X = coordinates.X1;
            this.Y = coordinates.Y1;
            double d12 = coordinates.X;
            double d13 = coordinates.Y;
        }
        if (this.Restricted) {
            if (!((PrimitiveLineObject)this.P1).contains(this.X, this.Y)) {
                this.Valid = false;
            }
            if (((PrimitiveCircleObject)this.P2).getStart() != this && ((PrimitiveCircleObject)this.P2).getEnd() != this && !((PrimitiveCircleObject)this.P2).contains(this.X, this.Y)) {
                this.Valid = false;
            }
        }
    }

    public void printArgs(XmlWriter xmlWriter) {
        super.printArgs(xmlWriter);
        if (this.First) {
            xmlWriter.printArg("which", "first");
        } else {
            xmlWriter.printArg("which", "second");
        }
    }

    public boolean isSwitchable() {
        return true;
    }

    public boolean canAlternate() {
        return true;
    }
}

