/*
 * Decompiled with CFR 0.152.
 */
package SharpTools;

import SharpTools.CellPoint;
import SharpTools.Formula;
import SharpTools.Function;
import SharpTools.FunctionAverage;
import SharpTools.FunctionCount;
import SharpTools.Node;
import SharpTools.ParserException;
import SharpTools.SharpTableModel;
import SharpTools.SharpTools;
import java.util.LinkedList;

class FunctionStddev
extends Function {
    FunctionStddev() {
    }

    @Override
    public Number evaluate(SharpTableModel table, Node node, int row, int col) throws ParserException {
        float dev = 0.0f;
        float nCells = new FunctionCount().evaluate(table, node, row, col).floatValue();
        float mean = new FunctionAverage().evaluate(table, node, row, col).floatValue();
        LinkedList params = node.getParams();
        if (params != null) {
            for (Node exp : params) {
                if (this.isRange(exp)) {
                    CellPoint[] addr = this.getFirst(exp).getAddressRange(row, col);
                    for (int i = addr[0].getRow(); i <= addr[1].getRow(); ++i) {
                        for (int j = addr[0].getCol(); j <= addr[1].getCol(); ++j) {
                            float temp = Math.abs(table.getNumericValueAt(i, j).floatValue() - mean);
                            dev += temp * temp;
                        }
                    }
                    continue;
                }
                float temp = Math.abs(Formula.evaluate(table, exp.getExp(), row, col).floatValue());
                dev += temp * temp;
            }
        }
        return new Float(Math.sqrt(dev / (nCells - 1.0f)));
    }

    @Override
    public String getUsage() {
        return "STDDEV(value1,value2,...)";
    }

    @Override
    public String getDescription() {
        return SharpTools.translation.getProperty("stddev_desc");
    }
}

