/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.data;

import edu.hws.jcm.data.Cases;
import edu.hws.jcm.data.ExpressionCommand;
import edu.hws.jcm.data.ExpressionProgram;
import edu.hws.jcm.data.StackOfDouble;
import edu.hws.jcm.data.Variable;

public class ConditionalExpression
implements ExpressionCommand {
    private ExpressionProgram trueCase;
    private ExpressionProgram falseCase;

    public ConditionalExpression(ExpressionProgram expressionProgram, ExpressionProgram expressionProgram2) {
        this.trueCase = expressionProgram;
        this.falseCase = expressionProgram2;
    }

    @Override
    public void apply(StackOfDouble stackOfDouble, Cases cases) {
        double d = stackOfDouble.pop();
        if (cases != null) {
            cases.addCase((int)d);
        }
        if (d != 0.0) {
            stackOfDouble.push(this.trueCase.getValueWithCases(cases));
        } else if (this.falseCase != null) {
            stackOfDouble.push(this.falseCase.getValueWithCases(cases));
        } else {
            stackOfDouble.push(Double.NaN);
        }
    }

    @Override
    public void compileDerivative(ExpressionProgram expressionProgram, int n, ExpressionProgram expressionProgram2, Variable variable) {
        expressionProgram.copyExpression(n - 1, expressionProgram2);
        ExpressionProgram expressionProgram3 = (ExpressionProgram)this.trueCase.derivative(variable);
        ExpressionProgram expressionProgram4 = this.falseCase == null ? null : (ExpressionProgram)this.falseCase.derivative(variable);
        expressionProgram2.addCommandObject(new ConditionalExpression(expressionProgram3, expressionProgram4));
    }

    @Override
    public int extent(ExpressionProgram expressionProgram, int n) {
        return 1 + expressionProgram.extent(n - 1);
    }

    @Override
    public boolean dependsOn(Variable variable) {
        return this.trueCase.dependsOn(variable) || this.falseCase != null && this.falseCase.dependsOn(variable);
    }

    @Override
    public void appendOutputString(ExpressionProgram expressionProgram, int n, StringBuffer stringBuffer) {
        stringBuffer.append('(');
        expressionProgram.appendOutputString(n - 1, stringBuffer);
        stringBuffer.append(") ? (");
        stringBuffer.append(this.trueCase.toString());
        stringBuffer.append(')');
        if (this.falseCase != null) {
            stringBuffer.append(" : (");
            stringBuffer.append(this.falseCase.toString());
            stringBuffer.append(')');
        }
    }
}

