/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.expression;

import rene.zirkel.Zirkel;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.expression.BasicExpression;
import rene.zirkel.expression.ExpressionText;
import rene.zirkel.expression.FunctionExpression;
import rene.zirkel.expression.InvalidException;
import rene.zirkel.expression.ObjectExpression;
import rene.zirkel.expression.Translator;
import rene.zirkel.objects.ConstructionObject;

class FindObjectExpression
extends ObjectExpression
implements Translator {
    String Name;
    String Var = null;
    Construction C;
    ConstructionObject O = null;

    public FindObjectExpression(String string, Construction construction) {
        super(null);
        this.Name = string;
        this.C = construction;
    }

    public ConstructionObject getObject() {
        if (this.C == null) {
            return null;
        }
        if (this.O != null && this.O.getConstruction() == this.C && this.O.isInConstruction() && this.O.getName().equals(this.Name)) {
            return this.O;
        }
        this.O = this.C.find(this.Name);
        return this.O;
    }

    public double getValue() throws ConstructionException {
        if (this.C == null) {
            throw new InvalidException("");
        }
        if (this.O != null && this.O.getConstruction() == this.C && this.O.isInConstruction() && this.O.getName().equals(this.Name)) {
            return this.O.getValue();
        }
        this.O = this.C.find(this.Name);
        if (this.O == null) {
            throw new InvalidException("");
        }
        return this.O.getValue();
    }

    public static BasicExpression scan(ExpressionText expressionText, boolean bl) throws ConstructionException {
        char c2;
        if (!bl && expressionText.next() == '\"') {
            expressionText.advance();
            BasicExpression basicExpression = FindObjectExpression.scan(expressionText, true);
            if (expressionText.next() != '\"') {
                throw new ConstructionException(Zirkel.name("exception.quotes"));
            }
            expressionText.advance();
            return basicExpression;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (Character.isLetterOrDigit(c2 = expressionText.next(bl)) || c2 == '\\' || c2 == '\'' || bl && c2 != '\"' && c2 != '\u0000' || bl && c2 == ' ') {
            stringBuffer.append(c2);
            expressionText.advance(bl);
        }
        if (!bl && expressionText.next() == '(') {
            return FunctionExpression.scan(expressionText, stringBuffer.toString());
        }
        String string = stringBuffer.toString();
        return new FindObjectExpression(string, expressionText.getConstruction());
    }

    public static BasicExpression scan(ExpressionText expressionText) throws ConstructionException {
        return FindObjectExpression.scan(expressionText, false);
    }

    public void translate() {
        this.C = this.C.getTranslation();
        this.C.addTranslator(this);
    }

    public String toString() {
        if (this.Var != null) {
            return this.Var;
        }
        return "@" + ObjectExpression.quote(this.Name);
    }

    public void laterTranslate(Construction construction) {
        if (this.C == null) {
            return;
        }
        ConstructionObject constructionObject = construction.find(this.Name);
        if (constructionObject == null || constructionObject.getTranslation() == null) {
            construction.addError(ConstructionObject.text1(Zirkel.name("warning.macrodefinition"), this.Name));
            return;
        }
        this.Name = constructionObject.getTranslation().getName();
        this.O = null;
    }
}

