/*
 * Decompiled with CFR 0.152.
 */
package rene.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.SystemColor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import rene.dialogs.Warning;
import rene.util.FileName;
import rene.util.parser.StringParser;

public class Global {
    public static Font NormalFont = null;
    public static Font FixedFont = null;
    public static Font BoldFont = null;
    public static Color Background;
    public static Color ControlBackground;
    protected static ResourceBundle B;
    static Properties P;
    static String ConfigName;
    static Frame F;
    public static String AppletClipboard;
    public static boolean IsApplet;
    public static Object ExitBlock;

    public static void makeFonts() {
        NormalFont = Global.createfont("normalfont", "SansSerif", 12, false);
        FixedFont = Global.createfont("fixedfont", "Monospaced", 12, false);
        BoldFont = Global.createfont("fixedfont", "Monospaced", 12, true);
    }

    public static Font createfont(String string, String string2, int n, boolean bl) {
        String string3 = Global.getParameter(string + ".name", string2);
        String string4 = Global.getParameter(string + ".mode", "plain");
        if (bl || string4.equals("bold")) {
            return new Font(string3, 1, Global.getParameter(string + ".size", n));
        }
        if (string4.equals("italic")) {
            return new Font(string3, 2, Global.getParameter(string + ".size", n));
        }
        return new Font(string3, 0, Global.getParameter(string + ".size", n));
    }

    public static void makeColors() {
        Background = Global.haveParameter("color.background") ? Global.getParameter("color.background", Color.gray.brighter()) : SystemColor.window;
        ControlBackground = Global.haveParameter("color.control") ? Global.getParameter("color.control", Color.gray.brighter()) : SystemColor.control;
    }

    public static Enumeration names() {
        if (B != null) {
            return B.getKeys();
        }
        return null;
    }

    public static String name(String string, String string2) {
        String string3;
        if (B == null) {
            return string2;
        }
        try {
            string3 = B.getString(string);
        }
        catch (Exception exception) {
            string3 = string2;
        }
        return string3;
    }

    public static String name(String string) {
        return Global.name(string, string.substring(string.lastIndexOf(".") + 1));
    }

    public static void initBundle(String string, boolean bl) {
        try {
            B = ResourceBundle.getBundle(string);
            String string2 = Global.getParameter("language", "");
            if (bl && !string2.equals("") && !string2.equals("default")) {
                String string3 = "";
                if (string2.length() > 3 && string2.charAt(2) == '_') {
                    string3 = string2.substring(3);
                    string2 = string2.substring(0, 2);
                }
                Locale.setDefault(new Locale(string2, string3));
                Global.initBundle(string, false);
            }
        }
        catch (RuntimeException runtimeException) {
            B = null;
        }
    }

    public static void initBundle(String string) {
        Global.initBundle(string, false);
    }

    public static synchronized Enumeration properties() {
        return P.keys();
    }

    public static synchronized void loadProperties(InputStream inputStream) {
        try {
            P = new Properties();
            P.load(inputStream);
            inputStream.close();
        }
        catch (Exception exception) {
            P = new Properties();
        }
    }

    public static synchronized boolean loadPropertiesFromResource(String string) {
        try {
            Object object = new Object();
            InputStream inputStream = object.getClass().getResourceAsStream(string);
            P = new Properties();
            P.load(inputStream);
            inputStream.close();
        }
        catch (Exception exception) {
            P = new Properties();
            return false;
        }
        ConfigName = string;
        return true;
    }

    public static synchronized boolean loadProperties(String string) {
        ConfigName = string;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            P = new Properties();
            P.load(fileInputStream);
            fileInputStream.close();
        }
        catch (Exception exception) {
            P = new Properties();
            return false;
        }
        return true;
    }

    public static synchronized void loadProperties(String string, String string2) {
        try {
            Properties properties = System.getProperties();
            ConfigName = string + properties.getProperty("file.separator") + string2;
            Global.loadProperties(ConfigName);
        }
        catch (Exception exception) {
            P = new Properties();
        }
    }

    public static synchronized void loadPropertiesInHome(String string) {
        try {
            Properties properties = System.getProperties();
            Global.loadProperties(properties.getProperty("user.home"), string);
        }
        catch (Exception exception) {
            P = new Properties();
        }
    }

    public static synchronized void clearProperties() {
        P = new Properties();
    }

    public static synchronized void saveProperties(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(ConfigName);
            P.save(fileOutputStream, string);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void saveProperties(String string, String string2) {
        ConfigName = string2;
        Global.saveProperties(string);
    }

    public static synchronized void setParameter(String string, boolean bl) {
        if (P == null) {
            return;
        }
        if (bl) {
            P.put(string, "true");
        } else {
            P.put(string, "false");
        }
    }

    public static synchronized boolean getParameter(String string, boolean bl) {
        try {
            String string2 = P.getProperty(string);
            if (string2.equals("true")) {
                return true;
            }
            if (string2.equals("false")) {
                return false;
            }
            return bl;
        }
        catch (Exception exception) {
            return bl;
        }
    }

    public static synchronized String getParameter(String string, String string2) {
        String string3 = string2;
        try {
            string3 = P.getProperty(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string3 != null) {
            if (string3.startsWith("$")) {
                string3 = string3.substring(1);
            }
            return string3;
        }
        return string2;
    }

    public static synchronized void setParameter(String string, String string2) {
        if (P == null) {
            return;
        }
        if (string2.length() > 0 && Character.isSpaceChar(string2.charAt(0))) {
            string2 = "$" + string2;
        }
        P.put(string, string2);
    }

    public static synchronized int getParameter(String string, int n) {
        try {
            return Integer.parseInt(Global.getParameter(string, ""));
        }
        catch (Exception exception) {
            try {
                double d2 = new Double(Global.getParameter(string, ""));
                return (int)d2;
            }
            catch (Exception exception2) {
                return n;
            }
        }
    }

    public static synchronized void setParameter(String string, int n) {
        Global.setParameter(string, "" + n);
    }

    public static synchronized double getParameter(String string, double d2) {
        try {
            return new Double(Global.getParameter(string, ""));
        }
        catch (Exception exception) {
            return d2;
        }
    }

    public static synchronized void setParameter(String string, double d2) {
        Global.setParameter(string, "" + d2);
    }

    public static synchronized Color getParameter(String string, Color color) {
        String string2 = Global.getParameter(string, "");
        if (string2.equals("")) {
            return color;
        }
        StringParser stringParser = new StringParser(string2);
        stringParser.replace(',', ' ');
        int n = stringParser.parseint();
        int n2 = stringParser.parseint();
        int n3 = stringParser.parseint();
        try {
            return new Color(n, n2, n3);
        }
        catch (RuntimeException runtimeException) {
            return color;
        }
    }

    public static synchronized Color getParameter(String string, int n, int n2, int n3) {
        String string2 = Global.getParameter(string, "");
        if (string2.equals("")) {
            return new Color(n, n2, n3);
        }
        StringParser stringParser = new StringParser(string2);
        stringParser.replace(',', ' ');
        n = stringParser.parseint();
        n2 = stringParser.parseint();
        n3 = stringParser.parseint();
        try {
            return new Color(n, n2, n3);
        }
        catch (RuntimeException runtimeException) {
            return Color.black;
        }
    }

    public static synchronized void setParameter(String string, Color color) {
        Global.setParameter(string, "" + color.getRed() + "," + color.getGreen() + "," + color.getBlue());
    }

    public static synchronized void removeParameter(String string) {
        P.remove(string);
    }

    public static synchronized void removeAllParameters(String string) {
        Enumeration<Object> enumeration = P.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            P.remove(string2);
        }
    }

    public static synchronized void resetDefaults(String string) {
        Enumeration<Object> enumeration = P.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            Global.setParameter(string2.substring(string.length()), Global.getParameter(string2, ""));
        }
    }

    public static void resetDefaults() {
        Global.resetDefaults("default.");
    }

    public static synchronized boolean haveParameter(String string) {
        try {
            String string2 = P.getProperty(string);
            if (string2 == null) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static void warning(String string) {
        if (F == null) {
            F = new Frame();
        }
        Warning warning = new Warning(F, string, Global.name("warning"), false);
        warning.center();
        warning.setVisible(true);
    }

    public static void setApplet(boolean bl) {
        IsApplet = bl;
    }

    public static boolean isApplet() {
        return IsApplet;
    }

    public static double getJavaVersion() {
        String string = System.getProperty("java.version");
        if (string == null) {
            return 0.0;
        }
        double d2 = 0.0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (!stringTokenizer.hasMoreTokens()) {
            return d2;
        }
        d2 = Global.convert(stringTokenizer.nextToken());
        if (stringTokenizer.hasMoreTokens()) {
            d2 += Global.convert(stringTokenizer.nextToken()) / 10.0;
        } else {
            return d2;
        }
        if (stringTokenizer.hasMoreTokens()) {
            d2 += Global.convert(stringTokenizer.nextToken()) / 100.0;
        }
        return d2;
    }

    public static double convert(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public static synchronized String getUserDir() {
        String string = System.getProperty("user.dir");
        return FileName.canonical(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void exit(int n) {
        Object object = ExitBlock;
        synchronized (object) {
            System.exit(n);
        }
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(new Color(4, 5, 600));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    static {
        Global.makeFonts();
        Background = null;
        ControlBackground = null;
        Global.makeColors();
        P = new Properties();
        F = null;
        AppletClipboard = null;
        IsApplet = false;
        ExitBlock = new Object();
    }
}

