/*
 * Decompiled with CFR 0.152.
 */
package fr.ove.openmath.jome.ctrl.linear;

import fr.ove.openmath.jome.ctrl.linear.events.LinearParserEvent;
import fr.ove.openmath.jome.ctrl.linear.events.LinearParserListener;
import fr.ove.utils.NumberUtils;
import fr.ove.utils.ResourcesManager;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class LinearParser
implements Serializable {
    private ResourcesManager resourcesManager;
    private Vector listeners = new Vector();
    private LinearParserEvent linearParserEvent = new LinearParserEvent(this);

    public LinearParser() {
        this.resourcesManager = new ResourcesManager("fr.ove.openmath.jome.ctrl.linear.LinearParserResources");
    }

    public synchronized void addLinearParserListener(LinearParserListener linearParserListener) {
        this.listeners.addElement(linearParserListener);
    }

    public synchronized void removeLinearParserListener(LinearParserListener linearParserListener) {
        this.listeners.removeElement(linearParserListener);
    }

    public void fireLinearParserEvent(LinearParserEvent linearParserEvent) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((LinearParserListener)this.listeners.elementAt(i)).consumeLinearParserEvent(linearParserEvent);
        }
    }

    public void parse(String string) {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "+-/*^_()=<>;, {}\\?!\u2192\u21d4\u211e\u2027", true);
        StringTokenizer stringTokenizer2 = null;
        String string2 = null;
        String string3 = null;
        this.linearParserEvent.setToken(26, null);
        this.fireLinearParserEvent(this.linearParserEvent);
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            ++n;
            if (string2.equals(" ")) continue;
            if (string2.equals("\u2192")) {
                this.linearParserEvent.setToken(23, "\u2192");
            } else if (string2.equals("\u21d4")) {
                this.linearParserEvent.setToken(23, "\u21d4");
            } else if (string2.equals("\u211e")) {
                this.linearParserEvent.setToken(23, "\u211e");
            } else if (string2.equals("+")) {
                this.linearParserEvent.setToken(4, string2);
            } else if (string2.equals("-")) {
                this.linearParserEvent.setToken(5, string2);
            } else if (string2.equals("*")) {
                this.linearParserEvent.setToken(6, "\u2027");
            } else if (string2.equals("\u2027")) {
                this.linearParserEvent.setToken(23, "\u2027");
            } else if (string2.equals("/")) {
                this.linearParserEvent.setToken(7, string2);
            } else if (string2.equals("^")) {
                this.linearParserEvent.setToken(8, string2);
            } else if (string2.equals("(")) {
                this.linearParserEvent.setToken(17, string2);
            } else if (string2.equals(")")) {
                this.linearParserEvent.setToken(18, string2);
            } else if (string2.equals("{")) {
                this.linearParserEvent.setToken(21, string2);
            } else if (string2.equals("}")) {
                this.linearParserEvent.setToken(22, string2);
            } else if (string2.equals(",")) {
                this.linearParserEvent.setToken(16, null);
            } else if (string2.equals("_")) {
                this.linearParserEvent.setToken(24, string2);
            } else if (string2.equals("<") || string2.equals(">")) {
                stringTokenizer2 = new StringTokenizer(string, "+-/*^_()=<>;, {}\\?!\u2192\u21d4\u211e\u2027", true);
                for (int i = 0; i < n + 1; ++i) {
                    try {
                        string3 = stringTokenizer2.nextToken();
                        continue;
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        string3 = null;
                    }
                }
                if (string2.equals("<")) {
                    if (string3 != null) {
                        if (string3.equals("=")) {
                            stringTokenizer.nextToken();
                            ++n;
                            this.linearParserEvent.setToken(12, "<=");
                        } else if (string3.equals(">")) {
                            stringTokenizer.nextToken();
                            ++n;
                            this.linearParserEvent.setToken(10, "<>");
                        } else {
                            this.linearParserEvent.setToken(11, string2);
                        }
                    } else {
                        this.linearParserEvent.setToken(11, string2);
                    }
                } else if (string3 != null) {
                    if (string3.equals("=")) {
                        stringTokenizer.nextToken();
                        ++n;
                        this.linearParserEvent.setToken(14, ">=");
                    } else {
                        this.linearParserEvent.setToken(13, string2);
                    }
                } else {
                    this.linearParserEvent.setToken(13, string2);
                }
            } else if (string2.equals("=")) {
                this.linearParserEvent.setToken(9, string2);
            } else if (string2.equals("\\")) {
                this.linearParserEvent.setToken(25, string2);
            } else if (string2.equals("?")) {
                this.linearParserEvent.setToken(25, string2);
            } else if (string2.equals("!")) {
                this.linearParserEvent.setToken(25, "fact");
            } else if (NumberUtils.isNumber(string2)) {
                if (NumberUtils.isFloat(string2)) {
                    this.linearParserEvent.setToken(3, string2);
                } else {
                    this.linearParserEvent.setToken(2, string2);
                }
            } else {
                stringTokenizer2 = new StringTokenizer(string, "+-/*^_()=<>;, {}\\?!\u2192\u21d4\u211e\u2027", true);
                for (int i = 0; i < n + 1; ++i) {
                    try {
                        string3 = stringTokenizer2.nextToken();
                        continue;
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        string3 = null;
                    }
                }
                if (string3 != null) {
                    if (string3.equals("(")) {
                        this.linearParserEvent.setToken(15, string2);
                        stringTokenizer.nextToken();
                        ++n;
                    } else {
                        String string4 = this.resourcesManager.getResourceString(string2);
                        if (string4 == null) {
                            this.linearParserEvent.setToken(1, string2);
                        } else {
                            this.linearParserEvent.setToken(23, string2);
                        }
                    }
                } else {
                    String string5 = this.resourcesManager.getResourceString(string2);
                    if (string5 == null) {
                        this.linearParserEvent.setToken(1, string2);
                    } else {
                        this.linearParserEvent.setToken(23, string2);
                    }
                }
            }
            this.fireLinearParserEvent(this.linearParserEvent);
        }
        this.linearParserEvent.setToken(27, null);
        this.fireLinearParserEvent(this.linearParserEvent);
    }

    public static void main(String[] stringArray) {
        LinearParserListener linearParserListener = new LinearParserListener(){

            public void consumeLinearParserEvent(LinearParserEvent linearParserEvent) {
                System.out.println(linearParserEvent.toString());
            }
        };
        LinearParser linearParser = new LinearParser();
        linearParser.addLinearParserListener(linearParserListener);
        linearParser.parse("1+2+23+C+in+pi+x_8");
    }
}

